/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.core.orm.uds.InstrumentConfiguration;
import fr.proline.core.orm.uds.PeaklistSoftware;
import fr.proline.studio.NbPreferences;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.gui.DefaultStorableDialog;
import fr.proline.studio.parameter.AbstractParameterToString;
import fr.proline.studio.parameter.BooleanParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.StringParameter;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImportMaxQuantResultDialog
extends DefaultStorableDialog {
    private static final String SETTINGS_KEY = "ImportMaxQuantResult";
    private ParameterList m_sourceParameterList;
    private JComboBox m_instrumentsComboBox = null;
    private JTextField m_accessionRegexpTF = null;
    private JCheckBox m_importQuantitationCB = null;
    private JList<File> m_fileList;
    private JButton m_addFileButton;
    private JButton m_removeFileButton;
    private String m_defaultImportMQPath;
    private JFileChooser m_fchooser;
    private static ImportMaxQuantResultDialog m_singletonDialog;

    public static ImportMaxQuantResultDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new ImportMaxQuantResultDialog(parent);
        }
        m_singletonDialog.resetParameters();
        return m_singletonDialog;
    }

    private ImportMaxQuantResultDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Import MaxQuant Results");
        this.setDocumentationSuffix("h.1tuee74");
        this.setResizable(true);
        this.setMinimumSize(new Dimension(200, 240));
        this.initInternalPanel();
        this.restoreInitialParameters(NbPreferences.root());
    }

    private void initInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        JPanel fileSelectionPanel = this.createFileSelectionPanel();
        JPanel allParametersPanel = this.createAllParametersPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        internalPanel.add((Component)fileSelectionPanel, c);
        ++c.gridy;
        c.weighty = 0.0;
        internalPanel.add((Component)allParametersPanel, c);
        this.setInternalComponent(internalPanel);
    }

    private JPanel createFileSelectionPanel() {
        Preferences preferences = NbPreferences.root();
        this.m_defaultImportMQPath = preferences.get("DefaultImportMQResultPath", "");
        JPanel fileSelectionPanel = new JPanel(new GridBagLayout());
        fileSelectionPanel.setBorder(BorderFactory.createTitledBorder(" Files Selection "));
        this.m_fileList = new JList(new DefaultListModel());
        JScrollPane m_fileListScrollPane = new JScrollPane(this.m_fileList){
            private Dimension preferredSize;
            {
                this.preferredSize = new Dimension(360, 200);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.preferredSize;
            }
        };
        this.m_addFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.OPEN_FILE));
        this.m_addFileButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_removeFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
        this.m_removeFileButton.setMargin(new Insets(2, 2, 2, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        fileSelectionPanel.add((Component)m_fileListScrollPane, c);
        ++c.gridx;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        fileSelectionPanel.add((Component)this.m_addFileButton, c);
        ++c.gridy;
        fileSelectionPanel.add((Component)this.m_removeFileButton, c);
        ++c.gridy;
        fileSelectionPanel.add(Box.createVerticalStrut(30), c);
        this.m_fileList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean sometingSelected = ImportMaxQuantResultDialog.this.m_fileList.getSelectedIndex() != -1;
                ImportMaxQuantResultDialog.this.m_removeFileButton.setEnabled(sometingSelected);
            }
        });
        this.m_addFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportMaxQuantResultDialog.this.setStatus(false, String.format("%d file(s)", ImportMaxQuantResultDialog.this.m_fileList.getModel().getSize()));
                if (ImportMaxQuantResultDialog.this.m_defaultImportMQPath != null && ImportMaxQuantResultDialog.this.m_defaultImportMQPath.length() > 0) {
                    ImportMaxQuantResultDialog.this.m_fchooser = new JFileChooser(new File(ImportMaxQuantResultDialog.this.m_defaultImportMQPath));
                } else {
                    ImportMaxQuantResultDialog.this.m_fchooser = new JFileChooser();
                }
                ImportMaxQuantResultDialog.this.m_fchooser.setMultiSelectionEnabled(false);
                ImportMaxQuantResultDialog.this.m_fchooser.setFileSelectionMode(1);
                int result = ImportMaxQuantResultDialog.this.m_fchooser.showOpenDialog((Component)((Object)m_singletonDialog));
                if (result == 0) {
                    boolean hasFilesPreviously = ImportMaxQuantResultDialog.this.m_fileList.getModel().getSize() != 0;
                    File[] files = new File[]{ImportMaxQuantResultDialog.this.m_fchooser.getSelectedFile()};
                    int nbFiles = files.length;
                    for (int i = 0; i < nbFiles; ++i) {
                        ((DefaultListModel)ImportMaxQuantResultDialog.this.m_fileList.getModel()).addElement(files[i]);
                    }
                    ImportMaxQuantResultDialog.this.setStatus(false, String.format("%d file(s)", ImportMaxQuantResultDialog.this.m_fileList.getModel().getSize()));
                    if (nbFiles > 0) {
                        File f = files[0];
                        if ((f = f.getParentFile()) != null && f.isDirectory()) {
                            ImportMaxQuantResultDialog.this.m_defaultImportMQPath = f.getAbsolutePath();
                        }
                    }
                }
            }
        });
        this.m_removeFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedValues = ImportMaxQuantResultDialog.this.m_fileList.getSelectedValuesList();
                Iterator it = selectedValues.iterator();
                while (it.hasNext()) {
                    ((DefaultListModel)ImportMaxQuantResultDialog.this.m_fileList.getModel()).removeElement(it.next());
                }
                ImportMaxQuantResultDialog.this.setStatus(false, String.format("%d file(s)", ImportMaxQuantResultDialog.this.m_fileList.getModel().getSize()));
                ImportMaxQuantResultDialog.this.m_removeFileButton.setEnabled(false);
            }
        });
        return fileSelectionPanel;
    }

    private JPanel createAllParametersPanel() {
        JPanel allParametersPanel = new JPanel(new GridBagLayout());
        allParametersPanel.setBorder(BorderFactory.createTitledBorder(" Parameters "));
        this.m_sourceParameterList = this.createSourceParameters();
        this.m_sourceParameterList.updateValues(NbPreferences.root());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        ++c.gridy;
        JLabel instrumentLabel = new JLabel("Instrument :");
        instrumentLabel.setHorizontalAlignment(4);
        allParametersPanel.add((Component)instrumentLabel, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        allParametersPanel.add((Component)this.m_instrumentsComboBox, c);
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        ++c.gridy;
        JLabel peaklistSoftwareLabel = new JLabel("Accession regexp :");
        peaklistSoftwareLabel.setHorizontalAlignment(4);
        allParametersPanel.add((Component)peaklistSoftwareLabel, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        allParametersPanel.add((Component)this.m_accessionRegexpTF, c);
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        ++c.gridy;
        allParametersPanel.add((Component)new JPanel(), c);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        allParametersPanel.add((Component)this.m_importQuantitationCB, c);
        return allParametersPanel;
    }

    public long getInstrumentId() {
        InstrumentConfiguration instrument = (InstrumentConfiguration)this.m_sourceParameterList.getParameter("instrument").getObjectValue();
        return instrument.getId();
    }

    public String getAccessionRegexp() {
        return this.m_sourceParameterList.getParameter("accession_regexp").getStringValue();
    }

    public Boolean getImportQuantitation() {
        return (Boolean)this.m_sourceParameterList.getParameter("import_quant_result").getObjectValue();
    }

    public File[] getFilePaths() {
        DefaultListModel model = (DefaultListModel)this.m_fileList.getModel();
        int nbFiles = model.getSize();
        File[] filePaths = new File[nbFiles];
        for (int i = 0; i < nbFiles; ++i) {
            filePaths[i] = (File)model.getElementAt(i);
        }
        return filePaths;
    }

    protected String getSettingsKey() {
        return SETTINGS_KEY;
    }

    protected boolean checkParameters() {
        ParameterError error = this.m_sourceParameterList.checkParameters();
        if (error != null) {
            this.setStatus(true, error.getErrorMessage());
            this.highlight(error.getParameterComponent());
            return false;
        }
        return true;
    }

    protected void resetParameters() {
        ((DefaultListModel)this.m_fileList.getModel()).removeAllElements();
        this.m_removeFileButton.setEnabled(false);
        this.setStatus(false, String.format("%d file(s)", this.m_fileList.getModel().getSize()));
        this.restoreInitialParameters(NbPreferences.root());
    }

    protected void loadParameters(Preferences filePreferences) throws Exception {
        Preferences preferences = NbPreferences.root();
        String[] keys = filePreferences.keys();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            String value = filePreferences.get(key, null);
            preferences.put(key, value);
        }
        this.restoreInitialParameters(preferences);
        this.m_sourceParameterList.loadParameters(filePreferences);
    }

    protected void saveParameters(Preferences preferences) {
        if (this.m_defaultImportMQPath != null) {
            preferences.put("DefaultImportMQResultPath", this.m_defaultImportMQPath);
        }
        this.m_sourceParameterList.saveParameters(preferences);
    }

    protected boolean okCalled() {
        if (!this.checkParametersForOK()) {
            return false;
        }
        this.saveParameters(NbPreferences.root());
        return true;
    }

    protected boolean cancelCalled() {
        return true;
    }

    private boolean checkParametersForOK() {
        int nbFiles = this.m_fileList.getModel().getSize();
        if (nbFiles == 0) {
            this.setStatus(true, "You must select a MaxQuant result folder to import.");
            this.highlight(this.m_fileList);
            return false;
        }
        return this.checkParameters();
    }

    private void restoreInitialParameters(Preferences preferences) {
        this.m_defaultImportMQPath = preferences.get("DefaultImportMQResultPath", null);
    }

    private ParameterList createSourceParameters() {
        ParameterList parameterList = new ParameterList("Parameter Source");
        AbstractParameterToString<InstrumentConfiguration> instrumentToString = new AbstractParameterToString<InstrumentConfiguration>(){

            public String toString(InstrumentConfiguration o) {
                return o.getName();
            }
        };
        AbstractParameterToString<PeaklistSoftware> softwareToString = new AbstractParameterToString<PeaklistSoftware>(){

            public String toString(PeaklistSoftware o) {
                String version = o.getVersion();
                if (version == null) {
                    return o.getName();
                }
                return o.getName() + " " + version;
            }
        };
        this.m_instrumentsComboBox = new JComboBox<InstrumentConfiguration>(DatabaseDataManager.getDatabaseDataManager().getInstrumentsWithNullArray());
        final ObjectParameter instrumentParameter = new ObjectParameter("instrument", "Instrument", this.m_instrumentsComboBox, (Object[])DatabaseDataManager.getDatabaseDataManager().getInstrumentsWithNullArray(), null, -1, (AbstractParameterToString)instrumentToString);
        parameterList.add((Object)instrumentParameter);
        this.m_instrumentsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                instrumentParameter.setUsed(true);
            }
        });
        this.m_accessionRegexpTF = new JTextField(20);
        this.m_accessionRegexpTF.setToolTipText("Specify regular expression to extract Protein accession from MaxQuant Protein Ids.\\n Leave blanc if not needed");
        StringParameter accessionParameter = new StringParameter("accession_regexp", "Accession regular expression", (JComponent)this.m_accessionRegexpTF, "", Integer.valueOf(0), null);
        accessionParameter.setUsed(true);
        parameterList.add((Object)accessionParameter);
        this.m_importQuantitationCB = new JCheckBox("Import quantitation values");
        BooleanParameter importParameter = new BooleanParameter("import_quant_result", "Import quantitation results", (JComponent)this.m_importQuantitationCB, Boolean.valueOf(false));
        importParameter.setUsed(true);
        parameterList.add((Object)importParameter);
        return parameterList;
    }
}

