/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.Exceptions;
import fr.proline.studio.NbPreferences;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dpm.data.ChangeTypicalRule;
import fr.proline.studio.dpm.task.jms.ValidationTask;
import fr.proline.studio.gui.DefaultStorableDialog;
import fr.proline.studio.gui.InfoDialog;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.BooleanParameter;
import fr.proline.studio.parameter.DoubleParameter;
import fr.proline.studio.parameter.IntegerParameter;
import fr.proline.studio.parameter.NoneParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.ParametersComboPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.ChangeTypicalProteinPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.FilterProteinSetPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.Timer;

public class ValidationDialog
extends DefaultStorableDialog {
    private static ValidationDialog m_singletonDialog = null;
    private boolean m_allowPropagateFilters = true;
    private static final String[] FDR_METHODS_VALUES = new String[]{"Target/Decoy", "BH"};
    private static final String[] FDR_METHODS_ASSOCIATED_KEYS = new String[]{"TARGET_DECOY", "BH"};
    private static final String[] PSM_FDR_ON_VALUES = new String[]{null, "Score", "e-Value", "Adjusted e-Value", "Identity p-Value", "Homology p-Value"};
    private static final String[] PSM_FDR_ON_VALUES_ASSOCIATED_KEYS = new String[]{null, "SCORE", "MASCOT_EVALUE", "MASCOT_ADJUSTED_EVALUE", "SCORE_IT_P-VALUE", "SCORE_HT_P-VALUE"};
    private static final String[] PROTEIN_SCORING_TYPE_OPTIONS = new String[]{"Standard", "Mascot Mudpit", "Mascot Modified Mudpit", "Fisher"};
    private static final String[] PROTEIN_SCORING_TYPE_VALUES = new String[]{"mascot:standard score", "mascot:mudpit score", "mascot:modified mudpit score", "proline:fisher score"};
    private static final String SETTINGS_KEY = "Validation";
    public static final String VALIDATION_PARAMS_VERSION_KEY = "Validation.parametersVersion";
    private final Integer VALIDATION_PARAM_CURRENT_VERSION = 3;
    private boolean m_checkFDR = true;
    private final ParameterList m_parameterList;
    private AbstractParameter[] m_psmPrefilterParameters;
    private ParametersComboPanel m_psmPrefiltersPanel;
    private AbstractParameter[] m_peptidePrefilterParameters;
    private ParametersComboPanel m_peptidePrefiltersPanel;
    private AbstractParameter m_psmFdrFilterParameter;
    private ObjectParameter<String> m_psmFdrPropertyParameter;
    private ObjectParameter<String> m_fdrMethodParameter;
    private AbstractParameter m_proteinFdrFilterParameter;
    private AbstractParameter m_peptideFdrFilterParameter;
    private AbstractParameter m_propagatePsmFiltersParameter;
    private JCheckBox m_propagatePsmFiltersCheckBox = null;
    private AbstractParameter[] m_proteinPrefilterParameters;
    private ParametersComboPanel m_proteinPrefiltersPanel;
    private AbstractParameter m_propagateProtSetFiltersParameter;
    private JCheckBox m_propagateProtSetFiltersCheckBox = null;
    private JLabel m_fdrLabelEnsure = null;
    private JLabel m_fdrLabelFDRLessThan = null;
    private JTextField m_psmFdrTextField = null;
    private JLabel m_fdrPercentageLabel = null;
    private JComboBox<String> m_psmFdrPropertyComboBox = null;
    private JComboBox<String> m_psmFdrMethodComboBox = null;
    private AbstractParameter m_psmFdrCheckboxParameter;
    private JCheckBox m_psmFdrCheckbox = null;
    private JPanel m_tdParamsPanel;
    private JLabel m_proteinFdrLabel = null;
    private JTextField m_proteinFdrTextField = null;
    private JLabel m_proteinFdrPercentageLabel = null;
    private JComboBox<String> m_proteinFdrMethodComboBox = null;
    private AbstractParameter m_proteinFdrCheckboxParameter;
    private JCheckBox m_proteinFdrCheckbox = null;
    private JLabel m_peptideFdrLabel = null;
    private JTextField m_peptideFdrTextField = null;
    private JLabel m_peptideFdrPercentageLabel = null;
    private JComboBox<String> m_peptideFdrMethodComboBox = null;
    private AbstractParameter m_peptideFdrCheckboxParameter;
    private JCheckBox m_peptideFdrCheckbox = null;
    private JCheckBox m_typicalProteinMatchCheckBox;
    private ChangeTypicalProteinPanel m_changeTypicalPanel = null;
    private JComboBox<String> m_proteinScoringTypeCbx = null;
    private DecoyStatus m_hasDecoy = DecoyStatus.WAITING;
    private String m_softwareName = "UNKNOWN";

    public static ValidationDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new ValidationDialog(parent);
        }
        return m_singletonDialog;
    }

    public ValidationDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(true);
        this.setTitle("Identification Validation");
        this.setDocumentationSuffix("id.42ddq1a");
        this.m_parameterList = new ParameterList(SETTINGS_KEY);
        this.createParameters();
        this.m_parameterList.updateValues(NbPreferences.root());
        this.setInternalComponent(this.createInternalPanel());
        this.updatePSMFDRObjects(this.m_psmFdrCheckboxParameter.isUsed());
        this.updatePeptideFDRConsistency();
        this.updateSelectedFilters();
        this.restoreScoringTypeParameter(NbPreferences.root());
        this.restoreTypicalProteinParameters(NbPreferences.root());
    }

    public synchronized void setHasDecoy(DecoyStatus hasDecoy) {
        this.m_hasDecoy = hasDecoy;
    }

    public synchronized DecoyStatus getHasDecoy() {
        return this.m_hasDecoy;
    }

    public synchronized void setSoftwareName(String softwareName) {
        this.m_softwareName = softwareName;
    }

    public void setAllowPropagateFilters(boolean allowPropagateFilters) {
        if (this.m_allowPropagateFilters != allowPropagateFilters) {
            if (!allowPropagateFilters) {
                this.m_propagatePsmFiltersCheckBox.setSelected(false);
                this.m_propagateProtSetFiltersCheckBox.setSelected(false);
                this.m_propagateProtSetFiltersParameter.setUsed(false);
                this.m_propagatePsmFiltersParameter.setUsed(false);
            }
            this.m_propagateProtSetFiltersCheckBox.setEnabled(allowPropagateFilters);
            this.m_propagatePsmFiltersCheckBox.setEnabled(allowPropagateFilters);
        }
        this.m_allowPropagateFilters = allowPropagateFilters;
        this.revalidate();
        this.repack();
    }

    public boolean isPropagateFiltersSelected() {
        return this.m_propagatePsmFiltersCheckBox.isEnabled() && this.m_propagatePsmFiltersCheckBox.isSelected() || this.m_propagateProtSetFiltersCheckBox.isEnabled() && this.m_propagateProtSetFiltersCheckBox.isSelected();
    }

    public void setDatasetList(final ArrayList<DDataset> datasetList) {
        this.setHasDecoy(DecoyStatus.WAITING);
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                DecoyStatus decoyStatus = DecoyStatus.HAS_DECOY;
                HashSet<String> softwareNames = new HashSet<String>();
                for (DDataset dataset : datasetList) {
                    ResultSet rset = dataset.getResultSet();
                    if (rset.getDecoyResultSet() == null) {
                        decoyStatus = DecoyStatus.NO_DECOY;
                    }
                    if (rset.getMsiSearch() != null) {
                        softwareNames.add(rset.getMsiSearch().getSearchSetting().getSoftwareName().toUpperCase());
                        continue;
                    }
                    softwareNames.add("UNKNOWN");
                }
                ValidationDialog.this.setHasDecoy(decoyStatus);
                ValidationDialog.this.setSoftwareName(softwareNames.size() == 1 ? (String)softwareNames.iterator().next() : "MIXED");
            }
        };
        DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
        task.initLoadRsetAndRsm(datasetList);
        task.setPriority(AbstractDatabaseTask.Priority.HIGH_3);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
    }

    private void updateSelectedFilters() {
        this.m_psmPrefiltersPanel.updatePanel();
        this.m_proteinPrefiltersPanel.updatePanel();
        this.m_peptidePrefiltersPanel.updatePanel();
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Validation Parameters", null, this.createValidationPanel(), null);
        tabbedPane.addTab("Typical Protein Parameters", null, this.createTypicalProteinPanel(), null);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        internalPanel.add((Component)tabbedPane, c);
        return internalPanel;
    }

    private JPanel createValidationPanel() {
        JPanel validationPanel = new JPanel(new BorderLayout());
        JScrollPane sPane = new JScrollPane();
        JPanel psmTabPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        psmTabPanel.add((Component)this.createPSMFilterPanel(), c);
        ++c.gridy;
        psmTabPanel.add((Component)this.createPeptideFilterPanel(), c);
        ++c.gridy;
        psmTabPanel.add((Component)this.createProteinSetFilterPanel(), c);
        sPane.setViewportView(psmTabPanel);
        validationPanel.add((Component)sPane, "Center");
        return validationPanel;
    }

    private JPanel createPeptideFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(" Peptide"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        this.m_peptidePrefiltersPanel = new ParametersComboPanel(" Filter(s) ", this.m_peptidePrefilterParameters);
        panel.add((Component)this.m_peptidePrefiltersPanel, c);
        ++c.gridy;
        panel.add((Component)this.createPeptideFDRPanel(), c);
        return panel;
    }

    private JPanel createPSMFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(" PSM"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        if (!this.m_allowPropagateFilters) {
            this.m_propagatePsmFiltersCheckBox.setSelected(false);
        }
        this.m_propagatePsmFiltersCheckBox.setEnabled(this.m_allowPropagateFilters);
        panel.add((Component)this.m_propagatePsmFiltersCheckBox, c);
        this.m_propagatePsmFiltersCheckBox.addActionListener(e -> {
            boolean enabled = this.m_propagatePsmFiltersCheckBox.isSelected();
            this.m_propagatePsmFiltersParameter.setUsed(enabled);
        });
        ++c.gridy;
        c.weightx = 1.0;
        this.m_psmPrefiltersPanel = new ParametersComboPanel(" Prefilter(s) ", this.m_psmPrefilterParameters);
        panel.add((Component)this.m_psmPrefiltersPanel, c);
        ++c.gridy;
        panel.add((Component)this.createPSMFDRPanel(), c);
        return panel;
    }

    private JPanel createPSMFDRPanel() {
        JPanel fdrPanel = new JPanel(new GridBagLayout());
        fdrPanel.setBorder(BorderFactory.createTitledBorder(" FDR PSM Filter "));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 2, 5, 2);
        this.m_fdrLabelEnsure = new JLabel("ensure");
        this.m_fdrLabelFDRLessThan = new JLabel("FDR <=");
        this.m_fdrPercentageLabel = new JLabel("%");
        c.gridx = 0;
        c.gridy = 0;
        fdrPanel.add((Component)this.m_psmFdrCheckbox, c);
        ++c.gridx;
        fdrPanel.add((Component)this.m_fdrLabelEnsure, c);
        ++c.gridx;
        fdrPanel.add(this.m_psmFdrMethodComboBox, c);
        ++c.gridx;
        fdrPanel.add((Component)this.m_fdrLabelFDRLessThan, c);
        ++c.gridx;
        fdrPanel.add((Component)this.m_psmFdrTextField, c);
        ++c.gridx;
        fdrPanel.add((Component)this.m_fdrPercentageLabel, c);
        ++c.gridx;
        c.weightx = 0.1;
        fdrPanel.add((Component)Box.createHorizontalBox(), c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 6;
        fdrPanel.add((Component)this.createTDPSMParamsPanel(), c);
        ++c.gridx;
        c.weightx = 0.1;
        this.m_tdParamsPanel.add((Component)Box.createHorizontalBox(), c);
        this.m_psmFdrCheckbox.addActionListener(e -> this.updatePSMFDRObjects(this.m_psmFdrCheckbox.isSelected()));
        MouseAdapter actionOnClick = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ValidationDialog.this.m_psmFdrCheckbox.isSelected()) {
                    ValidationDialog.this.updatePSMFDRObjects(true);
                    if (JComponent.class.isAssignableFrom(e.getSource().getClass())) {
                        ((JComponent)e.getSource()).requestFocusInWindow();
                    }
                }
            }
        };
        this.m_fdrLabelEnsure.addMouseListener(actionOnClick);
        this.m_fdrLabelFDRLessThan.addMouseListener(actionOnClick);
        this.m_psmFdrTextField.addMouseListener(actionOnClick);
        this.m_psmFdrMethodComboBox.addMouseListener(actionOnClick);
        return fdrPanel;
    }

    private JPanel createTDPSMParamsPanel() {
        this.m_tdParamsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 2, 5, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.1;
        this.m_tdParamsPanel.add((Component)Box.createHorizontalBox(), c);
        ++c.gridx;
        c.weightx = 0.0;
        this.m_tdParamsPanel.add((Component)new JLabel("Optimisation based on "), c);
        ++c.gridx;
        this.m_tdParamsPanel.add(this.m_psmFdrPropertyComboBox, c);
        ++c.gridx;
        c.weightx = 0.1;
        this.m_tdParamsPanel.add((Component)Box.createHorizontalBox(), c);
        return this.m_tdParamsPanel;
    }

    private void updatePSMFDRObjects(boolean enabled) {
        this.m_psmFdrCheckbox.setSelected(enabled);
        this.m_fdrLabelEnsure.setEnabled(enabled);
        this.m_fdrLabelFDRLessThan.setEnabled(enabled);
        this.m_psmFdrTextField.setEnabled(enabled);
        this.m_fdrPercentageLabel.setEnabled(enabled);
        this.setPanelEnabled(this.m_tdParamsPanel, enabled);
        this.m_psmFdrMethodComboBox.setEnabled(enabled);
        if (enabled) {
            Object fdrMethod = this.m_psmFdrMethodComboBox.getSelectedItem();
            boolean isTargetDecoyFdr = fdrMethod != null && ((String)fdrMethod).toLowerCase().contains("decoy");
            this.setPanelEnabled(this.m_tdParamsPanel, isTargetDecoyFdr);
            this.m_psmFdrPropertyParameter.setUsed(isTargetDecoyFdr);
        } else {
            this.m_psmFdrPropertyParameter.setUsed(false);
        }
        this.m_psmFdrFilterParameter.setUsed(enabled);
        this.m_psmFdrCheckboxParameter.setUsed(enabled);
        this.updateFdrMethod();
    }

    private JPanel createPeptideFDRPanel() {
        JPanel fdrPanel = new JPanel(new GridBagLayout());
        fdrPanel.setBorder(BorderFactory.createTitledBorder(" FDR Peptide Filter "));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        boolean parameterUsed = this.m_peptideFdrFilterParameter.isUsed();
        this.m_peptideFdrLabel = new JLabel("Peptide FDR <=");
        this.m_peptideFdrCheckbox.setSelected(parameterUsed);
        this.m_peptideFdrPercentageLabel = new JLabel(" %");
        this.updatePeptideFDRObjects(parameterUsed);
        c.gridx = 0;
        c.gridy = 0;
        fdrPanel.add((Component)this.m_peptideFdrCheckbox, c);
        ++c.gridx;
        fdrPanel.add(this.m_peptideFdrMethodComboBox, c);
        this.m_peptideFdrMethodComboBox.addActionListener(e -> {
            this.synchFDRMethods((JComboBox)e.getSource());
            this.updatePeptideFDRConsistency();
        });
        ++c.gridx;
        fdrPanel.add((Component)this.m_peptideFdrLabel, c);
        ++c.gridx;
        fdrPanel.add((Component)this.m_peptideFdrTextField, c);
        ++c.gridx;
        fdrPanel.add((Component)this.m_peptideFdrPercentageLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        fdrPanel.add((Component)Box.createHorizontalBox(), c);
        this.m_peptideFdrCheckbox.addActionListener(e -> this.updatePeptideFDRObjects(this.m_peptideFdrCheckbox.isSelected()));
        MouseAdapter actionOnClick = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ValidationDialog.this.m_peptideFdrCheckbox.isSelected()) {
                    ValidationDialog.this.updatePeptideFDRObjects(true);
                    if (JComponent.class.isAssignableFrom(e.getSource().getClass())) {
                        ((JComponent)e.getSource()).requestFocusInWindow();
                    }
                }
            }
        };
        this.m_peptideFdrLabel.addMouseListener(actionOnClick);
        this.m_peptideFdrTextField.addMouseListener(actionOnClick);
        this.m_peptideFdrMethodComboBox.addMouseListener(actionOnClick);
        return fdrPanel;
    }

    private JPanel createProteinSetFilterPanel() {
        JPanel proteinSetFilterPanel = new JPanel(new GridBagLayout());
        proteinSetFilterPanel.setBorder(BorderFactory.createTitledBorder(" Protein Set "));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        if (!this.m_allowPropagateFilters) {
            this.m_propagateProtSetFiltersCheckBox.setSelected(false);
        }
        this.m_propagateProtSetFiltersCheckBox.setEnabled(this.m_allowPropagateFilters);
        proteinSetFilterPanel.add((Component)this.m_propagateProtSetFiltersCheckBox, c);
        this.m_propagateProtSetFiltersCheckBox.addActionListener(e -> this.m_propagateProtSetFiltersParameter.setUsed(this.m_propagateProtSetFiltersCheckBox.isSelected()));
        ++c.gridy;
        c.weightx = 1.0;
        this.m_proteinPrefiltersPanel = new ParametersComboPanel(" Filter(s) ", this.m_proteinPrefilterParameters);
        proteinSetFilterPanel.add((Component)this.m_proteinPrefiltersPanel, c);
        ++c.gridy;
        proteinSetFilterPanel.add((Component)this.createProteinFDRPanel(), c);
        ++c.gridy;
        proteinSetFilterPanel.add((Component)this.createScoringTypePanel(), c);
        return proteinSetFilterPanel;
    }

    private JPanel createTypicalProteinPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.anchor = 18;
        c1.fill = 1;
        c1.insets = new Insets(5, 5, 5, 5);
        c1.gridx = 0;
        c1.gridy = 0;
        c1.weightx = 1.0;
        JPanel typicalProteinPanel = new JPanel(new GridBagLayout());
        typicalProteinPanel.setBorder(BorderFactory.createTitledBorder("Set Typical Protein Match "));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        this.m_typicalProteinMatchCheckBox = new JCheckBox("Using rules (in priority order):");
        this.m_typicalProteinMatchCheckBox.setHorizontalAlignment(4);
        typicalProteinPanel.add((Component)this.m_typicalProteinMatchCheckBox, c);
        this.m_typicalProteinMatchCheckBox.addActionListener(e -> this.m_changeTypicalPanel.enableRules(this.m_typicalProteinMatchCheckBox.isSelected()));
        c.gridx = 0;
        ++c.gridy;
        this.m_changeTypicalPanel = new ChangeTypicalProteinPanel();
        typicalProteinPanel.add((Component)this.m_changeTypicalPanel, c);
        ++c.gridy;
        c.weighty = 1.0;
        typicalProteinPanel.add(Box.createVerticalGlue(), c);
        panel.add((Component)typicalProteinPanel, c1);
        ++c1.gridy;
        c1.weighty = 1.0;
        panel.add(Box.createVerticalGlue(), c1);
        return panel;
    }

    private JPanel createProteinFDRPanel() {
        JPanel fdrPanel = new JPanel(new GridBagLayout());
        fdrPanel.setBorder(BorderFactory.createTitledBorder(" FDR Protein Filter "));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_proteinFdrLabel = new JLabel("Protein FDR <=");
        this.m_proteinFdrPercentageLabel = new JLabel(" %");
        this.updateProteinFDRObjects(this.m_proteinFdrCheckboxParameter.isUsed());
        c.gridx = 0;
        c.gridy = 0;
        fdrPanel.add((Component)this.m_proteinFdrCheckbox, c);
        ++c.gridx;
        fdrPanel.add(this.m_proteinFdrMethodComboBox, c);
        this.m_proteinFdrMethodComboBox.addActionListener(e -> this.synchFDRMethods((JComboBox)e.getSource()));
        ++c.gridx;
        fdrPanel.add((Component)this.m_proteinFdrLabel, c);
        ++c.gridx;
        fdrPanel.add((Component)this.m_proteinFdrTextField, c);
        ++c.gridx;
        fdrPanel.add((Component)this.m_proteinFdrPercentageLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        fdrPanel.add((Component)Box.createHorizontalBox(), c);
        this.m_proteinFdrCheckbox.addActionListener(e -> this.updateProteinFDRObjects(this.m_proteinFdrCheckbox.isSelected()));
        MouseAdapter actionOnClick = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ValidationDialog.this.m_proteinFdrCheckbox.isSelected()) {
                    ValidationDialog.this.updateProteinFDRObjects(true);
                    if (JComponent.class.isAssignableFrom(e.getSource().getClass())) {
                        ((JComponent)e.getSource()).requestFocusInWindow();
                    }
                }
            }
        };
        this.m_proteinFdrLabel.addMouseListener(actionOnClick);
        this.m_proteinFdrTextField.addMouseListener(actionOnClick);
        this.m_proteinFdrMethodComboBox.addMouseListener(actionOnClick);
        return fdrPanel;
    }

    private JPanel createScoringTypePanel() {
        JPanel scoringTypePanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel proteinScoringTypeLabel = new JLabel("Scoring Type: ");
        this.m_proteinScoringTypeCbx = new JComboBox<String>(PROTEIN_SCORING_TYPE_OPTIONS);
        c.gridx = 0;
        c.gridy = 0;
        scoringTypePanel.add((Component)proteinScoringTypeLabel, c);
        ++c.gridx;
        scoringTypePanel.add(this.m_proteinScoringTypeCbx, c);
        ++c.gridx;
        c.weightx = 1.0;
        scoringTypePanel.add((Component)Box.createHorizontalBox(), c);
        return scoringTypePanel;
    }

    private void restoreScoringTypeParameter(Preferences preferences) {
        String scoringType = preferences == null ? PROTEIN_SCORING_TYPE_OPTIONS[0] : preferences.get("ValidationScoringType", PROTEIN_SCORING_TYPE_OPTIONS[0]);
        this.m_proteinScoringTypeCbx.setSelectedItem(scoringType);
    }

    private void restoreTypicalProteinParameters(Preferences preferences) {
        boolean useTypicalProteinRegex = preferences == null || preferences.getBoolean("UseTypicalProteinRegex", true);
        this.m_typicalProteinMatchCheckBox.setSelected(useTypicalProteinRegex);
        this.m_changeTypicalPanel.restoreInitialParameters();
        this.m_changeTypicalPanel.enableRules(useTypicalProteinRegex);
    }

    private void updateProteinFDRObjects(boolean enabled) {
        this.m_proteinFdrCheckbox.setSelected(enabled);
        this.m_proteinFdrCheckboxParameter.setUsed(enabled);
        this.m_proteinFdrLabel.setEnabled(enabled);
        this.m_proteinFdrTextField.setEnabled(enabled);
        this.m_proteinFdrPercentageLabel.setEnabled(enabled);
        this.m_proteinFdrMethodComboBox.setEnabled(enabled);
        this.m_proteinFdrFilterParameter.setUsed(enabled);
        this.updateFdrMethod();
    }

    private void synchFDRMethods(JComboBox<String> source) {
        if (source != this.m_psmFdrMethodComboBox) {
            this.m_psmFdrMethodComboBox.setSelectedItem(source.getSelectedItem());
        }
        if (source != this.m_peptideFdrMethodComboBox) {
            this.m_peptideFdrMethodComboBox.setSelectedItem(source.getSelectedItem());
        }
        if (source != this.m_proteinFdrMethodComboBox) {
            this.m_proteinFdrMethodComboBox.setSelectedItem(source.getSelectedItem());
        }
    }

    private void updatePeptideFDRConsistency() {
        boolean isTargetDecoyFdr;
        Object fdrMethod = this.m_peptideFdrMethodComboBox.getSelectedItem();
        boolean bl = isTargetDecoyFdr = fdrMethod != null && ((String)fdrMethod).toLowerCase().contains("decoy");
        if (isTargetDecoyFdr) {
            this.updatePeptideFDRObjects(false);
            this.m_peptideFdrCheckbox.setEnabled(false);
            this.m_peptideFdrCheckboxParameter.setUsed(false);
        } else {
            this.m_peptideFdrCheckbox.setEnabled(true);
            this.m_peptideFdrCheckboxParameter.setUsed(true);
        }
    }

    private void updatePeptideFDRObjects(boolean enabled) {
        this.m_peptideFdrCheckbox.setSelected(enabled);
        this.m_peptideFdrCheckboxParameter.setUsed(enabled);
        this.m_peptideFdrLabel.setEnabled(enabled);
        this.m_peptideFdrTextField.setEnabled(enabled);
        this.m_peptideFdrPercentageLabel.setEnabled(enabled);
        this.m_peptideFdrMethodComboBox.setEnabled(enabled);
        this.m_peptideFdrFilterParameter.setUsed(enabled);
        this.updateFdrMethod();
    }

    private void updateFdrMethod() {
        this.m_fdrMethodParameter.setUsed(this.m_peptideFdrCheckbox.isSelected() || this.m_psmFdrCheckbox.isSelected() || this.m_proteinFdrCheckbox.isSelected());
    }

    private void createParameters() {
        this.m_psmPrefilterParameters = new AbstractParameter[12];
        this.m_psmPrefilterParameters[0] = null;
        this.m_psmPrefilterParameters[1] = new IntegerParameter("PSM_" + ValidationTask.PSMFilter.RANK.key, ValidationTask.PSMFilter.RANK.name, (JComponent)new JTextField(6), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(10));
        this.m_psmPrefilterParameters[1].setAssociatedData((Object)"<=");
        this.m_psmPrefilterParameters[1].addBackwardCompatibleKey("Rank");
        this.m_psmPrefilterParameters[1].addBackwardCompatibleKey("PSM_RANK");
        this.m_psmPrefilterParameters[2] = new IntegerParameter("PSM_" + ValidationTask.PSMFilter.PEP_LENGTH.key, ValidationTask.PSMFilter.PEP_LENGTH.name, (JComponent)new JTextField(6), Integer.valueOf(4), Integer.valueOf(4), null);
        this.m_psmPrefilterParameters[2].setAssociatedData((Object)">=");
        this.m_psmPrefilterParameters[3] = new DoubleParameter("PSM_" + ValidationTask.PSMFilter.SCORE.key, ValidationTask.PSMFilter.SCORE.name, (JComponent)new JTextField(6), Double.valueOf(0.0), Double.valueOf(0.0), null);
        this.m_psmPrefilterParameters[3].setAssociatedData((Object)">=");
        this.m_psmPrefilterParameters[4] = new DoubleParameter("PSM_" + ValidationTask.PSMFilter.MASCOT_EVAL.key, ValidationTask.PSMFilter.MASCOT_EVAL.name, (JComponent)new JTextField(6), Double.valueOf(1.0), Double.valueOf(0.0), Double.valueOf(1.0));
        this.m_psmPrefilterParameters[4].setAssociatedData((Object)"<=");
        this.m_psmPrefilterParameters[5] = new DoubleParameter("PSM_" + ValidationTask.PSMFilter.MASCOT_ADJUSTED_EVALUE.key, ValidationTask.PSMFilter.MASCOT_ADJUSTED_EVALUE.name, (JComponent)new JTextField(6), Double.valueOf(1.0), Double.valueOf(0.0), Double.valueOf(1.0));
        this.m_psmPrefilterParameters[5].setAssociatedData((Object)"<=");
        this.m_psmPrefilterParameters[6] = new DoubleParameter("PSM_" + ValidationTask.PSMFilter.MASCOT_IT_SCORE.key, ValidationTask.PSMFilter.MASCOT_IT_SCORE.name, (JComponent)new JTextField(6), Double.valueOf(0.05), Double.valueOf(0.0), Double.valueOf(1.0));
        this.m_psmPrefilterParameters[6].setAssociatedData((Object)"=");
        this.m_psmPrefilterParameters[7] = new DoubleParameter("PSM_" + ValidationTask.PSMFilter.MASCOT_HT_SCORE.key, ValidationTask.PSMFilter.MASCOT_HT_SCORE.name, (JComponent)new JTextField(6), Double.valueOf(0.05), Double.valueOf(0.0), Double.valueOf(1.0));
        this.m_psmPrefilterParameters[7].setAssociatedData((Object)"=");
        this.m_psmPrefilterParameters[8] = new NoneParameter("PSM_" + ValidationTask.PSMFilter.SINGLE_PSM_QUERY.key, ValidationTask.PSMFilter.SINGLE_PSM_QUERY.name);
        this.m_psmPrefilterParameters[8].setAssociatedData((Object)":");
        this.m_psmPrefilterParameters[9] = new NoneParameter("PSM_" + ValidationTask.PSMFilter.SINGLE_PSM_RANK.key, ValidationTask.PSMFilter.SINGLE_PSM_RANK.name);
        this.m_psmPrefilterParameters[9].setAssociatedData((Object)":");
        this.m_psmPrefilterParameters[10] = new NoneParameter("PSM_" + ValidationTask.PSMFilter.SINGLE_SEQ_RANK.key, ValidationTask.PSMFilter.SINGLE_SEQ_RANK.name);
        this.m_psmPrefilterParameters[10].setAssociatedData((Object)":");
        this.m_psmPrefilterParameters[11] = new IntegerParameter("PSM_" + ValidationTask.PSMFilter.ISOTOPE_OFFSET.key, ValidationTask.PSMFilter.ISOTOPE_OFFSET.name, (JComponent)new JTextField(6), Integer.valueOf(1), Integer.valueOf(0), null);
        this.m_psmPrefilterParameters[11].setAssociatedData((Object)"<=");
        for (AbstractParameter p : this.m_psmPrefilterParameters) {
            if (p == null) continue;
            p.setUsed(false);
            p.setCompulsory(false);
            this.m_parameterList.add((Object)p);
        }
        this.m_psmFdrCheckbox = new JCheckBox();
        this.m_psmFdrCheckboxParameter = new BooleanParameter("fdr_psm_validation", "PSM FDR Validation", (JComponent)this.m_psmFdrCheckbox, Boolean.valueOf(false));
        this.m_psmFdrCheckboxParameter.setUsed(false);
        this.m_psmFdrCheckboxParameter.setCompulsory(false);
        this.m_parameterList.add((Object)this.m_psmFdrCheckboxParameter);
        this.m_psmFdrTextField = new JTextField(5);
        this.m_psmFdrFilterParameter = new DoubleParameter(ValidationTask.ValidationParameters.EXPECTED_FDR.key, ValidationTask.ValidationParameters.EXPECTED_FDR.name, (JComponent)this.m_psmFdrTextField, Double.valueOf(1.0), Double.valueOf(0.0), Double.valueOf(10.0));
        this.m_psmFdrFilterParameter.setUsed(false);
        this.m_psmFdrFilterParameter.setCompulsory(false);
        this.m_parameterList.add((Object)this.m_psmFdrFilterParameter);
        this.m_psmFdrPropertyComboBox = new JComboBox<String>(PSM_FDR_ON_VALUES);
        this.m_psmFdrPropertyParameter = new ObjectParameter(ValidationTask.ValidationParameters.EXPECTED_FDR_PARAM.key, ValidationTask.ValidationParameters.EXPECTED_FDR_PARAM.name, this.m_psmFdrPropertyComboBox, (Object[])PSM_FDR_ON_VALUES, (Object[])PSM_FDR_ON_VALUES_ASSOCIATED_KEYS, 0, null);
        this.m_psmFdrPropertyParameter.setUsed(false);
        this.m_psmFdrPropertyParameter.setCompulsory(false);
        this.m_parameterList.add(this.m_psmFdrPropertyParameter);
        this.m_psmFdrMethodComboBox = new JComboBox<String>(FDR_METHODS_VALUES);
        this.m_peptideFdrMethodComboBox = new JComboBox<String>(FDR_METHODS_VALUES);
        this.m_proteinFdrMethodComboBox = new JComboBox<String>(FDR_METHODS_VALUES);
        this.m_psmFdrMethodComboBox.addActionListener(e -> {
            if (this.m_fdrLabelEnsure != null) {
                this.updatePSMFDRObjects(this.m_psmFdrCheckbox.isSelected());
            }
            this.synchFDRMethods((JComboBox)e.getSource());
        });
        this.m_fdrMethodParameter = new ObjectParameter(ValidationTask.ValidationParameters.FDR_METHOD.key, ValidationTask.ValidationParameters.FDR_METHOD.name, this.m_psmFdrMethodComboBox, (Object[])FDR_METHODS_VALUES, (Object[])FDR_METHODS_ASSOCIATED_KEYS, 0, null);
        this.m_fdrMethodParameter.setUsed(false);
        this.m_fdrMethodParameter.setCompulsory(false);
        this.m_parameterList.add(this.m_fdrMethodParameter);
        this.m_peptidePrefilterParameters = new AbstractParameter[1];
        this.m_peptidePrefilterParameters[0] = null;
        for (AbstractParameter p : this.m_peptidePrefilterParameters) {
            if (p == null) continue;
            p.setUsed(false);
            p.setCompulsory(false);
            this.m_parameterList.add((Object)p);
        }
        this.m_peptideFdrCheckbox = new JCheckBox("");
        this.m_peptideFdrCheckboxParameter = new BooleanParameter("fdr_peptide_validation", "Peptide FDR Validation", (JComponent)this.m_peptideFdrCheckbox, Boolean.valueOf(false));
        this.m_peptideFdrCheckboxParameter.setUsed(false);
        this.m_peptideFdrCheckboxParameter.setCompulsory(false);
        this.m_parameterList.add((Object)this.m_peptideFdrCheckboxParameter);
        this.m_peptideFdrTextField = new JTextField(5);
        this.m_peptideFdrFilterParameter = new DoubleParameter(ValidationTask.ValidationParameters.PEPTIDE_EXPECTED_FDR.key, ValidationTask.ValidationParameters.PEPTIDE_EXPECTED_FDR.name, (JComponent)this.m_peptideFdrTextField, Double.valueOf(1.0), Double.valueOf(0.0), Double.valueOf(10.0));
        this.m_peptideFdrFilterParameter.setUsed(false);
        this.m_peptideFdrFilterParameter.setCompulsory(false);
        this.m_parameterList.add((Object)this.m_peptideFdrFilterParameter);
        this.m_proteinPrefilterParameters = FilterProteinSetPanel.createProteinSetFilterParameters("PROT_", this.m_parameterList);
        this.m_proteinFdrCheckbox = new JCheckBox("");
        this.m_proteinFdrCheckboxParameter = new BooleanParameter("fdr_protein_validation", "protein FDR Validation", (JComponent)this.m_proteinFdrCheckbox, Boolean.valueOf(false));
        this.m_proteinFdrCheckboxParameter.setUsed(false);
        this.m_proteinFdrCheckboxParameter.setCompulsory(false);
        this.m_parameterList.add((Object)this.m_proteinFdrCheckboxParameter);
        this.m_proteinFdrTextField = new JTextField(5);
        this.m_proteinFdrFilterParameter = new DoubleParameter(ValidationTask.ValidationParameters.PROTEIN_EXPECTED_FDR.key, ValidationTask.ValidationParameters.PROTEIN_EXPECTED_FDR.name, (JComponent)this.m_proteinFdrTextField, Double.valueOf(5.0), Double.valueOf(0.0), Double.valueOf(10.0));
        this.m_proteinFdrFilterParameter.setUsed(false);
        this.m_proteinFdrFilterParameter.setCompulsory(false);
        this.m_parameterList.add((Object)this.m_proteinFdrFilterParameter);
        this.m_propagatePsmFiltersCheckBox = new JCheckBox();
        this.m_propagatePsmFiltersCheckBox.setText("Propagate PSM filtering to child Search Results");
        this.m_propagatePsmFiltersParameter = new BooleanParameter("propagate_pep_match_filters", "Propagate PSM PSMFilter", (JComponent)this.m_propagatePsmFiltersCheckBox, Boolean.valueOf(false));
        this.m_propagatePsmFiltersParameter.setUsed(false);
        this.m_propagatePsmFiltersParameter.setCompulsory(false);
        this.m_parameterList.add((Object)this.m_propagatePsmFiltersParameter);
        this.m_propagateProtSetFiltersCheckBox = new JCheckBox();
        this.m_propagateProtSetFiltersCheckBox.setText("Propagate ProteinSets filtering to child Search Results (Warning FDR Validation will not be propagated !");
        this.m_propagateProtSetFiltersParameter = new BooleanParameter("propagate_prot_set_filters", "Propagate ProteinSet PSMFilter", (JComponent)this.m_propagateProtSetFiltersCheckBox, Boolean.valueOf(false));
        this.m_propagateProtSetFiltersParameter.setUsed(false);
        this.m_propagateProtSetFiltersParameter.setCompulsory(false);
        this.m_parameterList.add((Object)this.m_propagateProtSetFiltersParameter);
    }

    public HashMap<String, String> getArguments() {
        return this.m_parameterList.getValues();
    }

    public List<ChangeTypicalRule> getChangeTypicalRules() {
        if (this.m_typicalProteinMatchCheckBox.isSelected()) {
            return this.m_changeTypicalPanel.getChangeTypicalRules();
        }
        return new ArrayList<ChangeTypicalRule>();
    }

    public String getScoringType() {
        return PROTEIN_SCORING_TYPE_VALUES[this.m_proteinScoringTypeCbx.getSelectedIndex()];
    }

    protected boolean okCalled() {
        this.m_checkFDR = true;
        if (!this.checkParameters()) {
            return false;
        }
        Preferences preferences = NbPreferences.root();
        try {
            this.saveParameters(preferences);
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return true;
    }

    protected String getSettingsKey() {
        return SETTINGS_KEY;
    }

    protected void saveParameters(Preferences preferences) throws Exception {
        this.m_parameterList.saveParameters(preferences);
        preferences.put("ValidationScoringType", this.m_proteinScoringTypeCbx.getSelectedItem().toString());
        this.m_changeTypicalPanel.savePreference(preferences);
        preferences.putBoolean("UseTypicalProteinRegex", this.m_typicalProteinMatchCheckBox.isSelected());
        preferences.putInt(VALIDATION_PARAMS_VERSION_KEY, this.VALIDATION_PARAM_CURRENT_VERSION);
    }

    protected void resetParameters() throws Exception {
        this.m_parameterList.initDefaults();
        this.m_psmPrefiltersPanel.clearPanel();
        this.m_peptidePrefiltersPanel.clearPanel();
        this.m_proteinPrefiltersPanel.clearPanel();
        this.restoreScoringTypeParameter(null);
        this.restoreTypicalProteinParameters(null);
        this.updateSelectedFilters();
    }

    protected void loadParameters(Preferences filePreferences) throws Exception {
        String[] keys;
        Integer paramVersion = filePreferences.getInt(VALIDATION_PARAMS_VERSION_KEY, 1);
        Preferences preferences = NbPreferences.root();
        for (String key : keys = filePreferences.keys()) {
            String value = filePreferences.get(key, null);
            preferences.put(key, value);
        }
        this.m_parameterList.loadParameters(filePreferences);
        if (paramVersion < this.VALIDATION_PARAM_CURRENT_VERSION) {
            String paramKey = this.m_parameterList.getPrefixName() + this.m_psmFdrFilterParameter.getKey();
            if (filePreferences.get(paramKey, null) != null) {
                this.m_psmFdrFilterParameter.setUsed(true);
            }
            if (filePreferences.get(paramKey = this.m_parameterList.getPrefixName() + this.m_proteinFdrFilterParameter.getKey(), null) != null) {
                this.m_proteinFdrFilterParameter.setUsed(true);
            }
        }
        this.restoreScoringTypeParameter(filePreferences);
        this.restoreTypicalProteinParameters(filePreferences);
        this.updatePSMFDRObjects(this.m_psmFdrFilterParameter.isUsed());
        this.updateProteinFDRObjects(this.m_proteinFdrFilterParameter.isUsed());
        this.updatePeptideFDRObjects(this.m_peptideFdrFilterParameter.isUsed());
        if (this.m_allowPropagateFilters) {
            this.m_propagatePsmFiltersCheckBox.setSelected(this.m_propagatePsmFiltersParameter.isUsed());
            this.m_propagateProtSetFiltersCheckBox.setSelected(this.m_propagateProtSetFiltersParameter.isUsed());
        }
        this.updateSelectedFilters();
    }

    protected boolean checkParameters() {
        ParameterError error;
        if (this.getArguments().isEmpty() && !this.m_psmFdrCheckbox.isSelected() && !this.m_proteinFdrCheckbox.isSelected()) {
            InfoDialog emptyArgumentsDialog = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.WARNING, "Warning", "You should not validate. Important arguments are not set.\nAre you sure you want to validate?");
            emptyArgumentsDialog.setButtonName(0, "Yes");
            emptyArgumentsDialog.setButtonName(1, "No");
            emptyArgumentsDialog.centerToWindow((Window)((Object)m_singletonDialog));
            emptyArgumentsDialog.setVisible(true);
            if (emptyArgumentsDialog.getButtonClicked() == 1) {
                return false;
            }
        }
        if (this.m_checkFDR) {
            boolean bhProtFdrSelected;
            boolean aTDFdrSelected;
            boolean bl = aTDFdrSelected = (this.m_psmFdrCheckbox.isSelected() || this.m_proteinFdrCheckbox.isSelected() || this.m_peptideFdrCheckbox.isSelected()) && ((String)this.m_psmFdrMethodComboBox.getSelectedItem()).toLowerCase().endsWith("decoy");
            if (aTDFdrSelected && this.getHasDecoy() == DecoyStatus.WAITING) {
                this.setBusy(true);
                Timer t = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ValidationDialog.this.okCalled();
                    }
                });
                t.setRepeats(false);
                t.start();
                return false;
            }
            this.setBusy(false);
            if (aTDFdrSelected && this.getHasDecoy() == DecoyStatus.NO_DECOY) {
                this.setStatus(true, "A Target/Decoy FDR can not be calculated without decoy data");
                if (this.m_psmFdrCheckbox.isSelected()) {
                    this.highlight(this.m_psmFdrCheckbox);
                } else if (this.m_proteinFdrCheckbox.isSelected()) {
                    this.highlight(this.m_proteinFdrCheckbox);
                } else {
                    this.highlight(this.m_peptideFdrCheckbox);
                }
                return false;
            }
            boolean bl2 = bhProtFdrSelected = this.m_proteinFdrCheckbox.isSelected() && ((String)this.m_psmFdrMethodComboBox.getSelectedItem()).toLowerCase().startsWith("bh");
            if (bhProtFdrSelected && !this.getScoringType().toLowerCase().startsWith("proline:fisher")) {
                this.setStatus(true, "Protein BH FDR is only compatible with Fisher protein scoring");
                this.highlight(this.m_proteinScoringTypeCbx);
                return false;
            }
            if (!this.m_softwareName.equalsIgnoreCase("MASCOT") && !this.m_softwareName.equals("UNKNOWN")) {
                AbstractParameter parameter = this.m_parameterList.getParameter(ValidationTask.ValidationParameters.FDR_METHOD.key);
                if (parameter.isUsed() && parameter.getStringValue().equals(FDR_METHODS_VALUES[1])) {
                    this.setStatus(true, "Peptide's BH FDR filtering is only allowed for Mascot datasets");
                    this.highlight(parameter.getComponent());
                    return false;
                }
                if (!this.getScoringType().equals(PROTEIN_SCORING_TYPE_VALUES[0])) {
                    this.setStatus(true, "Mascot and Fisher scoring can only be used for Mascot datasets");
                    this.highlight(this.m_proteinScoringTypeCbx);
                    return false;
                }
            }
        }
        if ((error = this.m_parameterList.checkParameters()) != null) {
            this.setStatus(true, error.getErrorMessage());
            this.highlight(error.getParameterComponent());
            return false;
        }
        return true;
    }

    protected boolean saveCalled() {
        this.m_checkFDR = false;
        return super.saveCalled();
    }

    protected boolean cancelCalled() {
        return true;
    }

    void setPanelEnabled(JPanel panel, Boolean isEnabled) {
        panel.setEnabled(isEnabled);
        Component[] components = panel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (JPanel.class.isAssignableFrom(components[i].getClass())) {
                this.setPanelEnabled((JPanel)components[i], isEnabled);
            }
            components[i].setEnabled(isEnabled);
        }
    }

    public static enum DecoyStatus {
        WAITING,
        HAS_DECOY,
        NO_DECOY;

    }
}

