/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.exporter;

import fr.proline.studio.NbPreferences;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.StringUtils;

public class Export2MzIdentMLFilePanel
extends JPanel {
    private DefaultDialog m_parent = null;
    private JTextField m_fileTextField;
    private JFileChooser m_fchooser;
    protected String errorMsg;

    public Export2MzIdentMLFilePanel(DefaultDialog parent) {
        this.m_parent = parent;
        this.setLayout(new BorderLayout());
        this.add((Component)this.createMainPanel(), "Center");
    }

    private JPanel createMainPanel() {
        JPanel exportPanel = new JPanel();
        Preferences preferences = NbPreferences.root();
        String defaultExportPath = preferences.get("DefaultExcelExportPath", System.getProperty("user.home"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        this.m_fileTextField = new JTextField(30);
        this.m_fileTextField.setText(defaultExportPath);
        exportPanel.add((Component)this.m_fileTextField, c);
        final JButton addFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.OPEN_FILE));
        addFileButton.setMargin(new Insets(2, 2, 2, 2));
        addFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Export2MzIdentMLFilePanel.this.m_fchooser = new JFileChooser();
                Export2MzIdentMLFilePanel.this.m_fchooser.setFileFilter(new FileNameExtensionFilter("MzIdent file", "mzid", "MZID"));
                int result = Export2MzIdentMLFilePanel.this.m_fchooser.showOpenDialog(addFileButton);
                if (result == 0) {
                    File file = Export2MzIdentMLFilePanel.this.m_fchooser.getSelectedFile();
                    String absolutePath = file.getAbsolutePath();
                    String fileName = file.getName();
                    if (fileName.indexOf(46) == -1) {
                        absolutePath = absolutePath + ".mzid";
                    }
                    Export2MzIdentMLFilePanel.this.m_fileTextField.setText(absolutePath);
                }
            }
        });
        c.gridx += 2;
        exportPanel.add((Component)addFileButton, c);
        return exportPanel;
    }

    public String getFileName() {
        return this.m_fileTextField.getText().trim();
    }

    protected boolean checkParameters() {
        if (StringUtils.isEmpty((CharSequence)this.m_fileTextField.getText().trim())) {
            this.m_parent.setStatus(true, "An export filename should be specified");
            this.m_parent.highlight((Component)this.m_fileTextField);
            return false;
        }
        return true;
    }
}

