/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.exporter;

import fr.proline.studio.WindowManager;
import fr.proline.studio.dpm.data.CVParam;
import fr.proline.studio.gui.JCheckBoxList;
import fr.proline.studio.rsmexplorer.gui.dialog.exporter.PrideWizardPanel;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.toolsuite.ols.dialog.OLSDialog;
import uk.ac.ebi.pride.toolsuite.ols.dialog.OLSInputable;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Term;

public class PrideSampleDescPanel
extends PrideWizardPanel
implements OLSInputable {
    private static PrideSampleDescPanel m_panel = null;
    private JTextField m_sampleNameTextField;
    private JTextField m_sampleDescTextField;
    private JComboBox<CVParam> m_sampleSpeciesCB;
    private JCheckBoxList<CVParam> m_sampleTissueCBList;
    private JCheckBoxList<CVParam> m_sampleCellCBList;
    private DefaultComboBoxModel<CVParam> m_sampleSpeciesCBModel;
    private String errorMsg;
    public static String SPECIES_FIELD = "species";
    public static String TISSUE_FIELD = "tissue";
    public static String CELLTYPE_FIELD = "cell";
    private static CVParam EMPTY_PARAM = new CVParam("NONE", "NONE", "NONE", null);

    public static PrideSampleDescPanel getPrideSampleDescPanel() {
        if (m_panel == null) {
            m_panel = new PrideSampleDescPanel();
        }
        return m_panel;
    }

    private PrideSampleDescPanel() {
        super.initWizardPanels("<html><b>Step 3:</b> Sample Definition</html>");
    }

    protected void resetPanel() {
        this.m_sampleNameTextField.setText(null);
        this.m_sampleDescTextField.setText(null);
        this.m_sampleSpeciesCB.setSelectedIndex(-1);
        this.m_sampleTissueCBList.unselectAll();
        this.m_sampleCellCBList.unselectAll();
    }

    @Override
    public HashMap<String, Object> getExportPrideParams() {
        int i;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((CharSequence)this.m_sampleNameTextField.getText().trim())) {
            params.put("sample_name", this.m_sampleNameTextField.getText().trim());
        }
        if (!StringUtils.isEmpty((CharSequence)this.m_sampleDescTextField.getText().trim())) {
            params.put("sample_desc", this.m_sampleDescTextField.getText().trim());
        }
        ArrayList<Object> additinalDescription = new ArrayList<Object>();
        if (this.m_sampleSpeciesCB.getSelectedItem() != null && !this.m_sampleSpeciesCB.getSelectedItem().equals(EMPTY_PARAM)) {
            additinalDescription.add(this.m_sampleSpeciesCB.getItemAt(this.m_sampleSpeciesCB.getSelectedIndex()));
        }
        for (i = 0; i < this.m_sampleTissueCBList.getListSize(); ++i) {
            if (!this.m_sampleTissueCBList.isVisible(i)) continue;
            additinalDescription.add(this.m_sampleTissueCBList.getElementAt(i));
        }
        for (i = 0; i < this.m_sampleCellCBList.getListSize(); ++i) {
            if (!this.m_sampleCellCBList.isVisible(i)) continue;
            additinalDescription.add(this.m_sampleCellCBList.getElementAt(i));
        }
        if (!additinalDescription.isEmpty()) {
            params.put("sample_additional", additinalDescription);
        }
        return params;
    }

    @Override
    protected Component checkExportPrideParams() {
        this.errorMsg = null;
        if (StringUtils.isEmpty((CharSequence)this.m_sampleNameTextField.getText().trim())) {
            this.errorMsg = "A sample name should be specified";
            return this.m_sampleNameTextField;
        }
        return null;
    }

    @Override
    protected String getErrorMessage() {
        return this.errorMsg;
    }

    @Override
    protected JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel sampleNameLabel = new JLabel("Sample Name* :");
        this.m_sampleNameTextField = new JTextField(30);
        c.gridx = 0;
        c.gridy = 0;
        mainPanel.add((Component)sampleNameLabel, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        mainPanel.add((Component)this.m_sampleNameTextField, c);
        JLabel sampleDescLabel = new JLabel("Description:");
        this.m_sampleDescTextField = new JTextField(30);
        c.gridx = 0;
        c.weightx = 0.5;
        ++c.gridy;
        c.gridwidth = 1;
        mainPanel.add((Component)sampleDescLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        mainPanel.add((Component)this.m_sampleDescTextField, c);
        JLabel sampleSpeciesCVLabel = new JLabel("Species:");
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        mainPanel.add((Component)sampleSpeciesCVLabel, c);
        this.m_sampleSpeciesCB = new JComboBox();
        this.m_sampleSpeciesCB.setMaximumRowCount(20);
        List<CVParam> speciesCVs = this.getCVParamsFromRsc("/fr/proline/studio/rsmexplorer/gui/dialog/pride/NEWT_entries.txt");
        speciesCVs.add(0, EMPTY_PARAM);
        this.m_sampleSpeciesCBModel = new DefaultComboBoxModel<CVParam>(speciesCVs.toArray(new CVParam[speciesCVs.size()]));
        this.m_sampleSpeciesCB.setModel(this.m_sampleSpeciesCBModel);
        this.m_sampleSpeciesCB.setSelectedIndex(1);
        ++c.gridx;
        mainPanel.add(this.m_sampleSpeciesCB, c);
        JButton olsSpeciesButton = new JButton("Other ...", IconManager.getIcon((IconManager.IconType)IconManager.IconType.PLUS));
        olsSpeciesButton.setMargin(new Insets(2, 2, 2, 2));
        olsSpeciesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new OLSDialog((JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, PrideSampleDescPanel.getPrideSampleDescPanel()), (OLSInputable)PrideSampleDescPanel.getPrideSampleDescPanel(), true, SPECIES_FIELD, "NEWT", null, false);
            }
        });
        ++c.gridx;
        c.fill = 2;
        mainPanel.add((Component)olsSpeciesButton, c);
        JLabel sampleTissueCVLabel = new JLabel("Tissue:");
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        mainPanel.add((Component)sampleTissueCVLabel, c);
        List<CVParam> tissueCVs = this.getCVParamsFromRsc("/fr/proline/studio/rsmexplorer/gui/dialog/pride/BTO_entries.txt");
        tissueCVs.add(0, EMPTY_PARAM);
        ArrayList<Boolean> tissueVisibility = new ArrayList<Boolean>(tissueCVs.size());
        for (int i = 0; i < tissueCVs.size(); ++i) {
            tissueVisibility.add(Boolean.FALSE);
        }
        this.m_sampleTissueCBList = new JCheckBoxList(tissueCVs, tissueVisibility);
        this.m_sampleTissueCBList.setVisibleRowCount(5);
        JScrollPane tissueScrollPane = new JScrollPane();
        tissueScrollPane.setViewportView((Component)this.m_sampleTissueCBList);
        ++c.gridx;
        mainPanel.add((Component)tissueScrollPane, c);
        JButton olsTissueButton = new JButton("Other ...", IconManager.getIcon((IconManager.IconType)IconManager.IconType.PLUS));
        olsTissueButton.setMargin(new Insets(2, 2, 2, 2));
        olsTissueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new OLSDialog((JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, PrideSampleDescPanel.getPrideSampleDescPanel()), (OLSInputable)PrideSampleDescPanel.getPrideSampleDescPanel(), true, TISSUE_FIELD, "BTO", null, false);
            }
        });
        ++c.gridx;
        c.fill = 2;
        mainPanel.add((Component)olsTissueButton, c);
        JLabel sampleCellTypeCVLabel = new JLabel("Cell Type:");
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        mainPanel.add((Component)sampleCellTypeCVLabel, c);
        List<CVParam> cellCVs = this.getCVParamsFromRsc("/fr/proline/studio/rsmexplorer/gui/dialog/pride/CL_entries.txt");
        cellCVs.add(0, EMPTY_PARAM);
        ArrayList<Boolean> cellVisibility = new ArrayList<Boolean>(cellCVs.size());
        for (int i = 0; i < cellCVs.size(); ++i) {
            cellVisibility.add(Boolean.FALSE);
        }
        this.m_sampleCellCBList = new JCheckBoxList(cellCVs, cellVisibility);
        this.m_sampleCellCBList.setVisibleRowCount(5);
        JScrollPane cellScrollPane = new JScrollPane();
        cellScrollPane.setViewportView((Component)this.m_sampleCellCBList);
        ++c.gridx;
        mainPanel.add((Component)cellScrollPane, c);
        JButton olsCellButton = new JButton("Other ...", IconManager.getIcon((IconManager.IconType)IconManager.IconType.PLUS));
        olsCellButton.setMargin(new Insets(2, 2, 2, 2));
        olsCellButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new OLSDialog((JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, PrideSampleDescPanel.getPrideSampleDescPanel()), (OLSInputable)PrideSampleDescPanel.getPrideSampleDescPanel(), true, CELLTYPE_FIELD, "NEWT", null, false);
            }
        });
        ++c.gridx;
        c.fill = 2;
        mainPanel.add((Component)olsCellButton, c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        mainPanel.add(Box.createVerticalGlue(), c);
        return mainPanel;
    }

    public void insertOLSResult(String field, Term selectedValue, Term accession, String ontologyShort, String ontologyLong, int modifiedRow, String mappedTerm, List<String> metadata) {
        LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer").debug("field : {}, selectedValue : {}  , accession : {} , ontologyShort : {} ontologyLong: {},  modifiedRow : {} mappedTerm: {} , nbr other : {}", new Object[]{field, selectedValue, accession, ontologyShort, ontologyLong, modifiedRow, mappedTerm, metadata});
        if (field == null) {
            return;
        }
        if (field.equals(SPECIES_FIELD)) {
            CVParam newParam = new CVParam(ontologyShort, accession.getLabel(), selectedValue.getLabel(), "");
            this.m_sampleSpeciesCBModel.addElement(newParam);
            this.m_sampleSpeciesCB.setSelectedItem(newParam);
        } else if (field.equals(TISSUE_FIELD)) {
            CVParam newParam = new CVParam(ontologyShort, accession.getLabel(), selectedValue.getLabel(), "");
            int newElemIndex = this.m_sampleTissueCBList.getListSize();
            this.m_sampleTissueCBList.addItem(newElemIndex, (Object)newParam, Boolean.TRUE);
            this.m_sampleTissueCBList.ensureIndexIsVisible(newElemIndex);
        } else {
            CVParam newParam = new CVParam(ontologyShort, accession.getLabel(), selectedValue.getLabel(), "");
            int newElemIndex = this.m_sampleCellCBList.getListSize();
            this.m_sampleCellCBList.addItem(newElemIndex, (Object)newParam, Boolean.TRUE);
            this.m_sampleCellCBList.ensureIndexIsVisible(newElemIndex);
        }
    }

    public Window getWindow() {
        return WindowManager.getDefault().getMainWindow();
    }

    public List<CVParam> getCVParamsFromRsc(String fileResource) {
        InputStream is = PrideSampleDescPanel.class.getResourceAsStream(fileResource);
        ArrayList<CVParam> cvParams = new ArrayList<CVParam>();
        BufferedReader in = null;
        if (StringUtils.isEmpty((CharSequence)fileResource) || fileResource.lastIndexOf("_entries.txt") == -1) {
            return cvParams;
        }
        int startIndex = fileResource.lastIndexOf(47) + 1;
        String cvLabel = fileResource.substring(startIndex, fileResource.lastIndexOf("_entries.txt"));
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(is));
            while ((line = in.readLine()) != null) {
                String[] tokens = line.split("\t");
                if (tokens.length != 2) continue;
                cvParams.add(new CVParam(cvLabel, tokens[0], tokens[1], null));
            }
            in.close();
            return cvParams;
        }
        catch (IOException ioe) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return cvParams;
        }
    }
}

