/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.spectralcount;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.rsmexplorer.gui.dialog.spectralcount.SpectralCountNamePanel;
import fr.proline.studio.rsmexplorer.gui.dialog.spectralcount.TreeSelectionPanel;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import fr.proline.studio.utils.IconManager;
import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.tree.TreePath;

public class SpectralCountDialog
extends DefaultDialog {
    private static final int STEP_PANEL_DEFINE_NAME = 0;
    private static final int STEP_PANEL_SELECT_IDENTIFICATION_SUMMARIES = 1;
    private static final int STEP_PANEL_SELECT_WEIGHT_REF_IDENT_SUMMARIES = 2;
    private int m_step = 0;
    private IdentificationTree m_tree = null;
    private ArrayList<DataSetNode> m_identRSMs = null;
    private ArrayList<DataSetNode> m_weightRefIdentRSMs = null;

    public SpectralCountDialog(Window parent, IdentificationTree childTree) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.m_tree = childTree;
        this.setTitle("Spectral Count Wizard");
        this.setResizable(true);
        this.setDocumentationSuffix("id.2mn7vak");
        this.setButtonName(0, "Next");
        this.setButtonIcon(0, IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW));
        SpectralCountNamePanel namePanel = SpectralCountNamePanel.getSpectralCountNamePanel();
        this.setHelpHeader("<html><b>Step 1:</b> Define spectral count name and description.</html>", null);
        namePanel.reinit();
        this.setInternalComponent(namePanel);
    }

    public String getSpectralCountName() {
        return SpectralCountNamePanel.getSpectralCountNamePanel().getSpectralCountName();
    }

    public String getSpectralCountDescription() {
        return SpectralCountNamePanel.getSpectralCountNamePanel().getSpectralCountDescription();
    }

    public ArrayList<DataSetNode> getSelectedRSMDSNodeList() {
        return this.m_identRSMs;
    }

    public ArrayList<DataSetNode> getSelectedWeightRSMDSNodeList() {
        return this.m_weightRefIdentRSMs;
    }

    protected boolean okCalled() {
        if (this.m_step == 0) {
            SpectralCountNamePanel spectralCountNamePanel = SpectralCountNamePanel.getSpectralCountNamePanel();
            String name = spectralCountNamePanel.getSpectralCountName();
            if (name.length() == 0) {
                this.setStatus(true, "You must fill the Spectral Count Name");
                this.highlight(spectralCountNamePanel.getNameTextField());
                return false;
            }
            TreeSelectionPanel treeSelectionPanel = TreeSelectionPanel.getTreeSelectionPanel(this.m_tree);
            this.setHelpHeader("<html><b>Step 2:</b> Select Identification Summaries.</html>", "Select the Identification Summaries for which Spectral Count will be calculated. The common list of protein sets and peptide specificity will be calculated at parent level, from which spectral count has been run.");
            this.replaceInternalComponent(treeSelectionPanel);
            this.revalidate();
            this.repaint();
            this.m_step = 1;
            return false;
        }
        if (this.m_step == 1) {
            TreePath[] paths = TreeSelectionPanel.getTreeSelectionPanel().getSelectionPaths();
            if (paths == null || paths.length == 0) {
                this.setStatus(true, "You must at least select one Identification Summary");
                this.highlight(TreeSelectionPanel.getTreeSelectionPanel().getTree());
                return false;
            }
            this.m_identRSMs = TreeSelectionPanel.getTreeSelectionPanel().getSelectedRSMDSNodeList();
            this.setButtonName(0, "OK");
            this.setButtonIcon(0, IconManager.getIcon((IconManager.IconType)IconManager.IconType.OK));
            this.m_tree.revertSelectionSetDisabled(true);
            this.m_tree.setSelection(new ArrayList<ResultSummary>());
            TreeSelectionPanel treeSelectionPanel = TreeSelectionPanel.getTreeSelectionPanel(this.m_tree);
            this.setHelpHeader("<html><b>Step 3:</b> Select Weight Computation Identification Summaries.</html>", "Select Datasets (and associated identification summaries) in the hierarchy where shared PSM weight will be defined. The calculated weight will then be applied to Identification Summaries previously selected, the nearest parent will be used as reference for PSM weight.");
            this.replaceInternalComponent(treeSelectionPanel);
            this.revalidate();
            this.repaint();
            this.m_step = 2;
            return false;
        }
        TreePath[] paths = TreeSelectionPanel.getTreeSelectionPanel().getSelectionPaths();
        if (paths == null || paths.length == 0) {
            this.setStatus(true, "You must at least select one Identification Summary for weight computation");
            this.highlight(TreeSelectionPanel.getTreeSelectionPanel().getTree());
            return false;
        }
        this.m_weightRefIdentRSMs = TreeSelectionPanel.getTreeSelectionPanel().getSelectedRSMDSNodeList();
        this.m_tree.setSelection(new ArrayList<ResultSummary>());
        this.m_tree.revertSelectionSetDisabled(false);
        return true;
    }

    protected boolean cancelCalled() {
        this.m_tree.setSelection(new ArrayList<ResultSummary>());
        this.m_tree.revertSelectionSetDisabled(false);
        return true;
    }
}

