/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.core.orm.uds.QuantitationMethod;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.AbstractParamsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class IsobaricMethodParamsPanel
extends AbstractParamsPanel {
    private final QuantitationMethod m_quantMethod;
    private JTextField m_extractionMoZTolTF;
    private JComboBox<String> m_reporterSourceCbx;
    private JCheckBox m_rescaleAbundancestoMS1CB;

    public IsobaricMethodParamsPanel(QuantitationMethod method) {
        this.m_quantMethod = method;
        this.setLayout(new BorderLayout());
        JPanel mainPanel = this.createMainPanel();
        this.add((Component)mainPanel, "Center");
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createTitledBorder("Isobaric tagging parameters"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        mainPanel.add((Component)this.createExtractionParamPanel(), c);
        ++c.gridy;
        mainPanel.add((Component)this.createReporterSourcePanel(), c);
        ++c.gridy;
        mainPanel.add(this.createRescalePanel(), c);
        ++c.gridy;
        c.weighty = 1.0;
        mainPanel.add(Box.createVerticalGlue(), c);
        return mainPanel;
    }

    private JPanel createReporterSourcePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel extractionMoZTolLabel = new JLabel("Reporter ions will be extracted from:");
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        panel.add((Component)extractionMoZTolLabel, c);
        this.m_reporterSourceCbx = new JComboBox();
        this.m_reporterSourceCbx.addItem("Proline spectrum");
        this.m_reporterSourceCbx.addItem("mzdb MS2 spectrum");
        this.m_reporterSourceCbx.addItem("mzdb MS3 spectrum");
        ++c.gridx;
        c.weightx = 0.0;
        panel.add(this.m_reporterSourceCbx, c);
        ++c.gridx;
        c.weightx = 1.0;
        panel.add(Box.createHorizontalGlue(), c);
        return panel;
    }

    private JPanel createExtractionParamPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel extractionMoZTolLabel = new JLabel("Reporter ions m/z tolerance (ppm):");
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        panel.add((Component)extractionMoZTolLabel, c);
        this.m_extractionMoZTolTF = new JTextField(10);
        ++c.gridx;
        c.weightx = 0.0;
        panel.add((Component)this.m_extractionMoZTolTF, c);
        ++c.gridx;
        c.weightx = 1.0;
        panel.add(Box.createHorizontalGlue(), c);
        return panel;
    }

    @Override
    public Map<String, Object> getQuantParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> extractionParams = new HashMap<String, String>();
        extractionParams.put("moz_tol", this.m_extractionMoZTolTF.getText());
        extractionParams.put("moz_tol_unit", "PPM");
        params.put("extraction_params", extractionParams);
        String sourceValue = (String)this.m_reporterSourceCbx.getSelectedItem();
        params.put("reporter_ion_data_source", sourceValue.replaceAll(" ", "_").toUpperCase());
        params.put("label_free_quant_config", this.m_rescaleAbundancestoMS1CB.isSelected());
        return params;
    }

    @Override
    public void setQuantParams(Map<String, Object> quantParams) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private Component createRescalePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        this.m_rescaleAbundancestoMS1CB = new JCheckBox("Rescale reporter abundances to MS1 signal", false);
        panel.add((Component)this.m_rescaleAbundancestoMS1CB, c);
        ++c.gridx;
        c.weightx = 1.0;
        panel.add(Box.createHorizontalGlue(), c);
        return panel;
    }
}

