/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.model.properties;

import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.ProjectUserAccountMap;
import fr.proline.studio.table.DataGroup;
import fr.proline.studio.table.PropertiesTableModel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Set;

public class ProjectPropertiesTableModel
extends PropertiesTableModel {
    Project m_project;

    public ProjectPropertiesTableModel(Project p) {
        this.m_project = p;
        this.init();
    }

    private void init() {
        this.m_datasetNameArray = new ArrayList();
        this.m_datasetNameArray.add(this.m_project.getName());
        ProjectInformationGroup dg = new ProjectInformationGroup(0);
        this.m_dataGroupList = new ArrayList(1);
        this.m_dataGroupList.add(dg);
    }

    public class ProjectInformationGroup
    extends DataGroup {
        private static final int ROWTYPE_PROJECT_ID = 0;
        private static final int ROWTYPE_PROJECT_NAME = 1;
        private static final int ROWTYPE_PROJECT_DESCRIPTION = 2;
        private static final int ROWTYPE_PROJECT_OWNER = 3;
        private static final int ROWTYPE_PROJECT_MEMBERS = 4;
        private static final int ROW_COUNT = 5;
        private final Color GROUP_COLOR_BACKGROUND;

        public ProjectInformationGroup(int rowStart) {
            super("Project Information", rowStart);
            this.GROUP_COLOR_BACKGROUND = new Color(76, 166, 107);
        }

        public DataGroup.GroupObject getGroupNameAt(int rowIndex) {
            switch (rowIndex) {
                case 0: {
                    return new DataGroup.GroupObject((DataGroup)this, "Id", (DataGroup)this);
                }
                case 1: {
                    return new DataGroup.GroupObject((DataGroup)this, "Name", (DataGroup)this);
                }
                case 2: {
                    return new DataGroup.GroupObject((DataGroup)this, "Description", (DataGroup)this);
                }
                case 3: {
                    return new DataGroup.GroupObject((DataGroup)this, "Owner", (DataGroup)this);
                }
                case 4: {
                    return new DataGroup.GroupObject((DataGroup)this, "Shared with", (DataGroup)this);
                }
            }
            return null;
        }

        public DataGroup.GroupObject getGroupValueAt(int rowIndex, int columnIndex) {
            if (ProjectPropertiesTableModel.this.m_project == null) {
                return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
            }
            switch (rowIndex) {
                case 0: {
                    return new DataGroup.GroupObject((DataGroup)this, String.valueOf(ProjectPropertiesTableModel.this.m_project.getId()), (DataGroup)this);
                }
                case 1: {
                    return new DataGroup.GroupObject((DataGroup)this, ProjectPropertiesTableModel.this.m_project.getName(), (DataGroup)this);
                }
                case 2: {
                    return new DataGroup.GroupObject((DataGroup)this, ProjectPropertiesTableModel.this.m_project.getDescription(), (DataGroup)this);
                }
                case 3: {
                    return new DataGroup.GroupObject((DataGroup)this, ProjectPropertiesTableModel.this.m_project.getOwner().getLogin(), (DataGroup)this);
                }
                case 4: {
                    StringBuilder sb = new StringBuilder();
                    Set members = ProjectPropertiesTableModel.this.m_project.getProjectUserAccountMap();
                    boolean first = true;
                    for (ProjectUserAccountMap nextMember : members) {
                        if (!first) {
                            sb.append(", ");
                        } else {
                            first = false;
                        }
                        sb.append(nextMember.getUserAccount().getLogin());
                    }
                    return new DataGroup.GroupObject((DataGroup)this, sb.toString(), (DataGroup)this);
                }
            }
            return null;
        }

        public Color getGroupColor(int row) {
            return this.GROUP_COLOR_BACKGROUND;
        }

        public int getRowCountImpl() {
            return 5;
        }
    }
}

