/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.ptm;

import fr.proline.core.orm.msi.dto.DBioSequence;
import fr.proline.core.orm.msi.dto.DPeptidePTM;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.studio.dam.tasks.DatabaseBioSequenceTask;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.dam.tasks.data.ptm.PTMSite;
import fr.proline.studio.rsmexplorer.gui.ptm.PTMMark;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTMPeptidesGraphicModel {
    private static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.rsmexplorer.ptm");
    private PTMSite m_mainPTMSite;
    private List<PTMPeptideInstance> m_ptmPeptidesInstances = new ArrayList<PTMPeptideInstance>();
    private Map<Integer, PTMMark> m_allPtmMarks;
    private String m_proteinSequence;
    private int m_lowerStartLocation = Integer.MAX_VALUE;
    private int m_higherEndLocation = Integer.MIN_VALUE;

    public List<PTMPeptideInstance> getPTMPeptideInstance() {
        return this.m_ptmPeptidesInstances;
    }

    public PTMPeptideInstance getPeptideAt(int index) {
        return this.m_ptmPeptidesInstances.get(index);
    }

    public int getPeptideIndex(PTMPeptideInstance pepInstance) {
        for (int i = 0; i < this.m_ptmPeptidesInstances.size(); ++i) {
            if (!this.m_ptmPeptidesInstances.get(i).equals(pepInstance)) continue;
            return i;
        }
        return -1;
    }

    public String getProteinSequence() {
        return this.m_proteinSequence;
    }

    public PTMSite getMainPTMSite() {
        return this.m_mainPTMSite;
    }

    public void setData(PTMSite mainPTMSite) {
        if (this.m_mainPTMSite != null && this.m_mainPTMSite.equals(mainPTMSite)) {
            return;
        }
        this.m_mainPTMSite = mainPTMSite;
    }

    public void setData(List<PTMPeptideInstance> ptmInstances, long prjId) {
        if (Objects.equals(ptmInstances, this.m_ptmPeptidesInstances)) {
            return;
        }
        this.m_ptmPeptidesInstances = ptmInstances;
        if (ptmInstances == null) {
            this.m_ptmPeptidesInstances = new ArrayList<PTMPeptideInstance>();
        }
        this.m_allPtmMarks = new HashMap<Integer, PTMMark>();
        this.m_lowerStartLocation = Integer.MAX_VALUE;
        this.m_higherEndLocation = Integer.MIN_VALUE;
        if (this.m_ptmPeptidesInstances.isEmpty()) {
            this.m_proteinSequence = "";
            this.m_lowerStartLocation = 0;
            this.m_higherEndLocation = 0;
            return;
        }
        DProteinMatch pm = null;
        boolean onlyProtNTermPTMWithOutMExist = true;
        HashMap ptmSiteByProteinPos = new HashMap();
        for (PTMSite nextPTMSite : this.m_ptmPeptidesInstances.stream().flatMap(pi -> pi.getPTMSites().stream()).collect(Collectors.toSet())) {
            if (pm == null) {
                pm = nextPTMSite.getProteinMatch();
            }
            int loc = nextPTMSite.getPositionOnProtein();
            boolean bl = onlyProtNTermPTMWithOutMExist = onlyProtNTermPTMWithOutMExist && nextPTMSite.isProteinNTermWithOutM();
            if (!ptmSiteByProteinPos.containsKey(loc)) {
                ptmSiteByProteinPos.put(loc, new ArrayList());
            }
            ((List)ptmSiteByProteinPos.get(loc)).add(nextPTMSite);
        }
        for (PTMPeptideInstance ptmPeptideInstance : ptmInstances) {
            int ptmPepStartLocOnProt = ptmPeptideInstance.getStartPosition();
            int ptmPepSeqLenght = ptmPeptideInstance.getSequence().length();
            if (this.m_lowerStartLocation > ptmPepStartLocOnProt) {
                this.m_lowerStartLocation = ptmPepStartLocOnProt;
            }
            if (this.m_higherEndLocation < ptmPepStartLocOnProt + ptmPepSeqLenght) {
                this.m_higherEndLocation = ptmPepStartLocOnProt + ptmPepSeqLenght;
            }
            for (DPeptidePTM ptm : ptmPeptideInstance.getPeptideInstance().getPeptide().getTransientData().getDPeptidePtmMap().values()) {
                int protLocation;
                boolean currentPTMisNCterm = false;
                int locOnPeptide = (int)ptm.getSeqPosition();
                int protLocToDisplay = protLocation = ptmPepStartLocOnProt + locOnPeptide;
                if (ptmSiteByProteinPos.containsKey(protLocation)) {
                    List ptmSitesPositionned = (List)ptmSiteByProteinPos.get(protLocation);
                    Optional<PTMSite> correspondingPTMSite = ptmSitesPositionned.stream().filter(site -> site.getPTMSpecificity().getIdPtmSpecificity() == ptm.getIdPtmSpecificity()).findFirst();
                    if (correspondingPTMSite.isPresent()) {
                        if (correspondingPTMSite.get().isProteinNTermWithOutM() && onlyProtNTermPTMWithOutMExist) {
                            this.m_lowerStartLocation = 0;
                            protLocToDisplay = 1;
                        }
                        if (correspondingPTMSite.get().isProteinCTerm() || correspondingPTMSite.get().isProteinNTerm()) {
                            currentPTMisNCterm = true;
                        }
                    }
                } else {
                    m_logger.warn("Try to display a PTM without associated PTMSites.... " + protLocation + " def id " + ptm.toString());
                }
                if (onlyProtNTermPTMWithOutMExist) {
                    --protLocation;
                }
                PTMMark mark = new PTMMark(ptm, protLocation, protLocToDisplay, currentPTMisNCterm);
                PTMMark exist = this.m_allPtmMarks.get(protLocation);
                if (exist != null && exist.equals(mark)) continue;
                this.m_allPtmMarks.put(protLocation, mark);
            }
        }
        if (pm != null) {
            DBioSequence bs = pm.getDBioSequence();
            if (bs == null && prjId > 0L) {
                m_logger.trace("BioSequence is absent from the protein match, trying to load it ...");
                DatabaseBioSequenceTask.fetchData(Collections.singletonList(pm), (Long)prjId);
                bs = pm.getDBioSequence();
            }
            this.m_proteinSequence = "";
            if (bs != null) {
                this.m_proteinSequence = bs.getSequence();
                if (onlyProtNTermPTMWithOutMExist) {
                    this.m_proteinSequence = this.m_proteinSequence.substring(1);
                }
            } else {
                this.m_proteinSequence = this.createSequence(onlyProtNTermPTMWithOutMExist);
            }
        }
    }

    public void setProteinSequence(String sequence) {
        this.m_proteinSequence = sequence;
    }

    private String createSequence(boolean onlyProtNTermPTMWithOutMExist) {
        StringBuilder sb = new StringBuilder(this.m_proteinSequence);
        if (this.m_lowerStartLocation > 1) {
            for (int i = 1; i < this.m_lowerStartLocation - 1; ++i) {
                sb.append("-");
            }
        }
        for (PTMPeptideInstance pepInst : this.m_ptmPeptidesInstances) {
            int l;
            String content = pepInst.getSequence();
            int cLength = content.length();
            int pIndex = pepInst.getStartPosition();
            if (pIndex == 1 && onlyProtNTermPTMWithOutMExist) {
                pIndex = 0;
            }
            if ((l = sb.length()) < pIndex) {
                for (int i = l; i < pIndex; ++i) {
                    sb.append("-");
                }
                sb.append(content);
                continue;
            }
            sb.replace(pIndex, pIndex + cLength, content);
        }
        return sb.toString();
    }

    public int getLowerStartInProtSeq() {
        return this.m_lowerStartLocation;
    }

    public int getHigherEndInProtSeq() {
        return this.m_higherEndLocation;
    }

    public int getRowCount() {
        return this.m_ptmPeptidesInstances.size();
    }

    public Map<Integer, PTMMark> getAllPtmMarks() {
        return this.m_allPtmMarks;
    }

    public int getPeptideIndex(int sequencePositon) {
        for (int i = 0; i < this.m_ptmPeptidesInstances.size(); ++i) {
            PTMPeptideInstance pep = this.m_ptmPeptidesInstances.get(i);
            int rangeA = pep.getStartPosition();
            int rangeZ = pep.getStopPosition();
            if (sequencePositon < rangeA || sequencePositon > rangeZ) continue;
            return i;
        }
        return -1;
    }
}

