/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.ptm;

import fr.proline.studio.rsmexplorer.gui.ptm.PTMSitePeptidesGraphicCtrlPanel;
import fr.proline.studio.rsmexplorer.gui.ptm.ViewContext;
import fr.proline.studio.rsmexplorer.gui.ptm.ViewSetting;
import fr.proline.studio.rsmexplorer.gui.ptm.mark.PTMMarkCtrl;
import fr.proline.studio.rsmexplorer.gui.ptm.mark.ProteinSequence;
import fr.proline.studio.rsmexplorer.gui.ptm.pep.PeptideAreaCtrl;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTMSitePeptidesGraphicViewPanel
extends JPanel {
    private static Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.rsmexplorer.ptm");
    private static final int AJUSTE_GAP = 2;
    private boolean m_isDataLoaded;
    private TitlePane m_titlePane;
    private PeptidePane m_peptidePane;
    private int m_rowCount;
    private int m_sequenceLength;
    private JScrollPane m_scrollPane;
    private PTMSitePeptidesGraphicCtrlPanel m_ptmSitePanel;
    private boolean m_isDataNull;
    private final PeptideNumberPane m_numberPane;

    protected PTMSitePeptidesGraphicViewPanel(PTMSitePeptidesGraphicCtrlPanel ctrl, PTMMarkCtrl ctrlMark, ProteinSequence ctrlSequence, PeptideAreaCtrl ctrlPeptideArea) {
        this.m_ptmSitePanel = ctrl;
        this.m_titlePane = new TitlePane(ctrlMark, ctrlSequence);
        this.m_peptidePane = new PeptidePane(ctrlPeptideArea);
        this.m_numberPane = new PeptideNumberPane();
        this.m_rowCount = 0;
        this.m_sequenceLength = 0;
        this.initComponents();
    }

    private void initComponents() {
        this.setDoubleBuffered(false);
        this.m_titlePane.setMarkBeginPoint(ViewSetting.BORDER_GAP, ViewSetting.BORDER_GAP);
        this.m_titlePane.setSequenceBeginPoint(ViewSetting.BORDER_GAP, ViewSetting.HEIGHT_MARK);
        this.m_peptidePane.setBeginPoint(ViewSetting.BORDER_GAP, ViewSetting.BORDER_GAP);
        this.m_numberPane.setBeginPoint(ViewSetting.BORDER_GAP, ViewSetting.BORDER_GAP);
        this.m_titlePane.setPreferredSize(new Dimension(this.getWidth(), ViewSetting.HEIGHT_MARK + ViewSetting.HEIGHT_SEQUENCE));
        this.m_titlePane.setBackground(Color.WHITE);
        this.m_peptidePane.setBackground(Color.WHITE);
        this.m_titlePane.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, CyclicColorPalette.GRAY_GRID));
        this.m_peptidePane.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, CyclicColorPalette.GRAY_GRID));
        this.m_scrollPane = new JScrollPane(this.m_peptidePane, 20, 30);
        this.m_scrollPane.setColumnHeaderView(this.m_titlePane);
        this.m_scrollPane.setRowHeaderView(this.m_numberPane);
        this.m_scrollPane.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_scrollPane, "Center");
    }

    public void setIsDataLoaded(boolean isDataLoaded) {
        if (isDataLoaded) {
            this.m_isDataNull = false;
        }
        this.m_isDataLoaded = isDataLoaded;
    }

    public void setScrollLocation(int ajustedLocation) {
        JScrollBar bar = this.m_scrollPane.getHorizontalScrollBar();
        int max = bar.getMaximum();
        int x = (int)((float)max / (float)this.m_sequenceLength * (float)(ajustedLocation - 2));
        bar.setValue(Math.min(x, max));
    }

    void setRowCount(int rowCount) {
        this.m_rowCount = rowCount;
    }

    public void setSequenceLength(int sequenceLength) {
        this.m_sequenceLength = sequenceLength;
    }

    @Override
    public void paint(Graphics g) {
        this.m_scrollPane.getViewport().revalidate();
        super.paint(g);
    }

    protected int getSelectedPeptideIndex() {
        return this.m_peptidePane.m_ctrlPeptideArea.getSelectedIndex();
    }

    protected void clean() {
        this.m_isDataNull = true;
    }

    protected void setSelectedPeptideIndex(int i) {
        this.m_peptidePane.m_ctrlPeptideArea.setSelectedIndex(i);
    }

    private class PeptideNumberPane
    extends JPanel {
        int m_x0;
        int m_y0;

        private PeptideNumberPane() {
            this.setBackground(Color.WHITE);
        }

        public void setBeginPoint(int x, int y) {
            this.m_x0 = x;
            this.m_y0 = y;
        }

        @Override
        public Dimension getPreferredSize() {
            int width = ViewSetting.WIDTH_AA + 2 * ViewSetting.BORDER_GAP;
            int height = PTMSitePeptidesGraphicViewPanel.this.m_rowCount * (ViewSetting.HEIGHT_AA * 2 - ViewSetting.HEIGHT_AA / 2);
            if (height == 0) {
                height = 5 * ViewSetting.HEIGHT_AA;
            }
            return new Dimension(width, height);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!PTMSitePeptidesGraphicViewPanel.this.m_isDataNull && PTMSitePeptidesGraphicViewPanel.this.m_isDataLoaded) {
                Graphics2D g2 = (Graphics2D)g;
                FontMetrics f = g2.getFontMetrics(ViewSetting.FONT_NUMBER);
                int ascend = f.getAscent();
                int y0 = this.m_y0 + ascend;
                g2.setColor(Color.black);
                g2.setFont(ViewSetting.FONT_NUMBER);
                for (int i = 1; i < PTMSitePeptidesGraphicViewPanel.this.m_rowCount + 1; ++i) {
                    String number = String.valueOf(i);
                    int stringWidth = f.stringWidth(number);
                    int x0 = this.m_x0 + ViewSetting.WIDTH_AA - stringWidth;
                    g2.drawString("" + i, x0, y0);
                    y0 = (int)((double)y0 + (double)ViewSetting.HEIGHT_AA * 1.5);
                }
            }
        }
    }

    private class PeptidePane
    extends JPanel {
        private PeptideAreaCtrl m_ctrlPeptideArea;

        private PeptidePane(PeptideAreaCtrl ctrlPeptideArea) {
            this.m_ctrlPeptideArea = ctrlPeptideArea;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    PeptidePane.this.requestFocusInWindow();
                    int oldSelected = PeptidePane.this.m_ctrlPeptideArea.getSelectedIndex();
                    int selectedIndex = PeptidePane.this.m_ctrlPeptideArea.getSelectedIndex(e.getX(), e.getY());
                    if (selectedIndex != oldSelected && selectedIndex != -1 && PTMSitePeptidesGraphicViewPanel.this.m_ptmSitePanel != null) {
                        PeptidePane.this.repaint();
                        PTMSitePeptidesGraphicViewPanel.this.m_ptmSitePanel.valueChanged();
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    int x = e.getX();
                    int y = e.getY();
                    String tips = PeptidePane.this.m_ctrlPeptideArea.getToolTipText(x, y);
                    PeptidePane.this.setToolTipText(tips);
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                }
            });
            this.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    int oldSelected = PeptidePane.this.m_ctrlPeptideArea.getSelectedIndex();
                    if (evt.getKeyCode() == 38) {
                        PeptidePane.this.m_ctrlPeptideArea.setRelativeSelected(-1);
                    } else if (evt.getKeyCode() == 40) {
                        PeptidePane.this.m_ctrlPeptideArea.setRelativeSelected(1);
                    }
                    int selectedIndex = PeptidePane.this.m_ctrlPeptideArea.getSelectedIndex();
                    if (oldSelected != selectedIndex) {
                        PTMSitePeptidesGraphicViewPanel.this.m_ptmSitePanel.valueChanged();
                        PeptidePane.this.repaint();
                    }
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            });
        }

        public void setBeginPoint(int x, int y) {
            this.m_ctrlPeptideArea.setBeginPoint(x, y);
        }

        @Override
        public Dimension getPreferredSize() {
            int width = (PTMSitePeptidesGraphicViewPanel.this.m_sequenceLength + 2) * ViewSetting.WIDTH_AA;
            int height = PTMSitePeptidesGraphicViewPanel.this.m_rowCount * (ViewSetting.HEIGHT_AA * 2 - ViewSetting.HEIGHT_AA / 2);
            if (height == 0) {
                height = 5 * ViewSetting.HEIGHT_AA;
            }
            return new Dimension(width, height);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!PTMSitePeptidesGraphicViewPanel.this.m_isDataNull) {
                ViewContext viewContext = new ViewContext();
                viewContext.setAreaWidth(this.getWidth());
                if (PTMSitePeptidesGraphicViewPanel.this.m_isDataLoaded) {
                    Graphics2D g2 = (Graphics2D)g;
                    this.m_ctrlPeptideArea.paint(g2, viewContext);
                }
            }
        }
    }

    private class TitlePane
    extends JPanel {
        private PTMMarkCtrl m_ctrlMark;
        private final ProteinSequence m_ctrlSequence;

        private TitlePane(PTMMarkCtrl ctrlMark, ProteinSequence ctrlSequence) {
            this.m_ctrlMark = ctrlMark;
            this.m_ctrlSequence = ctrlSequence;
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    int x = e.getX();
                    int y = e.getY();
                    String tips = TitlePane.this.m_ctrlMark.getToolTipText(x, y);
                    TitlePane.this.setToolTipText(tips);
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                }
            });
        }

        public void setMarkBeginPoint(int x, int y) {
            this.m_ctrlMark.setBeginPoint(x, y);
        }

        public void setSequenceBeginPoint(int x, int y) {
            this.m_ctrlSequence.setBeginPoint(x, y);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension((PTMSitePeptidesGraphicViewPanel.this.m_sequenceLength + 2) * ViewSetting.WIDTH_AA, ViewSetting.HEIGHT_MARK + ViewSetting.HEIGHT_SEQUENCE);
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.isPaintingOrigin();
            super.paintComponent(g);
            if (!PTMSitePeptidesGraphicViewPanel.this.m_isDataNull) {
                ViewContext viewContext = new ViewContext();
                if (PTMSitePeptidesGraphicViewPanel.this.m_isDataLoaded) {
                    Graphics2D g2 = (Graphics2D)g;
                    this.m_ctrlMark.paint(g2, viewContext);
                    this.m_ctrlSequence.paint(g2, viewContext);
                }
            }
        }
    }
}

