/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.renderer;

import fr.proline.studio.dam.data.SelectLevelEnum;
import fr.proline.studio.rsmexplorer.gui.renderer.RendererMouseCallback;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SelectLevelRenderer
extends DefaultTableCellRenderer
implements MouseListener,
MouseMotionListener {
    private final RendererMouseCallback m_callback;
    private final int m_column;

    public SelectLevelRenderer(RendererMouseCallback callback, int column) {
        this.m_callback = callback;
        this.m_column = column;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.checkCursor(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.checkCursor(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.checkCursor(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.checkCursor(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.m_callback == null) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (e.isShiftDown() || e.isControlDown()) {
            return;
        }
        JTable table = (JTable)e.getSource();
        Point pt = e.getPoint();
        int col = table.columnAtPoint(pt);
        int row = table.rowAtPoint(pt);
        int modelCol = table.convertColumnIndexToModel(col);
        if (modelCol != this.m_column || row == -1) {
            return;
        }
        JTableHeader th = table.getTableHeader();
        TableColumnModel tcm = th.getColumnModel();
        int columnStart = 0;
        for (int i = 0; i < col; ++i) {
            TableColumn column = tcm.getColumn(i);
            columnStart += column.getWidth();
        }
        if (columnStart + 20 < e.getX()) {
            return;
        }
        this.m_callback.mouseAction(e);
    }

    private void checkCursor(MouseEvent e) {
        if (this.m_callback == null) {
            return;
        }
        JTable table = (JTable)e.getSource();
        Point pt = e.getPoint();
        int col = table.columnAtPoint(pt);
        int row = table.rowAtPoint(pt);
        int modelCol = table.convertColumnIndexToModel(col);
        if (modelCol != this.m_column || row == -1) {
            table.setCursor(Cursor.getDefaultCursor());
            return;
        }
        JTableHeader th = table.getTableHeader();
        TableColumnModel tcm = th.getColumnModel();
        int columnStart = 0;
        for (int i = 0; i < col; ++i) {
            TableColumn column = tcm.getColumn(i);
            columnStart += column.getWidth();
        }
        if (columnStart + 20 < e.getX()) {
            table.setCursor(Cursor.getDefaultCursor());
            return;
        }
        table.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof SelectLevelEnum) {
            switch ((SelectLevelEnum)value) {
                case DESELECTED_MANUAL: 
                case DESELECTED_AUTO: {
                    this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.INVALIDATED));
                    break;
                }
                case SELECTED_AUTO: 
                case SELECTED_MANUAL: {
                    this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.VALIDATED));
                    break;
                }
                default: {
                    this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CROSS_SMALL16));
                }
            }
            this.setToolTipText(((SelectLevelEnum)value).getDescription());
        }
        if (isSelected) {
            this.setBackground(UIManager.getDefaults().getColor("Table.selectionBackground"));
            this.setForeground(Color.WHITE);
        } else {
            this.setBackground(UIManager.getDefaults().getColor("Table.background"));
            this.setForeground(Color.BLACK);
        }
        return this;
    }
}

