/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.spectrum;

import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelInterface;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.rsmexplorer.gui.spectrum.PeptideFragmentationData;
import fr.proline.studio.table.DecoratedTable;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.TablePopupMenu;
import java.awt.Component;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.table.TableColumnExt;

public class RsetPeptideFragmentationTable
extends DecoratedTable {
    private FragTableCustomRenderer m_fragTableRenderer;
    private boolean m_fragmentsIntensityVisible = false;

    public RsetPeptideFragmentationTable() {
        FragmentationTableModel fragmentationTableModel = new FragmentationTableModel();
        this.m_fragTableRenderer = new FragTableCustomRenderer();
        this.m_fragTableRenderer.setSelectMatrix(fragmentationTableModel.getMatrix());
        this.setModel((TableModel)((Object)fragmentationTableModel));
        this.setDefaultRenderer(Double.class, this.m_fragTableRenderer);
        this.setSortable(false);
        this.updateFragmentsIntensityVisibility(false);
    }

    public void setData(DPeptideMatch pepMatch, PeptideFragmentationData petpideFragmentationData) {
        this.setAllColumnsVisibles();
        FragmentationTableModel fragmentationTableModel = (FragmentationTableModel)((Object)this.getModel());
        if (petpideFragmentationData == null) {
            fragmentationTableModel.reinitData();
            this.m_fragTableRenderer.setSelectMatrix(fragmentationTableModel.getMatrix());
        } else {
            fragmentationTableModel.setData(petpideFragmentationData, pepMatch.getPeptide().getSequence());
            this.m_fragTableRenderer.setSelectMatrix(fragmentationTableModel.getMatrix());
            this.updateFragmentsIntensityVisibility();
        }
    }

    public final void updateFragmentsIntensityVisibility() {
        this.updateFragmentsIntensityVisibility(this.m_fragmentsIntensityVisible);
    }

    public final void updateFragmentsIntensityVisibility(boolean visible) {
        this.m_fragmentsIntensityVisible = visible;
        String intensityStringIdentifier = "(I)";
        List columns = this.getColumns(true);
        if (columns != null) {
            for (int i = 0; i < columns.size(); ++i) {
                TableColumnExt tce = (TableColumnExt)columns.get(i);
                if (tce.getTitle().indexOf("(I)") == -1) continue;
                tce.setVisible(visible);
            }
        }
    }

    public void setAllColumnsVisibles() {
        List columns = this.getColumns(true);
        if (columns != null) {
            for (int i = 0; i < columns.size(); ++i) {
                TableColumnExt tce = (TableColumnExt)columns.get(i);
                tce.setVisible(true);
            }
        }
    }

    public TablePopupMenu initPopupMenu() {
        return null;
    }

    public void prepostPopupMenu() {
    }

    public static class FragTableCustomRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private String[][] m_selectMatrix = new String[100][100];
        private StringBuilder m_stringBuilder;

        void setSelectMatrix(String[][] matx) {
            this.m_selectMatrix = matx;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.m_stringBuilder == null) {
                this.m_stringBuilder = new StringBuilder();
            } else {
                this.m_stringBuilder.setLength(0);
            }
            String textToExport = value != null ? value.toString() : "";
            if (this.m_selectMatrix[row][column] != null) {
                this.m_stringBuilder.append("<HTML>");
                if (this.m_selectMatrix[row][column].contains("ABC")) {
                    this.m_stringBuilder.append("<span style='color:").append(isSelected ? "#afffff" : "#3399ff").append("'>").append("<b>").append(textToExport).append("</b>").append("</span>");
                } else if (this.m_selectMatrix[row][column].contains("XYZ")) {
                    this.m_stringBuilder.append("<span style='color:").append(isSelected ? "#ffe6e6" : "#ff5555").append("'>").append("<b>").append(textToExport).append("</b>").append("</span>");
                }
                this.m_stringBuilder.append("</HTML>");
            } else {
                this.m_stringBuilder.append(textToExport);
            }
            Component component = super.getTableCellRendererComponent(table, this.m_stringBuilder.toString(), isSelected, hasFocus, row, column);
            return component;
        }
    }

    public static class FragmentationTableModel
    extends DecoratedTableModel
    implements ExtendedTableModelInterface,
    ExportModelInterface {
        private List<PeptideFragmentationData.TheoreticalFragmentSeries> m_fragSer;
        private String m_peptideSequence;
        private int m_sizeMaxSeries;
        private String[][] m_matrix;
        private double[][] m_matrixIntensity;
        private String[] m_columnNames;

        public FragmentationTableModel() {
            this.initData();
        }

        public void reinitData() {
            this.initData();
            this.fireTableStructureChanged();
        }

        private void initData() {
            this.m_fragSer = null;
            this.m_peptideSequence = null;
            this.m_sizeMaxSeries = 0;
            this.m_matrix = null;
            this.m_matrixIntensity = null;
            this.m_columnNames = null;
        }

        public void setData(PeptideFragmentationData peptideFragmentationData, String peptideSequence) {
            this.initData();
            this.m_fragSer = peptideFragmentationData.getTheoreticalFragmentSeries();
            PeptideFragmentationData.FragmentMatch[] fragmentMatches = peptideFragmentationData.getFragmentMatches();
            this.m_peptideSequence = peptideSequence;
            int sizeMaxSeries = 0;
            for (int i = 0; i < this.m_fragSer.size(); ++i) {
                if (this.m_fragSer.get((int)i).masses.length <= sizeMaxSeries) continue;
                sizeMaxSeries = this.m_fragSer.get((int)i).masses.length;
            }
            this.m_sizeMaxSeries = sizeMaxSeries;
            String xyzSerieName = peptideFragmentationData.getXYZReferenceSeriesName();
            String abcSerieName = peptideFragmentationData.getABCReferenceSeriesName();
            this.m_columnNames = new String[this.m_fragSer.size() + 3 + this.m_fragSer.size()];
            int i = 0;
            this.m_columnNames[i++] = "amino acid";
            this.m_columnNames[i++] = abcSerieName + " ion";
            for (PeptideFragmentationData.TheoreticalFragmentSeries currentFrag : this.m_fragSer) {
                this.m_columnNames[i++] = currentFrag.frag_series + " (M)";
            }
            this.m_columnNames[i] = xyzSerieName + " ion";
            ++i;
            for (PeptideFragmentationData.TheoreticalFragmentSeries currentFragSer : this.m_fragSer) {
                this.m_columnNames[i] = currentFragSer.frag_series + " (I)";
                ++i;
            }
            this.m_matrix = new String[sizeMaxSeries][this.m_columnNames.length];
            this.m_matrixIntensity = new double[sizeMaxSeries][this.m_columnNames.length];
            for (int j = 0; j < this.m_fragSer.size(); ++j) {
                for (int k = 0; k < this.m_fragSer.get((int)j).masses.length; ++k) {
                    for (i = 0; i < fragmentMatches.length; ++i) {
                        if (fragmentMatches[i].getCharge() != this.m_fragSer.get(j).getCharge() || !fragmentMatches[i].getSeriesName().equals(this.m_fragSer.get((int)j).frag_series) || !(Math.abs(fragmentMatches[i].calculated_moz - this.m_fragSer.get((int)j).masses[k]) < 0.01)) continue;
                        if ((this.m_fragSer.get((int)j).frag_series.toUpperCase().contains("A") || this.m_fragSer.get((int)j).frag_series.toUpperCase().contains("B") || this.m_fragSer.get((int)j).frag_series.toUpperCase().contains("C")) && fragmentMatches[i].getPosition() == k + 1) {
                            this.m_matrix[k][j + 2] = "ABC";
                            this.m_matrixIntensity[k][j + 2] = fragmentMatches[i].intensity.floatValue();
                            String[] stringArray = this.m_matrix[k];
                            int n = j + 2;
                            stringArray[n] = stringArray[n] + "intensity";
                            continue;
                        }
                        if (!this.m_fragSer.get((int)j).frag_series.toUpperCase().contains("X") && !this.m_fragSer.get((int)j).frag_series.toUpperCase().contains("Y") && !this.m_fragSer.get((int)j).frag_series.toUpperCase().contains("Z") || sizeMaxSeries - fragmentMatches[i].getPosition() != k) continue;
                        this.m_matrix[k][j + 2] = "XYZ";
                        this.m_matrixIntensity[k][j + 2] = fragmentMatches[i].intensity.floatValue();
                        String[] stringArray = this.m_matrix[k];
                        int n = j + 2;
                        stringArray[n] = stringArray[n] + "intensity";
                    }
                }
            }
            this.fireTableStructureChanged();
        }

        public String[][] getMatrix() {
            return this.m_matrix;
        }

        public String getColumnName(int col) {
            return this.m_columnNames[col];
        }

        public String getToolTipForHeader(int col) {
            return this.getColumnName(col);
        }

        public String getTootlTipValue(int row, int col) {
            return null;
        }

        public int getRowCount() {
            return this.m_sizeMaxSeries;
        }

        public int getColumnCount() {
            if (this.m_columnNames == null) {
                return 0;
            }
            return this.m_columnNames.length;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            if (columnIndex == 1) {
                return Integer.class;
            }
            if (columnIndex == this.m_fragSer.size() + 2) {
                return Integer.class;
            }
            return Double.class;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                if (rowIndex < this.m_peptideSequence.length()) {
                    return Character.valueOf(this.m_peptideSequence.charAt(rowIndex));
                }
                return "?";
            }
            if (columnIndex == 1) {
                return rowIndex + 1;
            }
            if (columnIndex == this.m_fragSer.size() + 3 - 1) {
                return this.m_sizeMaxSeries - rowIndex;
            }
            if (columnIndex < this.m_fragSer.size() + 3) {
                PeptideFragmentationData.TheoreticalFragmentSeries currentFragSer = this.m_fragSer.get(columnIndex - 2);
                if (currentFragSer.masses[rowIndex] != 0.0) {
                    return (double)Math.round(currentFragSer.masses[rowIndex] * 10000.0) / 10000.0;
                }
                return null;
            }
            if (columnIndex > this.m_fragSer.size() + 2 && columnIndex < this.m_columnNames.length) {
                if (this.m_matrixIntensity[rowIndex][columnIndex - this.m_fragSer.size() - 1] > 0.0) {
                    return new BigDecimal(this.m_matrixIntensity[rowIndex][columnIndex - this.m_fragSer.size() - 1], new MathContext(3));
                }
                return null;
            }
            return null;
        }

        public TableCellRenderer getRenderer(int row, int col) {
            return null;
        }

        public String getExportRowCell(int row, int col) {
            return ExportModelUtilities.getExportRowCell((ExtendedTableModelInterface)this, (int)row, (int)col);
        }

        public ArrayList<ExportFontData> getExportFonts(int row, int col) {
            String exportString = this.getExportRowCell(row, col);
            if (this.m_matrix[row][col] != null) {
                if (this.m_matrix[row][col].contains("ABC")) {
                    ArrayList<ExportFontData> ExportFontDatas = new ArrayList<ExportFontData>();
                    ExportFontData newSubStringFont = new ExportFontData(0, exportString.length(), 48, 1);
                    ExportFontDatas.add(newSubStringFont);
                    return ExportFontDatas;
                }
                if (this.m_matrix[row][col].contains("XYZ")) {
                    ArrayList<ExportFontData> ExportFontDatas = new ArrayList<ExportFontData>();
                    ExportFontData newSubStringFont = new ExportFontData(0, exportString.length(), 10, 1);
                    ExportFontDatas.add(newSubStringFont);
                    return ExportFontDatas;
                }
            }
            return null;
        }

        public String getExportColumnName(int col) {
            return this.getColumnName(col);
        }

        public String getDataColumnIdentifier(int columnIndex) {
            return this.getColumnName(columnIndex);
        }

        public Class getDataColumnClass(int columnIndex) {
            return this.getColumnClass(columnIndex);
        }

        public Object getDataValueAt(int rowIndex, int columnIndex) {
            return this.getValueAt(rowIndex, columnIndex);
        }

        public int[] getKeysColumn() {
            return null;
        }

        public int getInfoColumn() {
            return -1;
        }

        public void setName(String name) {
        }

        public String getName() {
            return null;
        }

        public Map<String, Object> getExternalData() {
            return null;
        }

        public PlotInformation getPlotInformation() {
            return null;
        }

        public ArrayList<ExtraDataType> getExtraDataTypes() {
            return null;
        }

        public Object getValue(Class c) {
            return null;
        }

        public Object getRowValue(Class c, int row) {
            return null;
        }

        public Object getColValue(Class c, int col) {
            return null;
        }
    }
}

