/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.lcms.dto.DFeature;
import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.corewrapper.util.PeptideClassesUtils;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.mzscope.MzScopeInterface;
import fr.proline.studio.mzscope.MzdbInfo;
import fr.proline.studio.rsmexplorer.gui.renderer.FontRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.TimeRenderer;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.LazyTableModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.BigFloatOrDoubleRenderer;
import fr.proline.studio.table.renderer.DefaultLeftAlignRenderer;
import fr.proline.studio.table.renderer.DefaultRightAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureTableModel
extends LazyTableModel
implements GlobalTableModelInterface,
MzScopeInterface {
    public static final int COLTYPE_FEATURE_ID = 0;
    public static final int COLTYPE_FEATURE_MAP_NAME = 1;
    public static final int COLTYPE_FEATURE_QC = 2;
    public static final int COLTYPE_FEATURE_MOZ = 3;
    public static final int COLTYPE_FEATURE_CALIBRATED_MOZ = 4;
    public static final int COLTYPE_FEATURE_CHARGE = 5;
    public static final int COLTYPE_FEATURE_RETENTION_TIME = 6;
    public static final int COLTYPE_FEATURE_APEX_INTENSITY = 7;
    public static final int COLTYPE_FEATURE_INTENSITY = 8;
    public static final int COLTYPE_FEATURE_DURATION = 9;
    public static final int COLTYPE_FEATURE_QUALITY_SCORE = 10;
    public static final int COLTYPE_FEATURE_IS_OVERLAPPING = 11;
    public static final int COLTYPE_FEATURE_PREDICTED_RETENTION_TIME = 12;
    public static final int COLTYPE_FEATURE_PEAKELS_COUNT = 13;
    public static final String SERIALIZED_PROP_PREDICTED_ELUTION_TIME = "predicted_elution_time";
    public static final String SERIALIZED_PROP_PEAKELS_COUNT = "peakels_count";
    public static final String SERIALIZED_PROP_IS_RELIABLE = "is_reliable";
    protected static final Logger logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private static final String[] m_columnNames = new String[]{"Id", "Map", "Quant. Channel", "m/z", "Calibrated MoZ", "Charge", "RT", "Apex Intensity", "Intensity", "Duration (sec)", "Quality Score", "Is Overlapping", "Predicted RT", "#Peakels"};
    private static final String[] m_toolTipColumns = new String[]{"Feature Id", "Map name", "Quantitation Channel ", "Mass to Charge Ratio", "Calibrated Mass to Charge Ratio", "Charge", "Retention Time in minutes", "Apex Intensity", "Intensity", "Duration (sec)", "Quality Score", "Is Overlapping", "Predicted Retention time in min", "Peakels count"};
    private static final String[] m_columnNamesForExport = new String[]{"Id", "Map", "Quantitation Channel", "m/z", "Calibrated MoZ", "Charge", "Elution Time (sec)", "Apex Intensity", "Intensity", "Duration (sec)", "Quality Score", "Is Overlapping", "Predicted Retention Time (sec)", "Peakels Count"};
    private DMasterQuantPeptideIon m_quantPeptideIon = null;
    private List<DFeature> m_features = null;
    private QuantChannelInfo m_quantChannelInfo = null;
    private List<Boolean> m_featureHasPeak = null;
    private Map<Long, Double> calibratedMozByFeatureId = new HashMap<Long, Double>();
    private String m_modelName;
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();

    public FeatureTableModel(LazyTable table) {
        super(table);
    }

    public int getColumnCount() {
        return m_columnNames.length;
    }

    public String getColumnName(int col) {
        return m_columnNames[col];
    }

    public String getExportColumnName(int col) {
        return m_columnNamesForExport[col];
    }

    public String getToolTipForHeader(int col) {
        return m_toolTipColumns[col];
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return Long.class;
        }
        return LazyData.class;
    }

    @Override
    public int getSubTaskId(int col) {
        return 0;
    }

    public int getRowCount() {
        if (this.m_features == null) {
            return 0;
        }
        return this.m_features.size();
    }

    public Object getValueAt(int row, int col) {
        DFeature feature = this.m_features.get(row);
        switch (col) {
            case 0: {
                return feature.getId();
            }
            case 1: {
                LazyData lazyData = this.getLazyData(row, col);
                if (feature.getCharge() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)((Object)feature.getMap().getName()));
                }
                return lazyData;
            }
            case 2: {
                LazyData lazyData = this.getLazyData(row, col);
                if (feature.getCharge() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    String title = this.m_quantChannelInfo.getQuantChannels(feature.getQuantChannelId()).getName();
                    Color color = this.m_quantChannelInfo.getQuantChannelColor(feature.getQuantChannelId());
                    String rsmHtmlColor = CyclicColorPalette.getHTMLColor((Color)color);
                    StringBuilder sb = new StringBuilder();
                    sb.append("<html>");
                    sb.append("<html><font color='").append(rsmHtmlColor).append("'>&#x25A0;&nbsp;</font>");
                    sb.append(title);
                    sb.append("</html>");
                    lazyData.setData((Comparable)((Object)sb.toString()));
                }
                return lazyData;
            }
            case 3: {
                LazyData lazyData = this.getLazyData(row, col);
                if (feature.getCharge() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Double.valueOf(feature.getMoz()));
                }
                return lazyData;
            }
            case 5: {
                LazyData lazyData = this.getLazyData(row, col);
                if (feature.getCharge() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)feature.getCharge());
                }
                return lazyData;
            }
            case 6: {
                LazyData lazyData = this.getLazyData(row, col);
                if (feature.getCharge() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Float.valueOf(feature.getElutionTime()));
                }
                return lazyData;
            }
            case 4: {
                LazyData lazyData = this.getLazyData(row, col);
                if (feature.getCharge() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else if (this.calibratedMozByFeatureId.containsKey(feature.getId())) {
                    lazyData.setData((Comparable)this.calibratedMozByFeatureId.get(feature.getId()));
                } else {
                    lazyData.setData((Comparable)this.getCalibratedMoZ(feature));
                }
                return lazyData;
            }
            case 7: {
                LazyData lazyData = this.getLazyData(row, col);
                if (feature.getCharge() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Float.valueOf(feature.getApexIntensity()));
                }
                return lazyData;
            }
            case 8: {
                LazyData lazyData = this.getLazyData(row, col);
                if (feature.getCharge() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Float.valueOf(feature.getIntensity()));
                }
                return lazyData;
            }
            case 9: {
                LazyData lazyData = this.getLazyData(row, col);
                if (feature.getCharge() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Float.valueOf(feature.getDuration()));
                }
                return lazyData;
            }
            case 10: {
                LazyData lazyData = this.getLazyData(row, col);
                if (feature.getCharge() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Float.valueOf(feature.getQualityScore()));
                }
                return lazyData;
            }
            case 11: {
                LazyData lazyData = this.getLazyData(row, col);
                if (feature.getCharge() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)((Object)(feature.getIsOverlapping() != false ? "Yes" : "No")));
                }
                return lazyData;
            }
            case 12: {
                LazyData lazyData = this.getLazyData(row, col);
                Map prop = null;
                try {
                    prop = feature.getSerializedPropertiesAsMap();
                }
                catch (Exception color) {
                    // empty catch block
                }
                if (prop != null) {
                    Object o = prop.get(SERIALIZED_PROP_PREDICTED_ELUTION_TIME);
                    if (o != null && o instanceof Double) {
                        Double predictedElutionTime = (Double)o;
                        lazyData.setData((Comparable)new Float(predictedElutionTime));
                    } else {
                        lazyData.setData((Comparable)new Float(feature.getPredictedElutionTime()));
                    }
                } else {
                    lazyData.setData((Comparable)new Float(feature.getPredictedElutionTime()));
                }
                return lazyData;
            }
            case 13: {
                LazyData lazyData = this.getLazyData(row, col);
                if (feature.getCharge() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Integer.valueOf(feature.getPeakelCount()));
                }
                return lazyData;
            }
        }
        return null;
    }

    private Double getCalibratedMoZ(DFeature feature) {
        logger.debug("calculate delta moz at RT " + feature.getElutionTime() + " for map =" + feature.getMap().getName());
        Double calcMoz = Double.NaN;
        try {
            if (this.m_quantPeptideIon != null) {
                Double deltaMoz = PeptideClassesUtils.getDeltaMozFor((double)feature.getMoz(), (double)feature.getCharge().intValue(), (Peptide)this.m_quantPeptideIon.getPeptideInstance().getPeptide()).doubleValue();
                calcMoz = feature.getMoz() + deltaMoz;
                this.calibratedMozByFeatureId.put(feature.getId(), calcMoz);
                logger.debug("...result= " + calcMoz);
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving time in map calibration: " + e);
        }
        return calcMoz;
    }

    public void setData(Long taskId, List<DFeature> features, QuantChannelInfo quantChannelInfo, List<Boolean> featureHasPeak, DMasterQuantPeptideIon pepIon) {
        this.m_features = features;
        this.m_quantPeptideIon = pepIon;
        this.calibratedMozByFeatureId.clear();
        this.m_quantChannelInfo = quantChannelInfo;
        this.m_featureHasPeak = featureHasPeak;
        this.m_taskId = taskId;
        this.fireTableDataChanged();
    }

    public void dataUpdated() {
        this.fireTableDataChanged();
    }

    public DFeature getFeature(int i) {
        return this.m_features.get(i);
    }

    public Color getPlotColor(int i) {
        return this.m_quantChannelInfo.getQuantChannelColor(this.m_features.get(i).getQuantChannelId());
    }

    public String getPlotTitle(int i) {
        return this.m_quantChannelInfo.getMapTitle(this.m_features.get(i).getMap().getId());
    }

    public int findRow(long featureId) {
        int nb = this.m_features.size();
        for (int i = 0; i < nb; ++i) {
            if (featureId != this.m_features.get(i).getId()) continue;
            return i;
        }
        return -1;
    }

    public void sortAccordingToModel(ArrayList<Long> featureIds, CompoundTableModel compoundTableModel) {
        if (this.m_features == null) {
            return;
        }
        HashSet<Long> featureIdMap = new HashSet<Long>(featureIds.size());
        featureIdMap.addAll(featureIds);
        int nb = this.m_table.getRowCount();
        int iCur = 0;
        for (int iView = 0; iView < nb; ++iView) {
            DFeature f;
            int iModel = this.m_table.convertRowIndexToModel(iView);
            if (compoundTableModel != null) {
                iModel = compoundTableModel.convertCompoundRowToBaseModelRow(iModel);
            }
            if (!featureIdMap.contains((f = this.getFeature(iModel)).getId())) continue;
            featureIds.set(iCur++, f.getId());
        }
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        filtersMap.put(3, (Filter)new DoubleFilter(this.getColumnName(3), null, 3));
        filtersMap.put(4, (Filter)new DoubleFilter(this.getColumnName(4), null, 4));
        filtersMap.put(5, (Filter)new IntegerFilter(this.getColumnName(5), null, 5));
        ConvertValueInterface minuteConverter = new ConvertValueInterface(){

            public Object convertValue(Object o) {
                if (o == null) {
                    return null;
                }
                return (double)((Float)o).floatValue() / 60.0;
            }
        };
        filtersMap.put(6, (Filter)new DoubleFilter(this.getColumnName(6), minuteConverter, 6));
        filtersMap.put(7, (Filter)new DoubleFilter(this.getColumnName(7), null, 7));
        filtersMap.put(8, (Filter)new DoubleFilter(this.getColumnName(8), null, 8));
        filtersMap.put(9, (Filter)new DoubleFilter(this.getColumnName(9), null, 9));
        filtersMap.put(10, (Filter)new DoubleFilter(this.getColumnName(10), null, 10));
        filtersMap.put(12, (Filter)new DoubleFilter(this.getColumnName(12), minuteConverter, 12));
        filtersMap.put(13, (Filter)new IntegerFilter(this.getColumnName(13), null, 13));
    }

    public int getLoadingPercentage() {
        return this.m_table.getLoadingPercentage();
    }

    public boolean isLoaded() {
        return this.m_table.isLoaded();
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Long.class;
            }
            case 1: 
            case 2: {
                return String.class;
            }
            case 3: 
            case 4: {
                return Double.class;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                return Float.class;
            }
            case 11: {
                return Boolean.class;
            }
            case 5: 
            case 13: {
                return Integer.class;
            }
        }
        return null;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        DFeature feature = this.m_features.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return feature.getId();
            }
            case 1: {
                return feature.getMap().getName();
            }
            case 2: {
                return this.m_quantChannelInfo.getMapTitle(feature.getMap().getId());
            }
            case 3: {
                return feature.getMoz();
            }
            case 5: {
                return feature.getCharge();
            }
            case 6: {
                return Float.valueOf(feature.getElutionTime());
            }
            case 7: {
                return Float.valueOf(feature.getApexIntensity());
            }
            case 8: {
                return Float.valueOf(feature.getIntensity());
            }
            case 9: {
                return Float.valueOf(feature.getDuration());
            }
            case 10: {
                return Float.valueOf(feature.getQualityScore());
            }
            case 11: {
                return feature.getIsOverlapping();
            }
            case 12: {
                Object o;
                Map prop = null;
                try {
                    prop = feature.getSerializedPropertiesAsMap();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (prop != null && (o = prop.get(SERIALIZED_PROP_PREDICTED_ELUTION_TIME)) != null && o instanceof Double) {
                    return (Double)o;
                }
                return new Float(feature.getPredictedElutionTime());
            }
            case 13: {
                return feature.getPeakelCount();
            }
            case 4: {
                if (this.calibratedMozByFeatureId.containsKey(feature.getId())) {
                    return this.calibratedMozByFeatureId.get(feature.getId());
                }
                return this.getCalibratedMoZ(feature);
            }
        }
        return null;
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{0};
        return keys;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public PlotType getBestPlotType() {
        return PlotType.SCATTER_PLOT;
    }

    public int[] getBestColIndex(PlotType plotType) {
        switch (plotType) {
            case HISTOGRAM_PLOT: {
                int[] cols = new int[]{8, 8};
                return cols;
            }
            case SCATTER_PLOT: {
                int[] cols = new int[]{6, 8};
                return cols;
            }
        }
        return null;
    }

    public int getInfoColumn() {
        return 0;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public String getTootlTipValue(int row, int col) {
        if (this.m_features == null || row < 0) {
            return "";
        }
        DFeature feature = this.m_features.get(row);
        String title = this.m_quantChannelInfo.getQuantChannels(feature.getQuantChannelId()).getName();
        Color color = this.m_quantChannelInfo.getQuantChannelColor(feature.getQuantChannelId());
        String rsmHtmlColor = CyclicColorPalette.getHTMLColor((Color)color);
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<html><font color='").append(rsmHtmlColor).append("'>&#x25A0;&nbsp;</font>");
        sb.append(title);
        sb.append("</html>");
        return sb.toString();
    }

    public String getExportRowCell(int row, int col) {
        DFeature feature = this.m_features.get(row);
        switch (col) {
            case 0: {
                return "" + feature.getId();
            }
            case 1: {
                if (feature.getCharge() == null) {
                    return "";
                }
                return feature.getMap().getName();
            }
            case 2: {
                if (feature.getCharge() == null) {
                    return "";
                }
                return this.m_quantChannelInfo.getMapTitle(feature.getMap().getId());
            }
            case 3: {
                if (feature.getCharge() == null) {
                    return "";
                }
                return "" + feature.getMoz();
            }
            case 4: {
                if (!this.calibratedMozByFeatureId.containsKey(feature.getId()) || this.calibratedMozByFeatureId.get(feature.getId()).isNaN()) {
                    return "";
                }
                return "" + this.calibratedMozByFeatureId.get(feature.getId());
            }
            case 5: {
                if (feature.getCharge() == null) {
                    return "";
                }
                return "" + feature.getCharge();
            }
            case 6: {
                if (feature.getCharge() == null) {
                    return "";
                }
                return "" + feature.getElutionTime();
            }
            case 7: {
                if (feature.getCharge() == null) {
                    return "";
                }
                return "" + feature.getApexIntensity();
            }
            case 8: {
                if (feature.getCharge() == null) {
                    return "";
                }
                return "" + feature.getIntensity();
            }
            case 9: {
                if (feature.getCharge() == null) {
                    return "";
                }
                return "" + feature.getDuration();
            }
            case 10: {
                if (feature.getCharge() == null) {
                    return "";
                }
                return "" + feature.getQualityScore();
            }
            case 11: {
                if (feature.getCharge() == null) {
                    return "";
                }
                return feature.getIsOverlapping() != false ? "Yes" : "No";
            }
            case 12: {
                Object o;
                Map prop = null;
                try {
                    prop = feature.getSerializedPropertiesAsMap();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (prop != null && (o = prop.get(SERIALIZED_PROP_PREDICTED_ELUTION_TIME)) != null && o instanceof Double) {
                    return ((Double)o).toString();
                }
                return String.valueOf(feature.getPredictedElutionTime());
            }
            case 13: {
                if (feature.getCharge() == null) {
                    return "";
                }
                return "" + feature.getPeakelCount();
            }
        }
        return "";
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    public List<Integer> getDefaultColumnsToHide() {
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        listIds.add(13);
        listIds.add(11);
        listIds.add(10);
        listIds.add(4);
        return listIds;
    }

    public Boolean isReliable(int row, int col) {
        DFeature feature = this.m_features.get(row);
        if (feature.getId() == -1L) {
            return false;
        }
        Map prop = null;
        try {
            prop = feature.getSerializedPropertiesAsMap();
        }
        catch (Exception ex) {
            prop = null;
        }
        if (prop != null) {
            Object o = prop.get(SERIALIZED_PROP_IS_RELIABLE);
            if (o != null && o instanceof Boolean) {
                return (Boolean)o;
            }
            return true;
        }
        return true;
    }

    public Boolean isInItalic(int row, int col) {
        DFeature feature = this.m_features.get(row);
        if (feature.getId() == -1L) {
            return true;
        }
        if (col == 12) {
            Map prop = null;
            try {
                prop = feature.getSerializedPropertiesAsMap();
            }
            catch (Exception ex) {
                prop = null;
            }
            if (prop != null) {
                Object o = prop.get(SERIALIZED_PROP_PREDICTED_ELUTION_TIME);
                if (o != null && o instanceof Double) {
                    return false;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public List<MzdbInfo> getMzdbInfo() {
        ArrayList<MzdbInfo> mzdbInfos = new ArrayList<MzdbInfo>();
        ArrayList<String> fileNameList = new ArrayList<String>();
        for (DFeature feature : this.m_features) {
            DQuantitationChannel qc = this.m_quantChannelInfo.getQuantChannelForMap(feature.getMap().getId());
            if (qc == null || qc.getMzdbFileName() == null) continue;
            String fn = qc.getMzdbFileName();
            MzdbInfo mzdbInfo = feature.getId() == -1L ? new MzdbInfo(fn, Double.valueOf(feature.getMoz()), Double.valueOf(feature.getPredictedElutionTime()), Double.valueOf(0.0), Double.valueOf(0.0)) : new MzdbInfo(fn, Double.valueOf(feature.getMoz()), Double.valueOf(feature.getElutionTime()), Double.valueOf(feature.getFirstScan().getTime()), Double.valueOf(feature.getLastScan().getTime()));
            if (fileNameList.contains(fn)) continue;
            mzdbInfos.add(mzdbInfo);
            fileNameList.add(fn);
        }
        return mzdbInfos;
    }

    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_rendererMap.containsKey(col)) {
            return this.m_rendererMap.get(col);
        }
        FontRenderer renderer = null;
        switch (col) {
            case 1: 
            case 2: 
            case 11: {
                renderer = new FontRenderer((TableCellRenderer)new DefaultLeftAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)));
                break;
            }
            case 3: 
            case 4: {
                renderer = new FontRenderer((TableCellRenderer)new DoubleRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 4));
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                renderer = new FontRenderer((TableCellRenderer)new BigFloatOrDoubleRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 0));
                break;
            }
            case 6: 
            case 12: {
                renderer = new FontRenderer(new TimeRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class))));
                break;
            }
            case 5: 
            case 13: {
                renderer = new FontRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class)));
            }
        }
        this.m_rendererMap.put(col, renderer);
        return renderer;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(DFeature.class, true));
        list.add(new ExtraDataType(QuantChannelInfo.class, false));
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    public Object getValue(Class c) {
        if (c.equals(QuantChannelInfo.class)) {
            return this.m_quantChannelInfo;
        }
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(DFeature.class)) {
            return this.m_features.get(row);
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }
}

