/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.lcms.MapTime;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.graphics.PlotDataSpec;
import fr.proline.studio.graphics.PlotInformation;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MapTimeTableModel
implements ExtendedTableModelInterface {
    protected List<MapTime> m_mapValues = null;
    public static final int COLTYPE_VALUE = 0;
    public static final int COLTYPE_DELTA_VALUE = 1;
    protected String[] m_columnNames = new String[]{"Value in Map", "Delta value"};
    protected Color m_color;
    protected String m_title;
    private boolean m_inverseDeltaSign = false;

    public MapTimeTableModel(List<MapTime> mapTimes, Color color, String title, String mapName) {
        this.m_mapValues = mapTimes;
        this.m_color = color;
        this.m_title = title;
        this.m_inverseDeltaSign = true;
        this.m_columnNames[0] = "Time in Map (min)";
        this.m_columnNames[1] = "Delta moz (experimental - theoretical)";
    }

    public MapTimeTableModel(List<MapTime> mapTimes, Color color, String title, String fromMapName, String toMapName) {
        this.m_mapValues = mapTimes;
        this.m_color = color;
        this.m_title = title;
        this.m_columnNames[0] = "Time in Map " + fromMapName + " (min)";
        this.m_columnNames[1] = "Delta time to Map " + toMapName + " (s)";
    }

    public int getRowCount() {
        return this.m_mapValues == null ? 0 : this.m_mapValues.size();
    }

    public int getColumnCount() {
        return this.m_columnNames.length;
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.m_columnNames[columnIndex];
    }

    public Class getDataColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 1: {
                return Double.class;
            }
        }
        return null;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        MapTime mapTime = this.m_mapValues.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return mapTime.getTime() / 60.0;
            }
            case 1: {
                if (this.m_inverseDeltaSign) {
                    return -mapTime.getDeltaValue().doubleValue();
                }
                return mapTime.getDeltaValue();
            }
        }
        return null;
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(MapTime.class)) {
            return this.m_mapValues.get(row);
        }
        return null;
    }

    public int[] getKeysColumn() {
        return new int[]{0};
    }

    public int getInfoColumn() {
        return 0;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getName() {
        return "Signal";
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        PlotInformation plotInformation = new PlotInformation();
        plotInformation.setPlotColor(this.m_color);
        plotInformation.setPlotTitle(this.m_title);
        plotInformation.setDrawPoints(false);
        plotInformation.setDrawGap(true);
        return plotInformation;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return null;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getColValue(Class c, int col) {
        return null;
    }

    public void addSingleValue(Object v) {
    }

    public Object getSingleValue(Class c) {
        return null;
    }

    public long row2UniqueId(int rowIndex) {
        return rowIndex;
    }

    public int uniqueId2Row(long id) {
        return (int)id;
    }

    public PlotDataSpec getDataSpecAt(int i) {
        return null;
    }
}

