/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon;
import fr.proline.core.orm.msi.dto.DQuantPeptideIon;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.utils.CyclicColorPalette;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class QuantAggregatePeptideIonTableModel
extends DecoratedTableModel
implements GlobalTableModelInterface {
    public static final int COLTYPE_MASTER_QUANT_PEPTIDE_ION_ID = 0;
    public static final int COLTYPE_QUANTI_DATASET_NAME = 1;
    public static final int LAST_STATIC_COLUMN = 1;
    private static final String[] m_columnNames = new String[]{"MasterQuantPeptideIon Id", "Quanti."};
    private static final String[] m_columnNamesForFilter = m_columnNames;
    private static final String[] m_toolTipColumns = new String[]{"Master Quant. Peption Ion Id of aggregated Quanti.", "Quantification"};
    private List<DMasterQuantPeptideIon> m_masterQuantPeptideIonList = null;
    private QuantChannelInfo m_quantChannelInfoParent = null;
    private List<QuantChannelInfo> m_quantChannelInfoChildren = null;
    private int m_nbRows = 0;
    private int m_nbCols = 0;
    private ArrayList<String> m_columnNamesDynamic = new ArrayList();
    private ArrayList<String> m_sourceQuantiNames = new ArrayList();
    private Integer[][] m_abundances = null;

    public QuantAggregatePeptideIonTableModel() {
        for (String columnName : m_columnNames) {
            this.m_columnNamesDynamic.add(columnName);
        }
        this.m_nbCols = this.m_columnNamesDynamic.size();
    }

    public void setData(DMasterQuantPeptideIon aggregatedMasterQuantPeptideIon, List<DMasterQuantPeptideIon> masterQuantPeptideIonList, QuantChannelInfo quantChannelInfo, HashMap<Long, HashSet<Long>> aggregatedToChildrenQuantChannelsId, HashMap<Long, DQuantitationChannel> quantitationChannelsMap) {
        this.m_masterQuantPeptideIonList = masterQuantPeptideIonList;
        this.m_quantChannelInfoParent = quantChannelInfo;
        ArrayList<String> columnNamesDynamic = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (String columnName : m_columnNames) {
            columnNamesDynamic.add(columnName);
        }
        if (aggregatedMasterQuantPeptideIon == null) {
            this.m_nbRows = 0;
            this.m_nbCols = columnNamesDynamic.size();
            this.m_abundances = null;
            this.m_sourceQuantiNames.clear();
            this.m_quantChannelInfoChildren = null;
        } else {
            int row;
            for (int col = 0; col < quantChannelInfo.getQuantChannels().length; ++col) {
                String rsmHtmlColor = CyclicColorPalette.getHTMLColor((int)col);
                sb.append("<html><font color='").append(rsmHtmlColor).append("'>&#x25A0;&nbsp;</font>");
                sb.append(quantChannelInfo.getQuantChannels()[col].getName());
                sb.append("</html>");
                columnNamesDynamic.add(sb.toString());
                sb.setLength(0);
            }
            this.m_nbRows = masterQuantPeptideIonList.size();
            this.m_nbCols = columnNamesDynamic.size();
            this.m_quantChannelInfoChildren = new ArrayList<QuantChannelInfo>();
            for (row = 0; row < this.m_nbRows; ++row) {
                String quantiName = "";
                DMasterQuantPeptideIon masterQuantPeptideIon = masterQuantPeptideIonList.get(row);
                ArrayList<DQuantitationChannel> quantChannelsChild = new ArrayList<DQuantitationChannel>();
                block3: for (DQuantitationChannel qc : quantChannelInfo.getQuantChannels()) {
                    HashSet<Long> childrenQC = aggregatedToChildrenQuantChannelsId.get(qc.getId());
                    Map quantPeptideIonMap = masterQuantPeptideIon.getQuantPeptideIonByQchIds();
                    for (Long qcId : childrenQC) {
                        if (quantPeptideIonMap.get(qcId) == null) continue;
                        quantiName = quantitationChannelsMap.get(qcId).getMasterQuantitationChannel().getDataset().getName();
                        quantChannelsChild.add(quantitationChannelsMap.get(qcId));
                        break block3;
                    }
                    this.m_quantChannelInfoChildren.add(new QuantChannelInfo(quantChannelsChild));
                }
                this.m_sourceQuantiNames.add(quantiName);
            }
            this.m_abundances = new Integer[this.m_nbRows][this.m_nbCols - 1 - 1];
            for (row = 0; row < this.m_nbRows; ++row) {
                DMasterQuantPeptideIon masterQuantPeptideIon = masterQuantPeptideIonList.get(row);
                for (int col = 0; col < this.m_nbCols - 1 - 1; ++col) {
                    Long qcId;
                    Integer abundance = null;
                    DQuantitationChannel aggregateQC = quantChannelInfo.getQuantChannels()[col];
                    HashSet<Long> childrenQC = aggregatedToChildrenQuantChannelsId.get(aggregateQC.getId());
                    DQuantPeptideIon peptideIon = null;
                    Map quantPeptideIonMap = masterQuantPeptideIon.getQuantPeptideIonByQchIds();
                    Iterator<Long> iterator = childrenQC.iterator();
                    while (iterator.hasNext() && (peptideIon = (DQuantPeptideIon)quantPeptideIonMap.get(qcId = iterator.next())) == null) {
                    }
                    abundance = peptideIon != null ? new Integer(Math.round(peptideIon.getAbundance().floatValue())) : new Integer(0);
                    this.m_abundances[row][col] = abundance;
                }
            }
        }
        boolean structureChanged = false;
        if (columnNamesDynamic.size() != this.m_columnNamesDynamic.size()) {
            structureChanged = true;
        } else {
            for (int i = 0; i < this.m_columnNamesDynamic.size(); ++i) {
                if (((String)columnNamesDynamic.get(i)).equals(this.m_columnNamesDynamic.get(i))) continue;
                structureChanged = true;
                break;
            }
        }
        if (structureChanged) {
            this.m_columnNamesDynamic = columnNamesDynamic;
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    public DMasterQuantPeptideIon getPeptideIon(int row) {
        return this.m_masterQuantPeptideIonList.get(row);
    }

    public QuantChannelInfo getQuantChannelInfo(int row) {
        DMasterQuantPeptideIon masterQuantPeptideIon = this.m_masterQuantPeptideIonList.get(row);
        return new QuantChannelInfo(masterQuantPeptideIon.getResultSummary().getTransientData(null).getDDataset());
    }

    public int getRowCount() {
        return this.m_nbRows;
    }

    public int getColumnCount() {
        return this.m_nbCols;
    }

    public String getColumnName(int col) {
        return this.m_columnNamesDynamic.get(col);
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Long.class;
            }
            case 1: {
                return String.class;
            }
        }
        return Integer.class;
    }

    public Object getValueAt(int row, int col) {
        DMasterQuantPeptideIon masterQuantPeptideIon = this.m_masterQuantPeptideIonList.get(row);
        switch (col) {
            case 0: {
                return masterQuantPeptideIon.getId();
            }
            case 1: {
                return this.m_sourceQuantiNames.get(row);
            }
        }
        return this.m_abundances[row][col -= 2];
    }

    public String getToolTipForHeader(int col) {
        if (col <= 1) {
            return m_toolTipColumns[col];
        }
        return null;
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public TableCellRenderer getRenderer(int row, int col) {
        return null;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public Long getTaskId() {
        return -1L;
    }

    public LazyData getLazyData(int row, int col) {
        return null;
    }

    public void givePriorityTo(Long taskId, int row, int col) {
    }

    public void sortingChanged(int col) {
    }

    public int getSubTaskId(int col) {
        return -1;
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        return this.getColumnClass(columnIndex);
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        return this.getValueAt(rowIndex, columnIndex);
    }

    public int[] getKeysColumn() {
        return null;
    }

    public int getInfoColumn() {
        return -1;
    }

    public void setName(String name) {
    }

    public String getName() {
        return null;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return null;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        filtersMap.put(1, (Filter)new StringDiffFilter(this.getExportColumnName(1), null, 1));
        int nbCol = this.getColumnCount();
        for (int i = 2; i < nbCol; ++i) {
            filtersMap.put(i, (Filter)new IntegerFilter(this.getColumnName(i), null, i));
        }
    }

    public boolean isLoaded() {
        return true;
    }

    public int getLoadingPercentage() {
        return 100;
    }

    public PlotType getBestPlotType() {
        return null;
    }

    public int[] getBestColIndex(PlotType plotType) {
        return null;
    }

    public List<Integer> getDefaultColumnsToHide() {
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        listIds.add(0);
        return listIds;
    }

    public String getExportRowCell(int row, int col) {
        return ExportModelUtilities.getExportRowCell((ExtendedTableModelInterface)this, (int)row, (int)col);
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    public String getExportColumnName(int col) {
        if (col <= 1) {
            return m_columnNames[col];
        }
        if (this.m_masterQuantPeptideIonList == null) {
            return "";
        }
        return this.m_quantChannelInfoParent.getQuantChannels()[col -= 2].getName();
    }
}

