/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.tree.xic;

import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.NbPreferences;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.parameter.BooleanParameter;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.xic.AbstractTreeTransferHandler;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalGroupNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalSampleAnalysisNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalSampleNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICSelectionTransferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XICTransferHandler
extends AbstractTreeTransferHandler {
    private Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private ParameterList m_parameterList;
    private BooleanParameter m_parameter;
    private static final String GENERAL_APPLICATION_SETTINGS = "General Application Settings";
    private AbstractTree m_tree;
    private boolean m_restrictToDnDToItself;

    public XICTransferHandler(boolean isSelectionTree, AbstractTree tree) {
        this(isSelectionTree, tree, false);
    }

    public XICTransferHandler(boolean isSelectionTree, AbstractTree tree, boolean restrictToDnDToItself) {
        super(isSelectionTree, tree.getId());
        this.m_tree = tree;
        this.m_restrictToDnDToItself = restrictToDnDToItself;
        this.m_parameterList = new ParameterList(GENERAL_APPLICATION_SETTINGS);
        JCheckBox checkBox = new JCheckBox("Use dataset type to create Xic Design by DnD");
        this.m_parameter = new BooleanParameter("XIC_Transfer_Handler_Retains_Structure", "XIC Transfer Handler Retains Structure", (JComponent)checkBox, Boolean.valueOf(true));
        this.m_parameterList.add((Object)this.m_parameter);
        this.m_parameterList.loadParameters(NbPreferences.root());
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!this.m_isIdentificationSelectionTree) {
            support.setShowDropLocation(true);
            if (support.isDataFlavorSupported(XICSelectionTransferable.RSMNodeList_FLAVOR)) {
                boolean designData;
                TreePath dropTreePath = ((JTree.DropLocation)support.getDropLocation()).getPath();
                if (dropTreePath == null) {
                    return false;
                }
                AbstractNode.NodeTypes designNodeType = null;
                try {
                    XICSelectionTransferable transfer = (XICSelectionTransferable)support.getTransferable().getTransferData(XICSelectionTransferable.RSMNodeList_FLAVOR);
                    XICSelectionTransferable.TransferData data = XICSelectionTransferable.getData(transfer.getTransferKey());
                    if (this.m_restrictToDnDToItself && data.getSourceId() != this.m_tree.getId()) {
                        return false;
                    }
                    designData = data.isDesignData();
                    if (designData) {
                        designNodeType = data.getDesignNodeType();
                    }
                }
                catch (UnsupportedFlavorException | IOException e) {
                    this.m_logger.error(this.getClass().getSimpleName() + " DnD error ", (Throwable)e);
                    return false;
                }
                Object dropComponent = dropTreePath.getLastPathComponent();
                if (designData) {
                    if (!(dropComponent instanceof AbstractNode)) {
                        return false;
                    }
                    AbstractNode.NodeTypes dropType = ((AbstractNode)dropComponent).getType();
                    switch (dropType) {
                        case DATA_SET: {
                            return designNodeType == AbstractNode.NodeTypes.BIOLOGICAL_GROUP;
                        }
                        case BIOLOGICAL_GROUP: {
                            return designNodeType == AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE;
                        }
                        case BIOLOGICAL_SAMPLE: {
                            return designNodeType == AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS;
                        }
                    }
                    return false;
                }
                if ((dropComponent instanceof XICBiologicalSampleNode || dropComponent instanceof DataSetNode || dropComponent instanceof XICBiologicalGroupNode) && !(dropComponent instanceof XICBiologicalSampleAnalysisNode)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (this.canImport(support)) {
            try {
                XICSelectionTransferable transfer = (XICSelectionTransferable)support.getTransferable().getTransferData(XICSelectionTransferable.RSMNodeList_FLAVOR);
                XICSelectionTransferable.TransferData data = XICSelectionTransferable.getData(transfer.getTransferKey());
                return this.importNodes(support, data);
            }
            catch (UnsupportedFlavorException | IOException e) {
                this.m_logger.error(this.getClass().getSimpleName() + " DnD error ", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private boolean importNodes(TransferHandler.TransferSupport support, XICSelectionTransferable.TransferData data) {
        block21: {
            DefaultTreeModel treeModel;
            AbstractNode dropRSMNode;
            int childIndex;
            block18: {
                String suffix;
                ArrayList<DataSetNode> datasetList;
                block19: {
                    block20: {
                        JTree.DropLocation location = (JTree.DropLocation)support.getDropLocation();
                        TreePath dropTreePath = location.getPath();
                        childIndex = location.getChildIndex();
                        dropRSMNode = (AbstractNode)dropTreePath.getLastPathComponent();
                        treeModel = (DefaultTreeModel)this.m_tree.getModel();
                        if (childIndex == -1) {
                            childIndex = dropRSMNode.getChildCount();
                        }
                        if ((datasetList = data.getDatasetList()) == null) break block18;
                        this.m_tree.expandNodeIfNeeded(dropRSMNode);
                        suffix = Integer.toString(dropRSMNode.getChildCount() + 1);
                        if (!datasetList.isEmpty()) {
                            DDataset parentNode = datasetList.get(0).getParentMergedDataset();
                            AbstractNode ancestorNode = datasetList.get(0).getLowestAncestor();
                            if (parentNode != null) {
                                int nb = datasetList.size();
                                boolean sameParent = true;
                                boolean sameAncestor = true;
                                for (int i = 1; i < nb; ++i) {
                                    AbstractNode a = datasetList.get(i).getLowestAncestor();
                                    DDataset p = datasetList.get(i).getParentMergedDataset();
                                    if (p != null && p.getId() != parentNode.getId()) {
                                        sameParent = false;
                                    }
                                    if (a != null && a == ancestorNode) continue;
                                    sameAncestor = false;
                                }
                                if (sameParent) {
                                    suffix = parentNode.getName();
                                } else if (sameAncestor) {
                                    suffix = ancestorNode.toString();
                                }
                            }
                        }
                        if (dropRSMNode instanceof DataSetNode) {
                            String groupName = "Group " + suffix;
                            XICBiologicalGroupNode biologicalGroupNode = new XICBiologicalGroupNode((AbstractData)DataSetData.createTemporaryAggregate((String)groupName));
                            treeModel.insertNodeInto(biologicalGroupNode, dropRSMNode, childIndex);
                            childIndex = 0;
                            dropRSMNode = biologicalGroupNode;
                            this.m_tree.expandNodeIfNeeded(dropRSMNode);
                        }
                        this.m_parameterList.loadParameters(NbPreferences.root());
                        boolean retainStructure = (Boolean)this.m_parameter.getObjectValue();
                        if (!retainStructure) break block19;
                        if (!(dropRSMNode instanceof XICBiologicalGroupNode)) break block20;
                        Hashtable samplesHashtable = new Hashtable();
                        LinkedHashSet<String> order = new LinkedHashSet<String>();
                        for (int i = 0; i < datasetList.size(); ++i) {
                            DataSetNode node = datasetList.get(i);
                            String currentParent = node.getParent() == null ? "null" : node.getParent().toString();
                            order.add(currentParent);
                            if (samplesHashtable.containsKey(currentParent)) {
                                ((ArrayList)samplesHashtable.get(currentParent)).add(node);
                                continue;
                            }
                            ArrayList<DataSetNode> newSample = new ArrayList<DataSetNode>();
                            newSample.add(node);
                            samplesHashtable.put(currentParent, newSample);
                        }
                        for (String key : order) {
                            ArrayList currentSampleList = (ArrayList)samplesHashtable.get(key);
                            suffix = key.contains("Identifications") ? String.valueOf(dropRSMNode.getChildCount() + 1) : key;
                            String sampleName = "Sample " + suffix;
                            XICBiologicalSampleNode biologicalSampleNode = new XICBiologicalSampleNode((AbstractData)DataSetData.createTemporaryAggregate((String)sampleName));
                            treeModel.insertNodeInto(biologicalSampleNode, dropRSMNode, childIndex);
                            childIndex = 0;
                            this.m_tree.expandNodeIfNeeded(biologicalSampleNode);
                            for (int i = 0; i < currentSampleList.size(); ++i) {
                                XICBiologicalSampleAnalysisNode sampleAnalysisNode = new XICBiologicalSampleAnalysisNode(((DataSetNode)currentSampleList.get(i)).getData());
                                treeModel.insertNodeInto(sampleAnalysisNode, biologicalSampleNode, childIndex);
                                ++childIndex;
                            }
                            childIndex -= currentSampleList.size() - 1;
                        }
                        break block21;
                    }
                    if (!(dropRSMNode instanceof XICBiologicalSampleNode)) break block21;
                    for (int i = 0; i < datasetList.size(); ++i) {
                        XICBiologicalSampleAnalysisNode sampleAnalysisNode = new XICBiologicalSampleAnalysisNode(datasetList.get(i).getData());
                        treeModel.insertNodeInto(sampleAnalysisNode, dropRSMNode, childIndex);
                        ++childIndex;
                    }
                    break block21;
                }
                if (dropRSMNode instanceof XICBiologicalGroupNode) {
                    String sampleName = "Sample " + suffix;
                    XICBiologicalSampleNode biologicalSampleNode = new XICBiologicalSampleNode((AbstractData)DataSetData.createTemporaryAggregate((String)sampleName));
                    treeModel.insertNodeInto(biologicalSampleNode, dropRSMNode, childIndex);
                    dropRSMNode = biologicalSampleNode;
                    childIndex = 0;
                    this.m_tree.expandNodeIfNeeded(dropRSMNode);
                }
                if (!(dropRSMNode instanceof XICBiologicalSampleNode)) break block21;
                int nbNodes = datasetList.size();
                for (int i = 0; i < nbNodes; ++i) {
                    DataSetNode node = datasetList.get(i);
                    XICBiologicalSampleAnalysisNode sampleAnalysisNode = new XICBiologicalSampleAnalysisNode(node.getData());
                    treeModel.insertNodeInto(sampleAnalysisNode, dropRSMNode, childIndex);
                    ++childIndex;
                }
                break block21;
            }
            ArrayList<AbstractNode> rsmList = data.getDesignList();
            int nbNodes = rsmList.size();
            for (int i = 0; i < nbNodes; ++i) {
                int indexChild;
                AbstractNode node = rsmList.get(i);
                if (dropRSMNode.isNodeChild(node) && (indexChild = dropRSMNode.getIndex(node)) < childIndex) {
                    --childIndex;
                }
                treeModel.removeNodeFromParent(node);
                treeModel.insertNodeInto(node, dropRSMNode, childIndex);
                ++childIndex;
            }
        }
        return true;
    }
}

