/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq;

import fr.profi.util.StringUtils;
import fr.proline.module.seq.DatabaseAccess;
import fr.proline.module.seq.dto.DBioSequence;
import fr.proline.module.seq.dto.DDatabankInstance;
import fr.proline.module.seq.dto.DDatabankProtein;
import fr.proline.module.seq.dto.DRepositoryProtein;
import fr.proline.module.seq.orm.Alphabet;
import fr.proline.module.seq.orm.BioSequence;
import fr.proline.module.seq.orm.Databank;
import fr.proline.module.seq.orm.DatabankInstance;
import fr.proline.module.seq.orm.DatabankProtein;
import fr.proline.module.seq.orm.Repository;
import fr.proline.module.seq.orm.RepositoryProtein;
import fr.proline.module.seq.orm.dao.DatabankProteinDao;
import fr.proline.repository.IDatabaseConnector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BioSequenceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BioSequenceProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, RelatedIdentifiers> findSEDbIdentRelatedData(Collection<String> proteinIdentifiers) {
        Map<String, RelatedIdentifiers> result = null;
        IDatabaseConnector seqDb = DatabaseAccess.getSEQDatabaseConnector(false);
        EntityManager seqEM = seqDb.createEntityManager();
        try {
            result = BioSequenceProvider.findMatchingProteins(seqEM, proteinIdentifiers, null);
        }
        finally {
            if (seqEM != null) {
                try {
                    seqEM.close();
                }
                catch (Exception exClose) {
                    LOG.error("Error closing SEQ Db EntityManager", (Throwable)exClose);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, RelatedIdentifiers> findSEDbIdentRelatedData(Collection<String> proteinIdentifiers, Map<DDatabankInstance, List<String>> proteinsAccByDatabankSubMap) {
        Map<String, RelatedIdentifiers> result = null;
        IDatabaseConnector seqDb = DatabaseAccess.getSEQDatabaseConnector(false);
        EntityManager seqEM = seqDb.createEntityManager();
        try {
            result = BioSequenceProvider.findMatchingProteins(seqEM, proteinIdentifiers, proteinsAccByDatabankSubMap);
        }
        finally {
            if (seqEM != null) {
                try {
                    seqEM.close();
                }
                catch (Exception exClose) {
                    LOG.error("Error closing SEQ Db EntityManager", (Throwable)exClose);
                }
            }
        }
        return result;
    }

    private static Map<String, RelatedIdentifiers> findMatchingProteins(EntityManager seqEM, Collection<String> proteinsIdentifiers, Map<DDatabankInstance, List<String>> proteinsAccByDatabankSubMap) {
        HashMap<String, RelatedIdentifiers> result = new HashMap<String, RelatedIdentifiers>();
        if (proteinsIdentifiers.isEmpty()) {
            return result;
        }
        List<Object> foundProteins = new ArrayList();
        ArrayList<String> notFoundProteins = new ArrayList<String>();
        if (proteinsAccByDatabankSubMap == null) {
            foundProteins = DatabankProteinDao.findProteins(seqEM, proteinsIdentifiers);
        } else {
            List<DatabankProtein> currentFoundProts;
            notFoundProteins.addAll(proteinsIdentifiers);
            for (DDatabankInstance dDatabankInstance : proteinsAccByDatabankSubMap.keySet()) {
                if (StringUtils.isEmpty((String)dDatabankInstance.getRelease()) || notFoundProteins.isEmpty()) continue;
                currentFoundProts = DatabankProteinDao.findProteinsInDatabankNameAndRelease(seqEM, dDatabankInstance.getName(), dDatabankInstance.getRelease(), notFoundProteins);
                foundProteins.addAll(currentFoundProts);
                for (DatabankProtein nextProt : currentFoundProts) {
                    notFoundProteins.remove(nextProt.getIdentifier());
                }
            }
            for (DDatabankInstance dDatabankInstance : proteinsAccByDatabankSubMap.keySet()) {
                if (notFoundProteins.isEmpty()) continue;
                currentFoundProts = DatabankProteinDao.findProteinsInDatabankName(seqEM, dDatabankInstance.getName(), notFoundProteins);
                for (DatabankProtein dbProt : currentFoundProts) {
                    String seqDBFastaname = dDatabankInstance.getSourcePath().replace("\\", "/");
                    int lastIndex = seqDBFastaname.lastIndexOf(47);
                    seqDBFastaname = seqDBFastaname.substring(lastIndex + 1, seqDBFastaname.length());
                    String dbProtFastaname = dbProt.getDatabankInstance().getSourcePath().replace("\\", "/");
                    lastIndex = dbProtFastaname.lastIndexOf(47);
                    if (!seqDBFastaname.equals(dbProtFastaname = dbProtFastaname.substring(lastIndex + 1, dbProtFastaname.length()))) continue;
                    foundProteins.add(dbProt);
                    notFoundProteins.remove(dbProt.getIdentifier());
                }
            }
            if (!notFoundProteins.isEmpty()) {
                List<DatabankProtein> currentFoundProts2 = DatabankProteinDao.findProteins(seqEM, notFoundProteins);
                foundProteins.addAll(currentFoundProts2);
                if (currentFoundProts2.size() < notFoundProteins.size()) {
                    LOG.debug(" {} proteins were not found in sequence database ", (Object)(notFoundProteins.size() - currentFoundProts2.size()));
                    if (LOG.isTraceEnabled()) {
                        for (DatabankProtein dbProt : currentFoundProts2) {
                            notFoundProteins.remove(dbProt.getIdentifier());
                        }
                        LOG.trace(" Not found proteins: " + ((Object)notFoundProteins).toString());
                    }
                }
            }
        }
        if (foundProteins != null && !foundProteins.isEmpty()) {
            for (DatabankProtein databankProtein : foundProteins) {
                String key = databankProtein.getIdentifier();
                if (key == null || key.isEmpty()) continue;
                String description = databankProtein.getDescription();
                RelatedIdentifiers relatedIdentifiers = (RelatedIdentifiers)result.get(key);
                if (relatedIdentifiers == null) {
                    relatedIdentifiers = new RelatedIdentifiers();
                    result.put(key, relatedIdentifiers);
                }
                relatedIdentifiers.getDBioSequences().add(BioSequenceProvider.buildDBioSequence(databankProtein));
                relatedIdentifiers.getDDatabankProteins().add(new DDatabankProtein(key, description));
            }
        }
        return result;
    }

    private static DBioSequence buildDBioSequence(DatabankProtein protein) {
        assert (protein != null) : "buildDBioSequence() protein is null";
        BioSequence bioSequence = protein.getBioSequence();
        long sequenceId = bioSequence.getId();
        String sequence = bioSequence.getSequence();
        DatabankInstance seDbInstance = protein.getDatabankInstance();
        String seDbRelease = seDbInstance.getRelease();
        String sourcePath = seDbInstance.getSourcePath();
        Databank seDb = seDbInstance.getDatabank();
        String seDbName = seDb.getName();
        Alphabet alphabet = seDb.getAlphabet();
        DDatabankInstance seDbInstanceW = new DDatabankInstance(seDbName, alphabet, sourcePath);
        DRepositoryProtein repositoryIdentValue = null;
        RepositoryProtein repositoryIdent = protein.getRepositoryIdentifier();
        if (repositoryIdent != null) {
            repositoryIdentValue = BioSequenceProvider.buildDRepositoryProtein(repositoryIdent);
        }
        return new DBioSequence(sequenceId, sequence, seDbInstanceW, seDbRelease, repositoryIdentValue);
    }

    private static DRepositoryProtein buildDRepositoryProtein(RepositoryProtein repositoryIdent) {
        assert (repositoryIdent != null) : "buildDRepositoryProtein() repositoryIdent is null";
        Repository repository = repositoryIdent.getRepository();
        String repositoryName = repository.getName();
        String repositoryURL = repository.getURL();
        String repositoryIdentValue = repositoryIdent.getValue();
        return new DRepositoryProtein(repositoryName, repositoryURL, repositoryIdentValue);
    }

    public static class RelatedIdentifiers {
        List<DBioSequence> bioSequences = new ArrayList<DBioSequence>();
        List<DDatabankProtein> proteins = new ArrayList<DDatabankProtein>();

        public List<DBioSequence> getDBioSequences() {
            return this.bioSequences;
        }

        public List<DDatabankProtein> getDDatabankProteins() {
            return this.proteins;
        }
    }
}

