/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq.service;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.profi.chemistry.algo.DigestionUtils;
import fr.profi.util.StringUtils;
import fr.proline.core.orm.msi.Alphabet;
import fr.proline.core.orm.msi.BioSequence;
import fr.proline.core.orm.msi.Enzyme;
import fr.proline.core.orm.msi.MsiSearch;
import fr.proline.core.orm.msi.ProteinMatch;
import fr.proline.core.orm.msi.ProteinSet;
import fr.proline.core.orm.msi.ProteinSetProteinMatchItem;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.SeqDatabase;
import fr.proline.core.orm.msi.repository.ResultSetRepository;
import fr.proline.core.orm.uds.EnzymeCleavage;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.repository.ProjectRepository;
import fr.proline.module.seq.BioSequenceProvider;
import fr.proline.module.seq.DatabaseAccess;
import fr.proline.module.seq.dto.DBioSequence;
import fr.proline.module.seq.dto.DDatabankInstance;
import fr.proline.module.seq.dto.DDatabankProtein;
import fr.proline.module.seq.service.SequenceMatchInfo;
import fr.proline.module.seq.util.HashUtil;
import fr.proline.module.seq.util.RegExUtil;
import fr.proline.repository.IDataStoreConnectorFactory;
import fr.proline.repository.IDatabaseConnector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Some;

public class ProjectHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectHandler.class);
    private static final String ALL_SEQ_DB_QUERY = "FROM fr.proline.core.orm.msi.SeqDatabase";
    private static final String VALIDATED_PM_COUNT_FOR_RSMS_QUERY = "SELECT COUNT (DISTINCT pm.accession) FROM fr.proline.core.orm.msi.ProteinMatch pm JOIN pm.proteinSetProteinMatchItems ps WHERE ((upper(pm.resultSet.type) = 'SEARCH') OR (upper(pm.resultSet.type) = 'USER') OR (upper(pm.resultSet.type) = 'QUANTITATION')) AND (ps.proteinSet.isValidated = true) AND (ps.proteinSet.resultSummary.id IN (:rsm_ids) )";
    private static final String VALIDATED_PM_SDM_FOR_RSMS_QUERY = "SELECT DISTINCT pm.accession, pm.description, sdb.id FROM fr.proline.core.orm.msi.ProteinMatch pm, fr.proline.core.orm.msi.SeqDatabase sdb, fr.proline.core.orm.msi.ProteinMatchSeqDatabaseMap pmsdb JOIN pm.proteinSetProteinMatchItems ps WHERE (pmsdb.id.proteinMatchId = pm.id) AND (pmsdb.id.seqDatabaseId = sdb.id) AND ((upper(pm.resultSet.type) = 'SEARCH') OR (upper(pm.resultSet.type) = 'USER') OR (upper(pm.resultSet.type) = 'QUANTITATION')) AND (ps.proteinSet.isValidated = true) AND (ps.proteinSet.resultSummary.id IN  (:rsm_ids))";
    private static final String VALIDATED_PM_FOR_RSMS_QUERY = "SELECT DISTINCT pm.accession, pm.description, ssdm.seqDatabase.id FROM fr.proline.core.orm.msi.ProteinMatch pm, fr.proline.core.orm.msi.SearchSettingsSeqDatabaseMap ssdm JOIN pm.proteinSetProteinMatchItems ps WHERE (pm.resultSet.msiSearch.searchSetting = ssdm.searchSetting) AND ((upper(pm.resultSet.type) = 'SEARCH') OR (upper(pm.resultSet.type) = 'USER') OR (upper(pm.resultSet.type) = 'QUANTITATION')) AND (ps.proteinSet.isValidated = true) AND (ps.proteinSet.resultSummary.id IN  (:rsm_ids))";
    private static final String LIST_RSM_IN_DATASET_ID_QUERY = "SELECT DISTINCT(dt.resultSummaryId) FROM Dataset dt WHERE dt.project.id= :projectId AND dt.type IN ('AGGREGATE','IDENTIFICATION') AND dt.resultSummaryId IS NOT NULL";
    private static final String LIST_QUANT_RSM_ID_QUERY = "SELECT DISTINCT(mqc.quantResultSummaryId) FROM MasterQuantitationChannel mqc, Dataset dt WHERE dt.project.id= :projectId AND mqc.quantDataset.id = dt.id and dt.type IN ('QUANTITATION') AND mqc.quantResultSummaryId IS NOT NULL";
    private static final String LIST_PS_FOR_RSM_QUERY = "SELECT ps FROM ProteinSet ps WHERE ps.resultSummary.id= :rsmId AND ps.isValidated = 'true'";
    private static final int EXPECTED_LINE_LENGTH = 3;
    private static final String GET_PEPID_BY_PSID_PM_QUERY = "SELECT pi.peptide.id, ps.id FROM fr.proline.core.orm.msi.PeptideInstance pi, fr.proline.core.orm.msi.PeptideSetPeptideInstanceItem  pspi,  fr.proline.core.orm.msi.ProteinSet ps  WHERE  pspi.resultSummary.id = :rsmId  AND pspi.peptideInstance= pi  AND ps.resultSummary.id = :rsmId AND ps.isValidated=true AND pspi.peptideSet.proteinSet = ps";
    private static final String GET_SEQ_MATCH_INFO_FOR_RS_QUERY = "SELECT sm.id.start, sm.id.stop, sm.id.proteinMatchId, sm.id.peptideId FROM SequenceMatch sm WHERE sm.resultSetId = :rsId";
    private final Long projectId;
    private EntityManager msiEM;
    private EntityManager udsEM;
    private int nbrNoSeqProt;
    private int nbrManySeqProt;
    private int nbrBioSeqMissMatch;

    public ProjectHandler(Long projectId) {
        this.projectId = projectId;
        this.open();
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void open() {
        IDataStoreConnectorFactory connectorFactory = DatabaseAccess.getDataStoreConnectorFactory();
        IDatabaseConnector udsDbConnector = connectorFactory.getUdsDbConnector();
        IDatabaseConnector msiDbConnector = connectorFactory.getMsiDbConnector(this.projectId.longValue());
        if (msiDbConnector == null) {
            LOG.error("Project #{} has NO associated MSI Db", (Object)this.projectId);
        } else {
            this.msiEM = msiDbConnector.createEntityManager();
            this.udsEM = udsDbConnector.createEntityManager();
        }
    }

    public void close() {
        LOG.debug("Closing ProjectHandler EntityManagers of Project #{}", (Object)this.projectId);
        this.close(this.msiEM);
        this.close(this.udsEM);
    }

    private void close(EntityManager em) {
        if (em != null) {
            try {
                em.close();
            }
            catch (Exception exClose) {
                LOG.error("Error closing EntityManager", (Throwable)exClose);
            }
        }
    }

    public void findProteinIdentifiers(Map<DDatabankInstance, Set<DDatabankProtein>> proteinsByDatabank, Map<Long, DDatabankInstance> databankBySeqDatabase, List<Long> rsmIds) {
        assert (databankBySeqDatabase != null) : "databankBySeqDatabase Map is null";
        assert (proteinsByDatabank != null) : "proteinsByDatabank Map is null";
        long start = System.currentTimeMillis();
        if (rsmIds.size() > 0) {
            LOG.info("Quering ProteinMatches for {} RSM(s) of Project #{} ", (Object)rsmIds.size(), (Object)this.projectId);
            long expectedProteinsCount = -1L;
            Query countQuery = this.msiEM.createQuery(VALIDATED_PM_COUNT_FOR_RSMS_QUERY);
            countQuery.setParameter("rsm_ids", rsmIds);
            Object obj = countQuery.getSingleResult();
            if (obj instanceof Number) {
                expectedProteinsCount = ((Number)obj).longValue();
            }
            LOG.info("{} Databank Instance(s) found in Project #{} ", (Object)databankBySeqDatabase.size(), (Object)this.projectId);
            LOG.info("{} Protein Identifiers expected in Project #{} ", (Object)expectedProteinsCount, (Object)this.projectId);
            if (expectedProteinsCount > 0L) {
                int nSEDbIdentifiers = 0;
                Query query = this.msiEM.createQuery(VALIDATED_PM_SDM_FOR_RSMS_QUERY).setParameter("rsm_ids", rsmIds);
                nSEDbIdentifiers = ProjectHandler.createProteinIdentifiersFromQuery(query, databankBySeqDatabase, proteinsByDatabank);
                if ((long)nSEDbIdentifiers >= expectedProteinsCount) {
                    LOG.debug("{} distinct (Protein Identifier, Description, Databank) retrieved via protein_match_Seq_database_map table", (Object)nSEDbIdentifiers);
                } else {
                    Query pmQuery = this.msiEM.createQuery(VALIDATED_PM_FOR_RSMS_QUERY).setParameter("rsm_ids", rsmIds);
                    nSEDbIdentifiers = ProjectHandler.createProteinIdentifiersFromQuery(query, databankBySeqDatabase, proteinsByDatabank);
                    LOG.debug("{} distinct (Protein Identifier, Description, Databank) WITHOUT protein_match_Seq_database_map table", (Object)nSEDbIdentifiers);
                }
            } else {
                LOG.warn("There is NO new validated Accession in MSI Project #{}", (Object)this.projectId);
            }
        }
        long end = System.currentTimeMillis();
        long duration = end - start;
        LOG.info("findProteinIdentifiers() execution for {} RSM(s) : {} ms ", (Object)rsmIds.size(), (Object)duration);
    }

    public List<Long> findAllRSMIds() {
        Query udsQuery = this.udsEM.createQuery(LIST_RSM_IN_DATASET_ID_QUERY);
        udsQuery.setParameter("projectId", (Object)this.projectId);
        List rsmIds = udsQuery.getResultList();
        Query udsQuantQuery = this.udsEM.createQuery(LIST_QUANT_RSM_ID_QUERY);
        udsQuantQuery.setParameter("projectId", (Object)this.projectId);
        rsmIds.addAll(udsQuantQuery.getResultList());
        return rsmIds;
    }

    public List<Long> filterRSMIdsToUpdate(List<Long> rsmIdsToTest, boolean forceUpdate) {
        ArrayList<Long> rsmIdsToFill = new ArrayList();
        if (forceUpdate) {
            rsmIdsToFill = rsmIdsToTest;
        } else {
            for (Long rsmId : rsmIdsToTest) {
                ResultSummary rsm = (ResultSummary)this.msiEM.find(ResultSummary.class, (Object)rsmId);
                if (rsm == null) {
                    LOG.warn("Unable to get Identification Summary with ID " + rsmId);
                    continue;
                }
                JsonObject array = ProjectHandler.getPropertiesAsJsonObject(rsm.getSerializedProperties());
                if (array.has("is_coverage_updated")) continue;
                rsmIdsToFill.add(rsmId);
            }
        }
        return rsmIdsToFill;
    }

    private static JsonObject getPropertiesAsJsonObject(String properties) {
        JsonParser parser = new JsonParser();
        JsonObject array = null;
        if (properties == null || properties.isEmpty()) {
            properties = "{}";
        }
        try {
            array = parser.parse(properties).getAsJsonObject();
        }
        catch (Exception e) {
            LOG.error("error accessing properties");
            throw e;
        }
        return array;
    }

    public Boolean isProjectActive() {
        Project p = (Project)this.udsEM.find(Project.class, (Object)this.projectId);
        JsonObject propAsJson = ProjectHandler.getPropertiesAsJsonObject(p.getSerializedProperties());
        return !propAsJson.has("is_active") || propAsJson.get("is_active").getAsBoolean();
    }

    static List<Long> retrieveAllActiveProjectIds() {
        IDataStoreConnectorFactory connectorFactory = DatabaseAccess.getDataStoreConnectorFactory();
        IDatabaseConnector udsDbConnector = connectorFactory.getUdsDbConnector();
        EntityManager udsEM = udsDbConnector.createEntityManager();
        List projectIds = ProjectRepository.findAllActiveProjectIds((EntityManager)udsEM);
        return projectIds;
    }

    public Map<Long, DDatabankInstance> retrieveAllSeqDatabases() {
        HashMap<Long, DDatabankInstance> result = null;
        TypedQuery seqDbQuery = this.msiEM.createQuery(ALL_SEQ_DB_QUERY, SeqDatabase.class);
        List seqDbs = seqDbQuery.getResultList();
        if (seqDbs != null && !seqDbs.isEmpty()) {
            result = new HashMap<Long, DDatabankInstance>();
            for (SeqDatabase seqDb : seqDbs) {
                long seqDbId = seqDb.getId();
                String name = seqDb.getName();
                if (name == null) {
                    LOG.error("SeqDb #{} name is null", (Object)seqDbId);
                    continue;
                }
                String trimmedName = name.trim();
                if (trimmedName.isEmpty()) {
                    LOG.error("SeqDb #{} name is empty", (Object)seqDbId);
                    continue;
                }
                String fastaFilePath = seqDb.getFastaFilePath();
                String version = seqDb.getVersion();
                if (StringUtils.isEmpty((String)fastaFilePath)) {
                    LOG.error("SeqDb #{} fastaFilePath is empty", (Object)seqDbId);
                    continue;
                }
                DDatabankInstance databankInstance = new DDatabankInstance(trimmedName, null, fastaFilePath);
                databankInstance.setRelease(version);
                result.put(seqDbId, databankInstance);
            }
        }
        return result;
    }

    private static int createProteinIdentifiersFromQuery(Query query, Map<Long, DDatabankInstance> databankBySeqDatabase, Map<DDatabankInstance, Set<DDatabankProtein>> proteinsByDatabank) {
        assert (databankBySeqDatabase != null) : "findProteinIdentifiers() databaseInstances Map is null";
        assert (proteinsByDatabank != null) : "findProteinIdentifiers() proteinIDsByDatabaseInstance Map is null";
        List lines = query.getResultList();
        int nIdentifiers = 0;
        if (lines != null && !lines.isEmpty()) {
            for (Object[] line : lines) {
                int lineLength = line.length;
                if (lineLength >= 3) {
                    DDatabankProtein protein;
                    boolean added;
                    String proteinId = null;
                    String description = null;
                    Long seqDbId = null;
                    if (line[0] instanceof String) {
                        proteinId = ((String)line[0]).trim();
                    }
                    if (line[1] instanceof String) {
                        description = ((String)line[1]).trim();
                    }
                    if (line[2] instanceof Long) {
                        seqDbId = (Long)line[2];
                    }
                    if (StringUtils.isEmpty((String)proteinId)) {
                        LOG.error("Invalid DatabankProtein value : {}", line[0]);
                        continue;
                    }
                    DDatabankInstance databaseInstance = databankBySeqDatabase.get(seqDbId);
                    if (databaseInstance == null) {
                        LOG.error("Unknown SeqDatabase id : {}", line[2]);
                        continue;
                    }
                    Set<DDatabankProtein> proteins = proteinsByDatabank.get(databaseInstance);
                    if (proteins == null) {
                        proteins = new HashSet<DDatabankProtein>();
                        proteinsByDatabank.put(databaseInstance, proteins);
                    }
                    if (!(added = proteins.add(protein = new DDatabankProtein(proteinId, description)))) continue;
                    ++nIdentifiers;
                    continue;
                }
                LOG.error("Invalid result line length {} (expected : {})", (Object)lineLength, (Object)3);
            }
        }
        return nIdentifiers;
    }

    public void fillProteinMatchesProperties(Map<Long, DDatabankInstance> databankBySeqDatabase, Map<DDatabankInstance, Set<DDatabankProtein>> proteinsByDatabank, List<Long> rsmIds) {
        HashMap<ProteinMatch, Integer> coveredSeqLengthByProtMatchList = new HashMap<ProteinMatch, Integer>();
        boolean msiTransactionOK = false;
        try {
            long startAll = System.currentTimeMillis();
            LOG.info("Quering ProteinMatches for {} RSM(s) of Project #{} ", (Object)rsmIds.size(), (Object)this.projectId);
            LOG.info("Filling ProteinMatches properties for {} RSM(s) of Project #{}", (Object)rsmIds.size(), (Object)this.projectId);
            if (databankBySeqDatabase == null || databankBySeqDatabase.isEmpty()) {
                LOG.warn("There is NO DatabankInstance in MSI Project #{}", (Object)this.projectId);
                msiTransactionOK = true;
            } else {
                LOG.info("Update SeqDatabase release properties for Project #{}. ", (Object)this.projectId);
                this.updateMSISeqDbRelease(databankBySeqDatabase);
                HashMap<String, List> seqDatabankByDbProtMatchIdentifier = new HashMap<String, List>();
                for (Map.Entry<DDatabankInstance, Set<DDatabankProtein>> e : proteinsByDatabank.entrySet()) {
                    for (DDatabankProtein dbProt : e.getValue()) {
                        List seqDbs = seqDatabankByDbProtMatchIdentifier.getOrDefault(dbProt.getIdentifier(), new ArrayList());
                        seqDbs.add(e.getKey());
                        seqDatabankByDbProtMatchIdentifier.put(dbProt.getIdentifier(), seqDbs);
                    }
                }
                for (Long rsmId : rsmIds) {
                    long start = System.currentTimeMillis();
                    msiTransactionOK = false;
                    this.msiEM.getTransaction().begin();
                    int psIdcount = 0;
                    LOG.debug("Start processing protein sets from RSM Id:" + rsmId);
                    ResultSummary rsm = (ResultSummary)this.msiEM.find(ResultSummary.class, (Object)rsmId);
                    if (rsm == null) {
                        LOG.warn("Referenced ReultSummary " + rsmId + " was not found in Project !");
                        msiTransactionOK = true;
                        this.msiEM.getTransaction().rollback();
                        this.msiEM.clear();
                        continue;
                    }
                    HashMap<Long, List<SequenceMatchInfo>> seqMatchesInfoByProteinMatchId = new HashMap<Long, List<SequenceMatchInfo>>();
                    Query getSeqMatchInfoQuery = this.msiEM.createQuery(GET_SEQ_MATCH_INFO_FOR_RS_QUERY);
                    getSeqMatchInfoQuery.setParameter("rsId", (Object)rsm.getResultSet().getId());
                    List resultSeqMatches = getSeqMatchInfoQuery.getResultList();
                    for (Object[] nextEntry : resultSeqMatches) {
                        int seqMatchStart = (Integer)nextEntry[0];
                        int seqMatchStop = (Integer)nextEntry[1];
                        Long proteinMatchId = (Long)nextEntry[2];
                        Long peptideId = (Long)nextEntry[3];
                        if (!seqMatchesInfoByProteinMatchId.containsKey(proteinMatchId)) {
                            seqMatchesInfoByProteinMatchId.put(proteinMatchId, new ArrayList());
                        }
                        ((List)seqMatchesInfoByProteinMatchId.get(proteinMatchId)).add(new SequenceMatchInfo(seqMatchStart, seqMatchStop, peptideId));
                    }
                    Query psQuery = this.msiEM.createQuery(LIST_PS_FOR_RSM_QUERY);
                    psQuery.setParameter("rsmId", (Object)rsmId);
                    List proteinSets = psQuery.getResultList();
                    int psIdListSize = proteinSets.size();
                    HashMap pepIdsByProtSetId = new HashMap();
                    Query getPepIdQuery = this.msiEM.createQuery(GET_PEPID_BY_PSID_PM_QUERY);
                    getPepIdQuery.setParameter("rsmId", (Object)rsmId);
                    List resultPepInsts = getPepIdQuery.getResultList();
                    for (Object[] nextEntry : resultPepInsts) {
                        Long pepId = (Long)nextEntry[0];
                        Long psId = (Long)nextEntry[1];
                        if (!pepIdsByProtSetId.containsKey(psId)) {
                            pepIdsByProtSetId.put(psId, new ArrayList());
                        }
                        ((List)pepIdsByProtSetId.get(psId)).add(pepId);
                    }
                    fr.profi.chemistry.model.Enzyme enzyme = null;
                    MsiSearch msiSearch = rsm.getResultSet().getMsiSearch();
                    Set sameEnzymes = null;
                    boolean isSameEnzyme = true;
                    if (msiSearch == null) {
                        List childSearchesIds = ResultSetRepository.findChildMsiSearchIdsForResultSet((EntityManager)this.msiEM, (Long)rsm.getResultSet().getId());
                        for (Object childMsiSearchId : childSearchesIds) {
                            MsiSearch childMsiSearch = (MsiSearch)this.msiEM.find(MsiSearch.class, childMsiSearchId);
                            Set enzymes = childMsiSearch.getSearchSetting().getEnzymes();
                            if (sameEnzymes == null) {
                                sameEnzymes = enzymes;
                            }
                            if (sameEnzymes.equals(enzymes)) continue;
                            isSameEnzyme = false;
                            break;
                        }
                    } else {
                        sameEnzymes = msiSearch.getSearchSetting().getEnzymes();
                    }
                    if (!isSameEnzyme) {
                        LOG.warn("Can't get Enzyme for Merged ResultSet as child don't have the same Enzyme ! ");
                    } else if (sameEnzymes != null && !sameEnzymes.isEmpty()) {
                        Object childMsiSearchId;
                        fr.proline.core.orm.uds.Enzyme ormEnzyme = (fr.proline.core.orm.uds.Enzyme)this.udsEM.find(fr.proline.core.orm.uds.Enzyme.class, (Object)((Enzyme)sameEnzymes.iterator().next()).getId());
                        ArrayList<fr.profi.chemistry.model.EnzymeCleavage> cleavages = new ArrayList<fr.profi.chemistry.model.EnzymeCleavage>();
                        childMsiSearchId = ormEnzyme.getCleavages().iterator();
                        while (childMsiSearchId.hasNext()) {
                            EnzymeCleavage c = (EnzymeCleavage)childMsiSearchId.next();
                            cleavages.add(new fr.profi.chemistry.model.EnzymeCleavage(c.getId(), c.getSite(), c.getResidues(), (Option)(c.getRestrictiveResidues() == null ? Option.empty() : new Some((Object)c.getRestrictiveResidues()))));
                        }
                        enzyme = new fr.profi.chemistry.model.Enzyme(ormEnzyme.getId(), ormEnzyme.getName(), cleavages.toArray(new fr.profi.chemistry.model.EnzymeCleavage[0]), (Option)new Some((Object)ormEnzyme.getCleavageRegexp()), false, false, Option.empty());
                    }
                    this.nbrNoSeqProt = 0;
                    this.nbrManySeqProt = 0;
                    this.nbrBioSeqMissMatch = 0;
                    for (ProteinSet protSet : proteinSets) {
                        coveredSeqLengthByProtMatchList.clear();
                        HashMap<ProteinMatch, ProteinSetProteinMatchItem> protSetMapByProtMatch = new HashMap<ProteinMatch, ProteinSetProteinMatchItem>();
                        ArrayList<String> allProtMatchesAccession = new ArrayList<String>();
                        HashMap<DDatabankInstance, List<String>> proteinsAccByDatabankSubMap = new HashMap<DDatabankInstance, List<String>>();
                        for (ProteinSetProteinMatchItem protSet2ProtMatch : protSet.getProteinSetProteinMatchItems()) {
                            ProteinMatch currentProtMatch = protSet2ProtMatch.getProteinMatch();
                            allProtMatchesAccession.add(currentProtMatch.getAccession());
                            List seqDbInsts = (List)seqDatabankByDbProtMatchIdentifier.get(currentProtMatch.getAccession());
                            for (DDatabankInstance seqDbInst : seqDbInsts) {
                                List prots = proteinsAccByDatabankSubMap.getOrDefault(seqDbInst, new ArrayList());
                                prots.add(currentProtMatch.getAccession());
                                proteinsAccByDatabankSubMap.put(seqDbInst, prots);
                            }
                            protSetMapByProtMatch.put(currentProtMatch, protSet2ProtMatch);
                            coveredSeqLengthByProtMatchList.put(currentProtMatch, ProjectHandler.computeSequenceCoverage(seqMatchesInfoByProteinMatchId, currentProtMatch, (List)pepIdsByProtSetId.get(protSet.getId())));
                        }
                        Map<String, BioSequenceProvider.RelatedIdentifiers> protMatchesObjResult = BioSequenceProvider.findSEDbIdentRelatedData(allProtMatchesAccession, proteinsAccByDatabankSubMap);
                        this.updateProteinMatchesProperties(coveredSeqLengthByProtMatchList, enzyme, protSetMapByProtMatch, protMatchesObjResult);
                        if (psIdcount % 500 == 0) {
                            LOG.info("Processed " + psIdcount + " protein sets / " + psIdListSize);
                        }
                        ++psIdcount;
                    }
                    LOG.info("Processed " + psIdcount + " protein sets / " + psIdListSize);
                    LOG.debug("--- Number of proteins with MORE THAN 1 Sequence : {}", (Object)this.nbrManySeqProt);
                    LOG.debug("--- Number of proteins with NO Sequence : {}", (Object)this.nbrNoSeqProt);
                    LOG.debug("--- Number of proteins with miss matched BioSequence : {}", (Object)this.nbrBioSeqMissMatch);
                    JsonObject array = ProjectHandler.getPropertiesAsJsonObject(rsm.getSerializedProperties());
                    if (!array.has("is_coverage_updated")) {
                        LOG.debug(" Saving coverage_updated property for rsm {}.", (Object)rsmId);
                        array.addProperty("is_coverage_updated", Boolean.valueOf(true));
                        rsm.setSerializedProperties(array.toString());
                        this.msiEM.merge((Object)rsm);
                    }
                    this.msiEM.getTransaction().commit();
                    msiTransactionOK = true;
                    this.msiEM.clear();
                    long end = System.currentTimeMillis();
                    long duration = end - start;
                    LOG.info("RSM Id #{} successfully processed. Duration : {} ms for {} protein sets ", new Object[]{rsmId, duration, psIdcount});
                }
                msiTransactionOK = true;
            }
            long duration = System.currentTimeMillis() - startAll;
            LOG.info("Total: fillProteinMatchesProperties() execution : {} ms for project #{} ", (Object)duration, (Object)this.projectId);
        }
        catch (Exception ex) {
            LOG.error("Error accessing MSI Db Project #" + this.projectId, (Throwable)ex);
            try {
                if (!msiTransactionOK) {
                    this.msiEM.getTransaction().rollback();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.error("Error RollingBack MSI Db Project #" + this.projectId, (Throwable)e);
            }
            throw ex;
        }
    }

    private void updateMSISeqDbRelease(Map<Long, DDatabankInstance> databankBySeqDatabase) {
        boolean msiTransactionOK = false;
        try {
            this.msiEM.getTransaction().begin();
            for (Long seqDbId : databankBySeqDatabase.keySet()) {
                DDatabankInstance databank = databankBySeqDatabase.get(seqDbId);
                if (databank.getRelease() == null) continue;
                SeqDatabase msiSeqDb = (SeqDatabase)this.msiEM.find(SeqDatabase.class, (Object)seqDbId);
                msiSeqDb.setVersion(databank.getRelease());
                this.msiEM.merge((Object)msiSeqDb);
            }
            this.msiEM.getTransaction().commit();
            msiTransactionOK = true;
        }
        catch (Exception ex) {
            LOG.error("Error saving SeqDatabase Release", (Throwable)ex);
            try {
                if (!msiTransactionOK) {
                    this.msiEM.getTransaction().rollback();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.error("Error saving SeqDatabase Release", (Throwable)e);
            }
            throw ex;
        }
    }

    private void updateProteinMatchesProperties(Map<ProteinMatch, Integer> coveredSeqLengthByProtMatchList, fr.profi.chemistry.model.Enzyme enzyme, Map<ProteinMatch, ProteinSetProteinMatchItem> protSetMapByProtMatch, Map<String, BioSequenceProvider.RelatedIdentifiers> seDbIdentsObjects) {
        for (Map.Entry<ProteinMatch, Integer> entry : coveredSeqLengthByProtMatchList.entrySet()) {
            String geneName;
            ProteinMatch protMatch = entry.getKey();
            boolean protMatch2Update = false;
            String protDescription = protMatch.getDescription();
            int coveredSequenceLength = entry.getValue();
            BioSequenceProvider.RelatedIdentifiers seDbIdents = seDbIdentsObjects.get(protMatch.getAccession());
            int entryIndex = -1;
            if (seDbIdents != null) {
                List<DDatabankProtein> sedbIdentifiers = seDbIdents.getDDatabankProteins();
                if (!StringUtils.isEmpty((String)protDescription)) {
                    if (sedbIdentifiers.size() >= 1) {
                        for (int index = 0; index < sedbIdentifiers.size(); ++index) {
                            DDatabankProtein nextProt = sedbIdentifiers.get(index);
                            if (nextProt.getDescription() == null || !nextProt.getDescription().equals(protDescription)) continue;
                            entryIndex = index;
                            break;
                        }
                    } else {
                        entryIndex = 0;
                    }
                } else if (sedbIdentifiers.size() >= 1) {
                    for (int index = 0; index < sedbIdentifiers.size(); ++index) {
                        DDatabankProtein sedbIdent = sedbIdentifiers.get(index);
                        if (sedbIdent == null || sedbIdent.getDescription() == null || sedbIdent.getDescription().trim().length() <= 0) continue;
                        protDescription = sedbIdent.getDescription();
                        protMatch.setDescription(protDescription);
                        entryIndex = index;
                        protMatch2Update = true;
                        break;
                    }
                } else {
                    entryIndex = 0;
                }
            }
            if (!StringUtils.isEmpty((String)protDescription) && (geneName = RegExUtil.getMatchingString(protDescription, ".*GN=([^\\s]+).*")) != null && !geneName.isEmpty()) {
                protMatch.setGeneName(geneName);
                protMatch2Update = true;
            }
            if (seDbIdents == null || seDbIdents.getDBioSequences() == null || seDbIdents.getDBioSequences().isEmpty()) {
                ++this.nbrNoSeqProt;
                if (this.nbrNoSeqProt <= 10) {
                    LOG.debug(" ****  FOUND NO Sequence for protein {}. Display only 10 first ", (Object)protMatch.getAccession());
                }
                LOG.trace(" ****  FOUND NO Sequence for protein {}", (Object)protMatch.getAccession());
            } else {
                List<DBioSequence> protMatchBioSeqs = seDbIdents.getDBioSequences();
                if (protMatchBioSeqs.size() > 1) {
                    ++this.nbrManySeqProt;
                    if (entryIndex == -1) {
                        entryIndex = 0;
                    }
                    if (this.nbrManySeqProt <= 10) {
                        LOG.debug(" ****  FOUND MORE THAN 1 Sequence for protein {}. Use sequence at index {} (Display only 10 first) ", (Object)protMatch.getAccession(), (Object)entryIndex);
                    }
                    LOG.trace(" ****  FOUND MORE THAN 1 Sequence for protein {}. Use sequence at index {} ", (Object)protMatch.getAccession(), (Object)entryIndex);
                } else {
                    entryIndex = 0;
                }
                DBioSequence bioSeq = protMatchBioSeqs.get(entryIndex);
                int bioSequenceLenght = bioSeq.getSequence().length();
                if (bioSequenceLenght > 0 && coveredSequenceLength <= bioSequenceLenght) {
                    JsonObject array;
                    double coverage = ProjectHandler.calculateSequenceCoverage(bioSequenceLenght, coveredSequenceLength);
                    ProteinSetProteinMatchItem proSetMap = protSetMapByProtMatch.get(protMatch);
                    proSetMap.setCoverage(new Float(coverage).floatValue());
                    this.msiEM.merge((Object)proSetMap);
                    if (enzyme != null && !(array = ProjectHandler.getPropertiesAsJsonObject(protMatch.getSerializedProperties())).has("observable_peptide_count")) {
                        int observablePeptideCount = DigestionUtils.getObservablePeptidesCount((String)bioSeq.getSequence(), (fr.profi.chemistry.model.Enzyme)enzyme);
                        LOG.trace(" Saving observable_peptide_count property for proteinMatch {}.", (Object)protMatch.getId());
                        array.addProperty("observable_peptide_count", (Number)observablePeptideCount);
                        protMatch.setSerializedProperties(array.toString());
                        protMatch2Update = true;
                    }
                    Long prevBioSeqId = protMatch.getBioSequenceId();
                    Long newBioSeqId = bioSeq.getSequenceId();
                    if (!newBioSeqId.equals(prevBioSeqId)) {
                        protMatch2Update = true;
                    }
                    BioSequence msiBioSeq = (BioSequence)this.msiEM.find(BioSequence.class, (Object)newBioSeqId);
                    int nmass = (int)Math.round(bioSeq.getMass());
                    if (msiBioSeq == null) {
                        msiBioSeq = new BioSequence();
                        msiBioSeq.setAlphabet(Alphabet.AA);
                        msiBioSeq.setId(newBioSeqId.longValue());
                        msiBioSeq.setLength(bioSeq.getSequence().length());
                        msiBioSeq.setMass(nmass);
                        msiBioSeq.setCrc64(HashUtil.calculateCRC64(bioSeq.getSequence()));
                        msiBioSeq.setPi(new Float(bioSeq.getPI()));
                        msiBioSeq.setSequence(bioSeq.getSequence());
                        this.msiEM.persist((Object)msiBioSeq);
                    } else {
                        boolean foundMissMatch = false;
                        StringBuffer sb = new StringBuffer(" Following properties don't match with current biosequence with id  ");
                        sb.append(newBioSeqId);
                        if (msiBioSeq.getLength() != bioSeq.getSequence().length()) {
                            foundMissMatch = true;
                            sb.append(" sequence length;");
                        }
                        if (msiBioSeq.getMass() != nmass) {
                            foundMissMatch = true;
                            sb.append(" sequence mass (");
                            sb.append(msiBioSeq.getMass());
                            sb.append(" vs ");
                            sb.append(nmass);
                            sb.append(");");
                        }
                        if (!msiBioSeq.getSequence().equals(bioSeq.getSequence())) {
                            foundMissMatch = true;
                            sb.append(" sequence;");
                        }
                        if (foundMissMatch) {
                            ++this.nbrBioSeqMissMatch;
                            String msg = sb.toString();
                            if (this.nbrBioSeqMissMatch <= 10) {
                                LOG.debug(msg + " (Display only first 10)");
                            }
                            LOG.trace(sb.toString());
                        }
                    }
                    protMatch.setBioSequenceId(newBioSeqId);
                } else {
                    LOG.warn(" ****  FOUND Sequence is shorter than theorical covered Sequence Length !!! ");
                }
            }
            if (!protMatch2Update) continue;
            this.msiEM.merge((Object)protMatch);
        }
    }

    private static Integer computeSequenceCoverage(Map<Long, List<SequenceMatchInfo>> seqMatchesByProteinMatchId, ProteinMatch protMatch, List<Long> peptideIds) {
        HashSet<Integer> coveredAASet = new HashSet<Integer>();
        List<SequenceMatchInfo> seqMatches = seqMatchesByProteinMatchId.get(protMatch.getId());
        for (SequenceMatchInfo seqMatch : seqMatches) {
            Long pepId = seqMatch.getPeptideId();
            if (!peptideIds.contains(pepId)) continue;
            int start = seqMatch.getStart();
            int stop = seqMatch.getStop();
            coveredAASet.addAll(ProjectHandler.getIndexesList(start, stop));
        }
        return coveredAASet.size();
    }

    private static double calculateSequenceCoverage(int biosequenceLength, int sequencematchLength) {
        double average = (double)sequencematchLength / (double)biosequenceLength * 100.0;
        return average;
    }

    private static List<Integer> getIndexesList(int start, int stop) {
        ArrayList<Integer> sequenceLength = new ArrayList<Integer>();
        for (int i = start; i <= stop; ++i) {
            sequenceLength.add(i);
        }
        return sequenceLength;
    }
}

