/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq.service;

import fr.proline.module.seq.orm.BioSequence;
import fr.proline.module.seq.orm.DatabankInstance;
import fr.proline.module.seq.orm.DatabankProtein;
import fr.proline.module.seq.orm.Repository;
import fr.proline.module.seq.orm.RepositoryProtein;
import fr.proline.module.seq.util.Counters;
import fr.proline.repository.util.JPAUtils;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;

public class RetrieverContext {
    private final EntityManager m_seqEM;
    private final DatabankInstance m_databankInstance;
    private final Map<String, List<DatabankProtein>> m_existingProteins;
    private final Map<String, BioSequence> m_existingBioSequences;
    private final Repository m_repository;
    private final Map<String, RepositoryProtein> m_existingRepositoryProteins;
    private Counters m_counters;

    public RetrieverContext(EntityManager seqEM, DatabankInstance seDbInstance, Map<String, List<DatabankProtein>> existingSEDbIdents, Map<String, BioSequence> existingBioSequences, Repository repository, Map<String, RepositoryProtein> existingRepositoryIdents, Counters counters) {
        assert (seDbInstance != null) : "SeDbInstance is null";
        assert (existingSEDbIdents != null) : "ExistingSEDbIdents is null";
        assert (existingBioSequences != null) : "ExistingBioSequences is null";
        JPAUtils.checkEntityManager((EntityManager)seqEM);
        this.m_seqEM = seqEM;
        this.m_databankInstance = seDbInstance;
        this.m_existingProteins = existingSEDbIdents;
        this.m_existingBioSequences = existingBioSequences;
        this.m_repository = repository;
        this.m_existingRepositoryProteins = existingRepositoryIdents;
        this.m_counters = counters == null ? new Counters("Retriever") : counters;
    }

    public EntityManager getSeqEM() {
        return this.m_seqEM;
    }

    public DatabankInstance getDatabankInstance() {
        return this.m_databankInstance;
    }

    public Map<String, List<DatabankProtein>> getExistingProteins() {
        return this.m_existingProteins;
    }

    public Map<String, BioSequence> getExistingBioSequences() {
        return this.m_existingBioSequences;
    }

    public Repository getRepository() {
        return this.m_repository;
    }

    public Map<String, RepositoryProtein> getExistingRepositoryIdents() {
        return this.m_existingRepositoryProteins;
    }

    public Counters getCounters() {
        return this.m_counters;
    }
}

