/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.logparser.gui;

import fr.proline.logparser.gui.TaskExecutionPanel;
import fr.proline.logparser.model.LogTask;
import fr.proline.logparser.model.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;

public class TaskView
extends JPanel {
    private JTextField m_startTimeTextfield;
    private JTextField m_endTimeTextfield;
    private JTextField m_deltaEndTimeTextfield;
    private JTextField m_deltaEndTimeInHourTextfield;
    private JTextField m_threadNameTextfield;
    private JTextField m_messageIdTextfield;
    private JTextField m_statusTextfield;
    private JTextField m_nbTaskParallelTextfield;
    private JTextField m_callServiceTextfield;
    private JTextField m_dataSetTextField;
    private JTextField m_startLineTextfield;
    private JTextField m_stopLineTextfield;
    private JTextField m_projectIdTextField;
    private JLabel m_startLineIndexLabel;
    private JLabel m_stopLineIndexLabel;
    JScrollPane m_paramPanel;
    TaskExecutionPanel m_executionPanel;
    private LogTask m_task;

    public TaskView() {
        this.setBorder(BorderFactory.createTitledBorder("Task Detail"));
        this.initComponents();
        this.setPreferredSize(new Dimension(700, 700));
    }

    public void setData(LogTask selectedTask) {
        this.m_task = selectedTask;
        if (this.m_task == null) {
            this.reinit();
            this.repaint();
        } else {
            this.reinit();
            this.m_threadNameTextfield.setText(this.m_task.getThreadName());
            this.m_messageIdTextfield.setText(this.m_task.getMessageId());
            LogTask.STATUS status = this.m_task.getStatus();
            this.m_statusTextfield.setText(status == null ? null : status.toString());
            int nbTask = this.m_task.getNbParallelTask();
            if (nbTask > 0) {
                this.m_nbTaskParallelTextfield.setText("+" + nbTask);
            } else {
                this.m_nbTaskParallelTextfield.setText("");
            }
            this.m_callServiceTextfield.setText(this.m_task.getCallService());
            this.m_dataSetTextField.setText(this.m_task.getDataSet());
            this.m_projectIdTextField.setText(this.m_task.getProjectId());
            this.m_startLineTextfield.setText(this.m_task.getStartLine().line);
            this.m_startLineTextfield.setCaretPosition(0);
            this.m_startLineIndexLabel.setText("L." + this.m_task.getStartLine().index);
            this.m_stopLineTextfield.setText(this.m_task.getStopLine().line);
            this.m_stopLineTextfield.setCaretPosition(0);
            this.m_stopLineIndexLabel.setText("L." + this.m_task.getStopLine().index);
            this.m_startTimeTextfield.setText(Utility.formatTime(this.m_task.getStartTime()));
            this.m_endTimeTextfield.setText(Utility.formatTime(this.m_task.getStopTime()));
            this.m_deltaEndTimeTextfield.setText(Utility.formatDeltaTime(this.m_task.getDuration()));
            this.m_deltaEndTimeInHourTextfield.setText(Utility.formatDurationInHour(this.m_task.getDuration()));
            JTree tree = this.m_task.getParamTree();
            this.expandTreeAllNodes(tree, 0, tree.getRowCount());
            this.m_paramPanel.getViewport().add(tree);
            this.m_executionPanel.setData(this.m_task.getTimeStamp(), this.m_task.getNbOtherTaskMoment(), "");
            this.repaint();
        }
    }

    private void expandTreeAllNodes(JTree tree, int startingIndex, int rowCount) {
        for (int i = startingIndex; i < rowCount; ++i) {
            tree.expandRow(i);
        }
        if (tree.getRowCount() != rowCount) {
            this.expandTreeAllNodes(tree, rowCount, tree.getRowCount());
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JPanel mainInfoPanel = this.createMainInfoPanel();
        JPanel timePanel = this.createTimePanel();
        this.m_paramPanel = this.createParameterPanel();
        this.m_executionPanel = this.createExecutionPanel();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        this.add((Component)mainInfoPanel, c);
        c.weightx = 1.0;
        ++c.gridy;
        this.add((Component)timePanel, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)this.m_executionPanel, c);
        ++c.gridy;
        c.weighty = 1.0;
        this.add((Component)this.m_paramPanel, c);
    }

    public JPanel createTimePanel() {
        JPanel timePanel = new JPanel(new GridBagLayout());
        timePanel.setBorder(BorderFactory.createTitledBorder(" Timestamp "));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel startTimeLabel = new JLabel("Start Time:");
        this.m_startTimeTextfield = new JTextField();
        this.m_startTimeTextfield.setEditable(false);
        this.m_startTimeTextfield.setBackground(Color.white);
        JLabel durationLabel = new JLabel("Duration:");
        JLabel endTimeLabel = new JLabel("End Time:");
        this.m_endTimeTextfield = new JTextField();
        this.m_endTimeTextfield.setEditable(false);
        this.m_endTimeTextfield.setBackground(Color.white);
        this.m_deltaEndTimeTextfield = new JTextField();
        this.m_deltaEndTimeTextfield.setEditable(false);
        this.m_deltaEndTimeTextfield.setBackground(Color.white);
        this.m_deltaEndTimeInHourTextfield = new JTextField();
        this.m_deltaEndTimeInHourTextfield.setToolTipText("duration in HHHH:mm:ss.SSS");
        this.m_deltaEndTimeInHourTextfield.setEditable(false);
        this.m_deltaEndTimeInHourTextfield.setBackground(Color.white);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        timePanel.add((Component)startTimeLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        timePanel.add((Component)this.m_startTimeTextfield, c);
        ++c.gridx;
        c.weightx = 0.0;
        timePanel.add((Component)durationLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        timePanel.add((Component)this.m_deltaEndTimeTextfield, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        timePanel.add((Component)endTimeLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        timePanel.add((Component)this.m_endTimeTextfield, c);
        c.gridx += 2;
        c.weightx = 0.3;
        timePanel.add((Component)this.m_deltaEndTimeInHourTextfield, c);
        return timePanel;
    }

    private void reinit() {
        this.m_threadNameTextfield.setText("");
        this.m_messageIdTextfield.setText("");
        this.m_statusTextfield.setText("");
        this.m_nbTaskParallelTextfield.setText("");
        this.m_callServiceTextfield.setText("");
        this.m_dataSetTextField.setText("");
        this.m_startLineTextfield.setText("");
        this.m_stopLineTextfield.setText("");
        this.m_projectIdTextField.setText("");
        this.m_startTimeTextfield.setText("");
        this.m_endTimeTextfield.setText("");
        this.m_deltaEndTimeTextfield.setText("");
        this.m_deltaEndTimeInHourTextfield.setText("");
        this.m_startLineIndexLabel.setText("line index");
        this.m_stopLineIndexLabel.setText("line index");
        this.m_paramPanel.getViewport().removeAll();
        this.m_executionPanel.init();
    }

    public JPanel createMainInfoPanel() {
        JPanel mainInfoPanel = new JPanel(new GridBagLayout());
        mainInfoPanel.setBorder(BorderFactory.createTitledBorder(" Main Info "));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel threadNameLabel = new JLabel("Thread:");
        threadNameLabel.setToolTipText("run on the Thread");
        this.m_threadNameTextfield = new JTextField();
        this.m_threadNameTextfield.setEditable(false);
        this.m_threadNameTextfield.setBackground(Color.white);
        JLabel messageIdLabel = new JLabel("Message Id:");
        this.m_messageIdTextfield = new JTextField();
        this.m_messageIdTextfield.setEditable(false);
        this.m_messageIdTextfield.setBackground(Color.white);
        JLabel statusLabel = new JLabel("Stauts:");
        this.m_statusTextfield = new JTextField();
        this.m_statusTextfield.setEditable(false);
        this.m_statusTextfield.setBackground(Color.white);
        JLabel callServiceLabel = new JLabel("Call Service:");
        this.m_callServiceTextfield = new JTextField();
        this.m_callServiceTextfield.setEditable(false);
        this.m_callServiceTextfield.setBackground(Color.white);
        JLabel dataSetLabel = new JLabel("Meta info:");
        this.m_dataSetTextField = new JTextField();
        this.m_dataSetTextField.setEditable(false);
        this.m_dataSetTextField.setBackground(Color.white);
        JLabel projectIdLabel = new JLabel("Project Id:");
        this.m_projectIdTextField = new JTextField();
        this.m_projectIdTextField.setEditable(false);
        this.m_projectIdTextField.setBackground(Color.white);
        JLabel nbTaskLabel = new JLabel("Tasks:");
        nbTaskLabel.setToolTipText("Nombre Task in parallel:");
        this.m_nbTaskParallelTextfield = new JTextField();
        this.m_nbTaskParallelTextfield.setEditable(false);
        this.m_nbTaskParallelTextfield.setBackground(Color.white);
        JLabel startLineLabel = new JLabel("Start line:");
        this.m_startLineTextfield = new JTextField();
        this.m_startLineTextfield.setEditable(false);
        this.m_startLineTextfield.setBackground(Color.white);
        JLabel stopLineLabel = new JLabel("Stop line:");
        this.m_stopLineTextfield = new JTextField();
        this.m_stopLineTextfield.setEditable(false);
        this.m_stopLineTextfield.setBackground(Color.white);
        this.m_startLineIndexLabel = new JLabel("line index");
        this.m_stopLineIndexLabel = new JLabel("line index");
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        mainInfoPanel.add((Component)threadNameLabel, c);
        ++c.gridx;
        c.gridwidth = 4;
        c.weightx = 1.0;
        mainInfoPanel.add((Component)this.m_threadNameTextfield, c);
        c.gridx += 4;
        c.gridwidth = 1;
        c.weightx = 0.0;
        mainInfoPanel.add((Component)messageIdLabel, c);
        ++c.gridx;
        c.gridwidth = 4;
        c.weightx = 0.5;
        mainInfoPanel.add((Component)this.m_messageIdTextfield, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        mainInfoPanel.add((Component)callServiceLabel, c);
        ++c.gridx;
        c.weightx = 0.6;
        c.gridwidth = 4;
        mainInfoPanel.add((Component)this.m_callServiceTextfield, c);
        c.gridx += 4;
        c.weightx = 0.0;
        c.gridwidth = 1;
        mainInfoPanel.add((Component)statusLabel, c);
        ++c.gridx;
        c.weightx = 0.3;
        c.gridwidth = 2;
        mainInfoPanel.add((Component)this.m_statusTextfield, c);
        c.gridx += 2;
        c.weightx = 0.0;
        c.gridwidth = 1;
        mainInfoPanel.add((Component)nbTaskLabel, c);
        ++c.gridx;
        c.weightx = 0.1;
        c.gridwidth = 1;
        mainInfoPanel.add((Component)this.m_nbTaskParallelTextfield, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        mainInfoPanel.add((Component)dataSetLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 7;
        mainInfoPanel.add((Component)this.m_dataSetTextField, c);
        c.gridx += 7;
        c.weightx = 0.0;
        c.gridwidth = 1;
        mainInfoPanel.add((Component)projectIdLabel, c);
        ++c.gridx;
        c.weightx = 0.1;
        c.gridwidth = 1;
        mainInfoPanel.add((Component)this.m_projectIdTextField, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        mainInfoPanel.add((Component)startLineLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 8;
        mainInfoPanel.add((Component)this.m_startLineTextfield, c);
        c.gridx += 8;
        c.weightx = 0.0;
        c.gridwidth = 1;
        mainInfoPanel.add((Component)this.m_startLineIndexLabel, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        mainInfoPanel.add((Component)stopLineLabel, c);
        ++c.gridx;
        c.gridwidth = 8;
        mainInfoPanel.add((Component)this.m_stopLineTextfield, c);
        c.gridx += 8;
        c.weightx = 0.0;
        c.gridwidth = 1;
        mainInfoPanel.add((Component)this.m_stopLineIndexLabel, c);
        return mainInfoPanel;
    }

    private JScrollPane createParameterPanel() {
        JScrollPane paramePane = new JScrollPane();
        paramePane.setBorder(BorderFactory.createTitledBorder("Task parameters"));
        return paramePane;
    }

    private TaskExecutionPanel createExecutionPanel() {
        TaskExecutionPanel pane = new TaskExecutionPanel(15, 12);
        pane.setSize(this.getWidth(), 40);
        pane.setBorder(BorderFactory.createTitledBorder("Exexution situation & Parallel task"));
        return pane;
    }
}

