/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.serverfilesystem;

import fr.proline.studio.dpm.serverfilesystem.ServerFileSystemView;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;

public class ServerFile
extends File {
    private char SEPARATOR = (char)47;
    private final boolean m_isDirectory;
    private final long m_lastModified;
    private final long m_length;
    private final String m_serverFilePath;
    private final String m_serverFileName;

    public ServerFile(String path, String name, boolean isDirectory, long lastModified, long length) {
        super(path);
        char serverSeparator;
        this.m_serverFilePath = path;
        this.m_serverFileName = name;
        if (this.m_serverFilePath.length() > this.m_serverFileName.length() && ((serverSeparator = this.m_serverFilePath.charAt(this.m_serverFilePath.length() - this.m_serverFileName.length() - 1)) == '/' || serverSeparator == '\\')) {
            this.SEPARATOR = serverSeparator;
        }
        this.m_isDirectory = isDirectory;
        this.m_lastModified = lastModified;
        this.m_length = length;
    }

    @Override
    public String getPath() {
        return this.m_serverFilePath;
    }

    @Override
    public String getName() {
        return this.m_serverFileName;
    }

    @Override
    public String getParent() {
        if (this.m_serverFilePath.length() <= this.m_serverFileName.length()) {
            return null;
        }
        String parentPath = this.m_serverFilePath.substring(0, this.m_serverFilePath.length() - this.m_serverFileName.length() - 1);
        return parentPath;
    }

    @Override
    public File getParentFile() {
        String p = this.getParent();
        if (p == null) {
            return null;
        }
        int lastIndex = p.lastIndexOf(this.SEPARATOR);
        if (lastIndex == -1) {
            return new ServerFile(p, p, true, 0L, 0L);
        }
        return new ServerFile(p, p.substring(lastIndex + 1, p.length()), true, 0L, 0L);
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public String getAbsolutePath() {
        return this.m_serverFilePath;
    }

    @Override
    public File getAbsoluteFile() {
        return this;
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this.m_serverFilePath;
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return this;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return this.m_isDirectory;
    }

    @Override
    public boolean isFile() {
        return !this.m_isDirectory;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public long lastModified() {
        return this.m_lastModified;
    }

    @Override
    public long length() {
        return this.m_length;
    }

    @Override
    public boolean createNewFile() throws IOException {
        throw new SecurityException("createNewFile not allowed");
    }

    @Override
    public boolean delete() {
        throw new SecurityException("delete not allowed");
    }

    @Override
    public void deleteOnExit() {
        throw new SecurityException("deleteOnExit not allowed");
    }

    @Override
    public String[] list() {
        if (this.m_isDirectory) {
            File[] files = ServerFileSystemView.getServerFileSystemView().getFiles(this, false);
            String[] filesArray = new String[files.length];
            for (int i = 0; i < filesArray.length; ++i) {
                filesArray[i] = files[i].getPath();
            }
            return filesArray;
        }
        return null;
    }

    @Override
    public File[] listFiles() {
        if (this.m_isDirectory) {
            return ServerFileSystemView.getServerFileSystemView().getFiles(this, false);
        }
        return null;
    }

    @Override
    public File[] listFiles(FilenameFilter filter) {
        throw new UnsupportedOperationException("listFiles Not supported.");
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        throw new UnsupportedOperationException("listFiles Not supported.");
    }

    @Override
    public boolean mkdir() {
        throw new SecurityException("mkdir not allowed");
    }

    @Override
    public boolean mkdirs() {
        throw new SecurityException("mkdir not allowed");
    }

    @Override
    public boolean renameTo(File dest) {
        throw new SecurityException("renameTo not allowed");
    }

    @Override
    public boolean setLastModified(long time) {
        throw new SecurityException("setLastModified not allowed");
    }

    @Override
    public boolean setReadOnly() {
        throw new SecurityException("setReadOnly not allowed");
    }

    @Override
    public boolean setWritable(boolean writable, boolean ownerOnly) {
        throw new SecurityException("setWritable not allowed");
    }

    @Override
    public boolean setReadable(boolean readable, boolean ownerOnly) {
        throw new SecurityException("setReadable not allowed");
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        throw new SecurityException("setReadable not allowed");
    }

    @Override
    public boolean canExecute() {
        return false;
    }

    @Override
    public long getTotalSpace() {
        throw new UnsupportedOperationException("getTotalSpace Not supported.");
    }

    @Override
    public long getFreeSpace() {
        throw new UnsupportedOperationException("getTotalSpace Not supported.");
    }

    @Override
    public long getUsableSpace() {
        throw new SecurityException("getUsableSpace not allowed");
    }
}

