/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.profi.util.security.SecurityUtils;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class ChangePasswordTask
extends AbstractJMSTask {
    private static final String m_serviceName = "proline/admin/UserAccount";
    private static final String m_methodName = "change_password";
    private String m_userName;
    private String m_password;
    private String m_oldPassword;

    public ChangePasswordTask(AbstractJMSCallback callback, String userName, String oldPassword, String newPassword) {
        super(callback, new TaskInfo("Change password for " + userName, false, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_userName = userName;
        this.m_password = newPassword;
        this.m_oldPassword = oldPassword;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request(m_methodName, (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", m_serviceName);
        this.addSupplementaryInfo((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("login", this.m_userName);
        params.put("old_password_hash", SecurityUtils.sha256Hex((String)this.m_oldPassword));
        params.put("new_password_hash", SecurityUtils.sha256Hex((String)this.m_password));
        return params;
    }

    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        TextMessage textMessage = (TextMessage)jmsMessage;
        String jsonString = textMessage.getText();
        JSONRPC2Message jsonMessage = JSONRPC2Message.parse((String)jsonString);
        if (jsonMessage instanceof JSONRPC2Notification) {
            m_loggerProline.warn("JSON Notification method: " + ((JSONRPC2Notification)jsonMessage).getMethod() + " instead of JSON Response");
            throw new Exception("Invalid JSONRPC2Message type");
        }
        if (jsonMessage instanceof JSONRPC2Response) {
            JSONRPC2Response jsonResponse = (JSONRPC2Response)jsonMessage;
            m_loggerProline.debug("JSON Response Id: " + jsonResponse.getID());
            JSONRPC2Error jsonError = jsonResponse.getError();
            if (jsonError != null) {
                m_loggerProline.error("JSON Error code {}, message : \"{}\"", (Object)jsonError.getCode(), (Object)jsonError.getMessage());
                m_loggerProline.error("JSON Throwable", (Throwable)jsonError);
                throw jsonError;
            }
            Object rs = jsonResponse.getResult();
            if (rs == null || !Boolean.class.isInstance(rs)) {
                m_loggerProline.debug("Invalid result: No status returned");
                throw new Exception("Invalid result " + rs);
            }
            m_loggerProline.debug("Result :\n" + rs);
            Boolean status = (Boolean)rs;
            if (!status.booleanValue()) {
                this.m_taskError = new TaskError("Change password failed");
                return;
            }
        }
        this.m_currentState = AbstractJMSTask.JMSState.STATE_DONE;
    }
}

