/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class DownloadProcessedFileTask
extends AbstractJMSTask {
    private final String m_userFilePath;
    private final String m_serverFilePath;
    private final String m_serverNodeId;

    public DownloadProcessedFileTask(AbstractJMSCallback callback, String userFilePath, String serverFilePath, String serverNodeId) {
        super(callback, new TaskInfo("Download File " + userFilePath, true, "Services JMS", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_userFilePath = userFilePath;
        this.m_serverFilePath = serverFilePath;
        this.m_serverNodeId = serverNodeId;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("get_resource_as_stream", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", "proline/misc/ResourceService");
        message.setStringProperty("Proline_NodeId", this.m_serverNodeId);
        this.addSupplementaryInfo((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> namedParams = new HashMap<String, Object>();
        namedParams.put("file_path", this.m_serverFilePath);
        return namedParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        if (jmsMessage instanceof BytesMessage) {
            boolean success = false;
            FilterOutputStream bos = null;
            String errorMsg = "";
            try {
                bos = new BufferedOutputStream(new FileOutputStream(this.m_userFilePath));
                m_loggerProline.debug("Saving stream to File [" + this.m_userFilePath + ']');
                jmsMessage.setObjectProperty("JMS_HQ_SaveStream", (Object)bos);
                success = true;
            }
            catch (FileNotFoundException | JMSException ex) {
                m_loggerProline.error("Error handling JMS_HQ_SaveStream OutputStream [" + this.m_userFilePath + ']', ex);
                errorMsg = "Error handling JMS_HQ_SaveStream OutputStream [" + this.m_userFilePath + "] (" + ex.getMessage() + ")";
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                        if (success) {
                            m_loggerProline.info("File [" + this.m_userFilePath + "] Saved");
                        }
                    }
                    catch (IOException ioEx) {
                        m_loggerProline.error("Error closing OutputStream [" + this.m_userFilePath + ']', (Throwable)ioEx);
                        errorMsg = "Error closing OutputStream [" + this.m_userFilePath + "] (" + ioEx.getMessage() + ")";
                    }
                }
            }
            if (!errorMsg.isEmpty()) {
                throw new Exception(errorMsg);
            }
        } else {
            if (jmsMessage instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)jmsMessage;
                String jsonString = textMessage.getText();
                throw new Exception(" Invalide message type to download file ! " + jsonString);
            }
            throw new Exception(" Invalide message type to download file ! ");
        }
        this.m_currentState = AbstractJMSTask.JMSState.STATE_DONE;
    }
}

