/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.ArrayList;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class GenerateSpectrumMatchTask
extends AbstractJMSTask {
    private static final String m_serviceName = "proline/dps/msi/GenerateSpectrumMatches";
    private Long m_projectId;
    private Long m_resultSetId;
    private Long m_resultSummaryId;
    private Long m_peptideMatchId = null;
    private Boolean m_forceGenerate = false;
    private Long m_fragmentRuleSetId = null;

    public GenerateSpectrumMatchTask(AbstractJMSCallback callback, String datasetName, Long projectId, Long resultSetId, Long resultSummaryId, Long peptideMatchId, long fragmRuleSetId, Boolean forceGenerate) {
        super(callback, new TaskInfo(datasetName != null ? "Generate Spectrum Matches for " + datasetName : "Generate Spectrum Match(es)", true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_projectId = projectId;
        this.m_resultSetId = resultSetId;
        this.m_resultSummaryId = resultSummaryId;
        this.m_peptideMatchId = peptideMatchId;
        this.m_fragmentRuleSetId = fragmRuleSetId;
        this.m_forceGenerate = forceGenerate;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", m_serviceName);
        this.addSupplementaryInfo((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("project_id", this.m_projectId);
        params.put("result_set_id", this.m_resultSetId);
        if (this.m_peptideMatchId != null) {
            ArrayList<Long> peptideMatches = new ArrayList<Long>();
            peptideMatches.add(this.m_peptideMatchId);
            params.put("peptide_match_ids", peptideMatches);
        } else if (this.m_resultSummaryId != null) {
            params.put("result_summary_id", this.m_resultSummaryId);
        }
        if (this.m_fragmentRuleSetId != null && this.m_fragmentRuleSetId > 0L) {
            params.put("fragmentation_rule_set_id", this.m_fragmentRuleSetId);
        }
        params.put("force_insert", this.m_forceGenerate);
        return params;
    }

    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        TextMessage textMessage = (TextMessage)jmsMessage;
        String jsonString = textMessage.getText();
        JSONRPC2Message jsonMessage = JSONRPC2Message.parse((String)jsonString);
        if (jsonMessage instanceof JSONRPC2Notification) {
            m_loggerProline.warn("JSON Notification method: " + ((JSONRPC2Notification)jsonMessage).getMethod() + " instead of JSON Response");
            throw new Exception("Invalid JSONRPC2Message type");
        }
        if (jsonMessage instanceof JSONRPC2Response) {
            JSONRPC2Response jsonResponse = (JSONRPC2Response)jsonMessage;
            m_loggerProline.debug("JSON Response Id: " + jsonResponse.getID());
            JSONRPC2Error jsonError = jsonResponse.getError();
            if (jsonError != null) {
                m_loggerProline.error("JSON Error code {}, message : \"{}\"", (Object)jsonError.getCode(), (Object)jsonError.getMessage());
                m_loggerProline.error("JSON Throwable", (Throwable)jsonError);
                throw jsonError;
            }
            Object result = jsonResponse.getResult();
            if (result == null || !Boolean.class.isInstance(result)) {
                m_loggerProline.debug("Invalid result");
                throw new Exception("Invalid result " + result);
            }
            m_loggerProline.debug("Result :\n" + result);
        }
        this.m_currentState = AbstractJMSTask.JMSState.STATE_DONE;
    }
}

