/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.HashMap;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class IdentifyPtmSitesTask
extends AbstractJMSTask {
    private static final String m_serviceName = "proline/dps/msi/IdentifyPtmSites";
    private Long m_projectId;
    private Long m_resultSummaryId;
    private Boolean m_forceAction;
    private String m_version;
    private List<Long> m_ptmIds;
    private String m_clusteringMethodName;

    public IdentifyPtmSitesTask(AbstractJMSCallback callback, String datasetName, Long projectId, Long resultSummaryId, Boolean force) {
        super(callback, new TaskInfo(datasetName != null ? "Identify Modification sites for " + datasetName : "Identify Modification sites", true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_projectId = projectId;
        this.m_resultSummaryId = resultSummaryId;
        this.m_forceAction = force;
    }

    public IdentifyPtmSitesTask(AbstractJMSCallback callback, String datasetName, Long projectId, Long resultSummaryId, Boolean force, String version, List<Long> ptmIds, String clusteringMethodName) {
        this(callback, datasetName, projectId, resultSummaryId, force);
        this.m_version = version;
        this.m_ptmIds = ptmIds;
        this.m_clusteringMethodName = clusteringMethodName;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", m_serviceName);
        if (this.m_version != null) {
            message.setStringProperty("Proline_ServiceVersion", this.m_version);
        }
        this.addSupplementaryInfo((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("project_id", this.m_projectId);
        params.put("result_summary_id", this.m_resultSummaryId);
        if (this.m_forceAction != null) {
            params.put("force", this.m_forceAction);
        } else {
            params.put("force", true);
        }
        if (this.m_version != null) {
            params.put("ptm_ids", this.m_ptmIds);
            HashMap<String, String> clusteringConfig = new HashMap<String, String>();
            clusteringConfig.put("method_name", this.m_clusteringMethodName);
            params.put("clustering_config", clusteringConfig);
        }
        return params;
    }

    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        TextMessage textMessage = (TextMessage)jmsMessage;
        String jsonString = textMessage.getText();
        JSONRPC2Message jsonMessage = JSONRPC2Message.parse((String)jsonString);
        if (jsonMessage instanceof JSONRPC2Notification) {
            m_loggerProline.warn("JSON Notification method: " + ((JSONRPC2Notification)jsonMessage).getMethod() + " instead of JSON Response");
            throw new Exception("Invalid JSONRPC2Message type");
        }
        if (jsonMessage instanceof JSONRPC2Response) {
            JSONRPC2Response jsonResponse = (JSONRPC2Response)jsonMessage;
            m_loggerProline.debug("JSON Response Id: " + jsonResponse.getID());
            JSONRPC2Error jsonError = jsonResponse.getError();
            if (jsonError != null) {
                m_loggerProline.error("JSON Error code {}, message : \"{}\"", (Object)jsonError.getCode(), (Object)jsonError.getMessage());
                m_loggerProline.error("JSON Throwable", (Throwable)jsonError);
                throw jsonError;
            }
            Object result = jsonResponse.getResult();
            if (result == null || !Boolean.class.isInstance(result)) {
                m_loggerProline.debug("Invalid result");
                throw new Exception("Invalid result " + result);
            }
            m_loggerProline.debug("Result :\n" + result);
        }
        this.m_currentState = AbstractJMSTask.JMSState.STATE_DONE;
    }
}

