/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class SpectralCountTask
extends AbstractJMSTask {
    private static final String m_serviceName = "proline/dps/msq/QuantifySC";
    private static final String m_version_2_0 = "2.0";
    private DDataset m_refDataset = null;
    private List<DDataset> m_rsmDataset = null;
    private List<DDataset> m_rsmWeightDataset = null;
    private Long[] m_quantiDatasetId = null;
    private String m_dsName = null;
    private String m_dsDescr = null;

    public SpectralCountTask(AbstractJMSCallback callback, DDataset refDataset, List<DDataset> rsmDataset, List<DDataset> rsmWeightDataset, String dsName, String dsDescr, Long[] quantiDatasetId) {
        super(callback, new TaskInfo("Spectral Count on " + refDataset.getName(), true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_refDataset = refDataset;
        this.m_rsmDataset = rsmDataset;
        this.m_rsmWeightDataset = rsmWeightDataset;
        this.m_quantiDatasetId = quantiDatasetId;
        this.m_dsName = dsName;
        this.m_dsDescr = dsDescr;
        if (this.m_dsName == null || this.m_dsName.isEmpty()) {
            this.m_dsName = this.m_refDataset.getName() + " Spectral Count";
        }
        if (this.m_dsDescr == null || this.m_dsDescr.isEmpty()) {
            this.m_dsDescr = this.m_dsName;
        }
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", m_serviceName);
        message.setStringProperty("Proline_ServiceVersion", m_version_2_0);
        this.addSupplementaryInfo((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", this.m_dsName);
        params.put("description", this.m_dsDescr);
        params.put("project_id", this.m_refDataset.getProject().getId());
        ArrayList<Long> weightRefRSMIds = new ArrayList<Long>();
        for (DDataset ddset : this.m_rsmWeightDataset) {
            weightRefRSMIds.add(ddset.getResultSummaryId());
        }
        params.put("peptide_ref_rsm_ids", weightRefRSMIds);
        HashMap experimentalDesignParams = new HashMap();
        ArrayList<Integer> sampleNumbers = new ArrayList<Integer>();
        ArrayList biologicalSampleList = new ArrayList();
        ArrayList quantChanneList = new ArrayList();
        int number = 1;
        for (DDataset d : this.m_rsmDataset) {
            String name = d.getName();
            HashMap<String, Object> biologicalSampleParams = new HashMap<String, Object>();
            biologicalSampleParams.put("number", number);
            biologicalSampleParams.put("name", name);
            biologicalSampleList.add(biologicalSampleParams);
            HashMap<String, Object> quantChannelParams = new HashMap<String, Object>();
            quantChannelParams.put("number", number);
            quantChannelParams.put("sample_number", number);
            quantChannelParams.put("name", name);
            quantChannelParams.put("ident_result_summary_id", d.getResultSummaryId());
            quantChanneList.add(quantChannelParams);
            sampleNumbers.add(number);
            ++number;
        }
        experimentalDesignParams.put("biological_samples", biologicalSampleList);
        ArrayList biologicalGroupList = new ArrayList();
        HashMap<String, Object> biologicalGroupParams = new HashMap<String, Object>();
        biologicalGroupParams.put("number", 0);
        biologicalGroupParams.put("name", this.m_refDataset.getName());
        biologicalGroupParams.put("sample_numbers", sampleNumbers);
        biologicalGroupList.add(biologicalGroupParams);
        experimentalDesignParams.put("biological_groups", biologicalGroupList);
        ArrayList masterQuantChannelsList = new ArrayList();
        HashMap<String, Object> masterQuantChannelParams = new HashMap<String, Object>();
        masterQuantChannelParams.put("number", 0);
        masterQuantChannelParams.put("name", this.m_refDataset.getName() + " Spectral Count");
        masterQuantChannelParams.put("ident_result_summary_id", this.m_refDataset.getResultSummaryId());
        masterQuantChannelParams.put("ident_dataset_id", this.m_refDataset.getId());
        masterQuantChannelParams.put("quant_channels", quantChanneList);
        masterQuantChannelsList.add(masterQuantChannelParams);
        experimentalDesignParams.put("master_quant_channels", masterQuantChannelsList);
        params.put("experimental_design", experimentalDesignParams);
        return params;
    }

    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        TextMessage textMessage = (TextMessage)jmsMessage;
        String jsonString = textMessage.getText();
        JSONRPC2Message jsonMessage = JSONRPC2Message.parse((String)jsonString);
        if (jsonMessage instanceof JSONRPC2Notification) {
            m_loggerProline.warn("JSON Notification method: " + ((JSONRPC2Notification)jsonMessage).getMethod() + " instead of JSON Response");
            throw new Exception("Invalid JSONRPC2Message type");
        }
        if (jsonMessage instanceof JSONRPC2Response) {
            JSONRPC2Response jsonResponse = (JSONRPC2Response)jsonMessage;
            m_loggerProline.debug("JSON Response Id: " + jsonResponse.getID());
            JSONRPC2Error jsonError = jsonResponse.getError();
            if (jsonError != null) {
                m_loggerProline.error("JSON Error code {}, message : \"{}\"", (Object)jsonError.getCode(), (Object)jsonError.getMessage());
                m_loggerProline.error("JSON Throwable", (Throwable)jsonError);
                throw jsonError;
            }
            Object result = jsonResponse.getResult();
            if (result == null || !Long.class.isInstance(result)) {
                m_loggerProline.debug("Invalid result");
                throw new Exception("Invalid result " + result);
            }
            m_loggerProline.debug("Result :\n" + result);
            this.m_quantiDatasetId[0] = (Long)result;
        }
        this.m_currentState = AbstractJMSTask.JMSState.STATE_DONE;
    }
}

