/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.util;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2ParseException;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.profi.util.StringUtils;
import fr.proline.studio.dpm.data.JMSNotificationMessage;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSMessageUtil {
    protected static final Logger m_loggerProline = LoggerFactory.getLogger((String)"ProlineStudio.DPM.Task");
    private static final String TAB = "    ";
    private static final String DATE_FORMAT = "%td/%<tm/%<tY %<tH:%<tM:%<tS.%<tL";
    private static final int MESSAGE_BUFFER_SIZE = 2048;

    public static JMSNotificationMessage buildJMSNotificationMessage(Message message, JMSNotificationMessage.MessageStatus status) {
        try {
            String sName = message.getStringProperty("Proline_ServiceName");
            String sVersion = message.getStringProperty("Proline_ServiceVersion");
            String sSource = message.getStringProperty("Proline_ServiceSource");
            String sDescription = message.getStringProperty("Proline_ServiceDescription");
            String sMoreInfo = null;
            if (message instanceof TextMessage) {
                sMoreInfo = ((TextMessage)message).getText();
            }
            Long sTimestamp = message.getJMSTimestamp();
            String jmsId = message.getJMSMessageID();
            String jsonId = "";
            if (message instanceof TextMessage) {
                try {
                    JSONRPC2Request jsonMsg = JSONRPC2Request.parse((String)((TextMessage)message).getText());
                    jsonId = jsonMsg.getID().toString();
                }
                catch (JSONRPC2ParseException ex) {
                    jsonId = jmsId;
                }
            }
            JMSNotificationMessage notifMsg = new JMSNotificationMessage(sName, sVersion, sSource, sDescription, sMoreInfo, sTimestamp, jmsId, jsonId, status);
            return notifMsg;
        }
        catch (JMSException jmsE) {
            return null;
        }
    }

    public static String formatMessage(Message message) {
        if (message == null) {
            throw new IllegalArgumentException("Message is null");
        }
        StringBuilder buff = new StringBuilder(2048);
        try {
            buff.append(message.getClass().getName()).append("  ").append(message.getJMSMessageID());
            buff.append(StringUtils.LINE_SEPARATOR);
            buff.append(TAB).append("JMSCorrelationID ");
            JMSMessageUtil.append(buff, message.getJMSCorrelationID());
            buff.append(StringUtils.LINE_SEPARATOR);
            buff.append(TAB).append("JMSTimestamp ").append(String.format(DATE_FORMAT, message.getJMSTimestamp()));
            buff.append(StringUtils.LINE_SEPARATOR);
            buff.append(TAB).append("JMSDestination ");
            JMSMessageUtil.append(buff, message.getJMSDestination());
            buff.append(StringUtils.LINE_SEPARATOR);
            buff.append(TAB).append("JMSReplyTo ");
            JMSMessageUtil.append(buff, message.getJMSReplyTo());
            buff.append(StringUtils.LINE_SEPARATOR);
            Enumeration nameEnum = message.getPropertyNames();
            while (nameEnum.hasMoreElements()) {
                String propertyName = (String)nameEnum.nextElement();
                buff.append(TAB).append('[').append(propertyName).append("] : ");
                String propertyValue = message.getStringProperty(propertyName);
                if (propertyValue == null) {
                    buff.append("NULL");
                } else {
                    buff.append('[').append(propertyValue).append(']');
                }
                buff.append(StringUtils.LINE_SEPARATOR);
            }
            if (message instanceof TextMessage) {
                buff.append(TAB).append(((TextMessage)message).getText());
            }
            buff.append(StringUtils.LINE_SEPARATOR);
        }
        catch (Exception ex) {
            m_loggerProline.error("Error retrieving JMS Message header or content", (Throwable)ex);
        }
        return buff.toString();
    }

    private static void append(StringBuilder sb, Object obj) {
        assert (sb != null) : "append() sb is null";
        if (obj == null) {
            sb.append("NULL");
        } else {
            sb.append(obj);
        }
    }

    public static void traceJSONResponse(String jsonString) throws JSONRPC2ParseException {
        JSONRPC2Message jsonMessage = JSONRPC2Message.parse((String)jsonString);
        if (jsonMessage instanceof JSONRPC2Notification) {
            JSONRPC2Notification jsonNotification = (JSONRPC2Notification)jsonMessage;
            m_loggerProline.debug("JSON Notification method: " + jsonNotification.getMethod());
            Map namedParams = jsonNotification.getNamedParams();
            if (namedParams != null && !namedParams.isEmpty()) {
                StringBuilder buff = new StringBuilder("Params: ");
                boolean first = true;
                Set entries = namedParams.entrySet();
                for (Map.Entry entry : entries) {
                    if (first) {
                        first = false;
                    } else {
                        buff.append(" | ");
                    }
                    buff.append((String)entry.getKey());
                    buff.append(" : ").append(entry.getValue());
                }
                m_loggerProline.debug(buff.toString());
            }
        } else if (jsonMessage instanceof JSONRPC2Response) {
            Object result;
            JSONRPC2Response jsonResponse = (JSONRPC2Response)jsonMessage;
            m_loggerProline.debug("JSON Response Id: " + jsonResponse.getID());
            JSONRPC2Error jsonError = jsonResponse.getError();
            if (jsonError != null) {
                m_loggerProline.error("JSON Error code {}, message : \"{}\"", (Object)jsonError.getCode(), (Object)jsonError.getMessage());
                m_loggerProline.error("JSON Throwable", (Throwable)jsonError);
            }
            if ((result = jsonResponse.getResult()) == null) {
                m_loggerProline.debug("No result");
            } else {
                m_loggerProline.debug("Result :\n" + result);
            }
        }
    }
}

