/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.iterator;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.AbstractMzDbReader;
import fr.profi.mzdb.io.reader.bb.IBlobReader;
import fr.profi.mzdb.io.reader.cache.AbstractSpectrumHeaderReader;
import fr.profi.mzdb.io.reader.iterator.AbstractSpectrumSliceIterator;
import fr.profi.mzdb.model.BoundingBox;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumSlice;
import fr.profi.mzdb.util.sqlite.ISQLiteStatementConsumer;
import java.io.StreamCorruptedException;
import java.util.Iterator;

public class SpectrumRangeIterator
implements Iterator<Spectrum> {
    private int bbStartingSpectrumId;
    private int bbEndingSpectrumId;
    private int wantedStartingSpectrumId;
    private int wantedEndingSpectrumId;
    private MsSpectrumRangeIteratorImpl _iter;
    private Long currentId;
    private String sqlQuery;
    private Long trueLastSpectrumId = 0L;

    public SpectrumRangeIterator(AbstractMzDbReader mzDbReader, SQLiteConnection connection, int msLevel, int start, int end) throws SQLiteException, StreamCorruptedException {
        AbstractSpectrumHeaderReader spectrumHeaderReader = mzDbReader.getSpectrumHeaderReader();
        this.wantedStartingSpectrumId = start;
        this.wantedEndingSpectrumId = end;
        this.bbStartingSpectrumId = spectrumHeaderReader.getSpectrumHeader(start, connection).getBBFirstSpectrumId();
        this.bbEndingSpectrumId = spectrumHeaderReader.getSpectrumHeader(end, connection).getBBFirstSpectrumId();
        this.sqlQuery = "SELECT bounding_box.* FROM bounding_box, spectrum WHERE spectrum.id = bounding_box.first_spectrum_id AND spectrum.ms_level= ? AND bounding_box.first_spectrum_id >= " + this.bbStartingSpectrumId + " AND bounding_box.first_spectrum_id <= " + this.bbEndingSpectrumId;
        this._iter = new MsSpectrumRangeIteratorImpl(mzDbReader, connection, msLevel);
    }

    @Override
    public boolean hasNext() {
        return this.currentId == null || !this.currentId.equals(this.trueLastSpectrumId);
    }

    @Override
    public Spectrum next() {
        Spectrum sSlice = this._iter.next();
        while (this._iter.hasNext() && sSlice == null) {
            sSlice = this._iter.next();
        }
        this.currentId = sSlice.getHeader().getId();
        return sSlice;
    }

    @Override
    public void remove() {
    }

    public class MsSpectrumRangeIteratorImpl
    extends AbstractSpectrumSliceIterator
    implements Iterator<Spectrum> {
        protected int spectrumSliceIdx;
        protected SpectrumSlice[] spectrumSliceBuffer;
        protected boolean bbHasNext;

        public MsSpectrumRangeIteratorImpl(AbstractMzDbReader mzDbReader, SQLiteConnection connection, final int msLevel) throws SQLiteException, StreamCorruptedException {
            super(mzDbReader.getSpectrumHeaderReader(), mzDbReader.getDataEncodingReader(), connection, SpectrumRangeIterator.this.sqlQuery, msLevel, new ISQLiteStatementConsumer(){

                @Override
                public void accept(SQLiteStatement stmt) throws SQLiteException {
                    stmt.bind(1, msLevel);
                }
            });
            this.spectrumSliceBuffer = null;
            this.bbHasNext = true;
            this.initSpectrumSliceBuffer();
        }

        protected void initSpectrumSliceBuffer() {
            this.spectrumSliceBuffer = this.firstBB.toSpectrumSlices();
            this.spectrumSliceIdx = 0;
            while (this.bbHasNext = this.boundingBoxIterator.hasNext()) {
                SpectrumSlice[] sSlices;
                BoundingBox bb = (BoundingBox)this.boundingBoxIterator.next();
                IBlobReader bbReader = bb.getReader();
                if (bb.getLastSpectrumId() > (long)SpectrumRangeIterator.this.wantedEndingSpectrumId) {
                    SpectrumRangeIterator.this.trueLastSpectrumId = bbReader.getSpectrumIdAt(bb.getSpectraCount() - 1);
                } else if (bb.getLastSpectrumId() == (long)SpectrumRangeIterator.this.wantedEndingSpectrumId) {
                    SpectrumRangeIterator.this.trueLastSpectrumId = bb.getLastSpectrumId();
                }
                if ((sSlices = bb.toSpectrumSlices()) == null) continue;
                if (sSlices[0].getSpectrumId() == this.spectrumSliceBuffer[0].getSpectrumId()) {
                    for (int i = 0; i < sSlices.length; ++i) {
                        this.spectrumSliceBuffer[i].getData().addSpectrumData(sSlices[i].getData());
                    }
                    continue;
                }
                this.firstBB = bb;
                break;
            }
        }

        @Override
        public Spectrum next() {
            int c = this.spectrumSliceIdx++;
            SpectrumSlice sSlice = this.spectrumSliceBuffer[c];
            if (this.spectrumSliceIdx == this.spectrumSliceBuffer.length) {
                if (this.bbHasNext) {
                    this.initSpectrumSliceBuffer();
                } else {
                    this.firstBB = null;
                }
            }
            if (sSlice.getSpectrumId() < (long)SpectrumRangeIterator.this.wantedStartingSpectrumId) {
                return null;
            }
            if (sSlice.getSpectrumId() > (long)SpectrumRangeIterator.this.bbEndingSpectrumId && sSlice.getSpectrumId() < (long)SpectrumRangeIterator.this.wantedEndingSpectrumId) {
                this.firstBB = null;
                SpectrumRangeIterator.this.currentId = sSlice.getSpectrumId();
                return sSlice;
            }
            if (sSlice.getSpectrumId() == (long)SpectrumRangeIterator.this.wantedEndingSpectrumId) {
                SpectrumRangeIterator.this.currentId = sSlice.getSpectrumId();
                return sSlice;
            }
            if (sSlice.getSpectrumId() > (long)SpectrumRangeIterator.this.wantedEndingSpectrumId) {
                SpectrumRangeIterator.this.currentId = null;
                return null;
            }
            return sSlice;
        }
    }
}

