/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import fr.proline.studio.graphics.Axis;
import fr.proline.studio.graphics.BasePlotPanelViewAll;
import fr.proline.studio.graphics.MoveGesture;
import fr.proline.studio.graphics.MoveableInterface;
import fr.proline.studio.graphics.PanAxisGesture;
import fr.proline.studio.graphics.PlotBaseAbstract;
import fr.proline.studio.graphics.PlotPanelListener;
import fr.proline.studio.graphics.PlotXYAbstract;
import fr.proline.studio.graphics.SelectionGestureLasso;
import fr.proline.studio.graphics.XAxis;
import fr.proline.studio.graphics.YAxis;
import fr.proline.studio.graphics.ZoomGesture;
import fr.proline.studio.graphics.core.PlotToolbarListenerInterface;
import fr.proline.studio.graphics.cursor.AbstractCursor;
import fr.proline.studio.graphics.measurement.AbstractMeasurement;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.utils.StringUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePlotPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
Axis.EnumXInterface,
Axis.EnumYInterface,
SettingsInterface,
MoveableInterface {
    private static final Logger m_logger = LoggerFactory.getLogger(BasePlotPanel.class);
    private static final Color PANEL_BACKGROUND_COLOR = UIManager.getColor("Panel.background");
    private XAxis m_xAxis = null;
    private YAxis m_yAxis = null;
    private YAxis m_yAxisRight = null;
    private double[] m_xAxisBounds = new double[]{Double.NaN, Double.NaN};
    private double[] m_yAxisBounds = new double[]{Double.NaN, Double.NaN};
    private double[] m_yAxisRightBounds = new double[]{Double.NaN, Double.NaN};
    private final ZoomGesture m_zoomGesture = new ZoomGesture();
    private final SelectionGestureLasso m_selectionGesture = new SelectionGestureLasso();
    private final PanAxisGesture m_panAxisGesture = new PanAxisGesture();
    private final MoveGesture m_moveGesture = new MoveGesture();
    public static final int GAP_FIGURES_Y = 30;
    public static final int GAP_FIGURES_X = 24;
    public static final int GAP_END_AXIS = 10;
    public static final int GAP_AXIS_TITLE = 20;
    public static final int GAP_AXIS_LINE = 5;
    private BufferedImage m_doubleBuffer = null;
    private boolean m_useDoubleBuffering = false;
    private boolean m_updateDoubleBuffer = false;
    private BasePlotPanelViewAll m_viewAllPanel = new BasePlotPanelViewAll(this);
    private boolean m_plotHorizontalGrid = true;
    private boolean m_plotVerticalGrid = true;
    private boolean m_dataLocked = false;
    private boolean m_drawCursor = false;
    private List<PlotPanelListener> m_listeners = new ArrayList<PlotPanelListener>();
    private PlotToolbarListenerInterface m_plotToolbarListener = null;
    private Rectangle m_plotArea = new Rectangle();
    private Rectangle m_plotAreaViewAllMap = new Rectangle();
    private String m_coordX = "";
    private String m_coordY = "";
    private int m_posx;
    private int m_posy;
    private static final Font coordFont = new Font("dialog", 1, 9);
    private static final Color coordColor = Color.GRAY;
    private static final NumberFormat nfE = NumberFormat.getNumberInstance();
    private static final DecimalFormat formatE = (DecimalFormat)nfE;
    private static final NumberFormat nf = NumberFormat.getNumberInstance();
    private static final DecimalFormat format = (DecimalFormat)nf;
    private String m_plotTitle = null;
    private static final Font TITLE_FONT = new Font("dialog", 1, 11);
    private static final Color TITLE_COLOR = Color.DARK_GRAY;
    private EventListenerList listenerList = new EventListenerList();
    private boolean m_isEnumAxisUpdated = false;
    private MOUSE_MODE m_mouseMode = MOUSE_MODE.NORMAL_MODE;
    private final double[] m_resMinMax = new double[2];
    private final StringBuilder m_sbTooltip = new StringBuilder();

    public BasePlotPanel() {
        formatE.applyPattern("0.#####E0");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setMouseMode(MOUSE_MODE mouseMode) {
        this.m_mouseMode = mouseMode;
    }

    public void setSelectionType(boolean selectionSquare) {
        this.m_selectionGesture.setSelectionIsSquare(selectionSquare);
    }

    public void setPlotTitle(String title) {
        this.m_plotTitle = title;
    }

    public String getPlotTitle() {
        return this.m_plotTitle;
    }

    public void setPlotToolbarListener(PlotToolbarListenerInterface plotToolbarListener) {
        this.m_plotToolbarListener = plotToolbarListener;
    }

    public void enableButton(PlotToolbarListenerInterface.BUTTONS button, boolean v) {
        if (this.m_plotToolbarListener != null) {
            this.m_plotToolbarListener.enable(button, v);
        }
    }

    public Rectangle getPlotArea() {
        return this.m_plotArea;
    }

    private void updateEnumAxis() {
        YAxis yAxisRight;
        XAxis xAxis = this.getXAxis();
        if (!xAxis.hasPlots()) {
            return;
        }
        YAxis yAxis = this.getYAxis();
        double xMin = xAxis.getMinValue();
        double xMax = xAxis.getMaxValue();
        double yMin = yAxis.getMinValue();
        double yMax = yAxis.getMaxValue();
        double newXMin = xMin;
        double newXMax = xMax;
        double newYMin = yMin;
        double newYMax = yMax;
        boolean isModified = false;
        if (xAxis.isEnum()) {
            newXMin = xMin - 0.5;
            newXMax = xMax + 0.5;
            isModified = true;
            xAxis.setRange(newXMin, newXMax);
        }
        if (yAxis.isEnum()) {
            newYMin = yMin - 0.5;
            newYMax = yMax + 0.5;
            isModified = true;
            yAxis.setRange(newYMin, newYMax);
        }
        if (isModified) {
            this.fireUpdateAxisRange(xMin, xMax, newXMin, newXMax, yMin, yMax, newYMin, newYMax);
        }
        if ((yAxisRight = this.getYAxisRight()).isEnum()) {
            double y2Min = yAxisRight.getMinValue() - 0.5;
            double y2Max = yAxisRight.getMaxValue() + 0.5;
            yAxisRight.setRange(y2Min, y2Max);
        }
        this.m_isEnumAxisUpdated = true;
    }

    @Override
    public void paint(Graphics g) {
        boolean hasPlot;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (!this.m_isEnumAxisUpdated) {
            this.updateEnumAxis();
        }
        boolean displayYAxisAtRight = this.m_yAxisRight != null && this.m_yAxisRight.hasPlots() && this.m_yAxisRight.displayAxis();
        int gapForAxisXTtile = this.getXAxis().displayTitle() ? 20 : 0;
        int gapForAxisYTitle = this.getYAxis().displayTitle() ? 20 : 0;
        int xAxisX = 30 + gapForAxisYTitle + 5;
        int yAxisWidth = 30 + gapForAxisYTitle + 5;
        int yAxisRightWidth = displayYAxisAtRight ? yAxisWidth : 0;
        int width = this.getWidth() - yAxisRightWidth;
        int height = this.getHeight();
        int xAxisWidth = width - xAxisX;
        this.m_plotArea.x = 0;
        this.m_plotArea.y = 0;
        this.m_plotArea.width = width;
        this.m_plotArea.height = height;
        g.setColor(PANEL_BACKGROUND_COLOR);
        g.fillRect(0, 0, width + yAxisRightWidth, height);
        int titleY = 0;
        if (this.m_plotTitle != null) {
            int wt = StringUtils.lenghtOfString(this.m_plotTitle, this.getFontMetrics(TITLE_FONT));
            int titleX = (width - wt) / 2;
            int ascent = this.getFontMetrics(TITLE_FONT).getAscent();
            int descent = this.getFontMetrics(TITLE_FONT).getDescent();
            titleY = ascent;
            g.setFont(TITLE_FONT);
            g.setColor(TITLE_COLOR);
            g.drawString(this.m_plotTitle, titleX, titleY);
            titleY += descent;
        }
        this.m_plotArea.y = titleY;
        g.setColor(Color.darkGray);
        int figuresXHeight = 24;
        this.m_xAxis.checkMaxZoomOutDone();
        this.m_yAxis.checkMaxZoomOutDone();
        boolean bl = hasPlot = this.m_xAxis != null && this.m_xAxis.hasPlots();
        if (hasPlot) {
            if (this.m_xAxis != null && this.m_xAxis.displayAxis()) {
                int xAxisY = height - figuresXHeight - gapForAxisXTtile;
                int xAxisHeight = figuresXHeight + gapForAxisXTtile + 5;
                this.m_xAxis.setSize(xAxisX, xAxisY, xAxisWidth, xAxisHeight);
                this.m_xAxis.preparePaint(g2d);
                figuresXHeight = this.m_xAxis.getMiniMumAxisHeight(figuresXHeight);
                xAxisY = height - figuresXHeight - gapForAxisXTtile;
                xAxisHeight = figuresXHeight + gapForAxisXTtile + 5;
                this.m_xAxis.setSize(xAxisX, xAxisY, xAxisWidth, xAxisHeight);
                this.m_plotArea.x = this.m_xAxis.getX() + 1;
                this.m_plotArea.width = this.m_xAxis.getWidth();
                this.m_xAxis.paint(g2d);
            }
            int yAxisX = 0;
            int yAxisY = 10 + titleY;
            int yAxisHeight = height - figuresXHeight - gapForAxisXTtile - 10 - titleY;
            if (this.m_yAxis != null) {
                this.m_yAxis.setSize(yAxisX, yAxisY, yAxisWidth, yAxisHeight);
                if (this.m_yAxis.displayAxis()) {
                    this.m_plotArea.y = this.m_yAxis.getY() + 1;
                    this.m_plotArea.height = this.m_yAxis.getHeight();
                    this.m_yAxis.paint(g2d);
                }
            }
            if (displayYAxisAtRight) {
                this.m_yAxisRight.setSize(this.m_plotArea.width + yAxisRightWidth, yAxisY, yAxisRightWidth, yAxisHeight);
                this.m_yAxisRight.paint(g2d);
            }
            if (this.m_plotArea.width >= 0 && this.m_plotArea.height >= 0) {
                if (this.m_useDoubleBuffering) {
                    boolean createDoubleBuffer;
                    boolean bl2 = createDoubleBuffer = this.m_doubleBuffer == null || this.m_doubleBuffer.getWidth() != this.m_plotArea.width || this.m_doubleBuffer.getHeight() != this.m_plotArea.height;
                    if (createDoubleBuffer) {
                        this.m_doubleBuffer = new BufferedImage(this.m_plotArea.width, this.m_plotArea.height, 2);
                    }
                    if (createDoubleBuffer || this.m_updateDoubleBuffer) {
                        Graphics2D graphicBufferG2d = (Graphics2D)this.m_doubleBuffer.getGraphics();
                        graphicBufferG2d.translate(-this.m_plotArea.x, -this.m_plotArea.y);
                        this.paintPlotWithGrid(graphicBufferG2d);
                        this.m_updateDoubleBuffer = false;
                    }
                    g2d.drawImage((Image)this.m_doubleBuffer, this.m_plotArea.x, this.m_plotArea.y, null);
                } else {
                    this.paintPlotWithGrid(g2d);
                }
                this.paintOverPlot(g2d);
                this.m_viewAllPanel.paintBufferedViewAllMap(g2d);
            }
            Shape previousClipping = g2d.getClip();
            if (this.m_xAxis != null && this.m_yAxis != null && this.m_xAxis.displayAxis() && this.m_yAxis.displayAxis()) {
                int clipX = this.m_xAxis.valueToPixel(this.m_xAxis.getMinValue());
                int clipWidth = this.m_xAxis.valueToPixel(this.m_xAxis.getMaxValue()) - clipX;
                int clipY = this.m_yAxis.valueToPixel(this.m_yAxis.getMaxValue());
                int clipHeight = this.m_yAxis.valueToPixel(this.m_yAxis.getMinValue()) - clipY;
                g2d.setClip(clipX, clipY, clipWidth, clipHeight);
            }
            this.m_zoomGesture.paint(g2d);
            this.m_selectionGesture.paint(g2d);
            if (this.m_drawCursor) {
                this.paintCoord(g2d);
            }
            g2d.setClip(previousClipping);
        }
    }

    private void paintPlotWithGrid(Graphics2D g2d) {
        long startPlotTime = System.currentTimeMillis();
        g2d.setColor(Color.white);
        g2d.fillRect(this.m_plotArea.x, this.m_plotArea.y, this.m_plotArea.width, this.m_plotArea.height);
        if (this.m_plotVerticalGrid && this.m_xAxis != null && this.m_xAxis.displayAxis()) {
            this.m_xAxis.paintGrid(g2d, this.m_plotArea.x, this.m_plotArea.width, this.m_plotArea.y, this.m_plotArea.height);
        }
        if (this.m_plotHorizontalGrid && this.m_yAxis != null && this.m_yAxis.displayAxis()) {
            this.m_yAxis.paintGrid(g2d, this.m_plotArea.x, this.m_plotArea.width, this.m_plotArea.y, this.m_plotArea.height);
        }
        for (PlotBaseAbstract plot : this.getYAxis().getPlots()) {
            plot.paint(g2d, this.m_xAxis, this.m_yAxis);
        }
        for (PlotBaseAbstract plot : this.getYAxisRight().getPlots()) {
            plot.paint(g2d, this.m_xAxis, this.getYAxisRight());
        }
        long stopPlotTime = System.currentTimeMillis();
        if (stopPlotTime - startPlotTime > 50L) {
            this.m_useDoubleBuffering = true;
        }
    }

    private void paintOverPlot(Graphics2D g2d) {
        for (PlotBaseAbstract plot : this.getYAxis().getPlots()) {
            plot.paintOver(g2d);
            plot.paintMarkers(g2d);
            plot.paintCursors(g2d);
        }
        for (PlotBaseAbstract plot : this.getYAxisRight().getPlots()) {
            plot.paintOver(g2d);
        }
    }

    private void paintCoord(Graphics2D g) {
        int lx = StringUtils.lenghtOfString(this.m_coordX, this.getFontMetrics(coordFont));
        int ly = StringUtils.lenghtOfString(this.m_coordY, this.getFontMetrics(coordFont));
        int maxl = Math.max(lx, ly);
        g.setColor(coordColor);
        g.setFont(coordFont);
        int px = this.m_posx + 10;
        int py = this.m_posy;
        if (px + maxl > this.getWidth()) {
            px = this.m_posx - maxl - 10;
        }
        if (py - 10 < 0) {
            py = 10;
        } else if (py + 20 > this.getHeight()) {
            py = this.getHeight() - 20;
        }
        g.drawString(this.m_coordX, px, py);
        g.drawString(this.m_coordY, px, py + 15);
    }

    @Override
    public ArrayList<ParameterList> getParameters() {
        if (this.m_yAxis == null) {
            return null;
        }
        for (PlotBaseAbstract plot : this.m_yAxis.getPlots()) {
            ArrayList<ParameterList> parameters = plot.getParameters();
            if (parameters == null) continue;
            return parameters;
        }
        return null;
    }

    @Override
    public void parametersChanged() {
        ArrayList<PlotBaseAbstract> plots = this.m_xAxis.getPlots();
        if (plots != null) {
            for (int i = 0; i < plots.size(); ++i) {
                plots.get(i).parametersChanged();
            }
        }
        this.m_updateDoubleBuffer = true;
        this.repaint();
    }

    @Override
    public boolean parametersCanceled() {
        boolean repaintNeeded = false;
        ArrayList<PlotBaseAbstract> plots = this.m_xAxis.getPlots();
        if (plots != null) {
            for (int i = 0; i < plots.size(); ++i) {
                repaintNeeded |= plots.get(i).parametersCanceled();
            }
        }
        if (repaintNeeded) {
            this.m_updateDoubleBuffer = true;
            this.repaint();
        }
        return repaintNeeded;
    }

    public void updatePlots(int[] cols, String parameterZ) {
        for (PlotBaseAbstract plot : this.getXAxis().getPlots()) {
            plot.update(cols, parameterZ);
        }
    }

    public void forceUpdateDoubleBuffer() {
        this.m_updateDoubleBuffer = true;
    }

    public void lockData(boolean lock) {
        if (lock == this.m_dataLocked) {
            return;
        }
        this.m_dataLocked = lock;
        this.m_updateDoubleBuffer = true;
        this.repaint();
    }

    public boolean isLocked() {
        return this.m_dataLocked;
    }

    public void lockMinXValue() {
        double[] resMinMax = this.getMinMaxPlots(this.getXAxis());
        this.m_xAxis.lockMinValue(resMinMax[0]);
    }

    public void lockMinYValue() {
        double[] resMinMax = this.getMinMaxPlots(this.getYAxis());
        this.m_yAxis.lockMinValue(resMinMax[0]);
    }

    public void setDrawCursor(boolean drawCursor) {
        this.m_drawCursor = drawCursor;
    }

    public void displayGrid(boolean v) {
        this.m_plotVerticalGrid = v;
        this.m_plotHorizontalGrid = v;
        this.m_updateDoubleBuffer = true;
        this.repaint();
    }

    public boolean displayGrid() {
        return this.m_plotHorizontalGrid || this.m_plotVerticalGrid;
    }

    public void displayViewAllMap(boolean b) {
        this.m_viewAllPanel.setDisplay(b);
    }

    public boolean isViewAllMapDisplayed() {
        return this.m_viewAllPanel.isDisplayed();
    }

    public void setPlot(PlotBaseAbstract plot) {
        this.getXAxis().setPlot(plot);
        this.getYAxis().setPlot(plot);
        this.m_viewAllPanel.setDisplay(false);
        if (this.m_plotToolbarListener != null) {
            this.m_plotToolbarListener.stateModified(PlotToolbarListenerInterface.BUTTONS.VIEW_ALL_MAP);
        }
        this.updateAxis(plot);
    }

    public void clearPlots() {
        this.getXAxis().clearPlots();
        this.getYAxis().clearPlots();
        this.getYAxisRight().clearPlots();
    }

    public void clearPlotsWithRepaint() {
        boolean actualLock = this.m_dataLocked;
        this.lockData(true);
        this.clearPlots();
        this.repaint();
        this.lockData(actualLock);
    }

    public boolean hasPlots() {
        return this.getXAxis().hasPlots();
    }

    public ArrayList<PlotBaseAbstract> getPlots() {
        return this.getXAxis().getPlots();
    }

    public void addPlot(PlotXYAbstract plot) {
        this.addPlot(plot, true);
    }

    public void addPlot(PlotXYAbstract plot, boolean leftYAxis) {
        this.getXAxis().addPlot(plot);
        if (leftYAxis) {
            this.getYAxis().addPlot(plot);
        } else {
            this.getYAxisRight().addPlot(plot);
        }
        this.updateAxis(plot);
    }

    public void setSecondAxisPlotInfo(String title, Color color) {
        this.getYAxisRight().setTitle(title);
        this.getYAxisRight().setColorOnTitle(color);
    }

    public ArrayList<Long> getSelection() {
        if (this.getXAxis().hasPlots()) {
            return this.getXAxis().getPlots().get(0).getSelectedIds();
        }
        return null;
    }

    public void setSelection(ArrayList<Long> selection) {
        if (this.getXAxis().hasPlots()) {
            this.getXAxis().getPlots().get(0).setSelectedIds(selection);
            this.m_updateDoubleBuffer = true;
            this.repaint();
        }
    }

    public double[] getMinMaxPlots(Axis axis) {
        int nb;
        boolean isXAxis = axis instanceof XAxis;
        ArrayList<PlotBaseAbstract> plotList = axis.getPlots();
        int n = nb = plotList != null ? plotList.size() : 0;
        if (nb > 0) {
            if (isXAxis) {
                double minX = plotList.get(0).getXMin();
                double maxX = plotList.get(0).getXMax();
                for (int k = 1; k < nb; ++k) {
                    double plotXMin = plotList.get(k).getXMin();
                    double plotXMax = plotList.get(k).getXMax();
                    if (plotXMin == 0.0 && plotXMax == 0.0) continue;
                    if (minX == 0.0 && maxX == 0.0) {
                        minX = plotXMin;
                        maxX = plotXMax;
                    }
                    minX = Math.min(minX, plotXMin);
                    maxX = Math.max(maxX, plotXMax);
                }
                this.m_resMinMax[0] = minX;
                this.m_resMinMax[1] = maxX;
            } else {
                double minY = plotList.get(0).getYMin();
                double maxY = plotList.get(0).getYMax();
                for (int k = 1; k < nb; ++k) {
                    double plotYMin = plotList.get(k).getYMin();
                    double plotYMax = plotList.get(k).getYMax();
                    if (plotYMin == 0.0 && plotYMax == 0.0) continue;
                    if (minY == 0.0 && maxY == 0.0) {
                        minY = plotYMin;
                        maxY = plotYMax;
                    }
                    minY = Math.min(minY, plotYMin);
                    maxY = Math.max(maxY, plotYMax);
                }
                this.m_resMinMax[0] = minY;
                this.m_resMinMax[1] = maxY;
            }
        }
        return this.m_resMinMax;
    }

    public void updateAxis(PlotBaseAbstract plot) {
        this.updateAxis(plot.getDoubleBufferingPolicy());
    }

    private void updateAxis(boolean useDoubleBuffering) {
        this.updateAxis();
        this.m_useDoubleBuffering = useDoubleBuffering;
    }

    public void updateAxis() {
        this.m_isEnumAxisUpdated = false;
        XAxis xAxis = this.getXAxis();
        double[] resMinMax = this.getMinMaxPlots(xAxis);
        xAxis.setSelected(false);
        xAxis.setRange(Double.isNaN(this.m_xAxisBounds[0]) ? resMinMax[0] : this.m_xAxisBounds[0], Double.isNaN(this.m_xAxisBounds[1]) ? resMinMax[1] : this.m_xAxisBounds[1]);
        YAxis yAxis = this.getYAxis();
        resMinMax = this.getMinMaxPlots(yAxis);
        yAxis.setSelected(false);
        yAxis.setRange(Double.isNaN(this.m_yAxisBounds[0]) ? resMinMax[0] : this.m_yAxisBounds[0], Double.isNaN(this.m_yAxisBounds[1]) ? resMinMax[1] : this.m_yAxisBounds[1]);
        YAxis rightYAxis = this.getYAxisRight();
        if (rightYAxis.hasPlots()) {
            resMinMax = this.getMinMaxPlots(rightYAxis);
            rightYAxis.setSelected(false);
            rightYAxis.setRange(Double.isNaN(this.m_yAxisRightBounds[0]) ? resMinMax[0] : this.m_yAxisRightBounds[0], Double.isNaN(this.m_yAxisRightBounds[1]) ? resMinMax[1] : this.m_yAxisRightBounds[1]);
        }
        this.m_updateDoubleBuffer = true;
        this.m_viewAllPanel.updateDoubleBuffer();
        this.m_viewAllPanel.setSelected(false, false);
    }

    public void setXAxisTitle(String title) {
        if (this.m_xAxis == null) {
            return;
        }
        this.m_xAxis.setTitle(title);
    }

    public void setXAxisBounds(double min, double max) {
        this.m_xAxisBounds = new double[]{min, max};
        if (this.getXAxis().hasPlots()) {
            this.updateAxis(this.getXAxis().getPlots().get(0));
        }
    }

    public double[] getXAxisBounds() {
        return new double[]{this.m_xAxisBounds[0], this.m_xAxisBounds[1]};
    }

    public double[] getYAxisBounds() {
        return new double[]{this.m_yAxisBounds[0], this.m_yAxisBounds[1]};
    }

    public double[] getYAxisRightBounds() {
        return new double[]{this.m_yAxisRightBounds[0], this.m_yAxisRightBounds[1]};
    }

    public void setYAxisBounds(double min, double max) {
        this.m_yAxisBounds = new double[]{min, max};
        if (this.getXAxis().hasPlots()) {
            this.updateAxis(this.getXAxis().getPlots().get(0));
        }
    }

    public void setYAxisRightBounds(double min, double max) {
        this.m_yAxisRightBounds = new double[]{min, max};
        if (this.getXAxis().hasPlots()) {
            this.updateAxis(this.getXAxis().getPlots().get(0));
        }
    }

    public void setYAxisTitle(String title) {
        this.getYAxis().setTitle(title);
    }

    public void setYAxisRightTitle(String title) {
        this.getYAxisRight().setTitle(title);
    }

    public XAxis getXAxis() {
        if (this.m_xAxis == null) {
            this.m_xAxis = new XAxis(this);
        }
        return this.m_xAxis;
    }

    public YAxis getYAxis() {
        if (this.m_yAxis == null) {
            this.m_yAxis = new YAxis(this);
        }
        return this.m_yAxis;
    }

    public YAxis getYAxisRight() {
        if (this.m_yAxisRight == null) {
            this.m_yAxisRight = new YAxis(this);
            this.m_yAxisRight.setSecondAxis();
        }
        return this.m_yAxisRight;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            for (PlotBaseAbstract plot : this.getXAxis().getPlots()) {
                plot.doubleClicked(e.getX(), e.getY());
            }
        }
        if (this.m_xAxis != null && this.m_yAxis != null) {
            double xValue = this.m_xAxis.pixelToValue(e.getX());
            double yValue = this.m_yAxis.pixelToValue(e.getY());
            this.fireMouseClicked(e, xValue, yValue);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int y;
        if (this.m_drawCursor) {
            this.setCursor(new Cursor(0));
        }
        if (!this.getXAxis().hasPlots()) {
            return;
        }
        int x = e.getX();
        if (this.insidePlotArea(x, y = e.getY())) {
            if (this.m_xAxis != null) {
                this.m_xAxis.setSelected(false);
            }
            if (this.m_yAxis != null) {
                this.m_yAxis.setSelected(false);
            }
            if (this.m_yAxisRight != null) {
                this.m_yAxisRight.setSelected(false);
            }
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (this.m_mouseMode == MOUSE_MODE.SELECTION_MODE) {
                    this.m_selectionGesture.startSelection(x, y);
                } else {
                    MoveableInterface movable = null;
                    PlotBaseAbstract plotWithMovable = null;
                    movable = this.m_viewAllPanel.getOverMovable(x, y);
                    if (movable != null) {
                        movable.setSelected(true, false);
                    }
                    if (movable == null) {
                        this.m_viewAllPanel.setSelected(false, false);
                        for (PlotBaseAbstract plot : this.getXAxis().getPlots()) {
                            movable = plot.getOverMovable(x, y);
                            if (movable == null) continue;
                            plotWithMovable = plot;
                            break;
                        }
                    }
                    if (movable == null) {
                        movable = this;
                    }
                    if (movable != null) {
                        this.m_moveGesture.startMoving(x, y, movable);
                        if (movable instanceof AbstractCursor) {
                            plotWithMovable.selectCursor((AbstractCursor)movable);
                        }
                        this.setCursor(new Cursor(13));
                    }
                }
            } else if (SwingUtilities.isRightMouseButton(e)) {
                this.m_zoomGesture.startZooming(x, y, !this.m_viewAllPanel.insideXY(x, y));
            }
            this.repaint();
        } else if (!SwingUtilities.isRightMouseButton(e) && this.m_xAxis != null && this.m_xAxis.inside(x, y)) {
            this.m_panAxisGesture.startPanning(x, y, 0);
        } else if (!SwingUtilities.isRightMouseButton(e) && this.m_yAxis != null && this.m_yAxis.inside(x, y)) {
            this.m_panAxisGesture.startPanning(x, y, 1);
        } else if (!SwingUtilities.isRightMouseButton(e) && this.m_yAxisRight != null && this.m_yAxisRight.inside(x, y)) {
            this.m_panAxisGesture.startPanning(x, y, 2);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.m_drawCursor) {
            this.setCursor(new Cursor(0));
        }
        boolean mustRepaint = false;
        int x = e.getX();
        int y = e.getY();
        if (e.isPopupTrigger() && !this.m_panAxisGesture.isPanning() && !this.m_zoomGesture.isZooming()) {
            JPopupMenu popup;
            if (this.m_xAxis != null && this.m_yAxis != null && this.m_xAxis.inside(x, y)) {
                this.m_xAxis.setSelected(true);
                this.m_yAxis.setSelected(false);
                this.m_yAxisRight.setSelected(false);
                popup = this.createAxisPopup(this.m_xAxis, null, x, y);
                popup.show((JComponent)e.getSource(), x, y);
                mustRepaint = true;
            } else if (this.m_xAxis != null && this.m_yAxis != null && this.m_yAxis.inside(x, y)) {
                this.m_xAxis.setSelected(false);
                this.m_yAxis.setSelected(true);
                this.m_yAxisRight.setSelected(false);
                popup = this.createAxisPopup(this.m_yAxis, this.getYAxisRight().hasPlots() ? this.getYAxisRight() : null, x, y);
                popup.show((JComponent)e.getSource(), x, y);
                mustRepaint = true;
            }
        } else if (!(this.m_zoomGesture.isZooming() || this.m_selectionGesture.isSelecting() || this.m_moveGesture.isMoving() || this.m_panAxisGesture.getAction() == 1)) {
            if (this.m_xAxis != null && this.m_xAxis.inside(x, y)) {
                mustRepaint |= this.m_xAxis.setSelected(!this.m_xAxis.isSelected());
                mustRepaint |= this.m_yAxis.setSelected(false);
            } else if (this.m_yAxis != null && this.m_yAxis.inside(x, y)) {
                mustRepaint |= this.m_xAxis.setSelected(false);
                mustRepaint |= this.m_yAxis.setSelected(!this.m_yAxis.isSelected());
            } else if (this.m_yAxisRight != null && this.m_yAxisRight.inside(x, y)) {
                mustRepaint |= this.m_xAxis.setSelected(false);
                mustRepaint |= this.m_yAxis.setSelected(false);
                mustRepaint |= this.m_yAxisRight.setSelected(!this.m_yAxisRight.isSelected());
            }
            if (mustRepaint) {
                this.repaint();
            }
        }
        if (this.m_moveGesture.isMoving()) {
            int modifier = e.getModifiers();
            boolean isCtrlOrShiftDown = (modifier & 3) != 0;
            this.m_moveGesture.stopMoving(x, y, isCtrlOrShiftDown);
            this.setCursor(new Cursor(0));
            this.m_updateDoubleBuffer = true;
            mustRepaint = true;
        } else if (this.m_selectionGesture.isSelecting()) {
            this.m_selectionGesture.stopSelection(x, y);
            int modifier = e.getModifiers();
            boolean isCtrlOrShiftDown = (modifier & 3) != 0;
            int action = this.m_selectionGesture.getAction();
            if (action == 1) {
                Point p = this.m_selectionGesture.getClickPoint();
                double valueX = this.m_xAxis.pixelToValue(p.x);
                double valueY = this.m_yAxis.pixelToValue(p.y);
                if (this.getXAxis().hasPlots()) {
                    this.getXAxis().getPlots().get(0).select(valueX, valueY, isCtrlOrShiftDown);
                }
                this.m_updateDoubleBuffer = true;
                this.m_viewAllPanel.updateDoubleBuffer();
                mustRepaint = true;
            } else if (action == 2) {
                Path2D.Double path = new Path2D.Double();
                Polygon p = this.m_selectionGesture.getSelectionPolygon();
                double valueX = this.m_xAxis.pixelToValue(p.xpoints[0]);
                double valueY = this.m_yAxis.pixelToValue(p.ypoints[0]);
                path.moveTo(valueX, valueY);
                for (int i = 1; i < p.npoints; ++i) {
                    valueX = this.m_xAxis.pixelToValue(p.xpoints[i]);
                    valueY = this.m_yAxis.pixelToValue(p.ypoints[i]);
                    path.lineTo(valueX, valueY);
                }
                path.closePath();
                double xMin = this.m_xAxis.pixelToValue(this.m_selectionGesture.getMinX());
                double xMax = this.m_xAxis.pixelToValue(this.m_selectionGesture.getMaxX());
                double yMin = this.m_yAxis.pixelToValue(this.m_selectionGesture.getMaxY());
                double yMax = this.m_yAxis.pixelToValue(this.m_selectionGesture.getMinY());
                if (this.getXAxis().hasPlots()) {
                    this.getXAxis().getPlots().get(0).select(path, xMin, xMax, yMin, yMax, isCtrlOrShiftDown);
                }
                this.m_updateDoubleBuffer = true;
                this.m_viewAllPanel.updateDoubleBuffer();
                mustRepaint = true;
            }
        } else if (this.m_zoomGesture.isZooming()) {
            double yValue;
            double xValue;
            PlotBaseAbstract plot;
            JPopupMenu popup;
            this.m_zoomGesture.stopZooming(e.getX(), e.getY());
            int action = this.m_zoomGesture.getAction();
            if (action == 1) {
                double oldMinX = this.m_xAxis.getMinValue();
                double oldMaxX = this.m_xAxis.getMaxValue();
                double oldMinY = this.m_yAxis.getMinValue();
                double oldMaxY = this.m_yAxis.getMaxValue();
                boolean isBasePlot = this.m_zoomGesture.isBasePlot();
                if (!isBasePlot) {
                    double[] resMinMax = this.getMinMaxPlots(this.m_xAxis);
                    this.m_xAxis.setRange(resMinMax[0], resMinMax[1]);
                    resMinMax = this.getMinMaxPlots(this.m_yAxis);
                    this.m_yAxis.setRange(resMinMax[0], resMinMax[1]);
                    if (this.m_yAxisRight.hasPlots()) {
                        resMinMax = this.getMinMaxPlots(this.m_yAxisRight);
                        this.m_yAxisRight.setRange(resMinMax[0], resMinMax[1]);
                    }
                }
                int startX = isBasePlot ? this.m_zoomGesture.getStartX() : this.m_viewAllPanel.convertToBasePlotX(this.m_zoomGesture.getStartX());
                int endX = isBasePlot ? this.m_zoomGesture.getEndX() : this.m_viewAllPanel.convertToBasePlotX(this.m_zoomGesture.getEndX());
                int startY = isBasePlot ? this.m_zoomGesture.getStartY() : this.m_viewAllPanel.convertToBasePlotY(this.m_zoomGesture.getStartY());
                int endY = isBasePlot ? this.m_zoomGesture.getEndY() : this.m_viewAllPanel.convertToBasePlotY(this.m_zoomGesture.getEndY());
                this.m_xAxis.setRange(this.m_xAxis.pixelToValue(startX), this.m_xAxis.pixelToValue(endX), true);
                this.m_yAxis.setRange(this.m_yAxis.pixelToValue(endY), this.m_yAxis.pixelToValue(startY), true);
                this.m_yAxisRight.setRange(this.m_yAxisRight.pixelToValue(endY), this.m_yAxisRight.pixelToValue(startY), true);
                this.m_updateDoubleBuffer = true;
                this.fireUpdateAxisRange(oldMinX, oldMaxX, this.m_xAxis.getMinValue(), this.m_xAxis.getMaxValue(), oldMinY, oldMaxY, this.m_yAxis.getMinValue(), this.m_yAxis.getMaxValue());
            } else if (action == 2) {
                if (this.getXAxis().hasPlots()) {
                    double oldMinX = this.m_xAxis.getMinValue();
                    double oldMaxX = this.m_xAxis.getMaxValue();
                    double oldMinY = this.m_yAxis.getMinValue();
                    double oldMaxY = this.m_yAxis.getMaxValue();
                    this.updateAxis(this.getXAxis().getPlots().get(0));
                    this.fireUpdateAxisRange(oldMinX, oldMaxX, this.m_xAxis.getMinValue(), this.m_xAxis.getMaxValue(), oldMinY, oldMaxY, this.m_yAxis.getMinValue(), this.m_yAxis.getMaxValue());
                    this.getXAxis().setRangeModifiedByUser(false);
                    this.getYAxis().setRangeModifiedByUser(false);
                    if (this.m_yAxisRight != null) {
                        this.m_yAxisRight.setRangeModifiedByUser(false);
                    }
                }
                this.m_updateDoubleBuffer = true;
            } else if (e.isPopupTrigger() && this.getXAxis().hasPlots() && (popup = (plot = this.getXAxis().getPlots().get(0)).getPopupMenu(xValue = this.m_xAxis.pixelToValue(e.getX()), yValue = this.m_yAxis.pixelToValue(e.getY()))) != null) {
                popup.show((JComponent)e.getSource(), e.getX(), e.getY());
            }
            mustRepaint = true;
        } else if (this.m_panAxisGesture.isPanning()) {
            this.m_panAxisGesture.stopPanning(e.getX(), e.getY());
        }
        if (mustRepaint) {
            this.repaint();
        }
    }

    public void repaintUpdateDoubleBuffer() {
        this.m_updateDoubleBuffer = true;
        this.repaint();
    }

    public void zoomIn() {
        this.zoom(true, true, true, this.getYAxisRight().hasPlots(), null, null);
    }

    public void zoomOut() {
        this.zoom(false, true, true, this.getYAxisRight().hasPlots(), null, null);
    }

    private void zoom(boolean zoomIn, boolean zoomX, boolean zoomY, boolean zoomYRight, Integer fixedCoordinateX, Integer fixedCoordinateY) {
        if (!this.getXAxis().hasPlots()) {
            return;
        }
        if (!zoomIn && zoomX && this.m_xAxis.isMaxZoomOutReached()) {
            return;
        }
        if (!zoomIn && zoomY && this.m_yAxis.isMaxZoomOutReached()) {
            return;
        }
        int zoomDirection = zoomIn ? -1 : 1;
        double fixedX = 0.0;
        double fixedY = 0.0;
        double fixedYRight = 0.0;
        if (fixedCoordinateX != null && zoomX) {
            fixedX = this.m_xAxis.pixelToValue(fixedCoordinateX);
        }
        if (fixedCoordinateY != null) {
            if (zoomY) {
                fixedY = this.m_yAxis.pixelToValue(fixedCoordinateY);
            }
            if (zoomYRight) {
                fixedYRight = this.m_yAxisRight.pixelToValue(fixedCoordinateY);
            }
        }
        double oldMinX = this.m_xAxis.getMinValue();
        double oldMaxX = this.m_xAxis.getMaxValue();
        if (zoomX) {
            double newXmax;
            double newXmin;
            boolean doZoom = true;
            if (this.m_xAxis.isLog()) {
                double factorMin;
                double factorMax;
                if (zoomDirection == 1) {
                    factorMax = 5.0;
                    factorMin = 0.2;
                } else {
                    factorMin = 5.0;
                    factorMax = 0.2;
                }
                newXmin = oldMinX * factorMin;
                newXmax = oldMaxX * factorMax;
                doZoom = newXmax / newXmin >= 2.0;
            } else {
                double factor = 0.2 * (double)zoomDirection;
                double xValue = (oldMinX + oldMaxX) / 2.0;
                newXmin = oldMinX + (oldMinX - xValue) * factor;
                newXmax = oldMaxX - (xValue - oldMaxX) * factor;
            }
            if (doZoom) {
                this.m_xAxis.setRange(newXmin, newXmax, true);
                if (fixedCoordinateX != null) {
                    if (this.m_xAxis.isLog()) {
                        int coordinateNowX = this.m_xAxis.valueToPixel(fixedX);
                        double mult = this.m_xAxis.deltaPixelToLogMultValue(fixedCoordinateX - coordinateNowX);
                        this.m_xAxis.setRange(this.m_xAxis.getMinValue() / mult, this.m_xAxis.getMaxValue() / mult, true);
                    } else {
                        double valueTranslated = this.m_xAxis.pixelToValue(fixedCoordinateX);
                        this.m_xAxis.setRange(newXmin + (fixedX - valueTranslated), newXmax + (fixedX - valueTranslated), true);
                    }
                }
            }
        }
        double oldMinY = this.m_yAxis.getMinValue();
        double oldMaxY = this.m_yAxis.getMaxValue();
        if (zoomY) {
            double newYmax;
            double newYmin;
            boolean doZoom = true;
            if (this.m_yAxis.isLog()) {
                double factorMin;
                double factorMax;
                if (zoomDirection == 1) {
                    factorMax = 5.0;
                    factorMin = 0.2;
                } else {
                    factorMin = 5.0;
                    factorMax = 0.2;
                }
                newYmin = oldMinY * factorMin;
                newYmax = oldMaxY * factorMax;
                doZoom = newYmax / newYmin >= 2.0;
            } else {
                double factor = 0.2 * (double)zoomDirection;
                double yValue = (oldMinY + oldMaxY) / 2.0;
                newYmin = oldMinY + (oldMinY - yValue) * factor;
                newYmax = oldMaxY - (yValue - oldMaxY) * factor;
            }
            if (doZoom) {
                this.m_yAxis.setRange(newYmin, newYmax, true);
                if (fixedCoordinateY != null) {
                    if (this.m_yAxis.isLog()) {
                        int coordinateNowY = this.m_yAxis.valueToPixel(fixedY);
                        double mult = this.m_yAxis.deltaPixelToLogMultValue(coordinateNowY - fixedCoordinateY);
                        this.m_yAxis.setRange(this.m_yAxis.getMinValue() / mult, this.m_yAxis.getMaxValue() / mult, true);
                    } else {
                        double valueTranslated = this.m_yAxis.pixelToValue(fixedCoordinateY);
                        this.m_yAxis.setRange(newYmin + (fixedY - valueTranslated), newYmax + (fixedY - valueTranslated), true);
                    }
                }
            }
        }
        double oldMinYRight = this.m_yAxisRight.getMinValue();
        double oldMaxYRight = this.m_yAxisRight.getMaxValue();
        if (zoomYRight) {
            double newYmax;
            double newYmin;
            boolean doZoom = true;
            if (this.m_yAxisRight.isLog()) {
                double factorMin;
                double factorMax;
                if (zoomDirection == 1) {
                    factorMax = 5.0;
                    factorMin = 0.2;
                } else {
                    factorMin = 5.0;
                    factorMax = 0.2;
                }
                newYmin = oldMinYRight * factorMin;
                newYmax = oldMaxYRight * factorMax;
                doZoom = newYmax / newYmin >= 2.0;
            } else {
                double factor = 0.2 * (double)zoomDirection;
                double yValue = (oldMinYRight + oldMaxYRight) / 2.0;
                newYmin = oldMinYRight + (oldMinYRight - yValue) * factor;
                newYmax = oldMaxYRight - (yValue - oldMaxYRight) * factor;
            }
            if (doZoom) {
                this.m_yAxisRight.setRange(newYmin, newYmax, true);
                if (fixedCoordinateY != null) {
                    if (this.m_yAxis.isLog()) {
                        int coordinateNowY = this.m_yAxisRight.valueToPixel(fixedYRight);
                        double mult = this.m_yAxisRight.deltaPixelToLogMultValue(coordinateNowY - fixedCoordinateY);
                        this.m_yAxisRight.setRange(this.m_yAxisRight.getMinValue() / mult, this.m_yAxisRight.getMaxValue() / mult, true);
                    } else {
                        double valueTranslated = this.m_yAxisRight.pixelToValue(fixedCoordinateY);
                        this.m_yAxisRight.setRange(newYmin + (fixedYRight - valueTranslated), newYmax + (fixedYRight - valueTranslated), true);
                    }
                }
            }
        }
        this.repaintUpdateDoubleBuffer();
        this.fireUpdateAxisRange(oldMinX, oldMaxX, this.m_xAxis.getMinValue(), this.m_xAxis.getMaxValue(), oldMinY, oldMaxY, this.m_yAxis.getMinValue(), this.m_yAxis.getMaxValue());
    }

    public void viewAll() {
        for (PlotBaseAbstract plot : this.getXAxis().getPlots()) {
            this.updateAxis(plot.getDoubleBufferingPolicy());
        }
        this.getXAxis().setRangeModifiedByUser(false);
        this.getYAxis().setRangeModifiedByUser(false);
        if (this.m_yAxisRight != null) {
            this.m_yAxisRight.setRangeModifiedByUser(false);
        }
        this.repaint();
    }

    public void addListener(PlotPanelListener listener) {
        this.m_listeners.add(listener);
    }

    private void fireMouseClicked(MouseEvent e, double xValue, double yValue) {
        for (PlotPanelListener l : this.m_listeners) {
            l.plotPanelMouseClicked(e, xValue, yValue);
        }
    }

    private void fireUpdateAxisRange(double oldMinX, double oldMaxX, double newMinX, double newMaxX, double oldMinY, double oldMaxY, double newMinY, double newMaxY) {
        double[] oldX = new double[]{oldMinX, oldMaxX};
        double[] newX = new double[]{newMinX, newMaxX};
        double[] oldY = new double[]{oldMinY, oldMaxY};
        double[] newY = new double[]{newMinY, newMaxY};
        for (PlotPanelListener l : this.m_listeners) {
            l.updateAxisRange(oldX, newX, oldY, newY);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.m_drawCursor) {
            this.m_coordX = "";
            this.m_coordY = "";
            this.repaint();
            this.setCursor(new Cursor(0));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.m_drawCursor) {
            this.setCursor(new Cursor(0));
        }
        if (this.m_moveGesture.isMoving()) {
            this.m_moveGesture.move(e.getX(), e.getY());
            this.repaint();
        } else if (this.m_selectionGesture.isSelecting()) {
            this.m_selectionGesture.continueSelection(e.getX(), e.getY());
            this.repaint();
        } else if (this.m_zoomGesture.isZooming()) {
            this.m_zoomGesture.moveZooming(e.getX(), e.getY());
            this.repaint();
        } else if (this.m_xAxis != null && this.m_yAxis != null && this.m_panAxisGesture.isPanning()) {
            double oldMinX = this.m_xAxis.getMinValue();
            double oldMaxX = this.m_xAxis.getMaxValue();
            double oldMinY = this.m_yAxis.getMinValue();
            double oldMaxY = this.m_yAxis.getMaxValue();
            if (this.m_panAxisGesture.getPanningAxis() == 0) {
                if (this.m_xAxis.isLog()) {
                    double mult = this.m_xAxis.deltaPixelToLogMultValue(e.getX() - this.m_panAxisGesture.getPreviousX());
                    this.m_xAxis.setRange(this.m_xAxis.getMinValue() / mult, this.m_xAxis.getMaxValue() / mult, true);
                } else {
                    double delta = this.m_xAxis.deltaPixelToDeltaValue(this.m_panAxisGesture.getPreviousX() - e.getX());
                    this.m_xAxis.setRange(this.m_xAxis.getMinValue() + delta, this.m_xAxis.getMaxValue() + delta, true);
                }
                this.fireUpdateAxisRange(oldMinX, oldMaxX, this.m_xAxis.getMinValue(), this.m_xAxis.getMaxValue(), oldMinY, oldMaxY, this.m_yAxis.getMinValue(), this.m_yAxis.getMaxValue());
            } else if (this.m_panAxisGesture.getPanningAxis() == 2) {
                if (this.m_yAxisRight.isLog()) {
                    double mult = this.m_yAxisRight.deltaPixelToLogMultValue(this.m_panAxisGesture.getPreviousY() - e.getY());
                    this.m_yAxisRight.setRange(this.m_yAxisRight.getMinValue() / mult, this.m_yAxisRight.getMaxValue() / mult, true);
                } else {
                    double delta = this.m_yAxisRight.deltaPixelToDeltaValue(this.m_panAxisGesture.getPreviousY() - e.getY());
                    this.m_yAxisRight.setRange(this.m_yAxisRight.getMinValue() + delta, this.m_yAxisRight.getMaxValue() + delta, true);
                }
            } else {
                if (this.m_yAxis.isLog()) {
                    double mult = this.m_yAxis.deltaPixelToLogMultValue(this.m_panAxisGesture.getPreviousY() - e.getY());
                    this.m_yAxis.setRange(this.m_yAxis.getMinValue() / mult, this.m_yAxis.getMaxValue() / mult, true);
                } else {
                    double delta = this.m_yAxis.deltaPixelToDeltaValue(this.m_panAxisGesture.getPreviousY() - e.getY());
                    this.m_yAxis.setRange(this.m_yAxis.getMinValue() + delta, this.m_yAxis.getMaxValue() + delta, true);
                }
                this.fireUpdateAxisRange(oldMinX, oldMaxX, this.m_xAxis.getMinValue(), this.m_xAxis.getMaxValue(), oldMinY, oldMaxY, this.m_yAxis.getMinValue(), this.m_yAxis.getMaxValue());
            }
            this.m_panAxisGesture.movePan(e.getX(), e.getY());
            this.m_updateDoubleBuffer = true;
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        String toolTipForPlot;
        boolean isPlotSelected;
        double yValue;
        boolean isInGridArea;
        if (!this.getXAxis().hasPlots() || e == null) {
            this.m_coordX = "";
            this.m_coordY = "";
            if (this.m_drawCursor) {
                this.repaint();
            }
            return;
        }
        if (this.m_xAxis == null || this.m_yAxis == null) {
            return;
        }
        int mouseX = e.getX();
        int mouseY = e.getY();
        double xValue = this.m_xAxis.pixelToValue(mouseX);
        boolean bl = isInGridArea = mouseX <= this.m_plotArea.width + this.m_plotArea.x && mouseX >= this.m_plotArea.x && mouseY >= this.m_plotArea.y && mouseY <= this.m_plotArea.height + this.m_plotArea.y;
        if (!isInGridArea) {
            this.m_coordX = "";
            this.m_coordY = "";
            if (this.m_xAxis.inside(mouseX, mouseY)) {
                this.setCursor(new Cursor(10));
            } else if (this.m_yAxis.inside(mouseX, mouseY)) {
                this.setCursor(new Cursor(8));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else {
            double yValue2 = this.m_yAxis.pixelToValue(mouseY);
            this.setCursor(new Cursor(0));
            if (this.m_drawCursor) {
                this.setCursor(new Cursor(1));
                this.m_coordX = xValue > -0.1 && xValue < 0.1 || xValue >= 10000.0 || xValue <= -10000.0 ? formatE.format(xValue) : format.format(xValue);
                this.m_coordY = yValue2 > -0.1 && yValue2 < 0.1 || yValue2 >= 10000.0 || yValue2 <= -10000.0 ? formatE.format(yValue2) : format.format(yValue2);
                this.m_posx = mouseX;
                this.m_posy = mouseY;
            }
        }
        int nbPlotTooltip = 0;
        boolean repaintNeeded = false;
        for (PlotBaseAbstract plot : this.getYAxis().getPlots()) {
            yValue = this.m_yAxis.pixelToValue(mouseY);
            isPlotSelected = isInGridArea && plot.isMouseOnPlot(xValue, yValue);
            repaintNeeded |= plot.setIsPaintMarker(isPlotSelected);
            toolTipForPlot = isInGridArea ? plot.getToolTipText(xValue, yValue) : null;
            if (toolTipForPlot == null || toolTipForPlot.isEmpty()) continue;
            if (nbPlotTooltip == 0) {
                this.m_sbTooltip.append("<html>");
            }
            if (nbPlotTooltip < 3) {
                this.m_sbTooltip.append(toolTipForPlot);
                this.m_sbTooltip.append("<br/>");
            }
            ++nbPlotTooltip;
        }
        for (PlotBaseAbstract plot : this.getYAxisRight().getPlots()) {
            yValue = this.getYAxisRight().pixelToValue(mouseY);
            isPlotSelected = isInGridArea && plot.isMouseOnPlot(xValue, yValue);
            repaintNeeded |= plot.setIsPaintMarker(isPlotSelected);
            toolTipForPlot = isInGridArea ? plot.getToolTipText(xValue, yValue) : null;
            if (toolTipForPlot == null || toolTipForPlot.isEmpty()) continue;
            if (nbPlotTooltip == 0) {
                this.m_sbTooltip.append("<html>");
            }
            if (nbPlotTooltip < 3) {
                this.m_sbTooltip.append(toolTipForPlot);
                this.m_sbTooltip.append("<br/>");
            }
            ++nbPlotTooltip;
        }
        if (nbPlotTooltip >= 3) {
            this.m_sbTooltip.append("[...]");
        }
        if (nbPlotTooltip > 0) {
            this.m_sbTooltip.append("</html>");
            this.setToolTipText(this.m_sbTooltip.toString());
            this.m_sbTooltip.setLength(0);
        } else {
            this.setToolTipText(null);
        }
        if (repaintNeeded) {
            this.repaintUpdateDoubleBuffer();
        } else if (this.m_drawCursor) {
            this.repaint();
        }
    }

    private JPopupMenu createAxisPopup(final Axis axis, YAxis secondAxis, int x, int y) {
        boolean isXAxis = axis.equals(this.m_xAxis);
        JPopupMenu popup = new JPopupMenu();
        popup.add(new LogAction(axis, isXAxis, secondAxis));
        popup.add(new TitleAction(axis, isXAxis ? null : this.m_yAxisRight));
        popup.add(new GridAction(axis.equals(this.m_xAxis)));
        popup.add(new RangeAction(axis, axis.equals(this.m_xAxis)));
        ArrayList<AbstractMeasurement> measurements = new ArrayList<AbstractMeasurement>();
        for (PlotBaseAbstract plot : this.getXAxis().getPlots()) {
            plot.getMeasurements(measurements, isXAxis ? AbstractMeasurement.MeasurementType.X_AXIS_POPUP : AbstractMeasurement.MeasurementType.Y_AXIS_POPUP);
        }
        if (measurements.size() > 0) {
            popup.addSeparator();
            for (AbstractMeasurement measurement : measurements) {
                popup.add(new MeasurementAction(measurement, x, y));
            }
        }
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                axis.setSelected(false);
                BasePlotPanel.this.repaint();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        return popup;
    }

    @Override
    public String getEnumValueX(int index, boolean fromData) {
        if (!this.getXAxis().hasPlots()) {
            return null;
        }
        return this.getXAxis().getPlots().get(0).getEnumValueX(index, fromData);
    }

    @Override
    public String getEnumValueY(int index, boolean fromData, Axis axis) {
        if (!axis.hasPlots()) {
            return null;
        }
        return axis.getPlots().get(0).getEnumValueY(index, fromData, axis);
    }

    public double getNearestXData(double x) {
        if (!this.getXAxis().hasPlots()) {
            return x;
        }
        return this.getXAxis().getPlots().get(0).getNearestXData(x);
    }

    public double getNearestYData(double y) {
        if (!this.getXAxis().hasPlots()) {
            return y;
        }
        return this.getXAxis().getPlots().get(0).getNearestYData(y);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        boolean isCtrlOrShiftDown;
        if (!this.getXAxis().hasPlots() || e == null) {
            return;
        }
        if (!this.getXAxis().getPlots().get(0).isMouseWheelSupported()) {
            return;
        }
        Integer fixedCoordinateX = null;
        Integer fixedCoordinateY = null;
        boolean zoomX = false;
        boolean zoomY = false;
        boolean zoomYRight = false;
        int modifier = e.getModifiers();
        boolean bl = isCtrlOrShiftDown = (modifier & 3) != 0;
        if (this.insidePlotArea(e.getX(), e.getY())) {
            zoomX = true;
            zoomY = true;
            zoomYRight = this.getYAxisRight().hasPlots();
            if (isCtrlOrShiftDown) {
                fixedCoordinateX = e.getX();
                fixedCoordinateY = e.getY();
            }
        } else if (this.m_xAxis != null && this.m_xAxis.inside(e.getX(), e.getY())) {
            zoomX = true;
            if (isCtrlOrShiftDown) {
                fixedCoordinateX = e.getX();
            }
        } else if (this.m_yAxis != null && this.m_yAxis.inside(e.getX(), e.getY())) {
            zoomY = true;
            if (isCtrlOrShiftDown) {
                fixedCoordinateY = e.getY();
            }
        } else if (this.m_yAxisRight != null && this.m_yAxisRight.inside(e.getX(), e.getY())) {
            zoomYRight = true;
            if (isCtrlOrShiftDown) {
                fixedCoordinateY = e.getY();
            }
        }
        this.zoom(e.getWheelRotation() < 0, zoomX, zoomY, zoomYRight, fixedCoordinateX, fixedCoordinateY);
    }

    public void setAxisXSpecificities(boolean isIntegerY, boolean isEnum, boolean isPixel) {
        XAxis axis = this.getXAxis();
        axis.setSpecificities(isIntegerY, isEnum, isPixel);
    }

    public void setAxisYSpecificities(boolean isIntegerY, boolean isEnum, boolean isPixel, PlotBaseAbstract plot) {
        YAxis yAxis = this.getYAxis();
        if (yAxis.hasPlot(plot)) {
            yAxis.setSpecificities(isIntegerY, isEnum, isPixel);
            return;
        }
        yAxis = this.getYAxisRight();
        if (yAxis.hasPlot(plot)) {
            yAxis.setSpecificities(isIntegerY, isEnum, isPixel);
            return;
        }
    }

    private boolean insidePlotArea(int x, int y) {
        return this.insidePlotArea(x, y, this.m_xAxis, this.m_yAxis);
    }

    private boolean insidePlotArea(int x, int y, XAxis xAxis, YAxis yAxis) {
        int x1 = xAxis.valueToPixel(xAxis.getMinValue());
        int x2 = xAxis.valueToPixel(xAxis.getMaxValue());
        int y1 = yAxis.valueToPixel(yAxis.getMaxValue());
        int y2 = yAxis.valueToPixel(yAxis.getMinValue());
        return x >= x1 && x <= x2 && y >= y1 && y <= y2;
    }

    @Override
    public boolean isMoveable() {
        return true;
    }

    @Override
    public void snapToData(boolean isCtrlOrShiftDown) {
    }

    @Override
    public void setSelected(boolean s, boolean isCtrlOrShiftDown) {
    }

    @Override
    public boolean insideXY(int x, int y) {
        return this.insidePlotArea(x, y);
    }

    @Override
    public void moveDXY(int deltaX, int deltaY) {
        double delta;
        double mult;
        double oldMinX = this.m_xAxis.getMinValue();
        double oldMaxX = this.m_xAxis.getMaxValue();
        double oldMinY = this.m_yAxis.getMinValue();
        double oldMaxY = this.m_yAxis.getMaxValue();
        if (this.m_xAxis.isLog()) {
            mult = this.m_xAxis.deltaPixelToLogMultValue(deltaX);
            this.m_xAxis.setRange(this.m_xAxis.getMinValue() / mult, this.m_xAxis.getMaxValue() / mult, true);
        } else {
            delta = this.m_xAxis.deltaPixelToDeltaValue(deltaX);
            this.m_xAxis.setRange(this.m_xAxis.getMinValue() - delta, this.m_xAxis.getMaxValue() - delta, true);
        }
        if (this.m_yAxis.isLog()) {
            mult = this.m_yAxis.deltaPixelToLogMultValue(-deltaY);
            this.m_yAxis.setRange(this.m_yAxis.getMinValue() / mult, this.m_yAxis.getMaxValue() / mult, true);
        } else {
            delta = this.m_yAxis.deltaPixelToDeltaValue(-deltaY);
            this.m_yAxis.setRange(this.m_yAxis.getMinValue() + delta, this.m_yAxis.getMaxValue() + delta, true);
        }
        if (this.m_yAxisRight != null && this.m_yAxisRight.hasPlots()) {
            if (this.m_yAxisRight.isLog()) {
                mult = this.m_yAxisRight.deltaPixelToLogMultValue(-deltaY);
                this.m_yAxisRight.setRange(this.m_yAxisRight.getMinValue() / mult, this.m_yAxisRight.getMaxValue() / mult, true);
            } else {
                delta = this.m_yAxisRight.deltaPixelToDeltaValue(-deltaY);
                this.m_yAxisRight.setRange(this.m_yAxisRight.getMinValue() + delta, this.m_yAxisRight.getMaxValue() + delta, true);
            }
        }
        this.fireUpdateAxisRange(oldMinX, oldMaxX, this.m_xAxis.getMinValue(), this.m_xAxis.getMaxValue(), oldMinY, oldMaxY, this.m_yAxis.getMinValue(), this.m_yAxis.getMaxValue());
        this.m_updateDoubleBuffer = true;
        this.repaint();
    }

    public class FPSUtility {
        private double[] frames;
        private int index = 0;
        private long startTime;

        private FPSUtility(int size) {
            this.frames = new double[size];
            Arrays.fill(this.frames, -1.0);
        }

        private void startFrame() {
            this.startTime = System.currentTimeMillis();
        }

        private void stopFrame() {
            this.frames[this.index++] = System.currentTimeMillis() - this.startTime;
            this.index %= this.frames.length;
        }

        public double getMeanTimePerFrame() {
            int count = 0;
            double sum = 0.0;
            for (double d : this.frames) {
                if (!(d > 0.0)) continue;
                ++count;
                sum += d;
            }
            return sum / (double)count;
        }
    }

    public class RangeAction
    extends AbstractAction {
        private final Axis m_axis;
        private final boolean m_isXAxis;

        public RangeAction(Axis axis, boolean isXAxis) {
            super("Set Visible Range");
            this.m_axis = axis;
            this.m_isXAxis = isXAxis;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Axis.AxisRangePanel panel = this.m_axis.getRangePanel();
            panel.setVisible(true);
            Point p = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(p, this.m_axis.getPlotPanel());
            if (this.m_isXAxis) {
                p.y = this.m_axis.getY() - panel.getHeight();
            }
            if (p.x + panel.getWidth() > BasePlotPanel.this.getWidth()) {
                p.x -= p.x + panel.getWidth() - BasePlotPanel.this.getWidth();
            }
            if (p.x < 0) {
                p.x = 0;
            }
            if (p.y + panel.getHeight() > BasePlotPanel.this.getHeight()) {
                p.y -= p.y + panel.getHeight() - BasePlotPanel.this.getHeight();
            }
            if (p.y < 0) {
                p.y = 0;
            }
            panel.setLocation(p.x, p.y);
        }
    }

    public class GridAction
    extends AbstractAction {
        private final boolean m_xAxis;

        public GridAction(boolean xAxis) {
            super(xAxis ? (BasePlotPanel.this.m_plotVerticalGrid ? "Remove Vertical Grid" : "Add Vertical Grid") : (BasePlotPanel.this.m_plotHorizontalGrid ? "Remove Horizontal Grid" : "Add Horizontal Grid"));
            this.m_xAxis = xAxis;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.m_xAxis) {
                BasePlotPanel.this.m_plotVerticalGrid = !BasePlotPanel.this.m_plotVerticalGrid;
            } else {
                BasePlotPanel.this.m_plotHorizontalGrid = !BasePlotPanel.this.m_plotHorizontalGrid;
            }
            if (BasePlotPanel.this.m_plotToolbarListener != null) {
                BasePlotPanel.this.m_plotToolbarListener.stateModified(PlotToolbarListenerInterface.BUTTONS.GRID);
            }
            BasePlotPanel.this.m_updateDoubleBuffer = true;
            BasePlotPanel.this.repaint();
        }
    }

    public class TitleAction
    extends AbstractAction {
        Axis m_axis1;
        Axis m_axis2;

        public TitleAction(Axis axis1, Axis axis2) {
            super(axis1.displayTitle() ? "Hide Title" : "Display Title");
            this.m_axis1 = axis1;
            this.m_axis2 = axis2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean displayTitle = !this.m_axis1.displayTitle();
            this.m_axis1.setDisplayTitle(displayTitle);
            if (this.m_axis2 != null) {
                this.m_axis2.setDisplayTitle(displayTitle);
            }
            BasePlotPanel.this.m_updateDoubleBuffer = true;
            BasePlotPanel.this.repaint();
        }
    }

    public class LogAction
    extends AbstractAction {
        private final Axis m_axis;
        private final boolean m_isXAxis;
        private final Axis m_secondAxis;

        public LogAction(Axis axis, boolean isXAxis, Axis secondAxis) {
            super(axis.isLog() ? "Linear Axis" : "Log10 Axis");
            this.m_axis = axis;
            this.m_isXAxis = isXAxis;
            this.m_secondAxis = secondAxis;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_axis.setLog(!this.m_axis.isLog());
            if (this.m_secondAxis != null) {
                this.m_secondAxis.setLog(this.m_axis.isLog());
            }
            BasePlotPanel.this.m_updateDoubleBuffer = true;
            BasePlotPanel.this.repaint();
        }

        @Override
        public boolean isEnabled() {
            return this.m_axis.canBeInLog() && (this.m_isXAxis ? BasePlotPanel.this.getXAxis().getPlots().get(0).canLogXAxis() : BasePlotPanel.this.getXAxis().getPlots().get(0).canLogYAxis());
        }
    }

    public class MeasurementAction
    extends AbstractAction {
        private final AbstractMeasurement m_measurement;
        private int m_x;
        private int m_y;

        public MeasurementAction(AbstractMeasurement measurement, int x, int y) {
            super(measurement.getName());
            this.m_measurement = measurement;
            this.m_x = x;
            this.m_y = y;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_measurement.applyMeasurement(this.m_x, this.m_y);
            BasePlotPanel.this.repaint();
        }

        @Override
        public boolean isEnabled() {
            return this.m_measurement.canApply();
        }
    }

    public static enum MOUSE_MODE {
        NORMAL_MODE,
        SELECTION_MODE;

    }
}

