/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.parameter;

import fr.proline.studio.gui.expressionbuilder.ExpressionBuilderPanel;
import fr.proline.studio.gui.expressionbuilder.ExpressionEntity;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.ParameterError;
import java.util.ArrayList;
import javax.swing.JComponent;

public class ExpressionParameter
extends AbstractParameter {
    private ArrayList<ExpressionEntity> m_functions = null;
    private ArrayList<ExpressionEntity> m_variables = null;
    private ArrayList<ExpressionEntity> m_calcFunctions = null;
    private int m_nbButtonsHorizontal;

    public ExpressionParameter(String key, String name, ArrayList<ExpressionEntity> functions, ArrayList<ExpressionEntity> variables, ArrayList<ExpressionEntity> calcFunctions, int nbButtonsHorizontal) {
        super(key, name, String.class, ExpressionBuilderPanel.class);
        this.m_functions = functions;
        this.m_variables = variables;
        this.m_calcFunctions = calcFunctions;
        this.m_nbButtonsHorizontal = nbButtonsHorizontal;
    }

    @Override
    public JComponent getComponent(Object value) {
        if (this.m_parameterComponent != null) {
            return this.m_parameterComponent;
        }
        if (this.m_graphicalType.equals(ExpressionBuilderPanel.class)) {
            ExpressionBuilderPanel expressionBuilderPanel = new ExpressionBuilderPanel(this.m_nbButtonsHorizontal);
            for (ExpressionEntity entity : this.m_functions) {
                expressionBuilderPanel.addFunction(entity);
            }
            for (ExpressionEntity entity : this.m_variables) {
                expressionBuilderPanel.addVariable(entity);
            }
            for (ExpressionEntity entity : this.m_calcFunctions) {
                expressionBuilderPanel.addCalcButton(entity);
            }
            this.m_parameterComponent = expressionBuilderPanel;
            return expressionBuilderPanel;
        }
        return null;
    }

    @Override
    public void initDefault() {
    }

    @Override
    public ParameterError checkParameter() {
        return null;
    }

    @Override
    public String getStringValue() {
        return this.getObjectValue().toString();
    }

    public String getHumanExpression() {
        return ((ExpressionBuilderPanel)this.m_parameterComponent).getDisplayExpression();
    }

    @Override
    public Object getObjectValue() {
        if (this.m_graphicalType.equals(ExpressionBuilderPanel.class) && this.m_parameterComponent != null) {
            return ((ExpressionBuilderPanel)this.m_parameterComponent).getCodeExpression();
        }
        return null;
    }

    @Override
    public void setValue(String v) {
    }

    @Override
    public boolean isEdited() {
        return true;
    }
}

