/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.parameter;

import fr.proline.studio.gui.AdvancedSelectionPanel;
import fr.proline.studio.gui.JCheckBoxList;
import fr.proline.studio.gui.JCheckBoxListPanel;
import fr.proline.studio.parameter.AbstractLinkedParameters;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.AbstractParameterToString;
import fr.proline.studio.parameter.ParameterError;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class MultiObjectParameter<E>
extends AbstractParameter {
    private final E[] m_objects;
    private Object[] m_associatedObjects = null;
    private boolean[] m_defaultSelection = null;
    private ArrayList<AbstractLinkedParameters> m_linkedParametersList = null;
    private int m_nbCompulsorySelection = 1;
    private boolean m_allowSelectAll = true;
    private String m_selectedName;
    private String m_unselectedName;

    public MultiObjectParameter(String key, String name, String selectedName, String unselectedName, Class graphicalType, E[] objects, Object[] associatedObjects, boolean[] selection, AbstractParameterToString<E> paramToString) {
        super(key, name, Integer.class, graphicalType);
        this.m_objects = objects;
        this.m_associatedObjects = associatedObjects;
        this.m_defaultSelection = selection;
        this.m_selectedName = selectedName;
        this.m_unselectedName = unselectedName;
        this.m_labelVisibility = AbstractParameter.LabelVisibility.AS_BORDER_TITLE;
    }

    public MultiObjectParameter(String key, String name, JCheckBoxList checkBoxList, E[] objects, Object[] associatedObjects, boolean[] selection, boolean allowSelectAll) {
        super(key, name, Integer.class, JCheckBoxList.class);
        this.m_objects = objects;
        this.m_defaultSelection = selection;
        this.m_allowSelectAll = allowSelectAll;
        this.m_parameterComponent = checkBoxList == null ? (JCheckBoxListPanel)this.getComponent(null) : new JCheckBoxListPanel(checkBoxList, allowSelectAll);
        this.m_associatedObjects = associatedObjects;
        this.m_labelVisibility = AbstractParameter.LabelVisibility.AS_BORDER_TITLE;
    }

    public void setCompulsory(int nbCompulsorySelection) {
        this.m_compulsory = nbCompulsorySelection > 0;
        this.m_nbCompulsorySelection = nbCompulsorySelection;
    }

    @Override
    public void setCompulsory(boolean v) {
        this.m_compulsory = v;
        this.m_nbCompulsorySelection = 0;
    }

    public void setSelection(int i, boolean v) {
        if (this.m_parameterComponent == null) {
            return;
        }
        if (this.m_graphicalType.equals(JCheckBoxList.class)) {
            JCheckBoxList checkBoxList = ((JCheckBoxListPanel)this.m_parameterComponent).getCheckBoxList();
            checkBoxList.selectItem(i, v);
        } else if (this.m_graphicalType.equals(AdvancedSelectionPanel.class)) {
            // empty if block
        }
    }

    @Override
    public boolean componentNeedsScrollPane() {
        return true;
    }

    @Override
    public JComponent getComponent(Object value) {
        if (this.m_parameterComponent != null && (this.m_graphicalType.equals(JCheckBoxList.class) || this.m_graphicalType.equals(AdvancedSelectionPanel.class))) {
            return this.m_parameterComponent;
        }
        ArrayList<E> list = new ArrayList<E>();
        ArrayList<Boolean> visibilityList = new ArrayList<Boolean>();
        for (int i = 0; i < this.m_objects.length; ++i) {
            E obj = this.m_objects[i];
            list.add(obj);
            if (this.m_defaultSelection != null) {
                visibilityList.add(this.m_defaultSelection[i] ? Boolean.TRUE : Boolean.FALSE);
                continue;
            }
            visibilityList.add(Boolean.FALSE);
        }
        if (this.m_graphicalType.equals(JCheckBoxList.class)) {
            JCheckBoxList checkboxList = new JCheckBoxList(list, visibilityList);
            this.m_parameterComponent = new JCheckBoxListPanel(checkboxList, this.m_allowSelectAll);
        } else if (this.m_graphicalType.equals(AdvancedSelectionPanel.class)) {
            AdvancedSelectionPanel selectionPanel;
            this.m_parameterComponent = selectionPanel = new AdvancedSelectionPanel(this.m_selectedName, this.m_unselectedName, list, visibilityList);
        }
        return this.m_parameterComponent;
    }

    @Override
    public void initDefault() {
    }

    @Override
    public ParameterError checkParameter() {
        if (!this.m_used && !this.m_compulsory) {
            return null;
        }
        List selectedList = this.m_graphicalType.equals(JCheckBoxList.class) ? ((JCheckBoxListPanel)this.m_parameterComponent).getCheckBoxList().getSelectedItems() : ((AdvancedSelectionPanel)this.m_parameterComponent).getSelectedItems();
        if (this.m_compulsory && selectedList.isEmpty()) {
            return new ParameterError("No selection done", this.m_parameterComponent);
        }
        int nb = selectedList.size();
        if (this.m_compulsory && nb < this.m_nbCompulsorySelection) {
            return new ParameterError("You must select at least " + this.m_nbCompulsorySelection + "values", this.m_parameterComponent);
        }
        return null;
    }

    @Override
    public void setValue(String v) {
    }

    @Override
    public String getStringValue() {
        return null;
    }

    @Override
    public List<E> getObjectValue() {
        if (this.m_graphicalType.equals(JCheckBoxList.class)) {
            JCheckBoxList checkBoxList = (JCheckBoxList)this.m_parameterComponent;
            List list = checkBoxList.getSelectedItems();
            return list;
        }
        if (this.m_graphicalType.equals(AdvancedSelectionPanel.class)) {
            List list = ((AdvancedSelectionPanel)this.m_parameterComponent).getSelectedItems();
            return list;
        }
        return null;
    }

    public Object getAssociatedValues(boolean selected) {
        int[] indices;
        if (this.m_associatedObjects == null) {
            return this.getObjectValue();
        }
        if (this.m_graphicalType.equals(JCheckBoxList.class)) {
            JCheckBoxList checkBoxList = ((JCheckBoxListPanel)this.m_parameterComponent).getCheckBoxList();
            indices = selected ? checkBoxList.getSelectedIndices() : checkBoxList.getNonSelectedIndices();
        } else {
            AdvancedSelectionPanel selectionPanel = (AdvancedSelectionPanel)this.m_parameterComponent;
            indices = selected ? selectionPanel.getSelectedIndices() : selectionPanel.getNonSelectedIndices();
        }
        ArrayList<Object> associatedSelectedList = new ArrayList<Object>(indices.length);
        for (int i : indices) {
            associatedSelectedList.add(this.m_associatedObjects[i]);
        }
        return associatedSelectedList;
    }

    public void addLinkedParameters(final AbstractLinkedParameters linkedParameters) {
        this.getComponent(null);
        if (this.m_linkedParametersList == null) {
            this.m_linkedParametersList = new ArrayList(1);
        }
        this.m_linkedParametersList.add(linkedParameters);
        if (this.m_parameterComponent instanceof JCheckBoxListPanel) {
            JCheckBoxList checkBoxList = ((JCheckBoxListPanel)this.m_parameterComponent).getCheckBoxList();
            checkBoxList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBoxList.CheckListItem item = (JCheckBoxList.CheckListItem)e.getSource();
                    linkedParameters.valueChanged(item.toString(), item.isSelected());
                }
            });
            this.initDefault();
        } else if (this.m_parameterComponent instanceof AdvancedSelectionPanel) {
            // empty if block
        }
    }

    @Override
    public boolean isEdited() {
        return true;
    }
}

