/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.model;

import fr.proline.mzscope.model.AnnotatedChromatogram;
import fr.proline.mzscope.model.IChromatogram;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.model.MsnExtractionRequest;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractionObject {
    private static final Logger logger = LoggerFactory.getLogger(ExtractionObject.class);
    private MsnExtractionRequest request;
    private Integer expectedCharge;
    private Map<IRawFile, AnnotatedChromatogram> chromatograms;
    private Status status = Status.NONE;

    public ExtractionObject(MsnExtractionRequest request, Integer expectedCharge) {
        this.request = request;
        this.expectedCharge = expectedCharge;
    }

    public float getMzTolPPM() {
        return this.request.getMzTolPPM();
    }

    public double getMz() {
        return this.request.getMz();
    }

    public double getMinMz() {
        return this.request.getMinMz();
    }

    public double getMaxMz() {
        return this.request.getMaxMz();
    }

    public float getElutionTimeLowerBound() {
        return this.request.getElutionTimeLowerBound();
    }

    public float getElutionTimeUpperBound() {
        return this.request.getElutionTimeUpperBound();
    }

    public float getElutionTime() {
        return this.request.getElutionTime();
    }

    public Integer getExpectedCharge() {
        return this.expectedCharge;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean addChromatogram(IRawFile rawFile, AnnotatedChromatogram chromato) {
        if (this.chromatograms == null) {
            this.chromatograms = new HashMap<IRawFile, AnnotatedChromatogram>();
        }
        this.chromatograms.put(rawFile, chromato);
        return true;
    }

    public Map<IRawFile, IChromatogram> getChromatogramsMap() {
        HashMap<IRawFile, IChromatogram> result = new HashMap<IRawFile, IChromatogram>();
        for (Map.Entry<IRawFile, AnnotatedChromatogram> entry : this.chromatograms.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public IChromatogram getChromatogram(IRawFile rawFile) {
        return this.chromatograms != null && this.chromatograms.containsKey(rawFile) ? (IChromatogram)this.chromatograms.get(rawFile) : null;
    }

    public MsnExtractionRequest getRequest() {
        return this.request;
    }

    public static enum Status {
        NONE,
        REQUESTED,
        DONE;

    }
}

