/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.processing;

import fr.proline.mzscope.model.AnnotatedChromatogram;
import fr.proline.mzscope.model.FeaturesExtractionRequest;
import fr.proline.mzscope.model.IChromatogram;
import fr.proline.mzscope.model.IPeakel;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.model.MsnExtractionRequest;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class PeakelAnnotatorImpl {
    private static double AVERAGE_ISOTOPE_MASS_DIFF = 1.0027;
    private final FeaturesExtractionRequest params;
    private IRawFile rawFile;
    private Map<Integer, List<IPeakel>> featuresByNominalMass;

    public PeakelAnnotatorImpl(IRawFile rawFile, FeaturesExtractionRequest params) {
        this.params = params;
        this.rawFile = rawFile;
    }

    private Map<Integer, List<IPeakel>> getPeakels() {
        if (this.featuresByNominalMass == null && this.params != null) {
            List<IPeakel> list = this.rawFile.extractPeakels(this.params);
            this.featuresByNominalMass = list.stream().collect(Collectors.groupingBy(f -> (int)f.getMz(), Collectors.toList()));
        }
        return this.featuresByNominalMass;
    }

    public AnnotatedChromatogram annotate(IChromatogram chromatogram, MsnExtractionRequest request, Integer expectedCharge) {
        List<IPeakel> peakels = this.getPeakels().get((int)request.getMz());
        if (peakels == null) {
            return chromatogram == null ? null : new AnnotatedChromatogram(chromatogram, null);
        }
        IPeakel peakel = peakels.stream().filter(f -> {
            double tolDa = f.getMz() * (double)this.params.getMzTolPPM() / 1000000.0;
            double upperTimeLimit = this.rawFile.getSpectrumElutionTime(this.rawFile.getNextSpectrumId(this.rawFile.getNextSpectrumId(this.rawFile.getSpectrumId(f.getLastElutionTime()), 1), 1));
            double lowerTimeLimit = this.rawFile.getSpectrumElutionTime(this.rawFile.getPreviousSpectrumId(this.rawFile.getSpectrumId(f.getFirstElutionTime()), 1));
            return (double)request.getElutionTime() * 60.0 >= lowerTimeLimit && (double)request.getElutionTime() * 60.0 <= upperTimeLimit && Math.abs(f.getMz() - request.getMz()) < tolDa;
        }).findFirst().orElse(null);
        if (peakel == null) {
            double secondIsotopeMz = request.getMz() + AVERAGE_ISOTOPE_MASS_DIFF / (double)expectedCharge.intValue();
            peakels = this.getPeakels().get((int)secondIsotopeMz);
            peakel = peakels != null ? (IPeakel)peakels.stream().filter(f -> {
                double tolDa = f.getMz() * (double)this.params.getMzTolPPM() / 1000000.0;
                double upperTimeLimit = this.rawFile.getSpectrumElutionTime(this.rawFile.getNextSpectrumId(this.rawFile.getNextSpectrumId(this.rawFile.getSpectrumId(f.getLastElutionTime()), 1), 1));
                double lowerTimeLimit = this.rawFile.getSpectrumElutionTime(this.rawFile.getPreviousSpectrumId(this.rawFile.getSpectrumId(f.getFirstElutionTime()), 1));
                return (double)request.getElutionTime() * 60.0 >= lowerTimeLimit && (double)request.getElutionTime() * 60.0 <= upperTimeLimit && Math.abs(f.getMz() - secondIsotopeMz) < tolDa;
            }).findFirst().orElse(null) : null;
        }
        return new AnnotatedChromatogram(chromatogram, peakel);
    }
}

