/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.timstof;

import fr.profi.brucker.timstof.converter.SpectrumGeneratingMethod;
import fr.profi.brucker.timstof.io.TimstofReader;
import fr.profi.brucker.timstof.model.AbstractTimsFrame;
import fr.profi.brucker.timstof.model.Spectrum;
import fr.profi.brucker.timstof.model.TimsMSFrame;
import fr.profi.brucker.timstof.model.TimsPASEFFrame;
import fr.profi.util.StringUtils;
import fr.proline.mzscope.model.Chromatogram;
import fr.proline.mzscope.model.FeaturesExtractionRequest;
import fr.proline.mzscope.model.IChromatogram;
import fr.proline.mzscope.model.IExportParameters;
import fr.proline.mzscope.model.IFeature;
import fr.proline.mzscope.model.IPeakel;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.model.MsnExtractionRequest;
import fr.proline.mzscope.model.QCMetrics;
import fr.proline.mzscope.model.Spectrum;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimstofRawFile
implements IRawFile {
    private File m_ttDirFile;
    private TimstofReader m_reader;
    private Long m_fileHandler;
    private List<AbstractTimsFrame> m_ttFrames;
    private Map<Integer, Integer> m_spectra2FrameIndex;
    private Map<Integer, Integer> m_frame2FirstSpectraIndex;
    private IChromatogram m_ticChromato;
    private IChromatogram m_bpcChromato;
    private String m_ms1Format;
    public static final String MS1_SINGLE_SPECTRA = "Single Spectra";
    public static final String MS1_SPECTRA_PER_SCAN = "Spectra Per Scan";
    private static final Logger LOG = LoggerFactory.getLogger(TimstofRawFile.class);

    public TimstofRawFile(File ttFile) {
        this(ttFile, MS1_SINGLE_SPECTRA);
    }

    public TimstofRawFile(File ttFile, String ms1SpectrumFormat) {
        long start = System.currentTimeMillis();
        if (!ttFile.isDirectory()) {
            throw new IllegalArgumentException("You should specify a brucker .d directory");
        }
        this.m_ms1Format = MS1_SINGLE_SPECTRA;
        if (ms1SpectrumFormat != null && StringUtils.isNotEmpty((String)ms1SpectrumFormat)) {
            switch (ms1SpectrumFormat) {
                case "Single Spectra": {
                    this.m_ms1Format = MS1_SINGLE_SPECTRA;
                    break;
                }
                case "Spectra Per Scan": {
                    this.m_ms1Format = MS1_SPECTRA_PER_SCAN;
                    break;
                }
                default: {
                    LOG.warn("Invalid MS1 Spectra format specified ! Default is used (Single Spectra)");
                }
            }
        }
        this.m_ttDirFile = ttFile;
        this.init();
        long end = System.currentTimeMillis();
        LOG.info(" Read TTof file " + ttFile.getAbsolutePath() + ". Duration " + (end - start) / 1000L);
    }

    private void init() {
        this.m_reader = TimstofReader.getTimstofReader();
        this.m_fileHandler = this.m_reader.openTimstofFile(this.m_ttDirFile);
        LOG.info(" Open file handle " + this.m_fileHandler);
        this.m_ttFrames = this.m_reader.getFullTimsFrames(this.m_fileHandler.longValue());
        Collections.sort(this.m_ttFrames);
        Integer spectrumIndex = 0;
        this.m_spectra2FrameIndex = new HashMap<Integer, Integer>();
        this.m_frame2FirstSpectraIndex = new HashMap<Integer, Integer>();
        for (AbstractTimsFrame tf : this.m_ttFrames) {
            Integer nbrSpectrum = tf.getSpectrumCount();
            if (this.m_ms1Format.equals(MS1_SPECTRA_PER_SCAN) && TimsMSFrame.class.isInstance(tf)) {
                nbrSpectrum = ((TimsMSFrame)tf).getNbrScans();
            }
            this.m_frame2FirstSpectraIndex.put(tf.getId(), spectrumIndex);
            for (int i = 0; i < nbrSpectrum; ++i) {
                this.m_spectra2FrameIndex.put(spectrumIndex, tf.getId());
                Integer n = spectrumIndex;
                Integer n2 = spectrumIndex = Integer.valueOf(spectrumIndex + 1);
            }
        }
    }

    @Override
    public String getName() {
        return this.m_ttDirFile.getName();
    }

    @Override
    public File getFile() {
        return this.m_ttDirFile;
    }

    @Override
    public IChromatogram getXIC(MsnExtractionRequest params) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public IChromatogram getTIC(int msLevel) {
        if (this.m_ticChromato == null) {
            double[] intensities = new double[this.m_ttFrames.size()];
            double[] times = new double[this.m_ttFrames.size()];
            int index = 0;
            for (AbstractTimsFrame frame : this.m_ttFrames) {
                times[index] = frame.getTime() / 60.0;
                intensities[index] = frame.getSummedIntensity();
                ++index;
            }
            this.m_ticChromato = new Chromatogram(this.getName(), this.getName(), times, intensities);
        }
        return this.m_ticChromato;
    }

    public float getSpectrumTIC(int index) {
        double[] intensities;
        int frIndx;
        if (this.m_ticChromato == null) {
            this.getTIC(-1);
        }
        if ((frIndx = this.m_spectra2FrameIndex.get(index).intValue()) < (intensities = this.m_ticChromato.getIntensities()).length) {
            return (float)intensities[frIndx];
        }
        return -1.0f;
    }

    @Override
    public IChromatogram getBPI() {
        if (this.m_bpcChromato == null) {
            double[] intensities = new double[this.m_ttFrames.size()];
            double[] times = new double[this.m_ttFrames.size()];
            int index = 0;
            for (AbstractTimsFrame frame : this.m_ttFrames) {
                times[index] = frame.getTime() / 60.0;
                intensities[index] = frame.getMaxIntensity();
                ++index;
            }
            this.m_bpcChromato = new Chromatogram(this.getName(), this.getName(), times, intensities);
        }
        return this.m_bpcChromato;
    }

    @Override
    public List<IFeature> extractFeatures(FeaturesExtractionRequest params) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public fr.proline.mzscope.model.Spectrum getSpectrum(int spectrumIndex) {
        Integer frameId = this.m_spectra2FrameIndex.get(spectrumIndex);
        Optional<AbstractTimsFrame> opFrame = this.m_ttFrames.stream().filter(frame -> frameId.equals(frame.getId())).findFirst();
        if (!opFrame.isPresent()) {
            return null;
        }
        AbstractTimsFrame tf = opFrame.get();
        if (!tf.spectrumRead()) {
            List<AbstractTimsFrame> tfs = Collections.singletonList(tf);
            this.m_reader.fillFramesWithSpectrumData(this.m_fileHandler, tfs);
        }
        fr.proline.mzscope.model.Spectrum spectrum = null;
        if (TimsPASEFFrame.class.isInstance(tf) && ((TimsPASEFFrame)tf).getPrecursorIds() != null) {
            TimsPASEFFrame pasefFrame = (TimsPASEFFrame)tf;
            Integer indexInFrameSpectra = spectrumIndex - this.m_frame2FirstSpectraIndex.get(pasefFrame.getId());
            IntArrayList precursorIds = pasefFrame.getPrecursorIds();
            if (indexInFrameSpectra >= precursorIds.size()) {
                return null;
            }
            Collections.sort(precursorIds);
            Spectrum tfSp = pasefFrame.getPrecursorSpectrum(((Integer)precursorIds.get(indexInFrameSpectra)).intValue());
            spectrum = new fr.proline.mzscope.model.Spectrum(spectrumIndex, (float)pasefFrame.getTime(), tfSp.getMasses(), tfSp.getIntensities(), 2);
            spectrum.setTitle(tfSp.getTitle());
        } else if (!TimsPASEFFrame.class.isInstance(tf)) {
            TimsMSFrame ms1Frame = (TimsMSFrame)tf;
            if (this.m_ms1Format.equals(MS1_SPECTRA_PER_SCAN)) {
                Integer indexInFrameSpectra = spectrumIndex - this.m_frame2FirstSpectraIndex.get(ms1Frame.getId());
                Spectrum tfSp = ms1Frame.getScanSpectrum(indexInFrameSpectra.intValue());
                if (tfSp != null) {
                    spectrum = new fr.proline.mzscope.model.Spectrum(spectrumIndex, (float)ms1Frame.getTime(), tfSp.getMasses(), tfSp.getIntensities(), 1, Spectrum.ScanType.CENTROID);
                    spectrum.setTitle(tfSp.getTitle() + "_scan_" + indexInFrameSpectra);
                } else {
                    spectrum = new fr.proline.mzscope.model.Spectrum(spectrumIndex, (float)ms1Frame.getTime(), new double[0], new float[0], 1);
                    spectrum.setTitle(ms1Frame.getId() + "_empty_scan_" + indexInFrameSpectra);
                }
            } else {
                Spectrum tfSp = tf.getSingleSpectrum(SpectrumGeneratingMethod.SMOOTH);
                spectrum = new fr.proline.mzscope.model.Spectrum(spectrumIndex, (float)tf.getTime(), tfSp.getMasses(), tfSp.getIntensities(), 1);
                spectrum.setTitle(tfSp.getTitle());
            }
        }
        return spectrum;
    }

    @Override
    public int getSpectrumCount() {
        return this.m_spectra2FrameIndex.size();
    }

    @Override
    public int getSpectrumId(double retentionTime) {
        for (AbstractTimsFrame fr : this.m_ttFrames) {
            if (!(Math.abs(fr.getTime() - retentionTime) < 0.05)) continue;
            return this.m_frame2FirstSpectraIndex.get(fr.getId());
        }
        return 0;
    }

    @Override
    public double[] getElutionTimes(int msLevel) {
        throw new UnsupportedOperationException("TimsTof getElutionTimes: Not supported yet.");
    }

    @Override
    public double getSpectrumElutionTime(int spectrumIndex) {
        Integer frameId = this.m_spectra2FrameIndex.get(spectrumIndex);
        Optional<AbstractTimsFrame> opFr = this.m_ttFrames.stream().filter(fr -> frameId.equals(fr.getId())).findFirst();
        if (opFr.isPresent()) {
            return opFr.get().getTime();
        }
        return 0.0;
    }

    @Override
    public int getNextSpectrumId(int spectrumIndex, int msLevel) {
        Integer nextFrameId;
        AbstractTimsFrame.MsMsType msmsType = msLevel == 2 ? AbstractTimsFrame.MsMsType.PASEF : AbstractTimsFrame.MsMsType.MS;
        Integer nextSpectrumId = spectrumIndex + 1;
        Integer frameId = this.m_spectra2FrameIndex.get(spectrumIndex);
        if (frameId.equals(nextFrameId = this.m_spectra2FrameIndex.get(nextSpectrumId))) {
            return nextSpectrumId;
        }
        boolean foundSpectrumFrame = false;
        while (!foundSpectrumFrame) {
            Integer finalFrId = nextFrameId;
            Optional<AbstractTimsFrame> opFr = this.m_ttFrames.stream().filter(fr -> finalFrId.equals(fr.getId())).findFirst();
            if (!opFr.isPresent()) break;
            if (opFr.get().getMsmsType().equals((Object)msmsType)) {
                foundSpectrumFrame = true;
                break;
            }
            Integer n = nextFrameId;
            Integer n2 = nextFrameId = Integer.valueOf(nextFrameId + 1);
            nextSpectrumId = this.m_frame2FirstSpectraIndex.get(nextFrameId);
        }
        if (foundSpectrumFrame) {
            return nextSpectrumId;
        }
        return 0;
    }

    @Override
    public int getPreviousSpectrumId(int spectrumIndex, int msLevel) {
        Integer prevFrameId;
        AbstractTimsFrame.MsMsType msmsType = msLevel == 2 ? AbstractTimsFrame.MsMsType.PASEF : AbstractTimsFrame.MsMsType.MS;
        Integer prevSpectrumId = spectrumIndex - 1;
        Integer frameId = this.m_spectra2FrameIndex.get(spectrumIndex);
        if (frameId.equals(prevFrameId = this.m_spectra2FrameIndex.get(prevSpectrumId))) {
            return prevSpectrumId;
        }
        boolean foundSpectrumFrame = false;
        while (!foundSpectrumFrame) {
            Integer finalFrId = prevFrameId;
            Optional<AbstractTimsFrame> opFr = this.m_ttFrames.stream().filter(fr -> finalFrId.equals(fr.getId())).findFirst();
            if (!opFr.isPresent()) break;
            if (opFr.get().getMsmsType().equals((Object)msmsType)) {
                foundSpectrumFrame = true;
                break;
            }
            Integer n = prevFrameId;
            Integer n2 = prevFrameId = Integer.valueOf(prevFrameId - 1);
            prevSpectrumId = this.m_frame2FirstSpectraIndex.get(prevFrameId);
        }
        if (foundSpectrumFrame) {
            return prevSpectrumId;
        }
        return 0;
    }

    @Override
    public List<Float> getMsMsEvent(double minMz, double maxMz) {
        throw new UnsupportedOperationException("TimsTof getMsMsEvent: Not supported yet.");
    }

    @Override
    public boolean exportRawFile(String outFileName, IExportParameters exportParams) {
        throw new UnsupportedOperationException("TimsTof exportRawFile: Not supported yet.");
    }

    @Override
    public boolean isDIAFile() {
        return false;
    }

    @Override
    public Map<String, Object> getFileProperties() {
        throw new UnsupportedOperationException("TimsTof getFileProperties: Not supported yet.");
    }

    @Override
    public QCMetrics getFileMetrics() {
        throw new UnsupportedOperationException("TimsTof getFileMetrics: Not supported yet.");
    }

    @Override
    public void closeIRawFile() {
        this.m_reader.closeTimstofFile(this.m_fileHandler.longValue());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public List<IPeakel> extractPeakels(FeaturesExtractionRequest params) {
        throw new UnsupportedOperationException("TimsTof extractPeakels: Not supported yet.");
    }
}

