/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.proline.mzscope.model.QCMetrics;
import fr.proline.mzscope.ui.model.StatisticsTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.PlotLinear;
import fr.proline.studio.graphics.PlotPanel;
import fr.proline.studio.graphics.PlotXYAbstract;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetricsDetailsPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(MetricsDetailsPanel.class);
    private JComboBox<String> m_metricsCbx;
    private JComboBox<Integer> m_msLevelCbx;
    private QCMetrics m_metrics;
    private BasePlotPanel m_plotPanel;

    public MetricsDetailsPanel() {
        this.setLayout(new BorderLayout());
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        this.m_metricsCbx = new JComboBox();
        this.m_metricsCbx.setPrototypeDisplayValue("XXXXXXXXXXXXXXXX");
        this.m_metricsCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetricsDetailsPanel.this.updateCurrentMetric();
            }
        });
        toolbar.setLayout(new FlowLayout(3, 5, 5));
        toolbar.add(this.m_metricsCbx);
        this.m_msLevelCbx = new JComboBox();
        this.m_msLevelCbx.addItem(1);
        this.m_msLevelCbx.addItem(2);
        this.m_msLevelCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetricsDetailsPanel.this.updateCurrentMetric();
            }
        });
        toolbar.add(this.m_msLevelCbx);
        toolbar.add(Box.createHorizontalGlue());
        this.add((Component)toolbar, "North");
        PlotPanel panel = new PlotPanel();
        this.m_plotPanel = panel.getBasePlotPanel();
        this.add((Component)panel, "Center");
    }

    public void updateCurrentMetric() {
        DescriptiveStatistics statistics;
        double[] time;
        String metricName = (String)this.m_metricsCbx.getSelectedItem();
        Integer msLevel = (Integer)this.m_msLevelCbx.getSelectedItem();
        if (metricName == null) {
            this.m_plotPanel.clearPlots();
            this.m_plotPanel.repaintUpdateDoubleBuffer();
            return;
        }
        DescriptiveStatistics[] stats = this.m_metrics.getMetricStatistics(metricName);
        if (stats == null) {
            logger.error("no stats found for metric " + metricName);
            this.m_plotPanel.clearPlots();
            this.m_plotPanel.repaintUpdateDoubleBuffer();
            return;
        }
        logger.info("set visible metric to " + metricName);
        if (stats[0] != null) {
            time = this.m_metrics.getMetricStatistics("RT events ")[0].getValues();
            statistics = stats[0];
            this.m_msLevelCbx.setEnabled(false);
        } else {
            time = this.m_metrics.getMetricStatistics("RT MS events ")[msLevel].getValues();
            statistics = stats[msLevel];
            this.m_msLevelCbx.setEnabled(true);
        }
        logger.info("Statistics size = " + statistics.getN());
        if (statistics.getN() == (long)time.length) {
            StatisticsTableModel model = new StatisticsTableModel(metricName, time, statistics);
            PlotLinear plot = new PlotLinear(this.m_plotPanel, (ExtendedTableModelInterface)model, null, 0, 1);
            plot.setPlotInformation(model.getPlotInformation());
            plot.setIsPaintMarker(true);
            plot.setStrokeFixed(true);
            this.m_plotPanel.clearPlots();
            this.m_plotPanel.addPlot((PlotXYAbstract)plot, true);
            this.m_plotPanel.repaintUpdateDoubleBuffer();
        } else {
            logger.warn("Should not append : time range and values size are not equal !");
        }
    }

    public void setQCMetrics(QCMetrics metrics) {
        if (this.isVisible()) {
            this.m_metrics = metrics;
            HashSet<String> metricNames = new HashSet<String>();
            metricNames.addAll(this.m_metrics.getPopulationMetricNames());
            int previousSelection = this.m_metricsCbx.getSelectedIndex();
            this.m_metricsCbx.removeAllItems();
            for (String name : metricNames) {
                this.m_metricsCbx.addItem(name);
            }
            this.m_metricsCbx.setSize(10, this.m_metricsCbx.getPreferredSize().height);
            if (previousSelection != -1) {
                this.m_metricsCbx.setSelectedIndex(previousSelection);
            } else {
                this.m_metricsCbx.setSelectedIndex(0);
            }
        } else {
            logger.info("Panel is hidden : do not take selection into account");
        }
    }
}

