/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.google.common.base.Strings;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.peakeldb.io.PeakelDbReader;
import fr.proline.mzscope.map.LcMsMap;
import fr.proline.mzscope.map.LcMsViewer;
import fr.proline.mzscope.map.LcMsViewport;
import fr.proline.mzscope.map.ui.LcMsViewerUI;
import fr.proline.mzscope.model.BasePeakel;
import fr.proline.mzscope.model.FeaturesExtractionRequest;
import fr.proline.mzscope.model.IExportParameters;
import fr.proline.mzscope.model.IFeature;
import fr.proline.mzscope.model.IPeakel;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.model.MsnExtractionRequest;
import fr.proline.mzscope.model.QCMetrics;
import fr.proline.mzscope.mzdb.MzdbPeakelWrapper;
import fr.proline.mzscope.ui.AbstractRawFilePanel;
import fr.proline.mzscope.ui.IMzScopeController;
import fr.proline.mzscope.ui.IRawFileLoading;
import fr.proline.mzscope.ui.IRawFileViewer;
import fr.proline.mzscope.ui.MultiRawFilePanel;
import fr.proline.mzscope.ui.PropertiesPanel;
import fr.proline.mzscope.ui.QCMetricsPanel;
import fr.proline.mzscope.ui.RawFileManager;
import fr.proline.mzscope.ui.SingleRawFilePanel;
import fr.proline.mzscope.ui.TabbedMultiRawFilePanel;
import fr.proline.mzscope.ui.XICExtractionPanel;
import fr.proline.mzscope.ui.dialog.ExportRawFileDialog;
import fr.proline.mzscope.ui.dialog.ExtractionParamsDialog;
import fr.proline.mzscope.ui.event.ExtractionEvent;
import fr.proline.mzscope.ui.event.ExtractionStateListener;
import fr.proline.mzscope.ui.model.MzScopePreferences;
import fr.proline.mzscope.ui.peakels.DetectedFeaturesPanel;
import fr.proline.mzscope.ui.peakels.PeakelsPanel;
import fr.proline.mzscope.utils.ButtonTabComponent;
import fr.proline.mzscope.utils.Display;
import fr.proline.mzscope.utils.MzScopeCallback;
import fr.proline.studio.Exceptions;
import fr.proline.studio.gui.DefaultDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterable;
import scala.collection.JavaConversions;

public class MzScopePanel
extends JPanel
implements IMzScopeController {
    private static final Logger logger = LoggerFactory.getLogger((String)"ProlineStudio.mzScope.MzScopePanel");
    private Frame parentFrame = null;
    private JSplitPane mainSplitPane = null;
    private JTabbedPane viewersTabPane = null;
    private JTabbedPane featuresTabPane = null;
    private IRawFileViewer selectedRawFilePanel;
    private XICExtractionPanel extractionPanel = null;
    private EventListenerList listenerList = new EventListenerList();
    private Map<IRawFile, List<AbstractRawFilePanel>> mapRawFilePanelRawFile;

    public MzScopePanel(Frame parentFrame) {
        this.parentFrame = parentFrame;
        this.initComponents();
    }

    private void initComponents() {
        this.mapRawFilePanelRawFile = new HashMap<IRawFile, List<AbstractRawFilePanel>>();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getExtractionPanel(), "North");
        this.add((Component)this.getMainComponent(), "Center");
    }

    private XICExtractionPanel getExtractionPanel() {
        if (this.extractionPanel == null) {
            this.extractionPanel = new XICExtractionPanel(this);
        }
        return this.extractionPanel;
    }

    private JSplitPane getMainComponent() {
        if (this.mainSplitPane == null) {
            this.mainSplitPane = new JSplitPane();
            this.mainSplitPane.setDividerLocation(320);
            this.mainSplitPane.setOrientation(0);
            this.mainSplitPane.setOneTouchExpandable(true);
            this.mainSplitPane.setRightComponent(this.getFeaturesTabPane());
            this.mainSplitPane.setLeftComponent(this.getViewersTabPane());
        }
        return this.mainSplitPane;
    }

    public JTabbedPane getFeaturesTabPane() {
        if (this.featuresTabPane == null) {
            this.featuresTabPane = new JTabbedPane();
        }
        return this.featuresTabPane;
    }

    private JTabbedPane getViewersTabPane() {
        if (this.viewersTabPane == null) {
            this.viewersTabPane = new JTabbedPane();
            this.viewersTabPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    MzScopePanel.this.viewersTabPaneStateChanged(evt);
                }
            });
        }
        return this.viewersTabPane;
    }

    private void viewersTabPaneStateChanged(ChangeEvent evt) {
        Component c = this.viewersTabPane.getSelectedComponent();
        if (c != null && IRawFileViewer.class.isAssignableFrom(c.getClass())) {
            this.selectedRawFilePanel = (IRawFileViewer)((Object)c);
            if (this.selectedRawFilePanel != null && this.selectedRawFilePanel.getCurrentRawfile() != null) {
                this.getExtractionPanel().setDIAEnabled(this.selectedRawFilePanel.getCurrentRawfile().isDIAFile());
            }
        }
    }

    @Override
    public IRawFileViewer getCurrentRawFileViewer() {
        return this.selectedRawFilePanel;
    }

    @Override
    public IRawFileViewer getRawFileViewer(IRawFile rawfile, boolean setVisible) {
        AbstractRawFilePanel viewer = this.displayRaw(rawfile, false);
        if (setVisible) {
            this.viewersTabPane.setSelectedComponent(viewer);
        }
        return viewer;
    }

    public void openRaw(List<File> files, boolean display) {
        ArrayList<IRawFile> rawfiles = new ArrayList<IRawFile>();
        for (File f : files) {
            IRawFile rawfile = RawFileManager.getInstance().getFile(f.getAbsolutePath());
            if (rawfile == null) {
                rawfile = RawFileManager.getInstance().addRawFile(f);
            }
            rawfiles.add(rawfile);
        }
        if (display) {
            this.displayRaw(rawfiles);
        }
    }

    public void openRawAndExtract(File file, final double moz, final double elutionTime, final double firstScanTime, final double lastScanTime) {
        IRawFile tmpRawFile = RawFileManager.getInstance().getFile(file.getAbsolutePath());
        if (tmpRawFile == null) {
            tmpRawFile = RawFileManager.getInstance().addRawFile(file);
        }
        final IRawFile rawfile = tmpRawFile;
        boolean fileAlreadyOpen = false;
        List<AbstractRawFilePanel> list = this.mapRawFilePanelRawFile.get(rawfile);
        if (list != null) {
            for (AbstractRawFilePanel p : list) {
                if (!(p instanceof SingleRawFilePanel)) continue;
                fileAlreadyOpen = true;
                break;
            }
        }
        if (!fileAlreadyOpen) {
            this.displayRaw(rawfile, false);
        }
        MsnExtractionRequest params = ((MsnExtractionRequest.Builder)((MsnExtractionRequest.Builder)MsnExtractionRequest.builder().setMzTolPPM(MzScopePreferences.getInstance().getMzPPMTolerance())).setMz(moz)).build();
        list = this.mapRawFilePanelRawFile.get(rawfile);
        for (final AbstractRawFilePanel p : list) {
            if (!(p instanceof SingleRawFilePanel)) continue;
            p.extractAndDisplayChromatogram(params, new Display(Display.Mode.REPLACE), new MzScopeCallback(){

                @Override
                public void callback(boolean success) {
                    p.displayPeakel(new BasePeakel(moz, (float)elutionTime, (float)firstScanTime, (float)lastScanTime, rawfile, 1));
                }
            });
            break;
        }
    }

    private ButtonTabComponent addRawTab(String s, Component c) {
        ButtonTabComponent buttonTabComp = this.addTab(this.viewersTabPane, s, c, null);
        this.viewersTabPane.setSelectedComponent(c);
        return buttonTabComp;
    }

    public ButtonTabComponent addFeatureTab(String s, Component c, String tooltip) {
        ButtonTabComponent buttonTabComp = this.addTab(this.featuresTabPane, s, c, tooltip);
        this.featuresTabPane.setSelectedComponent(c);
        return buttonTabComp;
    }

    private ButtonTabComponent addTab(final JTabbedPane tabPane, String s, final Component c, String tooltip) {
        tabPane.add(s, c);
        int i = tabPane.getTabCount() - 1;
        ButtonTabComponent buttonTabComp = new ButtonTabComponent(s);
        buttonTabComp.addCloseTabListener(new ButtonTabComponent.CloseTabListener(){

            @Override
            public void closeTab(ButtonTabComponent tabComponent) {
                block2: {
                    block3: {
                        int index = tabPane.indexOfTabComponent(tabComponent);
                        if (index == -1) break block2;
                        tabPane.remove(index);
                        if (!(c instanceof SingleRawFilePanel)) break block3;
                        SingleRawFilePanel p = (SingleRawFilePanel)c;
                        for (Map.Entry entrySet : MzScopePanel.this.mapRawFilePanelRawFile.entrySet()) {
                            IRawFile rf = (IRawFile)entrySet.getKey();
                            List list = (List)entrySet.getValue();
                            if (!list.contains(p)) continue;
                            list.remove(p);
                        }
                        break block2;
                    }
                    if (!(c instanceof MultiRawFilePanel)) break block2;
                    MultiRawFilePanel p = (MultiRawFilePanel)c;
                    for (Map.Entry entrySet : MzScopePanel.this.mapRawFilePanelRawFile.entrySet()) {
                        IRawFile rf = (IRawFile)entrySet.getKey();
                        List list = (List)entrySet.getValue();
                        if (!list.contains(p)) continue;
                        list.remove(p);
                    }
                }
            }
        });
        if (tooltip != null) {
            buttonTabComp.setToolTipText(tooltip);
            buttonTabComp.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int index = tabPane.indexOfTabComponent((Component)e.getSource());
                    tabPane.setSelectedIndex(index);
                }
            });
        }
        tabPane.setTabComponentAt(i, buttonTabComp);
        return buttonTabComp;
    }

    public AbstractRawFilePanel displayRaw(IRawFile rawfile, boolean displayDefaultChrom) {
        if (rawfile == null) {
            return null;
        }
        boolean rawPanelExists = false;
        AbstractRawFilePanel rawPanel = null;
        List<AbstractRawFilePanel> listTabs = this.mapRawFilePanelRawFile.get(rawfile);
        if (listTabs != null && !listTabs.isEmpty()) {
            for (AbstractRawFilePanel panel : listTabs) {
                if (!(panel instanceof SingleRawFilePanel)) continue;
                this.viewersTabPane.setSelectedComponent(panel);
                rawPanel = panel;
                rawPanelExists = true;
            }
        }
        if (!rawPanelExists) {
            rawPanel = new SingleRawFilePanel(rawfile, displayDefaultChrom);
            final ButtonTabComponent tabComp = this.addRawTab(rawfile.getName(), rawPanel);
            IRawFileLoading rawFileLoading = new IRawFileLoading(){

                @Override
                public void setWaitingState(boolean waitingState) {
                    tabComp.setWaitingState(waitingState);
                }
            };
            rawPanel.setRawFileLoading(rawFileLoading);
            if (displayDefaultChrom) {
                tabComp.setWaitingState(true);
            }
            this.registerRawFilePanel(rawfile, rawPanel);
        }
        return rawPanel;
    }

    private String getName(List<IRawFile> rawfiles) {
        String name = "";
        if (rawfiles.size() > 1) {
            String prefix = Strings.commonPrefix((CharSequence)rawfiles.get(0).getName(), (CharSequence)rawfiles.get(1).getName());
            if (!prefix.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                for (IRawFile rawfile : rawfiles) {
                    String shortName = rawfile.getName().substring(prefix.length() - 1);
                    shortName = shortName.substring(0, shortName.lastIndexOf(46));
                    builder.append("..").append(shortName).append(',');
                }
                builder.deleteCharAt(builder.length() - 1);
                name = builder.toString();
            } else {
                name = Integer.toString(rawfiles.size()) + " files";
            }
        } else {
            name = rawfiles.get(0).getName();
        }
        return name;
    }

    public AbstractRawFilePanel displayRaw(List<IRawFile> rawfiles) {
        if (rawfiles.size() == 1) {
            return this.displayRaw(rawfiles.get(0), true);
        }
        String name = this.getName(rawfiles);
        MultiRawFilePanel plotPanel = new MultiRawFilePanel(rawfiles);
        final ButtonTabComponent tabComp = this.addRawTab(name, plotPanel);
        IRawFileLoading rawFileLoading = new IRawFileLoading(){

            @Override
            public void setWaitingState(boolean waitingState) {
                tabComp.setWaitingState(waitingState);
            }
        };
        plotPanel.setRawFileLoading(rawFileLoading);
        tabComp.setWaitingState(true);
        for (IRawFile rawFile : rawfiles) {
            this.registerRawFilePanel(rawFile, plotPanel);
        }
        return plotPanel;
    }

    private void registerRawFilePanel(IRawFile rawfile, AbstractRawFilePanel plotPanel) {
        if (this.mapRawFilePanelRawFile.get(rawfile) == null) {
            ArrayList<AbstractRawFilePanel> list = new ArrayList<AbstractRawFilePanel>();
            list.add(plotPanel);
            this.mapRawFilePanelRawFile.put(rawfile, list);
        } else {
            List<AbstractRawFilePanel> list = this.mapRawFilePanelRawFile.get(rawfile);
            list.add(plotPanel);
            this.mapRawFilePanelRawFile.put(rawfile, list);
        }
    }

    public void detectPeakels(List<IRawFile> rawfiles) {
        boolean isDIA = this.isDIAFiles(rawfiles);
        ExtractionParamsDialog dialog = new ExtractionParamsDialog(this.parentFrame, true, isDIA);
        dialog.setExtractionParamsTitle("Detect Peakels Parameters");
        dialog.setLocationRelativeTo(this);
        dialog.showExtractionParamsDialog();
        FeaturesExtractionRequest.Builder builder = dialog.getExtractionParams();
        if (builder != null) {
            builder.setExtractionMethod(FeaturesExtractionRequest.ExtractionMethod.DETECT_PEAKELS);
            FeaturesExtractionRequest params = builder.build();
            this.startPeakelsExtractions(rawfiles, params);
        }
    }

    public void extractFeaturesFromMS2(List<IRawFile> rawfiles) {
        boolean isDIA = this.isDIAFiles(rawfiles);
        ExtractionParamsDialog dialog = new ExtractionParamsDialog(this.parentFrame, true, isDIA);
        dialog.setExtractionParamsTitle("Extract Features Parameters");
        dialog.setLocationRelativeTo(this);
        dialog.showExtractionParamsDialog();
        FeaturesExtractionRequest.Builder builder = dialog.getExtractionParams();
        if (builder != null) {
            builder.setExtractionMethod(FeaturesExtractionRequest.ExtractionMethod.EXTRACT_MS2_FEATURES);
            FeaturesExtractionRequest params = builder.build();
            this.startFeaturesExtractions(rawfiles, params);
        }
    }

    public void detectFeatures(List<IRawFile> rawfiles) {
        boolean isDIA = this.isDIAFiles(rawfiles);
        ExtractionParamsDialog dialog = new ExtractionParamsDialog(this.parentFrame, true, isDIA);
        dialog.setExtractionParamsTitle("Detect Features Parameters");
        dialog.setLocationRelativeTo(this);
        dialog.showExtractionParamsDialog();
        FeaturesExtractionRequest.Builder builder = dialog.getExtractionParams();
        if (builder != null) {
            builder.setExtractionMethod(FeaturesExtractionRequest.ExtractionMethod.DETECT_FEATURES);
            this.startFeaturesExtractions(rawfiles, builder.build());
        }
    }

    private void startPeakelsExtractions(final List<IRawFile> rawfiles, final FeaturesExtractionRequest params) {
        final PeakelsPanel peakelsPanel = new PeakelsPanel(this);
        final ButtonTabComponent tabComp = this.addFeatureTab(this.getName(rawfiles), peakelsPanel, params.getExtractionParamsString());
        tabComp.setWaitingState(true);
        this.fireExtractionEvent(new ExtractionEvent(this, ExtractionEvent.EXTRACTION_STARTED));
        final long start = System.currentTimeMillis();
        SwingWorker<Integer, List<IPeakel>> worker = new SwingWorker<Integer, List<IPeakel>>(){
            int count = 0;

            @Override
            protected Integer doInBackground() throws Exception {
                for (IRawFile rawFile : rawfiles) {
                    List<IPeakel> listF = rawFile.extractPeakels(params);
                    ++this.count;
                    this.publish(listF);
                }
                return this.count;
            }

            @Override
            protected void process(List<List<IPeakel>> list) {
                List<IPeakel> listF = list.stream().flatMap(l -> l.stream()).collect(Collectors.toList());
                logger.info("{} peakels extracted in {}", (Object)listF.size(), (Object)((double)(System.currentTimeMillis() - start) / 1000.0));
                if (this.count == 1) {
                    peakelsPanel.setPeakels(listF, rawfiles.size() > 1);
                } else {
                    peakelsPanel.addPeakels(listF);
                }
            }

            @Override
            protected void done() {
                logger.info("All peakels extracted in {}", (Object)((double)(System.currentTimeMillis() - start) / 1000.0));
                MzScopePanel.this.featuresTabPane.setSelectedComponent(peakelsPanel);
                tabComp.setWaitingState(false);
                MzScopePanel.this.fireExtractionEvent(new ExtractionEvent(this, ExtractionEvent.EXTRACTION_DONE));
            }
        };
        worker.execute();
        logger.debug("Peakels extraction running ... ");
    }

    private void startFeaturesExtractions(final List<IRawFile> rawfiles, final FeaturesExtractionRequest params) {
        final DetectedFeaturesPanel featurePanel = new DetectedFeaturesPanel(this);
        final ButtonTabComponent tabComp = this.addFeatureTab(this.getName(rawfiles), featurePanel, params.getExtractionParamsString());
        tabComp.setWaitingState(true);
        this.fireExtractionEvent(new ExtractionEvent(this, ExtractionEvent.EXTRACTION_STARTED));
        final long start = System.currentTimeMillis();
        SwingWorker<Integer, List<IFeature>> worker = new SwingWorker<Integer, List<IFeature>>(){
            int count = 0;

            @Override
            protected Integer doInBackground() throws Exception {
                for (IRawFile rawFile : rawfiles) {
                    List<IFeature> listF = rawFile.extractFeatures(params);
                    ++this.count;
                    this.publish(listF);
                }
                return this.count;
            }

            @Override
            protected void process(List<List<IFeature>> list) {
                List<IFeature> listF = list.stream().flatMap(l -> l.stream()).collect(Collectors.toList());
                logger.info("{} features extracted in {}", (Object)listF.size(), (Object)((double)(System.currentTimeMillis() - start) / 1000.0));
                if (this.count == 1) {
                    logger.info("Set {} features ", (Object)listF.size());
                    featurePanel.setFeatures(listF, rawfiles.size() > 1);
                } else {
                    logger.info("Add {} features ", (Object)listF.size());
                    featurePanel.addFeatures(listF);
                }
            }

            @Override
            protected void done() {
                logger.info("All features extracted in {}", (Object)((double)(System.currentTimeMillis() - start) / 1000.0));
                MzScopePanel.this.featuresTabPane.setSelectedComponent(featurePanel);
                tabComp.setWaitingState(false);
                MzScopePanel.this.fireExtractionEvent(new ExtractionEvent(this, ExtractionEvent.EXTRACTION_DONE));
            }
        };
        worker.execute();
        logger.debug("Features extraction running ... ");
    }

    public void loadPeakels(IRawFile rawfile, File file) {
        try {
            ArrayList<IPeakel> features = new ArrayList<IPeakel>();
            SQLiteConnection connection = new SQLiteConnection(file);
            connection.openReadonly();
            Iterator peakelsIt = JavaConversions.asJavaIterable((Iterable)PeakelDbReader.loadAllPeakels((SQLiteConnection)connection, (int)400000)).iterator();
            while (peakelsIt.hasNext()) {
                features.add(new MzdbPeakelWrapper((Peakel)peakelsIt.next(), rawfile));
            }
            logger.info("loaded peakels : " + features.size());
            connection.dispose();
            PeakelsPanel peakelsPanel = new PeakelsPanel(this);
            this.addFeatureTab(rawfile.getName(), peakelsPanel, "loaded from " + file.getAbsolutePath());
            peakelsPanel.setPeakels(features, true);
        }
        catch (SQLiteException ex) {
            logger.error("error while reading peakeldb file", (Throwable)ex);
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void addExtractionListener(ExtractionStateListener listener) {
        this.listenerList.add(ExtractionStateListener.class, listener);
    }

    public void removeExtractionListener(ExtractionStateListener listener) {
        this.listenerList.remove(ExtractionStateListener.class, listener);
    }

    void fireExtractionEvent(ExtractionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ExtractionStateListener.class) continue;
            ((ExtractionStateListener)listeners[i + 1]).extractionStateChanged(event);
        }
    }

    public boolean closeAllRaw() {
        Object[] options = new String[]{"Yes", "No"};
        int reply = JOptionPane.showOptionDialog(this.parentFrame, "All files will be closed, do you want to continue?", "Close all files", 0, 1, null, options, "Yes");
        if (reply == 0) {
            this.viewersTabPane.removeAll();
            this.featuresTabPane.removeAll();
            this.mapRawFilePanelRawFile = new HashMap<IRawFile, List<AbstractRawFilePanel>>();
            RawFileManager.getInstance().removeAllFiles();
            return true;
        }
        return false;
    }

    public void closeRawFile(IRawFile rawfile) {
        List<AbstractRawFilePanel> tabPanels = this.mapRawFilePanelRawFile.get(rawfile);
        if (tabPanels != null) {
            for (AbstractRawFilePanel tabPanel : tabPanels) {
                this.viewersTabPane.remove(tabPanel);
                if (!(tabPanel instanceof MultiRawFilePanel)) continue;
                List<IRawFile> list = this.getRawFileListForRawFilePanel(tabPanel);
                for (IRawFile rawFile : list) {
                    if (rawFile == rawfile) continue;
                    this.removeRawFilePanel(rawFile, tabPanel);
                }
            }
            this.mapRawFilePanelRawFile.remove(rawfile);
        }
        RawFileManager.getInstance().removeFile(rawfile);
    }

    private void removeRawFilePanel(IRawFile rawFile, AbstractRawFilePanel panel) {
        List<AbstractRawFilePanel> list = this.mapRawFilePanelRawFile.get(rawFile);
        if (list.contains(panel)) {
            list.remove(panel);
            this.mapRawFilePanelRawFile.put(rawFile, list);
        }
    }

    private List<IRawFile> getRawFileListForRawFilePanel(AbstractRawFilePanel panel) {
        ArrayList<IRawFile> list = new ArrayList<IRawFile>();
        if (panel == null) {
            return list;
        }
        for (Map.Entry<IRawFile, List<AbstractRawFilePanel>> entrySet : this.mapRawFilePanelRawFile.entrySet()) {
            IRawFile key = entrySet.getKey();
            List<AbstractRawFilePanel> value = entrySet.getValue();
            if (!value.contains(panel)) continue;
            list.add(key);
        }
        return list;
    }

    public TabbedMultiRawFilePanel displayAllRaw() {
        List<IRawFile> rawfiles = RawFileManager.getInstance().getAllFiles();
        TabbedMultiRawFilePanel multiRawPanel = new TabbedMultiRawFilePanel(rawfiles);
        this.addRawTab("All", multiRawPanel);
        return multiRawPanel;
    }

    public PropertiesPanel displayProperties(List<IRawFile> rawFiles) {
        if (rawFiles != null && rawFiles.size() > 0) {
            PropertiesPanel propertiesPanel = new PropertiesPanel(rawFiles);
            String title = rawFiles.size() == 1 ? "Properties" : "Properties " + rawFiles.get(0).getName();
            this.addTab(this.viewersTabPane, title, propertiesPanel, "Raw file properties panel");
            return propertiesPanel;
        }
        return null;
    }

    public QCMetricsPanel displayMetrics(List<QCMetrics> metrics) {
        if (metrics != null && metrics.size() > 0) {
            QCMetricsPanel metricsPanel = new QCMetricsPanel(metrics);
            this.addTab(this.viewersTabPane, "QC Metrics", metricsPanel, "QC metrics panel");
            return metricsPanel;
        }
        return null;
    }

    public LcMsViewer displayLCMSMap(IRawFile rawFile) {
        JDialog mapDialog = new JDialog(this.parentFrame);
        mapDialog.setTitle("LCMS Map Viewer");
        LcMsViewer viewer = new LcMsViewer(new LcMsMap(rawFile.getFile().getAbsolutePath()));
        LcMsViewerUI viewerUI = new LcMsViewerUI();
        mapDialog.add((Component)viewerUI.getGui(), "Center");
        mapDialog.setLocationRelativeTo(this);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        mapDialog.setBounds(0, 0, screenSize.width, screenSize.height);
        mapDialog.setVisible(true);
        viewerUI.setViewer(viewer);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        viewerUI.getController().changeViewport(new LcMsViewport(390.0, 440.0, 1000.0, 1150.0));
        return viewer;
    }

    public void export(final List<IRawFile> rawFiles) {
        final ExportRawFileDialog exportDialog = ExportRawFileDialog.getDialog(this.parentFrame, rawFiles.size() == 1 ? rawFiles.get(0).getName() : "selected Files");
        exportDialog.setLocationRelativeTo(this.parentFrame);
        exportDialog.setSelectionMode(rawFiles.size() == 1 ? 0 : 1);
        DefaultDialog.ProgressTask task = new DefaultDialog.ProgressTask(){

            public int getMinValue() {
                return 0;
            }

            public int getMaxValue() {
                return 100;
            }

            protected Object doInBackground() throws Exception {
                if (rawFiles.size() == 1) {
                    MzScopePanel.this.exportRawFile((IRawFile)rawFiles.get(0), exportDialog.getOutputFileName(), exportDialog.getExportParams());
                    this.setProgress(100);
                } else {
                    for (int i = 0; i < rawFiles.size(); ++i) {
                        IRawFile rawFile = (IRawFile)rawFiles.get(i);
                        String filename = rawFile.getName();
                        filename = filename.substring(0, filename.lastIndexOf(46));
                        StringBuilder filenameBuilder = new StringBuilder(exportDialog.getOutputFileName()).append('/').append(filename);
                        filenameBuilder.append('.').append(exportDialog.getFileExtension());
                        this.setProgress(0);
                        MzScopePanel.this.exportRawFile(rawFile, filenameBuilder.toString(), exportDialog.getExportParams());
                        this.setProgress((int)((double)(i + 1) * (100.0 / (double)rawFiles.size())));
                        this.firePropertyChange("progress", (int)((double)i * (100.0 / (double)rawFiles.size())), (int)((double)(i + 1) * (100.0 / (double)rawFiles.size())));
                    }
                    this.setProgress(100);
                }
                return null;
            }
        };
        exportDialog.setTask(task);
        exportDialog.setVisible(true);
    }

    private boolean exportRawFile(IRawFile rawFile, String exportFileName, IExportParameters exportParams) {
        return rawFile.exportRawFile(exportFileName, exportParams);
    }

    @Override
    public IRawFileViewer getTabbedMultiRawFileViewer() {
        int nbT = this.viewersTabPane.getTabCount();
        TabbedMultiRawFilePanel panel = null;
        for (int i = 0; i < nbT; ++i) {
            if (!(this.viewersTabPane.getComponentAt(i) instanceof TabbedMultiRawFilePanel)) continue;
            panel = (TabbedMultiRawFilePanel)this.viewersTabPane.getComponentAt(i);
        }
        if (panel == null) {
            panel = this.displayAllRaw();
        }
        return panel;
    }

    private boolean isDIAFiles(List<IRawFile> rawfiles) {
        return rawfiles.stream().anyMatch(rf -> rf.isDIAFile());
    }

    @Override
    public void displayFeatures(Map<String, List<IFeature>> features) {
        DetectedFeaturesPanel featurePanel = new DetectedFeaturesPanel(this);
        this.addFeatureTab("Generated Features", featurePanel, "generated");
        this.featuresTabPane.setSelectedComponent(featurePanel);
        featurePanel.setFeatures(features, false);
    }
}

