/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.cache;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.AbstractMzDbReader;
import fr.profi.mzdb.io.reader.MzDbReaderQueries;
import fr.profi.mzdb.io.reader.cache.AbstractDataEncodingReader;
import fr.profi.mzdb.io.reader.cache.MzDbEntityCacheContainer;
import fr.profi.mzdb.io.reader.table.ParamTreeParser;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.PeakEncoding;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.util.sqlite.ISQLiteRecordExtraction;
import fr.profi.mzdb.util.sqlite.SQLiteQuery;
import fr.profi.mzdb.util.sqlite.SQLiteRecord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractSpectrumHeaderReader
extends MzDbEntityCacheContainer {
    protected static final int TIME_INDEX_WIDTH = 15;
    private AbstractDataEncodingReader _dataEncodingReader;
    private ISQLiteRecordExtraction<SpectrumHeader> _spectrumHeaderExtractor;
    private static String _spectrumHeaderQueryStr = "SELECT id, initial_id, cycle, time, ms_level, tic, base_peak_mz, base_peak_intensity, main_precursor_mz, main_precursor_charge, data_points_count, param_tree, scan_list, precursor_list, data_encoding_id, bb_first_spectrum_id FROM spectrum";
    private static String _ms1SpectrumHeaderQueryStr = _spectrumHeaderQueryStr + " WHERE ms_level = 1";
    private static String _ms2SpectrumHeaderQueryStr = _spectrumHeaderQueryStr + " WHERE ms_level = 2";
    private static String _ms3SpectrumHeaderQueryStr = _spectrumHeaderQueryStr + " WHERE ms_level = 3";

    public AbstractSpectrumHeaderReader(AbstractMzDbReader mzDbReader, AbstractDataEncodingReader dataEncodingReader) throws SQLiteException {
        super(mzDbReader);
        this._dataEncodingReader = dataEncodingReader;
    }

    private ISQLiteRecordExtraction<SpectrumHeader> _getSpectrumHeaderExtractor(final SQLiteConnection connection) throws SQLiteException {
        if (this._spectrumHeaderExtractor != null) {
            return this._spectrumHeaderExtractor;
        }
        final AbstractMzDbReader mzDbReader = this.getMzDbReader();
        this._spectrumHeaderExtractor = new ISQLiteRecordExtraction<SpectrumHeader>(){

            @Override
            public SpectrumHeader extract(SQLiteRecord record) throws SQLiteException {
                SQLiteStatement stmt = record.getStatement();
                int msLevel = stmt.columnInt(SpectrumHeaderColIdx.msLevel);
                double precursorMz = 0.0;
                int precursorCharge = 0;
                if (msLevel >= 2) {
                    precursorMz = stmt.columnDouble(SpectrumHeaderColIdx.mainPrecursorMz);
                    precursorCharge = stmt.columnInt(SpectrumHeaderColIdx.mainPrecursorCharge);
                }
                int bbFirstSpectrumId = stmt.columnInt(SpectrumHeaderColIdx.bbFirstSpectrumId);
                DataEncoding dataEnc = AbstractSpectrumHeaderReader.this._dataEncodingReader.getDataEncoding(stmt.columnInt(SpectrumHeaderColIdx.dataEncodingId), connection);
                boolean isHighRes = dataEnc.getPeakEncoding() != PeakEncoding.LOW_RES_PEAK;
                SpectrumHeader sh = new SpectrumHeader(stmt.columnLong(SpectrumHeaderColIdx.id), stmt.columnInt(SpectrumHeaderColIdx.initialId), stmt.columnInt(SpectrumHeaderColIdx.cycleCol), (float)stmt.columnDouble(SpectrumHeaderColIdx.time), msLevel, stmt.columnInt(SpectrumHeaderColIdx.dataPointsCount), isHighRes, (float)stmt.columnDouble(SpectrumHeaderColIdx.tic), stmt.columnDouble(SpectrumHeaderColIdx.basePeakMz), (float)stmt.columnDouble(SpectrumHeaderColIdx.basePeakIntensity), precursorMz, precursorCharge, bbFirstSpectrumId);
                if (mzDbReader.isParamTreeLoadingEnabled()) {
                    sh.setParamTree(ParamTreeParser.parseParamTree(stmt.columnString(SpectrumHeaderColIdx.paramTree)));
                }
                if (mzDbReader.isScanListLoadingEnabled()) {
                    sh.setScanList(ParamTreeParser.parseScanList(stmt.columnString(SpectrumHeaderColIdx.scanList)));
                }
                if (mzDbReader.isPrecursorListLoadingEnabled() && msLevel >= 2) {
                    sh.setPrecursor(ParamTreeParser.parsePrecursor(stmt.columnString(SpectrumHeaderColIdx.precursorList)));
                }
                return sh;
            }
        };
        return this._spectrumHeaderExtractor;
    }

    private SpectrumHeader[] _loadSpectrumHeaders(SQLiteConnection connection, int msLevel, String queryStr) throws SQLiteException {
        int spectraCount = MzDbReaderQueries.getSpectraCount(msLevel, connection);
        SpectrumHeader[] spectrumHeaders = new SpectrumHeader[spectraCount];
        new SQLiteQuery(connection, queryStr).extractRecords(this._getSpectrumHeaderExtractor(connection), spectrumHeaders);
        return spectrumHeaders;
    }

    private Map<Long, SpectrumHeader> _buildSpectrumHeaderById(SpectrumHeader[] spectrumHeaders) throws SQLiteException {
        HashMap<Long, SpectrumHeader> spectrumHeaderById = new HashMap<Long, SpectrumHeader>(spectrumHeaders.length);
        for (SpectrumHeader spectrumHeader : spectrumHeaders) {
            spectrumHeaderById.put(spectrumHeader.getId(), spectrumHeader);
        }
        return spectrumHeaderById;
    }

    protected SpectrumHeader[] getSpectrumHeaders(SQLiteConnection connection) throws SQLiteException {
        if (this.getEntityCache() != null && this.getEntityCache().spectrumHeaders != null) {
            return this.getEntityCache().spectrumHeaders;
        }
        SpectrumHeader[] ms1SpectrumHeaders = this.getMs1SpectrumHeaders(connection);
        SpectrumHeader[] ms2SpectrumHeaders = this.getMs2SpectrumHeaders(connection);
        SpectrumHeader[] ms3SpectrumHeaders = this.getMs3SpectrumHeaders(connection);
        int spectraCount = ms1SpectrumHeaders.length + ms2SpectrumHeaders.length + ms3SpectrumHeaders.length;
        SpectrumHeader[] spectrumHeaders = new SpectrumHeader[spectraCount];
        System.arraycopy(ms1SpectrumHeaders, 0, spectrumHeaders, 0, ms1SpectrumHeaders.length);
        System.arraycopy(ms2SpectrumHeaders, 0, spectrumHeaders, ms1SpectrumHeaders.length, ms2SpectrumHeaders.length);
        System.arraycopy(ms3SpectrumHeaders, 0, spectrumHeaders, ms1SpectrumHeaders.length + ms2SpectrumHeaders.length, ms3SpectrumHeaders.length);
        if (this.getEntityCache() != null) {
            this.getEntityCache().spectrumHeaders = spectrumHeaders;
        }
        return spectrumHeaders;
    }

    public Map<Long, SpectrumHeader> getSpectrumHeaderById(SQLiteConnection connection) throws SQLiteException {
        if (this.getEntityCache() != null && this.getEntityCache().spectrumHeaderById != null) {
            return this.getEntityCache().spectrumHeaderById;
        }
        Map<Long, SpectrumHeader> spectrumHeaderById = this._buildSpectrumHeaderById(this.getSpectrumHeaders(connection));
        if (this.getEntityCache() != null) {
            this.getEntityCache().spectrumHeaderById = spectrumHeaderById;
        }
        return spectrumHeaderById;
    }

    protected SpectrumHeader[] getMs1SpectrumHeaders(SQLiteConnection connection) throws SQLiteException {
        if (this.getEntityCache() != null && this.getEntityCache().ms1SpectrumHeaders != null) {
            return this.getEntityCache().ms1SpectrumHeaders;
        }
        SpectrumHeader[] ms1SpectrumHeaders = this._loadSpectrumHeaders(connection, 1, _ms1SpectrumHeaderQueryStr);
        if (this.getEntityCache() != null) {
            this.getEntityCache().ms1SpectrumHeaders = ms1SpectrumHeaders;
        }
        return ms1SpectrumHeaders;
    }

    public Map<Long, SpectrumHeader> getMs1SpectrumHeaderById(SQLiteConnection connection) throws SQLiteException {
        if (this.getEntityCache() != null && this.getEntityCache().ms1SpectrumHeaderById != null) {
            return this.getEntityCache().ms1SpectrumHeaderById;
        }
        Map<Long, SpectrumHeader> ms1SpectrumHeaderById = this._buildSpectrumHeaderById(this.getMs1SpectrumHeaders(connection));
        if (this.getEntityCache() != null) {
            this.getEntityCache().ms1SpectrumHeaderById = ms1SpectrumHeaderById;
        }
        return ms1SpectrumHeaderById;
    }

    protected SpectrumHeader[] getMs2SpectrumHeaders(SQLiteConnection connection) throws SQLiteException {
        if (this.getEntityCache() != null && this.getEntityCache().ms2SpectrumHeaders != null) {
            return this.getEntityCache().ms2SpectrumHeaders;
        }
        SpectrumHeader[] ms2SpectrumHeaders = this._loadSpectrumHeaders(connection, 2, _ms2SpectrumHeaderQueryStr);
        if (this.getEntityCache() != null) {
            this.getEntityCache().ms2SpectrumHeaders = ms2SpectrumHeaders;
        }
        return ms2SpectrumHeaders;
    }

    public Map<Long, SpectrumHeader> getMs2SpectrumHeaderById(SQLiteConnection connection) throws SQLiteException {
        if (this.getEntityCache() != null && this.getEntityCache().ms2SpectrumHeaderById != null) {
            return this.getEntityCache().ms2SpectrumHeaderById;
        }
        Map<Long, SpectrumHeader> ms2SpectrumHeaderById = this._buildSpectrumHeaderById(this.getMs2SpectrumHeaders(connection));
        if (this.getEntityCache() != null) {
            this.getEntityCache().ms2SpectrumHeaderById = ms2SpectrumHeaderById;
        }
        return ms2SpectrumHeaderById;
    }

    protected SpectrumHeader[] getMs3SpectrumHeaders(SQLiteConnection connection) throws SQLiteException {
        if (this.getEntityCache() != null && this.getEntityCache().ms3SpectrumHeaders != null) {
            return this.getEntityCache().ms3SpectrumHeaders;
        }
        SpectrumHeader[] ms3SpectrumHeaders = this._loadSpectrumHeaders(connection, 3, _ms3SpectrumHeaderQueryStr);
        if (this.getEntityCache() != null) {
            this.getEntityCache().ms3SpectrumHeaders = ms3SpectrumHeaders;
        }
        return ms3SpectrumHeaders;
    }

    public Map<Long, SpectrumHeader> getMs3SpectrumHeaderById(SQLiteConnection connection) throws SQLiteException {
        if (this.getEntityCache() != null && this.getEntityCache().ms3SpectrumHeaderById != null) {
            return this.getEntityCache().ms3SpectrumHeaderById;
        }
        Map<Long, SpectrumHeader> ms3SpectrumHeaderById = this._buildSpectrumHeaderById(this.getMs3SpectrumHeaders(connection));
        if (this.getEntityCache() != null) {
            this.getEntityCache().ms3SpectrumHeaderById = ms3SpectrumHeaderById;
        }
        return ms3SpectrumHeaderById;
    }

    public SpectrumHeader getSpectrumHeader(long id, SQLiteConnection connection) throws SQLiteException {
        if (this.getEntityCache() != null) {
            return this.getSpectrumHeaderById(connection).get(id);
        }
        String queryStr = _spectrumHeaderQueryStr + " WHERE id = ? ";
        return new SQLiteQuery(connection, queryStr).bind(1, id).extractRecord(this._spectrumHeaderExtractor);
    }

    protected Map<Long, Float> getSpectrumTimeById(SQLiteConnection connection) throws SQLiteException {
        float[] spectrumTimes;
        if (this.getEntityCache() != null && this.getEntityCache().spectrumTimeById != null) {
            return this.getEntityCache().spectrumTimeById;
        }
        int spectraCount = MzDbReaderQueries.getSpectraCount(connection);
        if (spectraCount != (spectrumTimes = new SQLiteQuery(connection, "SELECT time FROM spectrum").extractFloats(spectraCount)).length) {
            System.err.println("extractFloats error: spectraCount != spectrumTimes.length");
        }
        HashMap<Long, Float> spectrumTimeById = new HashMap<Long, Float>(spectraCount);
        long spectrumId = 0L;
        for (float spectrumTime : spectrumTimes) {
            spectrumTimeById.put(++spectrumId, Float.valueOf(spectrumTime));
        }
        if (this.getEntityCache() != null) {
            this.getEntityCache().spectrumTimeById = spectrumTimeById;
        }
        return spectrumTimeById;
    }

    protected SpectrumHeader getSpectrumHeaderForTime(float time, int msLevel, SQLiteConnection connection) throws Exception {
        if (this.getEntityCache() != null) {
            Map<Integer, ArrayList<Long>> spectrumIdsByTimeIndex = this._getSpectrumIdsByTimeIndex(connection);
            int timeIndex = (int)(time / 15.0f);
            SpectrumHeader nearestSpectrumHeader = null;
            for (int index = timeIndex - 1; index <= timeIndex + 1; ++index) {
                if (!spectrumIdsByTimeIndex.containsKey(index)) continue;
                ArrayList<Long> tmpSpectrumIds = spectrumIdsByTimeIndex.get(index);
                for (Long tmpSpectrumId : tmpSpectrumIds) {
                    SpectrumHeader spectrumH = this.getSpectrumHeader(tmpSpectrumId, connection);
                    if (spectrumH == null) {
                        throw new Exception("can' t retrieve spectrum with id =" + tmpSpectrumId);
                    }
                    if (spectrumH.getMsLevel() != msLevel || nearestSpectrumHeader != null && !(Math.abs(spectrumH.getTime() - time) < Math.abs(nearestSpectrumHeader.getTime() - time))) continue;
                    nearestSpectrumHeader = spectrumH;
                }
            }
            return nearestSpectrumHeader;
        }
        String queryStr = "SELECT id FROM spectrum WHERE ms_level = ? ORDER BY abs(spectrum.time - ?) ASC limit 1";
        int spectrumId = new SQLiteQuery(connection, queryStr).bind(1, msLevel).bind(2, time).extractSingleInt();
        return this.getSpectrumHeader(spectrumId, connection);
    }

    private Map<Integer, ArrayList<Long>> _getSpectrumIdsByTimeIndex(SQLiteConnection connection) throws SQLiteException {
        SpectrumHeader[] spectrumHeaders;
        HashMap<Integer, ArrayList<Long>> spectrumIdsByTimeIndex = null;
        if (this.getEntityCache() != null) {
            spectrumIdsByTimeIndex = (HashMap<Integer, ArrayList<Long>>)this.getEntityCache().spectrumIdsByTimeIndex;
        }
        if (spectrumIdsByTimeIndex != null) {
            return spectrumIdsByTimeIndex;
        }
        spectrumIdsByTimeIndex = new HashMap<Integer, ArrayList<Long>>();
        for (SpectrumHeader spectrumH : spectrumHeaders = this.getSpectrumHeaders(connection)) {
            int timeIndex = (int)(spectrumH.getTime() / 15.0f);
            if (spectrumIdsByTimeIndex.get(timeIndex) == null) {
                spectrumIdsByTimeIndex.put(timeIndex, new ArrayList());
            }
            spectrumIdsByTimeIndex.get(timeIndex).add(spectrumH.getId());
        }
        if (this.getEntityCache() != null) {
            this.getEntityCache().spectrumIdsByTimeIndex = spectrumIdsByTimeIndex;
        }
        return spectrumIdsByTimeIndex;
    }

    protected long[] getSpectrumIdsForTimeRange(float minRT, float maxRT, int msLevel, SQLiteConnection connection) throws SQLiteException {
        SQLiteQuery query = new SQLiteQuery(connection, "SELECT id FROM spectrum WHERE ms_level = ? AND time >= ? AND time <= ?");
        return query.bind(1, msLevel).bind(2, minRT).bind(3, maxRT).extractLongs(1);
    }

    private static class SpectrumHeaderColIdx {
        static int id = SpectrumHeaderCol.ID.ordinal();
        static int initialId = SpectrumHeaderCol.INITIAL_ID.ordinal();
        static int cycleCol = SpectrumHeaderCol.CYCLE.ordinal();
        static int time = SpectrumHeaderCol.TIME.ordinal();
        static int msLevel = SpectrumHeaderCol.MS_LEVEL.ordinal();
        static int tic = SpectrumHeaderCol.TIC.ordinal();
        static int basePeakMz = SpectrumHeaderCol.BASE_PEAK_MZ.ordinal();
        static int basePeakIntensity = SpectrumHeaderCol.BASE_PEAK_INTENSITY.ordinal();
        static int mainPrecursorMz = SpectrumHeaderCol.MAIN_PRECURSOR_MZ.ordinal();
        static int mainPrecursorCharge = SpectrumHeaderCol.MAIN_PRECURSOR_CHARGE.ordinal();
        static int dataPointsCount = SpectrumHeaderCol.DATA_POINTS_COUNT.ordinal();
        static int paramTree = SpectrumHeaderCol.PARAM_TREE.ordinal();
        static int scanList = SpectrumHeaderCol.SCAN_LIST.ordinal();
        static int precursorList = SpectrumHeaderCol.PRECURSOR_LIST.ordinal();
        static int dataEncodingId = SpectrumHeaderCol.DATA_ENCODING_ID.ordinal();
        static int bbFirstSpectrumId = SpectrumHeaderCol.BB_FIRST_SPECTRUM_ID.ordinal();

        private SpectrumHeaderColIdx() {
        }
    }

    private static enum SpectrumHeaderCol {
        ID("id"),
        INITIAL_ID("initial_id"),
        CYCLE("cycle"),
        TIME("time"),
        MS_LEVEL("ms_level"),
        TIC("tic"),
        BASE_PEAK_MZ("base_peak_mz"),
        BASE_PEAK_INTENSITY("base_peak_intensity"),
        MAIN_PRECURSOR_MZ("main_precursor_mz"),
        MAIN_PRECURSOR_CHARGE("main_precursor_charge"),
        DATA_POINTS_COUNT("data_points_count"),
        PARAM_TREE("param_tree"),
        SCAN_LIST("scan_list"),
        PRECURSOR_LIST("precursor_list"),
        DATA_ENCODING_ID("data_encoding_id"),
        BB_FIRST_SPECTRUM_ID("bb_first_spectrum_id");

        protected final String columnName;

        private SpectrumHeaderCol(String colName) {
            this.columnName = colName;
        }
    }
}

