/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.model;

public enum AcquisitionMode {
    DDA("DDA acquisition", "Data Dependant Acquisition (Thermo designation), Warning: in ABI this is called IDA (Information Dependant Acquisition)"),
    SWATH("SWATH acquisition", "ABI Swath acquisition or Thermo swath acquisition"),
    MRM("MRM acquisition", "Multiple reaction monitoring"),
    SRM("SRM acquisition", "Single reaction monitoring"),
    UNKNOWN("UNKNOWN acquisition", "unknown acquisition mode");

    private String description;
    private String code;

    private AcquisitionMode(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.code;
    }

    public static AcquisitionMode getAcquisitionMode(String code) {
        AcquisitionMode[] acqModes;
        for (AcquisitionMode acquisitionMode : acqModes = AcquisitionMode.values()) {
            if (!acquisitionMode.code.equals(code)) continue;
            return acquisitionMode;
        }
        return UNKNOWN;
    }
}

