/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.model;

import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.io.reader.bb.IBlobReader;
import fr.profi.mzdb.model.DataMode;
import fr.profi.mzdb.model.SpectrumSlice;
import java.util.HashSet;

public class BoundingBox
implements Comparable<BoundingBox> {
    private int _id;
    protected long _firstSpectrumId;
    protected long _lastSpectrumId;
    protected int _runSliceId;
    protected int _msLevel;
    protected DataMode _dataMode;
    protected IBlobReader _reader;

    public BoundingBox(int id, IBlobReader _reader) {
        this._id = id;
        this._reader = _reader;
    }

    public int getId() {
        return this._id;
    }

    public void setId(int _id) {
        this._id = _id;
    }

    public IBlobReader getReader() {
        return this._reader;
    }

    public long getFirstSpectrumId() {
        return this._firstSpectrumId;
    }

    public void setFirstSpectrumId(long spectrumId) {
        this._firstSpectrumId = spectrumId;
    }

    public long getLastSpectrumId() {
        return this._lastSpectrumId;
    }

    public void setLastSpectrumId(long spectrumId) {
        this._lastSpectrumId = spectrumId;
    }

    public int getRunSliceId() {
        return this._runSliceId;
    }

    public void setRunSliceId(int _runSliceId) {
        this._runSliceId = _runSliceId;
    }

    public int getSpectraCount() {
        return this._reader.getSpectraCount();
    }

    public float getMinSpectrumId() throws SQLiteException {
        return this._reader.getSpectrumIdAt(0);
    }

    public float getMaxSpectrumId() {
        return this._reader.getSpectrumIdAt(this.getSpectraCount() - 1);
    }

    public SpectrumSlice[] toSpectrumSlices() {
        SpectrumSlice[] spectrumSliceArray = this._reader.readAllSpectrumSlices(this._runSliceId);
        HashSet<Long> spectrumIdSet = new HashSet<Long>();
        for (SpectrumSlice spectrumSlice : spectrumSliceArray) {
            long spectrumId = spectrumSlice.getHeader().getId();
            if (spectrumIdSet.contains(spectrumId)) {
                throw new IllegalArgumentException("duplicated spectrum id is: " + spectrumId);
            }
            spectrumIdSet.add(spectrumId);
        }
        return spectrumSliceArray;
    }

    @Override
    public int compareTo(BoundingBox bb) {
        try {
            if (this.getMinSpectrumId() < bb.getMinSpectrumId()) {
                return -1;
            }
            if (Math.abs(this.getMinSpectrumId() - bb.getMinSpectrumId()) == 0.0f) {
                return 0;
            }
        }
        catch (SQLiteException e) {
            e.printStackTrace();
        }
        return 1;
    }
}

