/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.repository;

import fr.profi.util.PropertiesUtils;
import fr.profi.util.StringUtils;
import fr.proline.repository.AbstractDatabaseConnector;
import fr.proline.repository.DriverType;
import fr.proline.repository.H2DatabaseConnector;
import fr.proline.repository.IDatabaseConnector;
import fr.proline.repository.PostgresDatabaseConnector;
import fr.proline.repository.ProlineDatabaseType;
import fr.proline.repository.SQLiteDatabaseConnector;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseConnectorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseConnectorFactory.class);

    private DatabaseConnectorFactory() {
    }

    public static IDatabaseConnector createDatabaseConnectorInstance(ProlineDatabaseType database, Map<Object, Object> properties) {
        if (database == null) {
            throw new IllegalArgumentException("Database is null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Properties Map is null");
        }
        String databaseURL = PropertiesUtils.getProperty(properties, (String)"javax.persistence.jdbc.url");
        if (databaseURL == null) {
            throw new IllegalArgumentException("Invalid database URL");
        }
        AbstractDatabaseConnector result = null;
        String normalizedDatabaseURL = databaseURL.toLowerCase();
        if (normalizedDatabaseURL.contains("jdbc:" + DriverType.POSTGRESQL.getJdbcURLProtocol())) {
            result = new PostgresDatabaseConnector(database, properties, IDatabaseConnector.DEFAULT_POOL_TYPE);
        } else if (normalizedDatabaseURL.contains("jdbc:" + DriverType.SQLITE.getJdbcURLProtocol())) {
            result = new SQLiteDatabaseConnector(database, properties);
        } else if (normalizedDatabaseURL.contains("jdbc:" + DriverType.H2.getJdbcURLProtocol())) {
            result = new H2DatabaseConnector(database, properties);
        } else {
            throw new IllegalArgumentException("Unknown database protocol");
        }
        return result;
    }

    public static IDatabaseConnector createDatabaseConnectorInstance(ProlineDatabaseType database, String propertiesFileName) {
        if (database == null) {
            throw new IllegalArgumentException("Database is null");
        }
        if (StringUtils.isEmpty((String)propertiesFileName)) {
            throw new IllegalArgumentException("Invalid propertiesFileName");
        }
        return DatabaseConnectorFactory.createDatabaseConnectorInstance(database, PropertiesUtils.loadProperties((String)propertiesFileName));
    }
}

