/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.repository;

import fr.profi.util.SQLUtils;
import fr.profi.util.StringUtils;
import fr.proline.repository.DriverType;
import fr.proline.repository.IDatabaseConnector;
import fr.proline.repository.ProlineDatabaseType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseUpgrader {
    public static final String MIGRATION_SCRIPTS_DIR = "dbscripts/";
    public static final String MIGRATION_CLASSPATH = "/fr/proline/repository/migration/";
    public static String JDBC_PASSWORD = null;
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseUpgrader.class);
    private static final int BUFFER_SIZE = 256;
    private static final String UDS_DB_SCRIPT_NAME = "V0_1__init_udsdb.sql";
    private static final String MSI_DB_SCRIPT_NAME = "V0_1__init_msidb.sql";
    private static final String LCMS_DB_SCRIPT_NAME = "V0_1__init_lcmsdb.sql";

    private DatabaseUpgrader() {
    }

    public static String buildMigrationScriptsLocation(ProlineDatabaseType database, DriverType driverType) {
        if (database == null) {
            throw new IllegalArgumentException("Database is null");
        }
        if (driverType == null) {
            throw new IllegalArgumentException("DriverType is null");
        }
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(MIGRATION_SCRIPTS_DIR);
        buffer.append(database.name().toLowerCase()).append('/');
        buffer.append(driverType.name().toLowerCase());
        return buffer.toString();
    }

    public static String buildMigrationClassLocation(ProlineDatabaseType database, DriverType driverType) {
        if (database == null) {
            throw new IllegalArgumentException("Database is null");
        }
        if (driverType == null) {
            throw new IllegalArgumentException("DriverType is null");
        }
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(MIGRATION_CLASSPATH);
        buffer.append(database.name().toLowerCase());
        String classPath = buffer.toString();
        URL rsc = DatabaseUpgrader.class.getResource(classPath);
        if (rsc == null) {
            return null;
        }
        return classPath;
    }

    public static int upgradeDatabase(IDatabaseConnector connector, String migrationScriptsLocation, String migrationClassLocation, boolean repairChecksum) {
        int migrationsCount;
        block14: {
            if (connector == null) {
                throw new IllegalArgumentException("Connector is null");
            }
            if (StringUtils.isEmpty((String)migrationScriptsLocation)) {
                throw new IllegalArgumentException("Invalid migrationLocation");
            }
            ProlineDatabaseType prolineDbType = connector.getProlineDatabaseType();
            LOG.debug("Upgrading {} Db, migrationScriptsLocation [{}], migrationClassLocation [{}]", new Object[]{prolineDbType, migrationScriptsLocation, migrationClassLocation});
            migrationsCount = -1;
            try {
                if (connector.getDriverType() == DriverType.SQLITE) {
                    migrationsCount = DatabaseUpgrader.upgradeSQLiteDb(connector, migrationScriptsLocation);
                    break block14;
                }
                Flyway flyway = new Flyway();
                if (migrationClassLocation != null) {
                    flyway.setLocations(new String[]{migrationScriptsLocation, migrationClassLocation});
                } else {
                    flyway.setLocations(new String[]{migrationScriptsLocation});
                }
                flyway.setDataSource(connector.getDataSource());
                MigrationInfo[] appliedMigrations = null;
                try {
                    appliedMigrations = flyway.info().applied();
                }
                catch (Throwable t) {
                    LOG.error("An error occured while retrieving the Flyway migration history", t);
                }
                if (appliedMigrations != null) {
                    int nAppliedMigrations = appliedMigrations.length;
                    if (nAppliedMigrations > 0) {
                        StringBuilder allMigrationsBuilder = new StringBuilder(256);
                        allMigrationsBuilder.append("Applied ").append((Object)prolineDbType).append(" Db Flyway migrations (").append(nAppliedMigrations).append("):");
                        for (int i = 0; i < nAppliedMigrations; ++i) {
                            allMigrationsBuilder.append(StringUtils.LINE_SEPARATOR).append("Migration ").append(i).append(' ').append(DatabaseUpgrader.formatMigrationInfo(appliedMigrations[i]));
                        }
                        LOG.info(allMigrationsBuilder.toString());
                    }
                    if (repairChecksum) {
                        flyway.repair();
                    }
                }
                flyway.setOutOfOrder(true);
                JDBC_PASSWORD = (String)connector.getProperty("javax.persistence.jdbc.password");
                migrationsCount = flyway.migrate();
                LOG.info("Flyway applies {} migration(s) to {}", (Object)migrationsCount, (Object)prolineDbType);
                JDBC_PASSWORD = null;
                MigrationInfo currentMigrationInfo = flyway.info().current();
                if (currentMigrationInfo != null) {
                    LOG.info("Current {} Db Flyway Migration {}", (Object)prolineDbType, (Object)DatabaseUpgrader.formatMigrationInfo(currentMigrationInfo));
                }
            }
            catch (Exception ex) {
                LOG.error("Error upgrading " + (Object)((Object)prolineDbType) + " Db", (Throwable)ex);
            }
        }
        return migrationsCount;
    }

    public static Map<ProlineDatabaseType, Map<String, MigrationState>> getUndoneMigrations(IDatabaseConnector connector) {
        HashMap<ProlineDatabaseType, Map<String, MigrationState>> undoneMigrationsInfos;
        block10: {
            HashMap<String, MigrationState> scriptsState = new HashMap<String, MigrationState>();
            undoneMigrationsInfos = new HashMap<ProlineDatabaseType, Map<String, MigrationState>>();
            if (connector == null) {
                throw new IllegalArgumentException("Connector is null");
            }
            String migrationScriptsLocation = DatabaseUpgrader.buildMigrationScriptsLocation(connector.getProlineDatabaseType(), connector.getDriverType());
            if (StringUtils.isEmpty((String)migrationScriptsLocation)) {
                throw new IllegalArgumentException("Invalid migrationLocation");
            }
            String migrationClassLocation = DatabaseUpgrader.buildMigrationClassLocation(connector.getProlineDatabaseType(), connector.getDriverType());
            ProlineDatabaseType prolineDbType = connector.getProlineDatabaseType();
            try {
                int nAllMigrations;
                if (connector.getDriverType() == DriverType.SQLITE) break block10;
                Flyway flyway = new Flyway();
                if (migrationClassLocation != null) {
                    flyway.setLocations(new String[]{migrationScriptsLocation, migrationClassLocation});
                } else {
                    flyway.setLocations(new String[]{migrationScriptsLocation});
                }
                flyway.setDataSource(connector.getDataSource());
                MigrationInfo[] allMigrations = null;
                try {
                    allMigrations = flyway.info().all();
                }
                catch (Throwable t) {
                    LOG.error("An error occured while retrieving the Flyway migration history", t);
                }
                if (allMigrations != null && (nAllMigrations = allMigrations.length) > 0) {
                    for (int i = 0; i < nAllMigrations; ++i) {
                        String script = allMigrations[i].getScript();
                        MigrationState state = allMigrations[i].getState();
                        if (script == null || state == null || state == MigrationState.SUCCESS) continue;
                        scriptsState.put(script, state);
                    }
                    undoneMigrationsInfos.put(prolineDbType, scriptsState);
                }
            }
            catch (Exception ex) {
                LOG.error("Error while trying to check undone migrations " + (Object)((Object)prolineDbType) + " Db", (Throwable)ex);
            }
        }
        return undoneMigrationsInfos;
    }

    public static int upgradeDatabase(IDatabaseConnector connector, boolean repairChecksum) {
        if (connector == null) {
            throw new IllegalArgumentException("Connector is null");
        }
        int result = -1;
        try {
            result = DatabaseUpgrader.upgradeDatabase(connector, DatabaseUpgrader.buildMigrationScriptsLocation(connector.getProlineDatabaseType(), connector.getDriverType()), DatabaseUpgrader.buildMigrationClassLocation(connector.getProlineDatabaseType(), connector.getDriverType()), repairChecksum);
        }
        catch (Exception ex) {
            LOG.error("Error upgrading " + (Object)((Object)connector.getProlineDatabaseType()) + " Db", (Throwable)ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] extractTableNames(Connection con) throws SQLException {
        if (con == null) {
            throw new IllegalArgumentException("Con is null");
        }
        String[] result = null;
        DatabaseMetaData meta = con.getMetaData();
        ResultSet rs = meta.getTables(null, null, "%", new String[]{"TABLE"});
        try {
            ArrayList<String> tableNames = new ArrayList<String>();
            while (rs.next()) {
                Object obj = rs.getObject("TABLE_NAME");
                if (!(obj instanceof String)) continue;
                tableNames.add((String)obj);
            }
            result = tableNames.toArray(new String[tableNames.size()]);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException exClose) {
                LOG.error("Error closing tables ResultSet", (Throwable)exClose);
            }
        }
        return result;
    }

    private static String formatMigrationInfo(MigrationInfo info) {
        Date installedOn;
        MigrationState state;
        String script;
        String description;
        MigrationVersion version;
        Integer checksum;
        assert (info != null) : "formatMigrationInfo() info is null";
        StringBuilder buff = new StringBuilder(256);
        MigrationType type = info.getType();
        if (type != null) {
            buff.append("type: ").append(type);
        }
        if ((checksum = info.getChecksum()) != null) {
            if (buff.length() > 0) {
                buff.append(' ');
            }
            buff.append("checksum: ").append(String.format("0x%08X", checksum));
        }
        if ((version = info.getVersion()) != null) {
            if (buff.length() > 0) {
                buff.append(' ');
            }
            buff.append(" version: ").append(version);
        }
        if ((description = info.getDescription()) != null) {
            if (buff.length() > 0) {
                buff.append(' ');
            }
            buff.append(" description [").append(description).append(']');
        }
        if ((script = info.getScript()) != null) {
            if (buff.length() > 0) {
                buff.append(' ');
            }
            buff.append(" script [").append(script).append(']');
        }
        if ((state = info.getState()) != null) {
            if (buff.length() > 0) {
                buff.append(' ');
            }
            buff.append(" state: ").append(state);
        }
        if ((installedOn = info.getInstalledOn()) != null) {
            buff.append(" installed on ").append(installedOn);
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int upgradeSQLiteDb(IDatabaseConnector connector, String migrationScriptsLocation) throws SQLException {
        ProlineDatabaseType prolineDbType = connector.getProlineDatabaseType();
        int result = -1;
        Connection con = null;
        try {
            DataSource ds = connector.getDataSource();
            con = ds.getConnection();
            int tablesCount = 0;
            String[] tableNames = DatabaseUpgrader.extractTableNames(con);
            if (tableNames != null) {
                tablesCount = tableNames.length;
            }
            if (tablesCount == 0) {
                DatabaseUpgrader.initSQLiteDb(con, migrationScriptsLocation);
                LOG.info("{} SQLite Db initialized", (Object)prolineDbType);
                result = 1;
            } else {
                LOG.info("{} SQLite Db table count: {}, conserving current schema", (Object)prolineDbType, (Object)tablesCount);
                result = 0;
            }
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException exClose) {
                    LOG.error("Error closing  " + (Object)((Object)prolineDbType) + " SQLite Db Connection", (Throwable)exClose);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initSQLiteDb(Connection con, String migrationScriptsLocation) throws SQLException {
        String scriptName = DatabaseUpgrader.getSQLiteScriptName(migrationScriptsLocation);
        if (scriptName == null) {
            throw new IllegalArgumentException("Script directory doesn't match any supported database");
        }
        String scriptLocation = migrationScriptsLocation + '/' + scriptName;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream scriptIS = cl.getResourceAsStream(scriptLocation);
        if (scriptIS == null) {
            LOG.warn("Cannot found [{}]", (Object)scriptLocation);
        } else {
            LOG.debug("Initializing SQLite Db from [{}]", (Object)scriptLocation);
            try {
                SQLUtils.executeSQLScript((Connection)con, (InputStream)scriptIS);
            }
            finally {
                try {
                    scriptIS.close();
                }
                catch (IOException exClose) {
                    LOG.error("Error closing [" + scriptLocation + "] InputStream", (Throwable)exClose);
                }
            }
        }
    }

    private static String getSQLiteScriptName(String migrationScriptsLocation) {
        String scriptName = null;
        if (migrationScriptsLocation.contains("/uds/")) {
            scriptName = UDS_DB_SCRIPT_NAME;
        } else if (migrationScriptsLocation.contains("/msi/")) {
            scriptName = MSI_DB_SCRIPT_NAME;
        } else if (migrationScriptsLocation.contains("/lcms/")) {
            scriptName = LCMS_DB_SCRIPT_NAME;
        }
        return scriptName;
    }
}

