/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.linear;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.linear.LinearConstraint;
import org.apache.commons.math.optimization.linear.LinearObjectiveFunction;
import org.apache.commons.math.optimization.linear.Relationship;
import org.apache.commons.math.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimplexTableau
implements Serializable {
    private static final long serialVersionUID = -1369660067587938365L;
    private final LinearObjectiveFunction f;
    private final Collection<LinearConstraint> constraints;
    private final boolean restrictToNonNegative;
    protected transient RealMatrix tableau;
    protected final int numDecisionVariables;
    protected final int numSlackVariables;
    protected int numArtificialVariables;
    protected final double epsilon;

    SimplexTableau(LinearObjectiveFunction f, Collection<LinearConstraint> constraints, GoalType goalType, boolean restrictToNonNegative, double epsilon) {
        this.f = f;
        this.constraints = constraints;
        this.restrictToNonNegative = restrictToNonNegative;
        this.epsilon = epsilon;
        this.numDecisionVariables = this.getNumVariables() + (restrictToNonNegative ? 0 : 1);
        this.numSlackVariables = this.getConstraintTypeCounts(Relationship.LEQ) + this.getConstraintTypeCounts(Relationship.GEQ);
        this.numArtificialVariables = this.getConstraintTypeCounts(Relationship.EQ) + this.getConstraintTypeCounts(Relationship.GEQ);
        this.tableau = new Array2DRowRealMatrix(this.createTableau(goalType == GoalType.MAXIMIZE));
        this.initialize();
    }

    protected double[][] createTableau(boolean maximize) {
        List<LinearConstraint> constraints = this.getNormalizedConstraints();
        int width = this.numDecisionVariables + this.numSlackVariables + this.numArtificialVariables + this.getNumObjectiveFunctions() + 1;
        int height = constraints.size() + this.getNumObjectiveFunctions();
        double[][] matrix = new double[height][width];
        if (this.getNumObjectiveFunctions() == 2) {
            matrix[0][0] = -1.0;
        }
        int zIndex = this.getNumObjectiveFunctions() == 1 ? 0 : 1;
        matrix[zIndex][zIndex] = maximize ? 1.0 : -1.0;
        RealVector objectiveCoefficients = maximize ? this.f.getCoefficients().mapMultiply(-1.0) : this.f.getCoefficients();
        this.copyArray(objectiveCoefficients.getData(), matrix[zIndex], this.getNumObjectiveFunctions());
        double d = matrix[zIndex][width - 1] = maximize ? this.f.getConstantTerm() : -1.0 * this.f.getConstantTerm();
        if (!this.restrictToNonNegative) {
            matrix[zIndex][this.getSlackVariableOffset() - 1] = SimplexTableau.getInvertedCoeffiecientSum(objectiveCoefficients);
        }
        int slackVar = 0;
        int artificialVar = 0;
        for (int i = 0; i < constraints.size(); ++i) {
            LinearConstraint constraint = constraints.get(i);
            int row = this.getNumObjectiveFunctions() + i;
            this.copyArray(constraint.getCoefficients().getData(), matrix[row], 1);
            if (!this.restrictToNonNegative) {
                matrix[row][this.getSlackVariableOffset() - 1] = SimplexTableau.getInvertedCoeffiecientSum(constraint.getCoefficients());
            }
            matrix[row][width - 1] = constraint.getValue();
            if (constraint.getRelationship() == Relationship.LEQ) {
                matrix[row][this.getSlackVariableOffset() + slackVar++] = 1.0;
            } else if (constraint.getRelationship() == Relationship.GEQ) {
                matrix[row][this.getSlackVariableOffset() + slackVar++] = -1.0;
            }
            if (constraint.getRelationship() != Relationship.EQ && constraint.getRelationship() != Relationship.GEQ) continue;
            matrix[0][this.getArtificialVariableOffset() + artificialVar] = 1.0;
            matrix[row][this.getArtificialVariableOffset() + artificialVar++] = 1.0;
        }
        return matrix;
    }

    public int getNumVariables() {
        return this.f.getCoefficients().getDimension();
    }

    public List<LinearConstraint> getNormalizedConstraints() {
        ArrayList<LinearConstraint> normalized = new ArrayList<LinearConstraint>();
        for (LinearConstraint constraint : this.constraints) {
            normalized.add(this.normalize(constraint));
        }
        return normalized;
    }

    private LinearConstraint normalize(LinearConstraint constraint) {
        if (constraint.getValue() < 0.0) {
            return new LinearConstraint(constraint.getCoefficients().mapMultiply(-1.0), constraint.getRelationship().oppositeRelationship(), -1.0 * constraint.getValue());
        }
        return new LinearConstraint(constraint.getCoefficients(), constraint.getRelationship(), constraint.getValue());
    }

    protected final int getNumObjectiveFunctions() {
        return this.numArtificialVariables > 0 ? 2 : 1;
    }

    private int getConstraintTypeCounts(Relationship relationship) {
        int count = 0;
        for (LinearConstraint constraint : this.constraints) {
            if (constraint.getRelationship() != relationship) continue;
            ++count;
        }
        return count;
    }

    private void initialize() {
        for (int artificialVar = 0; artificialVar < this.numArtificialVariables; ++artificialVar) {
            int row = this.getBasicRow(this.getArtificialVariableOffset() + artificialVar);
            this.subtractRow(0, row, 1.0);
        }
    }

    protected static double getInvertedCoeffiecientSum(RealVector coefficients) {
        double sum = 0.0;
        for (double coefficient : coefficients.getData()) {
            sum -= coefficient;
        }
        return sum;
    }

    private Integer getBasicRow(int col) {
        Integer row = null;
        for (int i = this.getNumObjectiveFunctions(); i < this.getHeight(); ++i) {
            if (MathUtils.equals(this.getEntry(i, col), 1.0, this.epsilon) && row == null) {
                row = i;
                continue;
            }
            if (MathUtils.equals(this.getEntry(i, col), 0.0, this.epsilon)) continue;
            return null;
        }
        return row;
    }

    protected void discardArtificialVariables() {
        if (this.numArtificialVariables == 0) {
            return;
        }
        int width = this.getWidth() - this.numArtificialVariables - 1;
        int height = this.getHeight() - 1;
        double[][] matrix = new double[height][width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width - 1; ++j) {
                matrix[i][j] = this.getEntry(i + 1, j + 1);
            }
            matrix[i][width - 1] = this.getEntry(i + 1, this.getRhsOffset());
        }
        this.tableau = new Array2DRowRealMatrix(matrix);
        this.numArtificialVariables = 0;
    }

    private void copyArray(double[] src, double[] dest, int destPos) {
        System.arraycopy(src, 0, dest, this.getNumObjectiveFunctions(), src.length);
    }

    protected RealPointValuePair getSolution() {
        double[] coefficients = new double[this.getOriginalNumDecisionVariables()];
        Integer basicRow = this.getBasicRow(this.getNumObjectiveFunctions() + this.getOriginalNumDecisionVariables());
        double mostNegative = basicRow == null ? 0.0 : this.getEntry(basicRow, this.getRhsOffset());
        HashSet<Integer> basicRows = new HashSet<Integer>();
        for (int i = 0; i < coefficients.length; ++i) {
            basicRow = this.getBasicRow(this.getNumObjectiveFunctions() + i);
            if (basicRows.contains(basicRow)) {
                coefficients[i] = 0.0;
                continue;
            }
            basicRows.add(basicRow);
            coefficients[i] = (basicRow == null ? 0.0 : this.getEntry(basicRow, this.getRhsOffset())) - (this.restrictToNonNegative ? 0.0 : mostNegative);
        }
        return new RealPointValuePair(coefficients, this.f.getValue(coefficients));
    }

    protected void divideRow(int dividendRow, double divisor) {
        for (int j = 0; j < this.getWidth(); ++j) {
            this.tableau.setEntry(dividendRow, j, this.tableau.getEntry(dividendRow, j) / divisor);
        }
    }

    protected void subtractRow(int minuendRow, int subtrahendRow, double multiple) {
        for (int j = 0; j < this.getWidth(); ++j) {
            this.tableau.setEntry(minuendRow, j, this.tableau.getEntry(minuendRow, j) - multiple * this.tableau.getEntry(subtrahendRow, j));
        }
    }

    protected final int getWidth() {
        return this.tableau.getColumnDimension();
    }

    protected final int getHeight() {
        return this.tableau.getRowDimension();
    }

    protected final double getEntry(int row, int column) {
        return this.tableau.getEntry(row, column);
    }

    protected final void setEntry(int row, int column, double value) {
        this.tableau.setEntry(row, column, value);
    }

    protected final int getSlackVariableOffset() {
        return this.getNumObjectiveFunctions() + this.numDecisionVariables;
    }

    protected final int getArtificialVariableOffset() {
        return this.getNumObjectiveFunctions() + this.numDecisionVariables + this.numSlackVariables;
    }

    protected final int getRhsOffset() {
        return this.getWidth() - 1;
    }

    protected final int getNumDecisionVariables() {
        return this.numDecisionVariables;
    }

    protected final int getOriginalNumDecisionVariables() {
        return this.restrictToNonNegative ? this.numDecisionVariables : this.numDecisionVariables - 1;
    }

    protected final int getNumSlackVariables() {
        return this.numSlackVariables;
    }

    protected final int getNumArtificialVariables() {
        return this.numArtificialVariables;
    }

    protected final double[][] getData() {
        return this.tableau.getData();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        try {
            SimplexTableau rhs = (SimplexTableau)other;
            return this.restrictToNonNegative == rhs.restrictToNonNegative && this.numDecisionVariables == rhs.numDecisionVariables && this.numSlackVariables == rhs.numSlackVariables && this.numArtificialVariables == rhs.numArtificialVariables && this.epsilon == rhs.epsilon && this.f.equals(rhs.f) && ((Object)this.constraints).equals(rhs.constraints) && this.tableau.equals(rhs.tableau);
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public int hashCode() {
        return Boolean.valueOf(this.restrictToNonNegative).hashCode() ^ this.numDecisionVariables ^ this.numSlackVariables ^ this.numArtificialVariables ^ Double.valueOf(this.epsilon).hashCode() ^ this.f.hashCode() ^ ((Object)this.constraints).hashCode() ^ this.tableau.hashCode();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        MatrixUtils.serializeRealMatrix(this.tableau, oos);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        MatrixUtils.deserializeRealMatrix(this, "tableau", ois);
    }
}

