/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks.data.ptm;

import fr.proline.core.orm.msi.dto.DMasterQuantPeptide;
import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.studio.dam.tasks.data.ptm.AggregatedMasterQuantPeptide;
import fr.proline.studio.dam.tasks.data.ptm.ComparableList;
import fr.proline.studio.dam.tasks.data.ptm.JSONPTMCluster;
import fr.proline.studio.dam.tasks.data.ptm.PTMDataset;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.dam.tasks.data.ptm.PTMSite;
import fr.proline.studio.dam.tasks.data.ptm.PTMSitePeptideInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTMCluster
implements Comparable<PTMCluster> {
    private final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ptm");
    private final List<PTMSite> m_sites;
    private int m_sitesCount;
    private final List<Long> m_peptideIds;
    private final Long m_id;
    private Float m_localizationConfidence;
    private int m_selectionLevel;
    private Integer m_selectionNotation;
    private String m_selectionInfo;
    private List<Integer> m_positionsOnProtein;
    private List<Float> m_probabilities;
    private DProteinMatch m_proteinMatch;
    private DMasterQuantProteinSet m_masterQuantProteinSet;
    private DPeptideMatch m_representativePepMatch;
    private DMasterQuantPeptide m_representativeMQPepMatch;
    private List<PTMPeptideInstance> m_parentPTMPeptideInstances;
    private List<PTMPeptideInstance> m_leafPTMPeptideInstances;
    private List<DPeptideInstance> m_parentPeptideInstances;
    private final PTMDataset m_ptmDataset;

    public PTMCluster(JSONPTMCluster jsonValue, PTMDataset ptmds) {
        this(jsonValue.id, jsonValue.localizationConfidence, jsonValue.selectionLevel, jsonValue.selectionConfidence, jsonValue.selectionInformation, Arrays.asList(jsonValue.ptmSiteLocations), Arrays.asList(jsonValue.peptideIds), ptmds);
    }

    public PTMCluster(Long id, Float confidence, Integer selectionLevel, Integer selectionNotation, String selectionInfo, List<Long> ptmSiteIds, List<Long> peptideIds, PTMDataset ptmds) {
        this.m_ptmDataset = ptmds;
        this.m_peptideIds = new ArrayList<Long>();
        this.m_peptideIds.addAll(peptideIds);
        this.m_localizationConfidence = confidence;
        this.m_sites = this.m_ptmDataset.getPTMSites().stream().filter(site -> ptmSiteIds.contains(site.getId())).sorted(Comparator.comparing(PTMSite::getPositionOnProtein)).collect(Collectors.toList());
        this.m_sitesCount = this.m_sites.size();
        this.m_id = id;
        this.m_selectionLevel = selectionLevel != null ? selectionLevel : 2;
        this.m_selectionNotation = selectionNotation;
        String string = this.m_selectionInfo = selectionInfo != null ? selectionInfo : "";
        if (!this.m_sites.isEmpty()) {
            this.m_proteinMatch = this.m_sites.get(0).getProteinMatch();
            this.m_masterQuantProteinSet = this.m_sites.get(0).getMasterQuantProteinSet();
        }
    }

    public int getSelectionLevel() {
        return this.m_selectionLevel;
    }

    public void setSelectionLevel(int selectionLevel) {
        if (selectionLevel < 0 || selectionLevel > 3) {
            throw new IllegalArgumentException("Invalid selection level specified");
        }
        this.m_selectionLevel = selectionLevel;
    }

    public Integer getSelectionNotation() {
        return this.m_selectionNotation;
    }

    public void setSelectionNotation(Integer selectionNotation) {
        this.m_selectionNotation = selectionNotation;
    }

    public String getSelectionInfo() {
        return this.m_selectionInfo;
    }

    public void setSelectionInfo(String selectionInfo) {
        this.m_selectionInfo = selectionInfo;
    }

    protected void addSites(List<PTMSite> newSites) {
        boolean listChanged = false;
        for (PTMSite s : newSites) {
            if (this.m_sites.contains(s)) continue;
            this.m_sites.add(s);
            listChanged = true;
        }
        if (listChanged) {
            this.m_positionsOnProtein = null;
            this.m_probabilities = null;
            this.m_parentPTMPeptideInstances = null;
            this.m_leafPTMPeptideInstances = null;
            this.m_parentPeptideInstances = null;
        }
    }

    protected void addPeptideIds(List<Long> newPepIds) {
        boolean listChanged = false;
        for (Long s : newPepIds) {
            if (this.m_peptideIds.contains(s)) continue;
            this.m_peptideIds.add(s);
            listChanged = true;
        }
        if (listChanged) {
            this.m_positionsOnProtein = null;
            this.m_probabilities = null;
            this.m_parentPTMPeptideInstances = null;
            this.m_leafPTMPeptideInstances = null;
            this.m_parentPeptideInstances = null;
        }
    }

    public void removePeptide(PTMPeptideInstance pep) {
        if (pep == null) {
            return;
        }
        Long pepId = pep.getPeptideInstance().getPeptideId();
        if (this.m_peptideIds.contains(pepId)) {
            this.m_peptideIds.remove(pepId);
            DMasterQuantPeptide finalClusterMQpep = this.getRepresentativeMQPepMatch();
            if (finalClusterMQpep != null && finalClusterMQpep instanceof AggregatedMasterQuantPeptide) {
                HashMap<Long, DMasterQuantPeptide> mqPepByPepInstId = new HashMap<Long, DMasterQuantPeptide>();
                ((AggregatedMasterQuantPeptide)finalClusterMQpep).getAggregatedMQPeptides().forEach(mqPep -> {
                    if (this.m_peptideIds.contains(mqPep.getPeptideInstance().getPeptideId())) {
                        mqPepByPepInstId.put(mqPep.getPeptideInstanceId(), (DMasterQuantPeptide)mqPep);
                    }
                });
                this.setRepresentativeMQPepMatch(this.m_ptmDataset.getRepresentativeMQPeptideForCluster(this, mqPepByPepInstId));
            } else if (finalClusterMQpep != null) {
                this.m_logger.warn(" ERROR. PTM Cluster in Quantitation do not used AggregatedMasterQuantPeptide. Unable to create new quantiation values ");
            }
            this.m_parentPTMPeptideInstances = null;
            this.m_leafPTMPeptideInstances = null;
            this.m_parentPeptideInstances = null;
        }
    }

    protected void setLocalizationConfidence(Float localizationConfidence) {
        this.m_localizationConfidence = localizationConfidence;
    }

    public Long getId() {
        return this.m_id;
    }

    public DProteinMatch getProteinMatch() {
        return this.m_proteinMatch;
    }

    public PTMDataset getPTMDataset() {
        return this.m_ptmDataset;
    }

    public void setRepresentativePepMatch(DPeptideMatch peptideMatch) {
        this.m_representativePepMatch = peptideMatch;
    }

    public DPeptideMatch getRepresentativePepMatch() {
        return this.m_representativePepMatch;
    }

    public void setRepresentativeMQPepMatch(DMasterQuantPeptide quantPeptideMatch) {
        this.m_representativeMQPepMatch = quantPeptideMatch;
    }

    public Float getLocalizationConfidence() {
        return this.m_localizationConfidence;
    }

    public DMasterQuantPeptide getRepresentativeMQPepMatch() {
        return this.m_representativeMQPepMatch;
    }

    public List<DPeptideInstance> getParentPeptideInstances() {
        if (this.m_sites == null || this.m_sites.isEmpty()) {
            return null;
        }
        if (this.m_parentPeptideInstances == null) {
            this.m_parentPeptideInstances = this.m_sites.stream().flatMap(site -> site.getParentPeptideInstances().stream()).distinct().filter(pi -> this.m_peptideIds.contains(pi.getPeptideId())).collect(Collectors.toList());
        }
        return this.m_parentPeptideInstances;
    }

    public PTMPeptideInstance getParentPTMPeptideInstance(Long peptideId) {
        if (this.m_sites == null || this.m_sites.isEmpty()) {
            return null;
        }
        PTMPeptideInstance foundPTMPepins = null;
        for (PTMSite site : this.m_sites) {
            PTMSitePeptideInstance ptmSiteIns = site.getPTMSitePeptideInstance(peptideId);
            if (ptmSiteIns == null) continue;
            foundPTMPepins = ptmSiteIns.getParentPTMPeptideInstance();
            break;
        }
        return foundPTMPepins;
    }

    public List<PTMPeptideInstance> getParentPTMPeptideInstances() {
        if (this.m_sites == null || this.m_sites.isEmpty()) {
            return null;
        }
        if (this.m_parentPTMPeptideInstances == null) {
            List sitesPosition = this.m_sites.stream().map(site -> site.getPositionOnProtein()).collect(Collectors.toList());
            Collection<PTMPeptideInstance> ptmPeptides = this.m_ptmDataset.getPTMPeptideInstances(this.m_proteinMatch.getId());
            this.m_parentPTMPeptideInstances = new ArrayList<PTMPeptideInstance>();
            block0: for (PTMPeptideInstance ptmPepI : ptmPeptides) {
                if (!this.m_peptideIds.contains(ptmPepI.getPeptideInstance().getPeptideId()) || this.m_parentPTMPeptideInstances.contains(ptmPepI)) continue;
                for (Integer sitePos : sitesPosition) {
                    if (sitePos < ptmPepI.getStartPosition() || sitePos > ptmPepI.getStopPosition()) continue;
                    this.m_parentPTMPeptideInstances.add(ptmPepI);
                    continue block0;
                }
            }
        }
        return this.m_parentPTMPeptideInstances;
    }

    public List<PTMPeptideInstance> getLeafPTMPeptideInstances() {
        if (this.m_sites == null || this.m_sites.isEmpty()) {
            return null;
        }
        if (this.m_leafPTMPeptideInstances == null) {
            this.m_leafPTMPeptideInstances = new ArrayList<PTMPeptideInstance>();
            HashSet allPTMSitePepInst = new HashSet();
            for (PTMSite nextSite : this.m_sites) {
                allPTMSitePepInst.addAll(nextSite.getPTMSitePeptideInstances().stream().filter(ptmSitePepI -> this.m_peptideIds.contains(ptmSitePepI.getParentPTMPeptideInstance().getPeptideInstance().getPeptideId())).collect(Collectors.toList()));
            }
            ArrayList parentPTMPepInstanceDone = new ArrayList();
            allPTMSitePepInst.forEach(ptmSitePepIns -> {
                if (!parentPTMPepInstanceDone.contains(ptmSitePepIns.getParentPTMPeptideInstance())) {
                    ptmSitePepIns.getLeafPepInstances().forEach(pepI -> {
                        List<PTMPeptideInstance> dsPtmPepIns = this.m_ptmDataset.getLeafPTMPeptideInstances(this.m_proteinMatch.getId(), pepI.getId());
                        PTMPeptideInstance associatedParentPTMPepInst = ptmSitePepIns.getParentPTMPeptideInstance();
                        PTMPeptideInstance finalLeafPtmPepI = null;
                        if (dsPtmPepIns == null || dsPtmPepIns.isEmpty()) {
                            finalLeafPtmPepI = new PTMPeptideInstance((DPeptideInstance)pepI);
                            finalLeafPtmPepI.setStartPosition(associatedParentPTMPepInst.getStartPosition());
                            finalLeafPtmPepI.addCluster(this);
                            PTMPeptideInstance leafPtmPepI = finalLeafPtmPepI;
                            associatedParentPTMPepInst.getPTMSites().forEach(parentSite -> leafPtmPepI.addPTMSite((PTMSite)parentSite));
                            this.m_leafPTMPeptideInstances.add(finalLeafPtmPepI);
                            this.m_ptmDataset.addLeafPTMPeptideInstance(leafPtmPepI, this.m_proteinMatch.getId());
                        } else {
                            this.m_leafPTMPeptideInstances.addAll(dsPtmPepIns);
                        }
                    });
                    parentPTMPepInstanceDone.add(ptmSitePepIns.getParentPTMPeptideInstance());
                }
            });
        }
        return this.m_leafPTMPeptideInstances;
    }

    public List<Integer> getPositionsOnProtein() {
        if (this.m_positionsOnProtein == null) {
            this.m_positionsOnProtein = this.m_sites.stream().map(s -> s.getPositionOnProtein()).collect(ComparableList::new, ArrayList::add, ArrayList::addAll);
        }
        return this.m_positionsOnProtein;
    }

    public List<Float> getSiteConfidences() {
        if (this.m_probabilities == null) {
            this.m_probabilities = this.m_sites.stream().map(s -> Float.valueOf(s.getLocalisationConfidence().floatValue() * 100.0f)).collect(ComparableList::new, ArrayList::add, ArrayList::addAll);
        }
        return this.m_probabilities;
    }

    public List<PTMSite> getPTMSites() {
        return this.m_sites;
    }

    public Integer getPTMSitesCount() {
        return this.m_sitesCount;
    }

    public void setPTMSitesCount(Integer sitesCount) {
        this.m_sitesCount = sitesCount;
    }

    public Integer getPeptideCount() {
        return this.m_peptideIds.size();
    }

    public List<Long> getPeptideIds() {
        return this.m_peptideIds;
    }

    public void setQuantProteinSet(DMasterQuantProteinSet mqps) {
        this.m_masterQuantProteinSet = mqps;
    }

    public DMasterQuantProteinSet getMasterQuantProteinSet() {
        return this.m_masterQuantProteinSet;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PTMCluster)) {
            return false;
        }
        PTMCluster objCluster = (PTMCluster)obj;
        return objCluster.m_id.equals(this.m_id);
    }

    @Override
    public int compareTo(PTMCluster o) {
        if (o == null) {
            return 1;
        }
        Integer start = Integer.MAX_VALUE;
        Optional<Integer> optStart = this.getParentPTMPeptideInstances().stream().map(pi -> pi.getStartPosition()).sorted().findFirst();
        if (optStart.isPresent()) {
            start = optStart.get();
        }
        Integer o2Start = Integer.MAX_VALUE;
        Optional<Integer> o2OptStart = o.getParentPTMPeptideInstances().stream().map(pi -> pi.getStartPosition()).sorted().findFirst();
        if (o2OptStart.isPresent()) {
            o2Start = o2OptStart.get();
        }
        return Integer.compare(start, o2Start);
    }
}

