/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.internal.util.StringHelper;

public class SQLServer2005LimitHandler
extends AbstractLimitHandler {
    private static final String SELECT = "select";
    private static final String FROM = "from";
    private static final String DISTINCT = "distinct";
    private static final String ORDER_BY = "order by";
    private static final String SELECT_DISTINCT = "select distinct";
    private static final String SELECT_DISTINCT_SPACE = "select distinct ";
    final String SELECT_SPACE = "select ";
    private static final Pattern SELECT_DISTINCT_PATTERN = SQLServer2005LimitHandler.buildShallowIndexPattern("select distinct ", true);
    private static final Pattern SELECT_PATTERN = SQLServer2005LimitHandler.buildShallowIndexPattern("select(.*)", true);
    private static final Pattern FROM_PATTERN = SQLServer2005LimitHandler.buildShallowIndexPattern("from", true);
    private static final Pattern DISTINCT_PATTERN = SQLServer2005LimitHandler.buildShallowIndexPattern("distinct", true);
    private static final Pattern ORDER_BY_PATTERN = SQLServer2005LimitHandler.buildShallowIndexPattern("order by", true);
    private static final Pattern COMMA_PATTERN = SQLServer2005LimitHandler.buildShallowIndexPattern(",", false);
    private static final Pattern ALIAS_PATTERN = Pattern.compile("(?![^\\[]*(\\]))\\S+\\s*(\\s(?i)as\\s)\\s*(\\S+)*\\s*$|(?![^\\[]*(\\]))\\s+(\\S+)$");
    private boolean topAdded;

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean useMaxForLimit() {
        return true;
    }

    @Override
    public boolean supportsLimitOffset() {
        return true;
    }

    @Override
    public boolean supportsVariableLimit() {
        return true;
    }

    @Override
    public int convertToFirstRowValue(int zeroBasedFirstResult) {
        return zeroBasedFirstResult + 1;
    }

    @Override
    public String processSql(String sql, RowSelection selection) {
        StringBuilder sb = new StringBuilder(sql);
        if (sb.charAt(sb.length() - 1) == ';') {
            sb.setLength(sb.length() - 1);
        }
        if (LimitHelper.hasFirstRow(selection)) {
            String selectClause = this.fillAliasInSelectClause(sb);
            int orderByIndex = SQLServer2005LimitHandler.shallowIndexOfPattern(sb, ORDER_BY_PATTERN, 0);
            if (orderByIndex > 0) {
                this.addTopExpression(sb);
            }
            this.encloseWithOuterQuery(sb);
            sb.insert(0, "WITH query AS (").append(") SELECT ").append(selectClause).append(" FROM query ");
            sb.append("WHERE __hibernate_row_nr__ >= ? AND __hibernate_row_nr__ < ?");
        } else {
            this.addTopExpression(sb);
        }
        return sb.toString();
    }

    @Override
    public int bindLimitParametersAtStartOfQuery(RowSelection selection, PreparedStatement statement, int index) throws SQLException {
        if (this.topAdded) {
            statement.setInt(index, this.getMaxOrLimit(selection) - 1);
            return 1;
        }
        return 0;
    }

    @Override
    public int bindLimitParametersAtEndOfQuery(RowSelection selection, PreparedStatement statement, int index) throws SQLException {
        return LimitHelper.hasFirstRow(selection) ? super.bindLimitParametersAtEndOfQuery(selection, statement, index) : 0;
    }

    protected String fillAliasInSelectClause(StringBuilder sb) {
        String alias;
        String expression;
        String separator = System.lineSeparator();
        LinkedList<String> aliases = new LinkedList<String>();
        int startPos = this.getSelectColumnsStartPosition(sb);
        int endPos = SQLServer2005LimitHandler.shallowIndexOfPattern(sb, FROM_PATTERN, startPos);
        int nextComa = startPos;
        int prevComa = startPos;
        int unique = 0;
        boolean selectsMultipleColumns = false;
        while (nextComa != -1) {
            prevComa = nextComa;
            if ((nextComa = SQLServer2005LimitHandler.shallowIndexOfPattern(sb, COMMA_PATTERN, nextComa)) > endPos) break;
            if (nextComa == -1) continue;
            expression = sb.substring(prevComa, nextComa);
            if (this.selectsMultipleColumns(expression)) {
                selectsMultipleColumns = true;
            } else {
                alias = this.getAlias(expression);
                if (alias == null) {
                    alias = StringHelper.generateAlias("page", unique);
                    sb.insert(nextComa, " as " + alias);
                    int aliasExprLength = (" as " + alias).length();
                    ++unique;
                    nextComa += aliasExprLength;
                    endPos += aliasExprLength;
                }
                aliases.add(alias);
            }
            ++nextComa;
        }
        if (this.selectsMultipleColumns(expression = sb.substring(prevComa, endPos = SQLServer2005LimitHandler.shallowIndexOfPattern(sb, FROM_PATTERN, startPos)))) {
            selectsMultipleColumns = true;
        } else {
            alias = this.getAlias(expression);
            if (alias == null) {
                alias = StringHelper.generateAlias("page", unique);
                boolean endWithSeparator = sb.substring(endPos - separator.length()).startsWith(separator);
                sb.insert(endPos - (endWithSeparator ? 2 : 1), " as " + alias);
            }
            aliases.add(alias);
        }
        return selectsMultipleColumns ? "*" : StringHelper.join(", ", aliases.iterator());
    }

    private int getSelectColumnsStartPosition(StringBuilder sb) {
        int startPos = this.getSelectStartPosition(sb);
        String sql = sb.toString().substring(startPos).toLowerCase();
        if (sql.startsWith(SELECT_DISTINCT_SPACE)) {
            return startPos + SELECT_DISTINCT_SPACE.length();
        }
        if (sql.startsWith("select ")) {
            return startPos + "select ".length();
        }
        return startPos;
    }

    private int getSelectStartPosition(StringBuilder sb) {
        return SQLServer2005LimitHandler.shallowIndexOfPattern(sb, SELECT_PATTERN, 0);
    }

    private boolean selectsMultipleColumns(String expression) {
        String lastExpr = expression.trim().replaceFirst("(?i)(.)*\\s", "").trim();
        return "*".equals(lastExpr) || lastExpr.endsWith(".*");
    }

    private String getAlias(String expression) {
        expression = expression.replaceFirst("(\\((.)*\\))", "").trim();
        Matcher matcher = ALIAS_PATTERN.matcher(expression);
        String alias = null;
        if (matcher.find() && matcher.groupCount() > 1 && (alias = matcher.group(3)) == null) {
            alias = matcher.group(0);
        }
        return alias != null ? alias.trim() : null;
    }

    protected void encloseWithOuterQuery(StringBuilder sql) {
        sql.insert(0, "SELECT inner_query.*, ROW_NUMBER() OVER (ORDER BY CURRENT_TIMESTAMP) as __hibernate_row_nr__ FROM ( ");
        sql.append(" ) inner_query ");
    }

    protected void addTopExpression(StringBuilder sql) {
        int selectDistinctPos;
        int selectPos = SQLServer2005LimitHandler.shallowIndexOfPattern(sql, SELECT_PATTERN, 0);
        if (selectPos == (selectDistinctPos = SQLServer2005LimitHandler.shallowIndexOfPattern(sql, SELECT_DISTINCT_PATTERN, 0))) {
            sql.insert(selectDistinctPos + SELECT_DISTINCT.length(), " TOP(?)");
        } else {
            sql.insert(selectPos + SELECT.length(), " TOP(?)");
        }
        this.topAdded = true;
    }

    private static int shallowIndexOfPattern(StringBuilder sb, Pattern pattern, int fromIndex) {
        int index;
        block3: {
            Matcher matcher;
            List<IgnoreRange> ignoreRangeList;
            block2: {
                index = -1;
                String matchString = sb.toString();
                if (matchString.length() < fromIndex || fromIndex < 0) {
                    return -1;
                }
                ignoreRangeList = SQLServer2005LimitHandler.generateIgnoreRanges(matchString);
                matcher = pattern.matcher(matchString);
                matcher.region(fromIndex, matchString.length());
                if (!ignoreRangeList.isEmpty()) break block2;
                if (!matcher.find() || matcher.groupCount() <= 0) break block3;
                index = matcher.start();
                break block3;
            }
            while (matcher.find() && matcher.groupCount() > 0) {
                int position = matcher.start();
                if (SQLServer2005LimitHandler.isPositionIgnorable(ignoreRangeList, position)) continue;
                index = position;
                break;
            }
        }
        return index;
    }

    private static Pattern buildShallowIndexPattern(String pattern, boolean wordBoundary) {
        return Pattern.compile("(" + (wordBoundary ? "\\b" : "") + pattern + (wordBoundary ? "\\b" : "") + ")(?![^\\(|\\[]*(\\)|\\]))", 2);
    }

    private static List<IgnoreRange> generateIgnoreRanges(String sql) {
        ArrayList<IgnoreRange> ignoreRangeList = new ArrayList<IgnoreRange>();
        int depth = 0;
        int start = -1;
        for (int i = 0; i < sql.length(); ++i) {
            char ch = sql.charAt(i);
            if (ch == '(') {
                if (++depth != 1) continue;
                start = i;
                continue;
            }
            if (ch != ')') continue;
            if (depth > 0) {
                if (depth == 1) {
                    ignoreRangeList.add(new IgnoreRange(start, i));
                    start = -1;
                }
                --depth;
                continue;
            }
            throw new IllegalStateException("Found an unmatched ')' at position " + i + ": " + sql);
        }
        if (depth != 0) {
            throw new IllegalStateException("Unmatched parenthesis in rendered SQL (" + depth + " depth): " + sql);
        }
        return ignoreRangeList;
    }

    private static boolean isPositionIgnorable(List<IgnoreRange> ignoreRangeList, int position) {
        for (IgnoreRange ignoreRange : ignoreRangeList) {
            if (!ignoreRange.isWithinRange(position)) continue;
            return true;
        }
        return false;
    }

    static class IgnoreRange {
        private int start;
        private int end;

        IgnoreRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        boolean isWithinRange(int position) {
            return position >= this.start && position <= this.end;
        }
    }
}

