/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.mzdb.PeakelDetectorQueueEntry;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.Queue;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001\u0013\t\u0019\u0002+Z1lK2$U\r^3di>\u0014\u0018+^3vK*\u00111\u0001B\u0001\u0005[j$'M\u0003\u0002\u0006\r\u0005)\u0001O]8gS*\tq!\u0001\u0002ge\u000e\u00011c\u0001\u0001\u000b!A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001a\u0004\"!\u0005\r\u000e\u0003IQ!a\u0005\u000b\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005U1\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003]\t1aY8n\u0013\tI\"CA\u0006MCjLHj\\4hS:<\u0007\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u000f5\f\u0007pU5{KB\u00111\"H\u0005\u0003=1\u00111!\u00138u\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0003\u0019a\u0014N\\5u}Q\u0011!\u0005\n\t\u0003G\u0001i\u0011A\u0001\u0005\u00067}\u0001\r\u0001\b\u0005\bM\u0001\u0001\r\u0011\"\u0003(\u0003%I7o\u0015;paB,G-F\u0001)!\tY\u0011&\u0003\u0002+\u0019\t9!i\\8mK\u0006t\u0007b\u0002\u0017\u0001\u0001\u0004%I!L\u0001\u000eSN\u001cFo\u001c9qK\u0012|F%Z9\u0015\u00059\n\u0004CA\u00060\u0013\t\u0001DB\u0001\u0003V]&$\bb\u0002\u001a,\u0003\u0003\u0005\r\u0001K\u0001\u0004q\u0012\n\u0004B\u0002\u001b\u0001A\u0003&\u0001&\u0001\u0006jgN#x\u000e\u001d9fI\u0002BqA\u000e\u0001C\u0002\u0013Eq'A\nqK\u0006\\W\r\u001c#fi\u0016\u001cGo\u001c:Rk\u0016,X-F\u00019!\rId\bQ\u0007\u0002u)\u00111\bP\u0001\b[V$\u0018M\u00197f\u0015\tiD\"\u0001\u0006d_2dWm\u0019;j_:L!a\u0010\u001e\u0003\u000bE+X-^3\u0011\u0005\r\n\u0015B\u0001\"\u0003\u0005a\u0001V-Y6fY\u0012+G/Z2u_J\fV/Z;f\u000b:$(/\u001f\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002\u001d\u0002)A,\u0017m[3m\t\u0016$Xm\u0019;peF+X-^3!\u0011\u00151\u0005\u0001\"\u0001H\u0003\u0015\u0019G.Z1s)\u0005q\u0003\"B%\u0001\t\u0003Q\u0015A\u00035bg\u0016sGO]5fgR\t\u0001\u0006C\u0003M\u0001\u0011\u0005q)\u0001\u0003ti>\u0004\b\"\u0002(\u0001\t\u0003y\u0015a\u00023fcV,W/\u001a\u000b\u0002\u0001\")\u0011\u000b\u0001C\u0001%\u00069QM\\9vKV,GC\u0001\u0018T\u0011\u0015!\u0006\u000b1\u0001A\u0003)\tX/Z;f\u000b:$(/\u001f\u0005\b-\u0002\u0011\r\u0011\"\u0005X\u00039)\u0007pY3qi&|g.U;fk\u0016,\u0012\u0001\u0017\t\u0004syJ\u0006C\u0001.c\u001d\tY\u0006M\u0004\u0002]?6\tQL\u0003\u0002_\u0011\u00051AH]8pizJ\u0011!D\u0005\u0003C2\tq\u0001]1dW\u0006<W-\u0003\u0002dI\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0003C2AaA\u001a\u0001!\u0002\u0013A\u0016aD3yG\u0016\u0004H/[8o#V,W/\u001a\u0011\t\u000b!\u0004A\u0011\u0001&\u0002\u001b!\f7/\u0012=dKB$\u0018n\u001c8t\u0011\u0015Q\u0007\u0001\"\u0001l\u0003A!W-];fk\u0016,\u0005pY3qi&|g\u000eF\u0001Z\u0011\u0015i\u0007\u0001\"\u0001o\u0003A)g.];fk\u0016,\u0005pY3qi&|g\u000e\u0006\u0002/_\")\u0001\u000f\u001ca\u00013\u0006\tA\u000f")
public class PeakelDetectorQueue
implements LazyLogging {
    private final int maxSize;
    private boolean isStopped;
    private final Queue<PeakelDetectorQueueEntry> peakelDetectorQueue;
    private final Queue<Throwable> exceptionQueue;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        PeakelDetectorQueue peakelDetectorQueue = this;
        synchronized (peakelDetectorQueue) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private boolean isStopped() {
        return this.isStopped;
    }

    private void isStopped_$eq(boolean x$1) {
        this.isStopped = x$1;
    }

    public Queue<PeakelDetectorQueueEntry> peakelDetectorQueue() {
        return this.peakelDetectorQueue;
    }

    public void clear() {
        this.peakelDetectorQueue().clear();
    }

    public boolean hasEntries() {
        return !this.peakelDetectorQueue().isEmpty();
    }

    public synchronized void stop() {
        this.isStopped_$eq(true);
    }

    public PeakelDetectorQueueEntry dequeue() {
        Queue<PeakelDetectorQueueEntry> queue = this.peakelDetectorQueue();
        synchronized (queue) {
            if (this.isStopped()) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                return null;
            }
            while (this.peakelDetectorQueue().isEmpty()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace("waiting for new entries in the queue...");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.peakelDetectorQueue().wait();
            }
            this.peakelDetectorQueue().notifyAll();
            Object object = this.peakelDetectorQueue().dequeue();
            return (PeakelDetectorQueueEntry)object;
        }
    }

    public void enqueue(PeakelDetectorQueueEntry queueEntry) {
        Queue<PeakelDetectorQueueEntry> queue = this.peakelDetectorQueue();
        synchronized (queue) {
            if (this.isStopped()) {
                return;
            }
            while (this.peakelDetectorQueue().size() >= this.maxSize) {
                this.peakelDetectorQueue().wait();
            }
            this.peakelDetectorQueue().notifyAll();
            this.peakelDetectorQueue().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PeakelDetectorQueueEntry[]{queueEntry}));
            return;
        }
    }

    public Queue<Throwable> exceptionQueue() {
        return this.exceptionQueue;
    }

    public boolean hasExceptions() {
        return !this.exceptionQueue().isEmpty();
    }

    public Throwable dequeueException() {
        Queue<Throwable> queue = this.exceptionQueue();
        synchronized (queue) {
            while (this.exceptionQueue().isEmpty()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Watching for new exception in the queue...");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.exceptionQueue().wait();
            }
            this.exceptionQueue().notifyAll();
            Object object = this.exceptionQueue().dequeue();
            return (Throwable)object;
        }
    }

    public void enqueueException(Throwable t) {
        Queue<Throwable> queue = this.exceptionQueue();
        synchronized (queue) {
            this.exceptionQueue().notifyAll();
            this.exceptionQueue().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Throwable[]{t}));
            return;
        }
    }

    public PeakelDetectorQueue(int maxSize) {
        this.maxSize = maxSize;
        LazyLogging.class.$init$((LazyLogging)this);
        this.isStopped = false;
        this.peakelDetectorQueue = new Queue();
        this.exceptionQueue = new Queue();
    }
}

