/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.ms.algo.IsotopePatternEstimator$;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.algo.IIsotopicPatternScorer;
import fr.profi.mzdb.algo.IIsotopicPatternScorer$class;
import fr.profi.mzdb.model.SpectrumData;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class DotProductPatternScorer$
implements IIsotopicPatternScorer {
    public static final DotProductPatternScorer$ MODULE$;
    private final int fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new DotProductPatternScorer$();
    }

    @Override
    public int fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE() {
        return this.fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE;
    }

    @Override
    public void fr$profi$mzdb$algo$IIsotopicPatternScorer$_setter_$fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE_$eq(int x$1) {
        this.fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE = x$1;
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern>[] calcIsotopicPatternHypotheses(SpectrumData spectrum, double mz, double ppmTol) {
        return IIsotopicPatternScorer$class.calcIsotopicPatternHypotheses(this, spectrum, mz, ppmTol);
    }

    private Logger logger$lzycompute() {
        DotProductPatternScorer$ dotProductPatternScorer$ = this;
        synchronized (dotProductPatternScorer$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern> getIPHypothesis(SpectrumData spectrum, double initialMz, int isotopicShift, int charge, double ppmTol) {
        double score = 0.0;
        double mz = initialMz - (double)isotopicShift * 1.0027 / (double)charge;
        TheoreticalIsotopePattern pattern = IsotopePatternEstimator$.MODULE$.getTheoreticalPattern(mz, charge);
        double scale = (double)spectrum.getIntensityList()[spectrum.getNearestPeakIndex(initialMz)] / (double)BoxesRunTime.unboxToFloat((Object)pattern.mzAbundancePairs()[isotopicShift]._2());
        DoubleRef ipMoz = DoubleRef.create((double)mz);
        double[] observed = new double[pattern.mzAbundancePairs().length];
        double[] expected = new double[pattern.mzAbundancePairs().length];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), pattern.mzAbundancePairs().length).foreach$mVc$sp((Function1)new Serializable(spectrum, charge, ppmTol, pattern, scale, ipMoz, observed, expected){
            public static final long serialVersionUID = 0L;
            private final SpectrumData spectrum$2;
            private final int charge$2;
            private final double ppmTol$2;
            private final TheoreticalIsotopePattern pattern$2;
            private final double scale$1;
            private final DoubleRef ipMoz$2;
            private final double[] observed$1;
            private final double[] expected$1;

            public final void apply(int rank) {
                this.apply$mcVI$sp(rank);
            }

            public void apply$mcVI$sp(int rank) {
                this.ipMoz$2.elem = rank == 0 ? this.ipMoz$2.elem : this.ipMoz$2.elem + 1.0027 / (double)this.charge$2;
                int nearestPeakIdx = this.spectrum$2.getNearestPeakIndex(this.ipMoz$2.elem);
                this.observed$1[rank] = 1000000.0 * Math.abs(this.spectrum$2.getMzList()[nearestPeakIdx] - this.ipMoz$2.elem) / this.ipMoz$2.elem < this.ppmTol$2 ? (double)this.spectrum$2.getIntensityList()[nearestPeakIdx] : (double)(-BoxesRunTime.unboxToFloat((Object)this.pattern$2.mzAbundancePairs()[rank]._2())) * this.scale$1;
                this.expected$1[rank] = BoxesRunTime.unboxToFloat((Object)this.pattern$2.mzAbundancePairs()[rank]._2());
            }
            {
                this.spectrum$2 = spectrum$2;
                this.charge$2 = charge$2;
                this.ppmTol$2 = ppmTol$2;
                this.pattern$2 = pattern$2;
                this.scale$1 = scale$1;
                this.ipMoz$2 = ipMoz$2;
                this.observed$1 = observed$1;
                this.expected$1 = expected$1;
            }
        });
        score = this.dotProduct(observed, expected);
        score = 1.0 - score;
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)score), (Object)pattern);
    }

    public double dotProduct(double[] observed, double[] expected) {
        double sumObserved = 0.0;
        double sumExpected = 0.0;
        double product = 0.0;
        ObjectRef weights = ObjectRef.create((Object)((double[])Predef$.MODULE$.doubleArrayOps(expected).take(6)));
        weights.elem = (double[])Predef$.MODULE$.doubleArrayOps((double[])weights.elem).map((Function1)new Serializable(weights){
            public static final long serialVersionUID = 0L;
            private final ObjectRef weights$1;

            public final double apply(double x$3) {
                return this.apply$mcDD$sp(x$3);
            }

            public double apply$mcDD$sp(double x$3) {
                return x$3 / BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])this.weights$1.elem).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            }
            {
                this.weights$1 = weights$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        for (int k = 0; k < observed.length; ++k) {
            double weight = k < Predef$.MODULE$.doubleArrayOps((double[])weights.elem).size() ? ((double[])weights.elem)[k] : 0.0;
            product += weight * observed[k] * expected[k];
            sumExpected += weight * expected[k] * expected[k];
            sumObserved += weight * observed[k] * observed[k];
        }
        return sumExpected == 0.0 || sumObserved == 0.0 ? 0.0 : product / (Math.sqrt(sumExpected) * Math.sqrt(sumObserved));
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern> selectBestPatternHypothese(Tuple2<Object, TheoreticalIsotopePattern>[] putativePatterns, double deltaScore) {
        double refScore = ((Tuple2)Predef$.MODULE$.refArrayOps((Object[])putativePatterns).head())._1$mcD$sp();
        Tuple2[] patterns = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])putativePatterns).filter((Function1)new Serializable(deltaScore, refScore){
            public static final long serialVersionUID = 0L;
            private final double deltaScore$1;
            private final double refScore$1;

            public final boolean apply(Tuple2<Object, TheoreticalIsotopePattern> p) {
                return package$.MODULE$.abs(p._1$mcD$sp() - this.refScore$1) < this.deltaScore$1;
            }
            {
                this.deltaScore$1 = deltaScore$1;
                this.refScore$1 = refScore$1;
            }
        });
        return (Tuple2)Predef$.MODULE$.refArrayOps((Object[])patterns).maxBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, TheoreticalIsotopePattern> p) {
                return ((TheoreticalIsotopePattern)p._2()).charge();
            }
        }, (Ordering)Ordering.Int$.MODULE$);
    }

    @Override
    public double selectBestPatternHypothese$default$2() {
        return 0.1;
    }

    private DotProductPatternScorer$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        IIsotopicPatternScorer$class.$init$(this);
    }
}

