/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.ms.algo.IsotopePatternEstimator$;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.algo.IIsotopicPatternScorer;
import fr.profi.mzdb.algo.IIsotopicPatternScorer$class;
import fr.profi.mzdb.model.SpectrumData;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public final class LegacyIsotopicPatternScorer$
implements IIsotopicPatternScorer {
    public static final LegacyIsotopicPatternScorer$ MODULE$;
    private final int fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new LegacyIsotopicPatternScorer$();
    }

    @Override
    public int fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE() {
        return this.fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE;
    }

    @Override
    public void fr$profi$mzdb$algo$IIsotopicPatternScorer$_setter_$fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE_$eq(int x$1) {
        this.fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE = x$1;
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern>[] calcIsotopicPatternHypotheses(SpectrumData spectrum, double mz, double ppmTol) {
        return IIsotopicPatternScorer$class.calcIsotopicPatternHypotheses(this, spectrum, mz, ppmTol);
    }

    private Logger logger$lzycompute() {
        LegacyIsotopicPatternScorer$ legacyIsotopicPatternScorer$ = this;
        synchronized (legacyIsotopicPatternScorer$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern> getIPHypothesis(SpectrumData spectrum, double initialMz, int isotopicShift, int charge, double ppmTol) {
        DoubleRef score = DoubleRef.create((double)0.0);
        double alternativeMoz = initialMz - (double)isotopicShift * 1.0027 / (double)charge;
        TheoreticalIsotopePattern pattern = IsotopePatternEstimator$.MODULE$.getTheoreticalPattern(alternativeMoz, charge);
        float isotopeAbundance = spectrum.getIntensityList()[spectrum.getNearestPeakIndex(alternativeMoz)];
        float normAbundance = BoxesRunTime.unboxToFloat((Object)pattern.mzAbundancePairs()[0]._2());
        DoubleRef ipMoz = DoubleRef.create((double)alternativeMoz);
        boolean rank = false;
        IntRef matches = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), pattern.mzAbundancePairs().length).foreach$mVc$sp((Function1)new Serializable(spectrum, isotopicShift, charge, ppmTol, score, pattern, isotopeAbundance, normAbundance, ipMoz, matches){
            public static final long serialVersionUID = 0L;
            private final SpectrumData spectrum$1;
            private final int isotopicShift$1;
            private final int charge$1;
            private final double ppmTol$1;
            private final DoubleRef score$1;
            private final TheoreticalIsotopePattern pattern$1;
            private final float isotopeAbundance$1;
            private final float normAbundance$1;
            private final DoubleRef ipMoz$1;
            private final IntRef matches$1;

            public final void apply(int rank) {
                this.apply$mcVI$sp(rank);
            }

            public void apply$mcVI$sp(int rank) {
                float f;
                double rankPenality;
                this.ipMoz$1.elem = rank == 0 ? this.ipMoz$1.elem : this.ipMoz$1.elem + 1.0027 / (double)this.charge$1;
                float ipAbundance = BoxesRunTime.unboxToFloat((Object)this.pattern$1.mzAbundancePairs()[rank]._2()) * this.isotopeAbundance$1 / this.normAbundance$1;
                int nearestPeakIdx = this.spectrum$1.getNearestPeakIndex(this.ipMoz$1.elem);
                double d = rankPenality = rank == this.isotopicShift$1 ? 100.0 : Math.max(0.01, Math.pow(10.0, -(2 * rank - 4)));
                if (1000000.0 * Math.abs(this.spectrum$1.getMzList()[nearestPeakIdx] - this.ipMoz$1.elem) / this.ipMoz$1.elem < this.ppmTol$1) {
                    this.ipMoz$1.elem = this.spectrum$1.getMzList()[nearestPeakIdx];
                    ++this.matches$1.elem;
                    f = this.spectrum$1.getIntensityList()[nearestPeakIdx];
                } else {
                    f = ipAbundance / 1000.0f;
                }
                float abundance2 = f;
                double d2 = (double)((ipAbundance - abundance2) / package$.MODULE$.min(abundance2, ipAbundance)) * rankPenality;
                this.score$1.elem += d2 * d2;
            }
            {
                this.spectrum$1 = spectrum$1;
                this.isotopicShift$1 = isotopicShift$1;
                this.charge$1 = charge$1;
                this.ppmTol$1 = ppmTol$1;
                this.score$1 = score$1;
                this.pattern$1 = pattern$1;
                this.isotopeAbundance$1 = isotopeAbundance$1;
                this.normAbundance$1 = normAbundance$1;
                this.ipMoz$1 = ipMoz$1;
                this.matches$1 = matches$1;
            }
        });
        score.elem = Math.log10(score.elem) - (double)matches.elem;
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)score.elem), (Object)pattern);
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern> selectBestPatternHypothese(Tuple2<Object, TheoreticalIsotopePattern>[] putativePatterns, double deltaScore) {
        return (Tuple2)Predef$.MODULE$.refArrayOps((Object[])putativePatterns).head();
    }

    @Override
    public double selectBestPatternHypothese$default$2() {
        return 0.1;
    }

    private LegacyIsotopicPatternScorer$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        IIsotopicPatternScorer$class.$init$(this);
    }
}

