/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo;

import com.almworks.sqlite4java.SQLiteConnection;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.algo.IIsotopicPatternPredictor;
import fr.profi.mzdb.algo.IIsotopicPatternPredictor$class;
import fr.profi.mzdb.algo.IIsotopicPatternScorer;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumSlice;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MzDbPatternPredictor$
implements IIsotopicPatternPredictor {
    public static final MzDbPatternPredictor$ MODULE$;
    private final IIsotopicPatternScorer isotopicPatternScorer;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new MzDbPatternPredictor$();
    }

    @Override
    public IIsotopicPatternScorer isotopicPatternScorer() {
        return this.isotopicPatternScorer;
    }

    @Override
    public void fr$profi$mzdb$algo$IIsotopicPatternPredictor$_setter_$isotopicPatternScorer_$eq(IIsotopicPatternScorer x$1) {
        this.isotopicPatternScorer = x$1;
    }

    @Override
    public boolean isMatchReliable(SpectrumData spectrumData, double ppm, double moz, int charge, double mozTolInDa) {
        return IIsotopicPatternPredictor$class.isMatchReliable(this, spectrumData, ppm, moz, charge, mozTolInDa);
    }

    private Logger logger$lzycompute() {
        MzDbPatternPredictor$ mzDbPatternPredictor$ = this;
        synchronized (mzDbPatternPredictor$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Tuple2<Object, TheoreticalIsotopePattern> getBestExplanation(MzDbReader reader, SQLiteConnection sqliteConn, Peakel peakel, double mozTolInDa) {
        double apexMz = peakel.getApexMz();
        float apexRt = peakel.getApexElutionTime();
        SpectrumSlice[] slices = reader.getMsSpectrumSlices(apexMz - (double)5, apexMz + (double)5, apexRt - 0.1f, apexRt + 0.1f);
        Option sliceOpt = Predef$.MODULE$.refArrayOps((Object[])slices).find((Function1)new Serializable(peakel){
            public static final long serialVersionUID = 0L;
            private final Peakel peakel$1;

            public final boolean apply(SpectrumSlice x$1) {
                return x$1.getHeader().getSpectrumId() == this.peakel$1.getApexSpectrumId();
            }
            {
                this.peakel$1 = peakel$1;
            }
        });
        float ppmTol = peakel.getLeftHwhmMean() == 0.0f ? (float)(1000000.0 * mozTolInDa / peakel.getApexMz()) : (float)(1000000.0 * (double)peakel.getLeftHwhmMean() / apexMz);
        Tuple2<Object, TheoreticalIsotopePattern>[] putativePatterns = this.isotopicPatternScorer().calcIsotopicPatternHypotheses(((Spectrum)sliceOpt.get()).getData(), peakel.getApexMz(), ppmTol);
        return this.isotopicPatternScorer().selectBestPatternHypothese(putativePatterns, this.isotopicPatternScorer().selectBestPatternHypothese$default$2());
    }

    public ArrayBuffer<Tuple2<Peakel, Object>> assessReliability(MzDbReader reader, SQLiteConnection sqliteConn, Peakel[] matchingPeakels, int charge, double mozTolInDa) {
        ArrayBuffer filteredPeakels = new ArrayBuffer(matchingPeakels.length);
        Predef$.MODULE$.refArrayOps((Object[])matchingPeakels).foreach((Function1)new Serializable(reader, charge, mozTolInDa, filteredPeakels){
            public static final long serialVersionUID = 0L;
            private final MzDbReader reader$1;
            private final int charge$1;
            private final double mozTolInDa$1;
            private final ArrayBuffer filteredPeakels$1;

            public final Object apply(Peakel matchingPeakel) {
                BoxedUnit boxedUnit;
                float apexRt;
                double apexMz = matchingPeakel.getApexMz();
                SpectrumSlice[] slices = this.reader$1.getMsSpectrumSlices(apexMz - (double)5, apexMz + (double)5, (apexRt = matchingPeakel.getApexElutionTime()) - 0.1f, apexRt + 0.1f);
                Option sliceOpt = Predef$.MODULE$.refArrayOps((Object[])slices).find((Function1)new Serializable(this, matchingPeakel){
                    public static final long serialVersionUID = 0L;
                    private final Peakel matchingPeakel$1;

                    public final boolean apply(SpectrumSlice x$2) {
                        return x$2.getHeader().getSpectrumId() == this.matchingPeakel$1.getApexSpectrumId();
                    }
                    {
                        this.matchingPeakel$1 = matchingPeakel$1;
                    }
                });
                if (sliceOpt.isDefined()) {
                    float ppm = matchingPeakel.getLeftHwhmMean() == 0.0f ? (float)(1000000.0 * this.mozTolInDa$1 / matchingPeakel.getApexMz()) : (float)(1000000.0 * (double)matchingPeakel.getLeftHwhmMean() / apexMz);
                    boolean isReliable = MzDbPatternPredictor$.MODULE$.isMatchReliable(((Spectrum)sliceOpt.get()).getData(), ppm, matchingPeakel.getApexMz(), this.charge$1, this.mozTolInDa$1);
                    boxedUnit = this.filteredPeakels$1.$plus$eq((Object)new Tuple2((Object)matchingPeakel, (Object)BoxesRunTime.boxToBoolean((boolean)isReliable)));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.reader$1 = reader$1;
                this.charge$1 = charge$1;
                this.mozTolInDa$1 = mozTolInDa$1;
                this.filteredPeakels$1 = filteredPeakels$1;
            }
        });
        return filteredPeakels;
    }

    private MzDbPatternPredictor$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        IIsotopicPatternPredictor$class.$init$(this);
    }
}

