/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.util.math;

import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;

public final class VectorSimilarity$ {
    public static final VectorSimilarity$ MODULE$;

    static {
        new VectorSimilarity$();
    }

    public <T> double dot(Iterable<T> as, Iterable<T> bs, Function2<T, T, Object> f) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)as.zip(bs, Iterable$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<T, T> check$ifrefutable$1) {
                Tuple2<T, T> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(f){
            public static final long serialVersionUID = 0L;
            private final Function2 f$1;

            public final double apply(Tuple2<T, T> x$1) {
                Tuple2<T, T> tuple2 = x$1;
                if (tuple2 != null) {
                    Object a = tuple2._1();
                    Object b = tuple2._2();
                    double d = BoxesRunTime.unboxToDouble((Object)this.f$1.apply(a, b));
                    return d;
                }
                throw new MatchError(tuple2);
            }
            {
                this.f$1 = f$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public double dotProduct(double[] vector1, double[] vector2) {
        return this.dot((Iterable)Predef$.MODULE$.wrapDoubleArray(vector1), (Iterable)Predef$.MODULE$.wrapDoubleArray(vector2), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$2, double x$3) {
                return this.apply$mcDDD$sp(x$2, x$3);
            }

            public double apply$mcDDD$sp(double x$2, double x$3) {
                return x$2 * x$3;
            }
        });
    }

    public double dotProduct(float[] vector1, float[] vector2) {
        return this.dot((Iterable)Predef$.MODULE$.wrapFloatArray(vector1), (Iterable)Predef$.MODULE$.wrapFloatArray(vector2), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(float x$4, float x$5) {
                return x$4 * x$5;
            }
        });
    }

    public double dotProduct(int[] vector1, int[] vector2) {
        return this.dot((Iterable)Predef$.MODULE$.wrapIntArray(vector1), (Iterable)Predef$.MODULE$.wrapIntArray(vector2), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(int x$6, int x$7) {
                return this.apply$mcDII$sp(x$6, x$7);
            }

            public double apply$mcDII$sp(int x$6, int x$7) {
                return x$6 * x$7;
            }
        });
    }

    public double magnitude(double[] vector) {
        return package$.MODULE$.sqrt(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(vector).fold((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x2Sum, double x) {
                return this.apply$mcDDD$sp(x2Sum, x);
            }

            public double apply$mcDDD$sp(double x2Sum, double x) {
                return x2Sum + x * x;
            }
        })));
    }

    public double cosineSimilarity(double[] vector1, double[] vector2) {
        Predef$.MODULE$.require(Predef$.MODULE$.doubleArrayOps(vector1).size() == Predef$.MODULE$.doubleArrayOps(vector2).size(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "vectors must have same length";
            }
        });
        return this.dotProduct(vector1, vector2) / (this.magnitude(vector1) * this.magnitude(vector2));
    }

    public double uncenteredCorrelation(double[] vector1, double[] vector2) {
        Predef$.MODULE$.require(Predef$.MODULE$.doubleArrayOps(vector1).size() == Predef$.MODULE$.doubleArrayOps(vector2).size(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "vectors must have same length";
            }
        });
        int N = vector1.length;
        double sum_coproduct = 0.0;
        double sum_sq_x = 0.0;
        double sum_sq_y = 0.0;
        int i = -1;
        while (i < N) {
            double x = vector1[++i];
            double y = vector2[i];
            sum_coproduct += x * y;
            sum_sq_x += x * x;
            sum_sq_y += y * y;
        }
        return sum_coproduct / package$.MODULE$.sqrt(sum_sq_x * sum_sq_y);
    }

    public double squaredPearsonCorrelation(float[] vector1, float[] vector2) {
        return package$.MODULE$.pow(this.pearsonCorrelation(vector1, vector2), 2.0);
    }

    public double squaredPearsonCorrelation(double[] vector1, double[] vector2) {
        return package$.MODULE$.pow(this.pearsonCorrelation(vector1, vector2), 2.0);
    }

    public double pearsonCorrelation(float[] vector1, float[] vector2) {
        return this.pearsonCorrelation((double[])Predef$.MODULE$.floatArrayOps(vector1).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(float x$8) {
                return this.apply$mcDF$sp(x$8);
            }

            public double apply$mcDF$sp(float x$8) {
                return x$8;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), (double[])Predef$.MODULE$.floatArrayOps(vector2).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(float x$9) {
                return this.apply$mcDF$sp(x$9);
            }

            public double apply$mcDF$sp(float x$9) {
                return x$9;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    public double pearsonCorrelation(double[] vector1, double[] vector2) {
        int N = vector1.length;
        Predef$.MODULE$.require(N == vector2.length, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "vectors must have same length";
            }
        });
        Predef$.MODULE$.require(N > 0, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "vectors must contain data";
            }
        });
        DoubleRef sum_sq_x = DoubleRef.create((double)0.0);
        DoubleRef sum_sq_y = DoubleRef.create((double)0.0);
        DoubleRef sum_coproduct = DoubleRef.create((double)0.0);
        DoubleRef mean_x = DoubleRef.create((double)vector1[0]);
        DoubleRef mean_y = DoubleRef.create((double)vector2[0]);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), N).foreach$mVc$sp((Function1)new Serializable(vector1, vector2, sum_sq_x, sum_sq_y, sum_coproduct, mean_x, mean_y){
            public static final long serialVersionUID = 0L;
            private final double[] vector1$1;
            private final double[] vector2$1;
            private final DoubleRef sum_sq_x$1;
            private final DoubleRef sum_sq_y$1;
            private final DoubleRef sum_coproduct$1;
            private final DoubleRef mean_x$1;
            private final DoubleRef mean_y$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                double sweep = ((double)i - 1.0) / (double)i;
                double delta_x = this.vector1$1[i - 1] - this.mean_x$1.elem;
                double delta_y = this.vector2$1[i - 1] - this.mean_y$1.elem;
                this.sum_sq_x$1.elem += delta_x * delta_x * sweep;
                this.sum_sq_y$1.elem += delta_y * delta_y * sweep;
                this.sum_coproduct$1.elem += delta_x * delta_y * sweep;
                this.mean_x$1.elem += delta_x / (double)i;
                this.mean_y$1.elem += delta_y / (double)i;
            }
            {
                this.vector1$1 = vector1$1;
                this.vector2$1 = vector2$1;
                this.sum_sq_x$1 = sum_sq_x$1;
                this.sum_sq_y$1 = sum_sq_y$1;
                this.sum_coproduct$1 = sum_coproduct$1;
                this.mean_x$1 = mean_x$1;
                this.mean_y$1 = mean_y$1;
            }
        });
        double pop_sd_x = package$.MODULE$.sqrt(sum_sq_x.elem / (double)N);
        double pop_sd_y = package$.MODULE$.sqrt(sum_sq_y.elem / (double)N);
        double cov_x_y = sum_coproduct.elem / (double)N;
        return cov_x_y / (pop_sd_x * pop_sd_y);
    }

    public double rmsd(double[] vector1, double[] vector2) {
        Predef$.MODULE$.require(Predef$.MODULE$.doubleArrayOps(vector1).size() == Predef$.MODULE$.doubleArrayOps(vector2).size(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "vectors must have same length";
            }
        });
        double sumSquare = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Tuple2Zipped$.MODULE$.map$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)vector1, (Object)vector2)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<Object> apply(double[] xs) {
                return Predef$.MODULE$.doubleArrayOps(xs);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<Object> apply(double[] xs) {
                return Predef$.MODULE$.doubleArrayOps(xs);
            }
        }), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x, double y) {
                return this.apply$mcDDD$sp(x, y);
            }

            public double apply$mcDDD$sp(double x, double y) {
                return package$.MODULE$.pow(y - x, 2.0);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return package$.MODULE$.sqrt(sumSquare / (double)Predef$.MODULE$.doubleArrayOps(vector1).size());
    }

    private VectorSimilarity$() {
        MODULE$ = this;
    }
}

