/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.util;

public final class FileUtils {
    private FileUtils() {
    }

    public static String[] splitFilePath(String abstractPathname) {
        if (abstractPathname == null) {
            throw new IllegalArgumentException("AbstractPathname is null");
        }
        boolean isLinux = abstractPathname.contains("/");
        boolean isWindows = abstractPathname.contains("\\");
        if (isLinux && isWindows) {
            throw new IllegalArgumentException("Cannot guess Linux or Windows file name separator from [" + abstractPathname + ']');
        }
        String[] result = null;
        result = isLinux ? abstractPathname.split("/+") : (isWindows ? abstractPathname.split("\\\\+") : new String[]{abstractPathname});
        return result;
    }

    public static String extractFileName(String abstractPathname) {
        String[] pathParts = FileUtils.splitFilePath(abstractPathname);
        String fileName = null;
        int nParts = pathParts.length;
        if (nParts <= 0) {
            throw new IllegalArgumentException("Invalid abstractPathname [" + abstractPathname + ']');
        }
        fileName = pathParts[nParts - 1];
        return fileName;
    }
}

