/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.aaproperties;

import java.util.HashMap;
import java.util.Map;
import org.biojava.nbio.aaproperties.PeptideProperties;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;

public class Constraints {
    private static AminoAcidCompoundSet aaSet = new AminoAcidCompoundSet();
    public static AminoAcidCompound A = aaSet.getCompoundForString("A");
    public static AminoAcidCompound R = aaSet.getCompoundForString("R");
    public static AminoAcidCompound N = aaSet.getCompoundForString("N");
    public static AminoAcidCompound D = aaSet.getCompoundForString("D");
    public static AminoAcidCompound C = aaSet.getCompoundForString("C");
    public static AminoAcidCompound E = aaSet.getCompoundForString("E");
    public static AminoAcidCompound Q = aaSet.getCompoundForString("Q");
    public static AminoAcidCompound G = aaSet.getCompoundForString("G");
    public static AminoAcidCompound H = aaSet.getCompoundForString("H");
    public static AminoAcidCompound I = aaSet.getCompoundForString("I");
    public static AminoAcidCompound L = aaSet.getCompoundForString("L");
    public static AminoAcidCompound K = aaSet.getCompoundForString("K");
    public static AminoAcidCompound M = aaSet.getCompoundForString("M");
    public static AminoAcidCompound F = aaSet.getCompoundForString("F");
    public static AminoAcidCompound P = aaSet.getCompoundForString("P");
    public static AminoAcidCompound S = aaSet.getCompoundForString("S");
    public static AminoAcidCompound T = aaSet.getCompoundForString("T");
    public static AminoAcidCompound W = aaSet.getCompoundForString("W");
    public static AminoAcidCompound Y = aaSet.getCompoundForString("Y");
    public static AminoAcidCompound V = aaSet.getCompoundForString("V");
    public static Map<AminoAcidCompound, Double> aa2ExtinctionCoefficient = new HashMap<AminoAcidCompound, Double>();
    public static Map<AminoAcidCompound, Double> aa2MolecularWeight = new HashMap<AminoAcidCompound, Double>();
    public static Map<AminoAcidCompound, Double> aa2Hydrophathicity = new HashMap<AminoAcidCompound, Double>();
    public static Map<AminoAcidCompound, Double> aa2PKa = new HashMap<AminoAcidCompound, Double>();
    public static Map<String, Double> diAA2Instability = new HashMap<String, Double>();
    public static Map<AminoAcidCompound, Double> aa2NTerminalPka = new HashMap<AminoAcidCompound, Double>();
    public static Map<AminoAcidCompound, Double> aa2CTerminalPka = new HashMap<AminoAcidCompound, Double>();

    public static void initMolecularWeight() {
        aa2MolecularWeight.put(A, 71.0788);
        aa2MolecularWeight.put(R, 156.1875);
        aa2MolecularWeight.put(N, 114.1038);
        aa2MolecularWeight.put(D, 115.0886);
        aa2MolecularWeight.put(C, 103.1388);
        aa2MolecularWeight.put(E, 129.1155);
        aa2MolecularWeight.put(Q, 128.1307);
        aa2MolecularWeight.put(G, 57.0519);
        aa2MolecularWeight.put(H, 137.1411);
        aa2MolecularWeight.put(I, 113.1594);
        aa2MolecularWeight.put(L, 113.1594);
        aa2MolecularWeight.put(K, 128.1741);
        aa2MolecularWeight.put(M, 131.1926);
        aa2MolecularWeight.put(F, 147.1766);
        aa2MolecularWeight.put(P, 97.1167);
        aa2MolecularWeight.put(S, 87.0782);
        aa2MolecularWeight.put(T, 101.1051);
        aa2MolecularWeight.put(W, 186.2132);
        aa2MolecularWeight.put(Y, 163.176);
        aa2MolecularWeight.put(V, 99.1326);
    }

    private static void initHydropathicity() {
        aa2Hydrophathicity.put(A, 1.8);
        aa2Hydrophathicity.put(R, -4.5);
        aa2Hydrophathicity.put(N, -3.5);
        aa2Hydrophathicity.put(D, -3.5);
        aa2Hydrophathicity.put(C, 2.5);
        aa2Hydrophathicity.put(E, -3.5);
        aa2Hydrophathicity.put(Q, -3.5);
        aa2Hydrophathicity.put(G, -0.4);
        aa2Hydrophathicity.put(H, -3.2);
        aa2Hydrophathicity.put(I, 4.5);
        aa2Hydrophathicity.put(L, 3.8);
        aa2Hydrophathicity.put(K, -3.9);
        aa2Hydrophathicity.put(M, 1.9);
        aa2Hydrophathicity.put(F, 2.8);
        aa2Hydrophathicity.put(P, -1.6);
        aa2Hydrophathicity.put(S, -0.8);
        aa2Hydrophathicity.put(T, -0.7);
        aa2Hydrophathicity.put(W, -0.9);
        aa2Hydrophathicity.put(Y, -1.3);
        aa2Hydrophathicity.put(V, 4.2);
    }

    private static void initPKaInnovagen() {
        aa2CTerminalPka.put(G, 2.34);
        aa2CTerminalPka.put(A, 2.34);
        aa2CTerminalPka.put(P, 1.99);
        aa2CTerminalPka.put(V, 2.32);
        aa2CTerminalPka.put(L, 2.36);
        aa2CTerminalPka.put(I, 2.36);
        aa2CTerminalPka.put(M, 2.28);
        aa2CTerminalPka.put(F, 1.83);
        aa2CTerminalPka.put(Y, 2.2);
        aa2CTerminalPka.put(W, 2.38);
        aa2CTerminalPka.put(S, 2.21);
        aa2CTerminalPka.put(T, 2.11);
        aa2CTerminalPka.put(C, 1.96);
        aa2CTerminalPka.put(N, 2.02);
        aa2CTerminalPka.put(Q, 2.17);
        aa2CTerminalPka.put(K, 2.18);
        aa2CTerminalPka.put(H, 1.82);
        aa2CTerminalPka.put(R, 2.17);
        aa2CTerminalPka.put(D, 1.88);
        aa2CTerminalPka.put(E, 2.19);
        aa2NTerminalPka.put(G, 9.6);
        aa2NTerminalPka.put(A, 9.69);
        aa2NTerminalPka.put(P, 10.96);
        aa2NTerminalPka.put(V, 9.62);
        aa2NTerminalPka.put(L, 9.6);
        aa2NTerminalPka.put(I, 9.68);
        aa2NTerminalPka.put(M, 9.21);
        aa2NTerminalPka.put(F, 9.13);
        aa2NTerminalPka.put(Y, 9.11);
        aa2NTerminalPka.put(W, 9.39);
        aa2NTerminalPka.put(S, 9.15);
        aa2NTerminalPka.put(T, 9.62);
        aa2NTerminalPka.put(C, 10.28);
        aa2NTerminalPka.put(N, 8.8);
        aa2NTerminalPka.put(Q, 9.13);
        aa2NTerminalPka.put(K, 8.95);
        aa2NTerminalPka.put(H, 9.17);
        aa2NTerminalPka.put(R, 9.04);
        aa2NTerminalPka.put(D, 9.6);
        aa2NTerminalPka.put(E, 9.67);
        aa2PKa.put(K, 10.53);
        aa2PKa.put(D, 3.65);
        aa2PKa.put(R, 12.48);
        aa2PKa.put(E, 4.25);
        aa2PKa.put(H, 6.0);
        aa2PKa.put(C, 8.18);
        aa2PKa.put(Y, 10.07);
    }

    private static void initPKa() {
        Constraints.initPKaInnovagen();
    }

    private static void initInstability() {
        double[][] instability = new double[][]{{1.0, 1.0, 24.68, 24.68, 1.0, 1.0, 1.0, 13.34, 1.0, 1.0, 1.0, 1.0, -14.03, 1.0, 1.0, -7.49, 1.0, -9.37, -14.03, 13.34}, {24.68, 1.0, 33.6, 33.6, 1.0, 1.0, -6.54, 1.0, 1.0, 1.0, 20.26, 20.26, 33.6, 1.0, 1.0, -6.54, 1.0, 1.0, 1.0, 20.26}, {1.0, 1.0, -1.88, 58.28, 24.68, 1.0, -6.54, 1.0, 1.0, -6.54, 1.0, 44.94, -1.88, 1.0, 1.0, 1.0, 44.94, 1.0, 13.34, 1.0}, {-1.88, 1.0, 1.0, 1.0, 44.94, -9.37, 1.0, 24.68, 44.94, 1.0, 1.0, -1.88, -6.54, 24.68, 1.0, 1.0, 1.0, -9.37, 1.0, 1.0}, {-9.37, 1.0, 44.94, 13.34, 13.34, 1.0, 1.0, 1.0, 1.0, -15.91, 24.68, 13.34, -7.49, 1.0, -6.54, 1.0, 1.0, -7.49, 24.68, 1.0}, {1.0, 1.0, 1.0, 1.0, 33.6, 1.0, 1.0, 1.0, 1.0, 1.0, 13.34, 20.26, 1.0, -14.03, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, -6.54, 1.0, 1.0, -6.54, -6.54, 20.26, 1.0, 1.0, 1.0, 20.26, 20.26, 1.0, 1.0, 20.26, -6.54, 44.94, 1.0, 1.0, 1.0}, {-9.37, -1.88, 1.0, 1.0, 1.0, -14.03, -6.54, 1.0, 44.94, 1.0, 1.0, -1.88, -7.49, 24.68, 1.0, 1.0, 1.0, -14.03, 1.0, 1.0}, {1.0, 1.0, 1.0, 13.34, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, -1.88, 1.0, -7.49, 44.94, -7.49, 1.0, 1.0, 1.0, 20.26}, {58.28, 1.0, 1.0, 20.26, -6.54, 1.0, 20.26, 13.34, 1.0, 58.28, 1.0, 20.26, 1.0, 1.0, 1.0, 1.0, 44.94, -7.49, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, -6.54, 1.0, 1.0, 1.0, -6.54, 1.0, 1.0, -14.03, -7.49, 1.0, 1.0, 20.26, 1.0, 1.0, 1.0}, {-1.88, -6.54, -6.54, 1.0, 1.0, 20.26, 20.26, 1.0, 1.0, -6.54, -6.54, 20.26, 1.0, 1.0, 18.38, 20.26, 20.26, 1.0, 20.26, 1.0}, {-14.03, 1.0, 1.0, 1.0, 1.0, 13.34, -6.54, -14.03, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 20.26, 1.0, 1.0, -7.49, 1.0, 1.0}, {1.0, 1.0, 33.6, 1.0, 1.0, 1.0, 24.68, 1.0, -7.49, 33.6, 1.0, -6.54, 1.0, 1.0, 1.0, -7.49, 1.0, -7.49, 1.0, -7.49}, {-14.03, 44.94, 1.0, -6.54, 1.0, 1.0, 20.26, 1.0, 20.26, 1.0, 20.26, 20.26, 1.0, 1.0, 33.6, 1.0, 20.26, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, -6.54, 1.0, 1.0, 1.0, 1.0, 1.0, -14.03, 20.26, -7.49, -1.88, 1.0, 1.0, 1.0, -7.49, 1.0, 1.0}, {1.0, 33.6, 1.0, 1.0, 1.0, 1.0, 20.26, 1.0, 1.0, 20.26, 1.0, 44.94, 1.0, 1.0, 20.26, 1.0, 20.26, 1.0, 1.0, 1.0}, {13.34, 1.0, 1.0, 1.0, -7.49, 1.0, 1.0, -7.49, -7.49, 1.0, 1.0, 1.0, -7.49, -7.49, -6.54, 1.0, 1.0, 13.34, -7.49, 1.0}, {1.0, 44.94, 1.0, -7.49, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, -7.49, 20.26, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {24.68, 1.0, 1.0, 1.0, 1.0, 1.0, 33.6, 1.0, 1.0, 20.26, 1.0, 20.26, 1.0, -7.49, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}};
        PeptideProperties.SingleLetterAACode[] aa = PeptideProperties.SingleLetterAACode.values();
        for (int i = 0; i < aa.length; ++i) {
            for (int j = 0; j < aa.length; ++j) {
                diAA2Instability.put("" + (Object)((Object)aa[i]) + (Object)((Object)aa[j]), instability[i][j]);
            }
        }
    }

    public static void initExtinctionCoefficient() {
        aa2ExtinctionCoefficient.put(Y, 1490.0);
        aa2ExtinctionCoefficient.put(W, 5500.0);
        aa2ExtinctionCoefficient.put(C, 125.0);
    }

    static {
        Constraints.initMolecularWeight();
        Constraints.initHydropathicity();
        Constraints.initPKa();
        Constraints.initInstability();
        Constraints.initExtinctionCoefficient();
    }
}

